/*
 * Decompiled with CFR 0.152.
 */
package bdvm.debugger;

import bdvm.debugger.CommandLine;
import bdvm.debugger.snapshots;
import bdvm.debugger.traces;
import bdvm.vm.BDVM;
import bdvm.vm.common;
import bdvm.vm.constants;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;

public class Debugger
extends JFrame
implements ActionListener,
KeyListener {
    private static final long serialVersionUID = 5536492998515988818L;
    public static final BDVM vm = new BDVM();
    private static boolean recordSnapshots = false;
    private static snapshots snapshot_trap_reg;
    private static snapshots snapshot_trap_mem;
    private static snapshots snapshot_break_reg;
    private static snapshots snapshot_break_mem;
    private static traces pc_trace;
    private static traces ins_trace;
    private static traces timer_trace;
    private static boolean autosuspend;
    public static File discMountPath;
    private static final ArrayList<Integer> breakPoints;
    private static IntBuffer traceBuffer;
    private static IntBuffer timerBuffer;
    private final ArrayList<File> memSnapshots = new ArrayList();
    private final ArrayList<File> regSnapshots = new ArrayList();
    private final ArrayList<File> breakMemSnapshots = new ArrayList();
    private final ArrayList<File> breakRegSnapshots = new ArrayList();
    private static final byte[] dataBreakPoints;
    private static final byte READ = 1;
    private static final byte WRITE = 2;
    private static final byte SELECTED = 4;
    private static final byte FOUND = 8;
    private static final int[] oldRegisters;
    private final long[] R_copy = new long[32];
    private final ArrayList<Integer> findPositions = new ArrayList();
    private int curFindPosIndex = 0;
    private int PostBreakSnapshotsPresent = 0;
    private int PostTrapSnapshotsPresent = 0;
    private static final MemTableModel memTableModel;
    private static final JTable code;
    private static final JScrollPane codeScroll;
    private static final VMTableModel vmModel;
    private static final JTable vmState;
    private static final RawMemTableModel rawMemModel;
    private static final JTable rawMemView;
    private static final JScrollPane rawMemScroll;
    private final JMenuItem setdiscMountPath;
    private final JMenuItem setVolumeID;
    private final JMenuItem loadMem;
    private final JMenuItem loadTrace;
    private final JMenuItem loadTimer;
    private final JMenuItem dumpMem;
    private final JMenuItem loadRegisters;
    private final JMenuItem loadSnapshots;
    private final JMenuItem createSnapshots;
    private final JFileChooser fc = new JFileChooser();
    private final JToolBar toolbar = new JToolBar();
    private final JButton step = new JButton("Step (F11)");
    private final JButton run = new JButton("Run (F5)");
    private final JButton toggleBreakpoint = new JButton("Toggle Breakpoint");
    private final JButton gotoLine = new JButton("View Address...");
    private final JButton gotoPc = new JButton("View PC Address");
    private final JButton setPc = new JButton("Set PC...");
    private final JButton setVID = new JButton("Set Volume ID...");
    private final JButton setTc = new JButton("Set TC...");
    private final JButton setIc = new JButton("Set IC...");
    private final JButton setWd = new JButton("Set WD...");
    private final JButton setBc = new JButton("Set BC...");
    private final JButton find = new JButton("Find...");
    private final JButton findNext = new JButton("Find next");
    private final JButton findPrev = new JButton("Find prev");
    private final JButton dataBreakPointRead = new JButton("Toggle data read breakpoint");
    private final JButton dataBreakPointWrite = new JButton("Toggle data write breakpoint");

    public Debugger() {
        super("BDVM Debugger v0.1.5");
        this.setLayout(new BorderLayout());
        JMenuBar menu = new JMenuBar();
        JMenu settings = new JMenu("Settings");
        menu.add(settings);
        this.setdiscMountPath = new JMenuItem("Select disc mount path");
        this.setdiscMountPath.addActionListener(this);
        this.setVolumeID = new JMenuItem("Set volume id");
        this.setVolumeID.addActionListener(this);
        this.loadMem = new JMenuItem("Load Memory dump (little endian)");
        this.loadMem.addActionListener(this);
        this.loadTrace = new JMenuItem("Load PC Trace (little endian)");
        this.loadTrace.addActionListener(this);
        this.loadTimer = new JMenuItem("Load Timer Trace (little endian)");
        this.loadTimer.addActionListener(this);
        this.loadRegisters = new JMenuItem("Load Registers (little endian)");
        this.loadRegisters.addActionListener(this);
        this.dumpMem = new JMenuItem("Dump Memory (little endian)");
        this.dumpMem.addActionListener(this);
        settings.add(this.setdiscMountPath);
        settings.add(this.setVolumeID);
        JMenu debug = new JMenu("Debug");
        menu.add(debug);
        debug.add(this.loadMem);
        debug.add(this.loadTrace);
        debug.add(this.loadTimer);
        debug.add(this.loadRegisters);
        debug.add(this.dumpMem);
        this.loadSnapshots = new JMenuItem("Load snapshots");
        this.createSnapshots = new JMenuItem("Record snapshots");
        this.loadSnapshots.addActionListener(this);
        this.createSnapshots.addActionListener(this);
        JMenu menu_snapshots = new JMenu("Snapshots");
        menu.add(menu_snapshots);
        menu_snapshots.add(this.loadSnapshots);
        menu_snapshots.add(this.createSnapshots);
        this.setJMenuBar(menu);
        code.setShowGrid(false);
        code.getColumnModel().getColumn(0).setPreferredWidth(5);
        code.getColumnModel().getColumn(1).setPreferredWidth(30);
        code.getColumnModel().getColumn(2).setPreferredWidth(30);
        code.getColumnModel().getColumn(3).setPreferredWidth(150);
        code.setSelectionMode(0);
        code.setDefaultRenderer(Object.class, new MemTableRenderer());
        code.addKeyListener(this);
        vmState.setShowGrid(false);
        vmState.setDefaultRenderer(Object.class, new VMTableRenderer());
        vmState.addKeyListener(this);
        rawMemView.getColumnModel().getColumn(0).setPreferredWidth(80);
        rawMemView.getColumnModel().getColumn(17).setPreferredWidth(134);
        for (int i = 0; i < 16; ++i) {
            rawMemView.getColumnModel().getColumn(1 + i).setPreferredWidth(20);
        }
        rawMemView.setShowGrid(false);
        rawMemView.setCellSelectionEnabled(true);
        rawMemView.setDefaultRenderer(Object.class, new RawMemTableRenderer());
        rawMemView.addKeyListener(this);
        this.addToToolbar(this.step);
        this.addToToolbar(this.run);
        this.addToToolbar(this.toggleBreakpoint);
        this.addToToolbar(this.gotoLine);
        this.addToToolbar(this.gotoPc);
        this.addToToolbar(this.setPc);
        this.addToToolbar(this.setVID);
        this.addToToolbar(this.setTc);
        this.addToToolbar(this.setIc);
        this.addToToolbar(this.setWd);
        this.addToToolbar(this.setBc);
        this.addToToolbar(this.find);
        this.addToToolbar(this.findNext);
        this.addToToolbar(this.findPrev);
        this.addToToolbar(this.dataBreakPointRead);
        this.toolbar.setFloatable(false);
        this.getContentPane().add((Component)this.toolbar, "First");
        JSplitPane rightSplit = new JSplitPane(0, new JScrollPane(vmState), rawMemScroll);
        JSplitPane split = new JSplitPane(1, codeScroll, rightSplit);
        this.getContentPane().add((Component)split, "Center");
        this.setPreferredSize(new Dimension(1130, 1024));
        this.setDefaultCloseOperation(3);
        this.addKeyListener(this);
        this.pack();
        split.setDividerLocation(0.45);
        split.setDividerSize(4);
        rightSplit.setDividerLocation(0.43);
        rightSplit.setDividerSize(4);
        this.setVisible(true);
    }

    private void addToToolbar(JButton btn) {
        this.toolbar.add(btn);
        btn.addActionListener(this);
        btn.addKeyListener(this);
    }

    public static byte[] hexStringToByteArray(String s) {
        int len = s.length();
        byte[] data = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            data[i / 2] = (byte)((Character.digit(s.charAt(i), 16) << 4) + Character.digit(s.charAt(i + 1), 16));
        }
        return data;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        block90: {
            try {
                if (e.getSource() == this.setdiscMountPath) {
                    this.fc.setFileSelectionMode(1);
                    if (this.fc.showOpenDialog(this) == 0) {
                        discMountPath = this.fc.getSelectedFile().getAbsoluteFile();
                        try {
                            System.out.format("Loading %s/BDSVM/00000.svm ...\n", discMountPath);
                            vm.initVM(discMountPath, 4096);
                            vm.loadFile("BDSVM/00000.svm");
                            Debugger.updateRegisters();
                            Debugger.showCodePos(Debugger.vm.pc / 4);
                        }
                        catch (Exception ex) {
                            System.out.format("[E] Couldn't load %s/BDSVM/00000.svm!\n", discMountPath);
                            ex.printStackTrace();
                        }
                    }
                    break block90;
                }
                if (e.getSource() == this.setVolumeID) {
                    byte[] volume_id = Debugger.hexStringToByteArray(JOptionPane.showInputDialog("Please input Volume ID (as 16 hex bytes)"));
                    vm.getVPI().setVolumeId(volume_id, 0);
                    System.out.format("Volume ID set to: ", new Object[0]);
                    for (int i = 0; i < volume_id.length; ++i) {
                        System.out.format("%02X ", volume_id[i]);
                    }
                    System.out.format("\n", new Object[0]);
                    break block90;
                }
                if (e.getSource() == this.loadSnapshots) {
                    try {
                        snapshot_trap_reg = new snapshots();
                        snapshot_trap_reg.open("snapshots/post_trap_reg_diffarchive.bin");
                        snapshot_trap_mem = new snapshots();
                        snapshot_trap_mem.open("snapshots/post_trap_mem_diffarchive.bin");
                    }
                    catch (Exception ex) {
                        System.out.format("[W] No post-trap snapshot archive found!\n", new Object[0]);
                    }
                    try {
                        snapshot_break_reg = new snapshots();
                        snapshot_break_reg.open("snapshots/post_break_reg_diffarchive.bin");
                        snapshot_break_mem = new snapshots();
                        snapshot_break_mem.open("snapshots/post_break_mem_diffarchive.bin");
                    }
                    catch (Exception ex) {
                        System.out.format("[W] No post-break snapshot archive found!\n", new Object[0]);
                    }
                    try {
                        pc_trace = new traces("traces/pc_trace.bin");
                    }
                    catch (Exception ex) {
                        System.out.format("[W] No program counter trace found!\n", new Object[0]);
                    }
                    try {
                        ins_trace = new traces("traces/ins_trace.bin");
                    }
                    catch (Exception ex) {
                        System.out.format("[W] No instruction trace found!\n", new Object[0]);
                    }
                    try {
                        timer_trace = new traces("traces/timer_trace.bin");
                    }
                    catch (Exception ex) {
                        System.out.format("[W] No timer trace found!\n", new Object[0]);
                    }
                    break block90;
                }
                if (e.getSource() == this.createSnapshots) {
                    try {
                        snapshot_trap_reg = new snapshots();
                        snapshot_trap_reg.create("snapshots/post_trap_reg_diffarchive.bin", 128);
                        snapshot_trap_mem = new snapshots();
                        snapshot_trap_mem.create("snapshots/post_trap_mem_diffarchive.bin", 0x400000);
                    }
                    catch (Exception ex) {
                        System.out.format("[W] No post-trap snapshot archive found!\n", new Object[0]);
                    }
                    try {
                        snapshot_break_reg = new snapshots();
                        snapshot_break_reg.create("snapshots/post_break_reg_diffarchive.bin", 128);
                        snapshot_break_mem = new snapshots();
                        snapshot_break_mem.create("snapshots/post_break_mem_diffarchive.bin", 0x400000);
                    }
                    catch (Exception ex) {
                        System.out.format("[W] No post-break snapshot archive found!\n", new Object[0]);
                    }
                    recordSnapshots = true;
                    autosuspend = false;
                    Debugger.run();
                    break block90;
                }
                if (e.getSource() == this.step) {
                    System.arraycopy(Debugger.vm.R, 0, oldRegisters, 0, 32);
                    Debugger.step();
                } else if (e.getSource() == this.run) {
                    autosuspend = false;
                    Debugger.run();
                } else {
                    if (e.getSource() == this.toggleBreakpoint) {
                        Integer address = code.getSelectedRow() * 4;
                        address = address <= 0 ? Debugger.vm.pc : address;
                        if (Debugger.hasBreakPoint(address)) {
                            breakPoints.remove(address);
                        } else {
                            breakPoints.add(address);
                        }
                        Debugger.updateRegisters();
                        return;
                    }
                    if (e.getSource() == this.gotoLine) {
                        String s = JOptionPane.showInputDialog("Please input address (as hex)");
                        if (s == null) {
                            return;
                        }
                        int address = Integer.parseInt(s, 16);
                        Debugger.showCodePos(address / 4);
                        Debugger.showMemPos(address);
                        return;
                    }
                    if (e.getSource() == this.loadTrace) {
                        if (this.fc.showOpenDialog(this) == 0) {
                            File f = this.fc.getSelectedFile();
                            ByteBuffer tmp = ByteBuffer.allocate((int)f.length());
                            tmp.order(ByteOrder.LITTLE_ENDIAN);
                            BufferedInputStream input = new BufferedInputStream(new FileInputStream(f));
                            int l = (int)f.length();
                            for (int i = 0; i < l; ++i) {
                                tmp.put((byte)input.read());
                            }
                            input.close();
                            tmp.rewind();
                            traceBuffer = tmp.asIntBuffer();
                        }
                    } else if (e.getSource() == this.loadTimer) {
                        if (this.fc.showOpenDialog(this) == 0) {
                            File f = this.fc.getSelectedFile();
                            ByteBuffer tmp = ByteBuffer.allocate((int)f.length());
                            tmp.order(ByteOrder.LITTLE_ENDIAN);
                            BufferedInputStream input = new BufferedInputStream(new FileInputStream(f));
                            int l = (int)f.length();
                            for (int i = 0; i < l; ++i) {
                                tmp.put((byte)input.read());
                            }
                            input.close();
                            tmp.rewind();
                            timerBuffer = tmp.asIntBuffer();
                        }
                    } else if (e.getSource() == this.dumpMem) {
                        if (this.fc.showSaveDialog(this) == 0) {
                            File f = this.fc.getSelectedFile();
                            BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(f));
                            for (int i = 0; i < 0x400000; ++i) {
                                output.write(Debugger.vm.mem8.get(i ^ 3));
                            }
                            output.close();
                        }
                    } else if (e.getSource() == this.loadMem) {
                        if (this.fc.showOpenDialog(this) == 0) {
                            Debugger.loadMemSnapshot(this.fc.getSelectedFile());
                        }
                    } else if (e.getSource() == this.setPc) {
                        int address = Integer.parseInt(JOptionPane.showInputDialog("Please input address (as hex)"), 16);
                        if (address % 4 == 0 && address > 0 && address < 0x400000) {
                            Debugger.vm.pc = address;
                        }
                    } else if (e.getSource() == this.setVID) {
                        byte[] volume_id = Debugger.hexStringToByteArray(JOptionPane.showInputDialog("Please input Volume ID (as 16 hex bytes)"));
                        vm.getVPI().setVolumeId(volume_id, 0);
                    } else if (e.getSource() == this.setTc) {
                        int number = Integer.parseInt(JOptionPane.showInputDialog("Please input number (as hex)"), 16);
                        if (number >= 0) {
                            Debugger.vm.trapCounter = number;
                        }
                    } else if (e.getSource() == this.setIc) {
                        int number = Integer.parseInt(JOptionPane.showInputDialog("Please input number (as hex)"), 16);
                        if (number >= 0) {
                            Debugger.vm.instructionCounter = number;
                        }
                    } else if (e.getSource() == this.setWd) {
                        int number = Integer.parseInt(JOptionPane.showInputDialog("Please input number (as hex)"), 16);
                        if (number >= 0) {
                            Debugger.vm.watchDogCounter = number;
                        }
                    } else if (e.getSource() == this.setBc) {
                        int number = Integer.parseInt(JOptionPane.showInputDialog("Please input number (as hex)"), 16);
                        if (number >= 0) {
                            Debugger.vm.breakCounter = number;
                        }
                    } else if (e.getSource() == this.loadRegisters) {
                        if (this.fc.showOpenDialog(this) == 0) {
                            Debugger.loadRegSnapshot(this.fc.getSelectedFile());
                        }
                    } else if (e.getSource() == this.dataBreakPointRead || e.getSource() == this.dataBreakPointWrite) {
                        int address;
                        int mask = e.getSource() == this.dataBreakPointRead ? 1 : 2;
                        boolean areAllSelected = true;
                        for (int row : rawMemView.getSelectedRows()) {
                            for (int col : rawMemView.getSelectedColumns()) {
                                if (col < 1 || col > 16) continue;
                                address = row * 16 + col - 1;
                                areAllSelected &= (dataBreakPoints[address] & mask) > 0;
                            }
                        }
                        for (int row : rawMemView.getSelectedRows()) {
                            for (int col : rawMemView.getSelectedColumns()) {
                                if (col < 1 || col > 16) continue;
                                address = row * 16 + col - 1;
                                if (areAllSelected) {
                                    int n = address;
                                    dataBreakPoints[n] = (byte)(dataBreakPoints[n] & ~mask);
                                    continue;
                                }
                                int n = address;
                                dataBreakPoints[n] = (byte)(dataBreakPoints[n] | mask);
                            }
                        }
                    } else if (e.getSource() == this.find) {
                        byte[] byteSequence;
                        String s = JOptionPane.showInputDialog("Please input String or Hex Sequence (starting with '0x')");
                        if (s == null) {
                            return;
                        }
                        if (s.startsWith("0x")) {
                            ByteArrayOutputStream output = new ByteArrayOutputStream();
                            if ((s = s.substring(2)).length() % 2 == 1) {
                                s = "0" + s;
                            }
                            while (s.length() > 0) {
                                String sb = s.substring(0, 2);
                                s = s.substring(2);
                                output.write((byte)Long.parseLong(sb, 16));
                            }
                            output.close();
                            byteSequence = output.toByteArray();
                        } else {
                            byteSequence = s.getBytes();
                        }
                        this.findPositions.clear();
                        this.curFindPosIndex = 0;
                        int i = 0;
                        while (i < 0x400000) {
                            int n = i++;
                            dataBreakPoints[n] = (byte)(dataBreakPoints[n] & 0xFFFFFFF7);
                        }
                        int pos = 0;
                        while (pos + byteSequence.length - 1 < 0x400000 && (pos = vm.find(pos, 0x400000 - pos - byteSequence.length + 1, byteSequence)) >= 0) {
                            this.findPositions.add(pos);
                            for (int i2 = 0; i2 < byteSequence.length; ++i2) {
                                int n = pos + i2;
                                dataBreakPoints[n] = (byte)(dataBreakPoints[n] | 8);
                            }
                            ++pos;
                        }
                        if (this.findPositions.size() > 0) {
                            Debugger.showMemPos(this.findPositions.get(0));
                        }
                    } else if (e.getSource() == this.findPrev) {
                        if (this.curFindPosIndex > 0) {
                            --this.curFindPosIndex;
                            Debugger.showMemPos(this.findPositions.get(this.curFindPosIndex));
                        }
                    } else if (e.getSource() == this.findNext && this.curFindPosIndex < this.findPositions.size() - 1) {
                        ++this.curFindPosIndex;
                        Debugger.showMemPos(this.findPositions.get(this.curFindPosIndex));
                    }
                }
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(this, ex.getMessage());
                ex.printStackTrace();
            }
        }
        Debugger.updateRegisters();
        Debugger.showCodePos(Debugger.vm.pc / 4);
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
        try {
            if (e.getKeyCode() == 122) {
                System.arraycopy(Debugger.vm.R, 0, oldRegisters, 0, 32);
                Debugger.step();
            } else if (e.getKeyCode() == 116) {
                autosuspend = false;
                Debugger.run();
            }
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, ex.getMessage());
            ex.printStackTrace();
        }
        Debugger.updateRegisters();
        Debugger.showCodePos(Debugger.vm.pc / 4);
    }

    private static void step() {
        int reg;
        int i;
        byte[] regfile;
        int referenceTimer;
        int referenceProgramCounter;
        int oldTrapCount = (int)Debugger.vm.trapCounter;
        byte[] BA_reg = new byte[4];
        vm.step();
        if (pc_trace != null && (referenceProgramCounter = pc_trace.readEntry()) != Debugger.vm.pc) {
            System.out.format("[!] program counter difference %08X (vm) != %08X ( trace ) \n", Debugger.vm.pc, referenceProgramCounter);
            Debugger.vm.pc = referenceProgramCounter;
        }
        if (timer_trace != null && (long)(referenceTimer = timer_trace.readEntry()) != Debugger.vm.watchDogCounter) {
            System.out.format("[!] timer difference %08X (vm) != %08X ( trace ) \n", Debugger.vm.watchDogCounter, referenceTimer);
            Debugger.vm.watchDogCounter = referenceTimer;
        }
        if (Debugger.vm.statusExecutedTrap == 1 && snapshot_trap_reg != null) {
            if (recordSnapshots) {
                regfile = new byte[128];
                for (i = 0; i < 32; ++i) {
                    common.int32ToByteArray(Debugger.vm.R[i], regfile, 4 * i);
                }
                snapshot_trap_reg.store(regfile);
                snapshot_trap_mem.store(Debugger.vm.memory);
            } else {
                int i2;
                for (i2 = 0; i2 < 32; ++i2) {
                    System.arraycopy(Debugger.snapshot_trap_reg.memory, 4 * i2, BA_reg, 0, 4);
                    reg = common.byteArrayToInt(BA_reg, 0);
                    if (reg == Debugger.vm.R[i2]) continue;
                    System.out.format("[!] register difference after trap call: r%02d: %08X (vm) != %08X (snapshot) \n", i2, Debugger.vm.R[i2], reg);
                    Debugger.vm.R[i2] = reg;
                }
                if (!Arrays.equals(Debugger.vm.memory, Debugger.snapshot_trap_mem.memory)) {
                    for (i2 = 0; i2 < 0x400000; ++i2) {
                        if (Debugger.vm.memory[i2] == Debugger.snapshot_trap_mem.memory[i2]) continue;
                        System.out.format("[!] memory difference after trap call: %06X: %02X (vm) != %02X (snapshot) \n", i2, Debugger.vm.memory[i2], Debugger.snapshot_trap_mem.memory[i2]);
                        Debugger.vm.memory[i2] = Debugger.snapshot_trap_mem.memory[i2];
                    }
                }
                snapshot_trap_reg.next();
                snapshot_trap_mem.next();
            }
        }
        if (Debugger.vm.statusExecutionInterruption == 1 && snapshot_break_reg != null) {
            if (recordSnapshots) {
                regfile = new byte[128];
                for (i = 0; i < 32; ++i) {
                    common.int32ToByteArray(Debugger.vm.R[i], regfile, 4 * i);
                }
                snapshot_break_reg.store(regfile);
                snapshot_break_mem.store(Debugger.vm.memory);
            } else {
                int i3;
                for (i3 = 0; i3 < 32; ++i3) {
                    System.arraycopy(Debugger.snapshot_break_reg.memory, 4 * i3, BA_reg, 0, 4);
                    reg = common.byteArrayToInt(BA_reg, 0);
                    if (reg == Debugger.vm.R[i3]) continue;
                    System.out.format("[!] register difference after interruption: r%02d: %08X (vm) != %08X (snapshot) \n", i3, common.unsigned(Debugger.vm.R[i3]), common.unsigned(reg));
                    Debugger.vm.R[i3] = reg;
                }
                if (!Arrays.equals(Debugger.vm.memory, Debugger.snapshot_break_mem.memory)) {
                    for (i3 = 0; i3 < 0x400000; ++i3) {
                        if (Debugger.vm.memory[i3] == Debugger.snapshot_break_mem.memory[i3]) continue;
                        System.out.format("[!] memory difference after interruption: %06X: %02X (vm) != %02X (snapshot) \n", i3, Debugger.vm.memory[i3], Debugger.snapshot_break_mem.memory[i3]);
                        Debugger.vm.memory[i3] = Debugger.snapshot_break_mem.memory[i3];
                    }
                }
                snapshot_break_reg.next();
                snapshot_break_mem.next();
            }
        }
    }

    private static void run() {
        do {
            Debugger.step();
        } while (!Debugger.suspendVM());
        if (recordSnapshots) {
            snapshot_trap_reg.finalizeRecording();
            snapshot_trap_mem.finalizeRecording();
            snapshot_break_reg.finalizeRecording();
            snapshot_break_mem.finalizeRecording();
        }
    }

    public static void stepn(int n) {
        System.arraycopy(Debugger.vm.R, 0, oldRegisters, 0, 32);
        for (int i = 0; i < n && !Debugger.suspendVM(); ++i) {
            Debugger.step();
        }
    }

    private static void loadMemSnapshot(File f) throws IOException {
        BufferedInputStream input = new BufferedInputStream(new FileInputStream(f));
        int l = (int)f.length();
        for (int i = 0; i < l; ++i) {
            Debugger.vm.mem8.put(i ^ 3, (byte)input.read());
        }
        input.close();
    }

    private static void loadRegSnapshot(File f) throws IOException {
        BufferedInputStream input = new BufferedInputStream(new FileInputStream(f));
        for (int i = 0; i < 32; ++i) {
            int b1 = input.read();
            int b2 = input.read();
            int b3 = input.read();
            int b4 = input.read();
            Debugger.vm.R[i] = b4 << 24 | b3 << 16 | b2 << 8 | b1;
        }
        input.close();
    }

    public static void suspend() {
        autosuspend = true;
    }

    private static boolean suspendVM() {
        if (vm.isSuspended()) {
            vm.setSuspend(false);
            return true;
        }
        if (autosuspend) {
            return true;
        }
        if (Debugger.hasBreakPoint(Debugger.vm.pc)) {
            return true;
        }
        int address = vm.getNextReadAddress();
        if (address >= 0 && (dataBreakPoints[address] & 1) > 0) {
            return true;
        }
        address = vm.getNextWriteAddress();
        if (address >= 0 && (dataBreakPoints[address] & 2) > 0) {
            return true;
        }
        if (traceBuffer == null) {
            return false;
        }
        if (Debugger.vm.instructionCounter > (long)traceBuffer.capacity()) {
            return false;
        }
        return Debugger.vm.instructionCounter == (long)traceBuffer.capacity() || traceBuffer.get((int)Debugger.vm.instructionCounter) != Debugger.vm.pc;
    }

    private static boolean hasBreakPoint(Integer line) {
        return breakPoints.contains(line);
    }

    public static void showCodePos(int row) {
        Point p = new Point(0, row * code.getRowHeight());
        if (!codeScroll.getViewport().getViewRect().contains(p)) {
            codeScroll.getViewport().setViewPosition(p);
        }
    }

    public static void showMemPos(int address) {
        Point p = new Point(0, address / 16 * code.getRowHeight());
        if (!rawMemScroll.getViewport().getViewRect().contains(p)) {
            rawMemScroll.getViewport().setViewPosition(p);
        }
    }

    public static void updateRegisters() {
        vmModel.fireTableDataChanged();
        memTableModel.fireTableDataChanged();
        rawMemModel.fireTableDataChanged();
    }

    public static void main(String[] args) {
        new Debugger();
        new CommandLine(System.in, System.out);
    }

    static {
        breakPoints = new ArrayList();
        dataBreakPoints = new byte[0x400000];
        oldRegisters = new int[32];
        memTableModel = new MemTableModel();
        code = new JTable(memTableModel);
        codeScroll = new JScrollPane(code);
        vmModel = new VMTableModel();
        vmState = new JTable(vmModel);
        rawMemModel = new RawMemTableModel();
        rawMemView = new JTable(rawMemModel);
        rawMemScroll = new JScrollPane(rawMemView);
    }

    private class RawMemTableRenderer
    extends JLabel
    implements TableCellRenderer {
        private static final long serialVersionUID = -123502368819L;
        private final Color[] COLORS = new Color[]{Color.WHITE, Color.GREEN, Color.RED, Color.YELLOW, new Color(100, 100, 255), Color.CYAN, Color.MAGENTA, Color.LIGHT_GRAY, Color.ORANGE};

        public RawMemTableRenderer() {
            this.setOpaque(true);
            this.setFont(new Font("Monospaced", 0, 12));
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Color background = Color.white;
            if (column >= 1 && column <= 16) {
                int address = row * 16 + column - 1;
                int mask = dataBreakPoints[address];
                if (isSelected) {
                    mask |= 4;
                }
                background = this.COLORS[Math.min(mask, this.COLORS.length - 1)];
            }
            this.setBackground(background);
            this.setText(value.toString());
            return this;
        }
    }

    private static class RawMemTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 227447967395833360L;

        private RawMemTableModel() {
        }

        @Override
        public int getColumnCount() {
            return 18;
        }

        @Override
        public int getRowCount() {
            return 262144;
        }

        @Override
        public String getColumnName(int column) {
            return "";
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            int address = rowIndex * 16;
            if (columnIndex == 0) {
                return Integer.toHexString(address).toUpperCase();
            }
            if (columnIndex <= 16) {
                int b = Debugger.vm.mem8.get(address + (columnIndex - 1) % 16);
                b = b < 0 ? b + 256 : b;
                String tmp = Integer.toHexString(b).toUpperCase();
                tmp = tmp.length() == 1 ? "0" + tmp : tmp;
                return tmp;
            }
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < 16; ++i) {
                byte b = Debugger.vm.mem8.get(address + i);
                if (b >= 32 && b <= 126) {
                    sb.append((char)b);
                    continue;
                }
                sb.append(".");
            }
            return sb.toString();
        }
    }

    private class MemTableRenderer
    extends JLabel
    implements TableCellRenderer {
        private static final long serialVersionUID = -4464870005802860210L;
        private final Color selected = new Color(200, 200, 255);

        public MemTableRenderer() {
            this.setOpaque(true);
            this.setFont(new Font("Monospaced", 0, 12));
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Color background = isSelected ? this.selected : Color.WHITE;
            background = row == Debugger.vm.pc / 4 ? Color.YELLOW : background;
            this.setBackground(background);
            this.setText(value.toString());
            return this;
        }
    }

    private static class MemTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = -391050575586742206L;
        private final String[] COL_NAMES = new String[]{"x", "address", "raw value", "instruction"};

        private MemTableModel() {
        }

        @Override
        public int getColumnCount() {
            return 4;
        }

        @Override
        public int getRowCount() {
            return 0x100000;
        }

        @Override
        public String getColumnName(int column) {
            return this.COL_NAMES[column];
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (columnIndex == 0) {
                return Debugger.hasBreakPoint(rowIndex * 4) ? "x" : "";
            }
            if (columnIndex == 1) {
                return String.format("%08X", rowIndex * 4);
            }
            if (columnIndex == 2) {
                return String.format("%08X", Debugger.vm.mem32.get(rowIndex));
            }
            try {
                return vm.disassemble(rowIndex * 4);
            }
            catch (Exception e) {
                return "";
            }
        }
    }

    private class VMTableRenderer
    extends JLabel
    implements TableCellRenderer {
        private static final long serialVersionUID = -4464870005802860210L;

        public VMTableRenderer() {
            this.setOpaque(true);
            this.setFont(new Font("Monospaced", 0, 12));
            this.setBackground(new Color(242, 242, 255));
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Color textColor = Color.BLACK;
            if (row < 16 && (column & 1) == 1) {
                int idx = column / 2 * 16 + row;
                if (oldRegisters[idx] != Debugger.vm.R[idx]) {
                    textColor = Color.red;
                }
            }
            this.setForeground(textColor);
            this.setText(value.toString());
            return this;
        }
    }

    private static class VMTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 3797759536948048029L;
        private final String[] LABELS16 = new String[]{"", "pc", "expected pc", "instruction counter", "watch dog counter", "expected watch dog", "trap counter", "break counter"};

        private VMTableModel() {
        }

        @Override
        public int getColumnCount() {
            return 4;
        }

        @Override
        public int getRowCount() {
            return 24;
        }

        @Override
        public String getColumnName(int column) {
            return "";
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (rowIndex < 16) {
                int idx = columnIndex / 2 * 16 + rowIndex;
                if ((columnIndex & 1) == 0) {
                    return String.format("r%02d", idx);
                }
                return String.format("%08X", Debugger.vm.R[idx]);
            }
            switch (columnIndex) {
                case 0: {
                    if (rowIndex != 16) {
                        return this.LABELS16[rowIndex - 16];
                    }
                    return vm.getNextTrap() != 0 ? String.format("TRAP#%04X", vm.getNextTrap()) : "";
                }
                case 1: {
                    switch (rowIndex) {
                        case 16: {
                            return vm.getNextTrap() != 0 ? constants.getTrapName(vm.getNextTrap()) : "";
                        }
                        case 17: {
                            return String.format("%08X", Debugger.vm.pc);
                        }
                        case 18: {
                            try {
                                return String.format("%08X", traceBuffer.get((int)Debugger.vm.instructionCounter));
                            }
                            catch (Exception e) {
                                return "";
                            }
                        }
                        case 19: {
                            return "" + Debugger.vm.instructionCounter;
                        }
                        case 20: {
                            return String.format("%08X", Debugger.vm.watchDogCounter);
                        }
                        case 21: {
                            try {
                                return String.format("%08X", timerBuffer.get((int)Debugger.vm.instructionCounter));
                            }
                            catch (Exception e) {
                                return "";
                            }
                        }
                        case 22: {
                            return "" + Debugger.vm.trapCounter;
                        }
                        case 23: {
                            return "" + Debugger.vm.breakCounter;
                        }
                    }
                }
                case 2: {
                    int idx = rowIndex - 16;
                    return vm.getNextTrap() != 0 && idx < constants.getTrapParamCount(vm.getNextTrap()) ? constants.getTrapParam(vm.getNextTrap(), idx) : "";
                }
                case 3: {
                    int idx = rowIndex - 16;
                    return vm.getNextTrap() != 0 && idx < constants.getTrapParamCount(vm.getNextTrap()) ? String.format("%08X", vm.getStackArg(idx)) : "";
                }
            }
            return "";
        }
    }
}

