/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.napkinlaf.util;

import java.awt.geom.Point2D;
import net.sourceforge.napkinlaf.util.RandomValue;

public class RandomXY {
    private final RandomValue x;
    private final RandomValue y;
    private Point2D point;
    private Point2D mid;
    private Point2D min;
    private Point2D max;

    public RandomXY(double xMid, double yMid) {
        this(xMid, 0.0, yMid, 0.0);
    }

    public RandomXY(double xMid, double xRange, double yMid, double yRange) {
        this(new RandomValue(xMid, xRange), new RandomValue(yMid, yRange));
    }

    public RandomXY(RandomValue x, RandomValue y) {
        this.x = x;
        this.y = y;
    }

    public void randomize() {
        this.x.randomize();
        this.y.randomize();
        this.point = null;
    }

    public Point2D get() {
        if (this.point == null) {
            this.point = new Point2D.Double(this.x.get(), this.y.get());
        }
        return this.point;
    }

    public Point2D generate() {
        this.randomize();
        return this.get();
    }

    public RandomValue getX() {
        return this.x;
    }

    public RandomValue getY() {
        return this.y;
    }

    public void setMid(double xMid, double yMid) {
        this.x.setMid(xMid);
        this.y.setMid(yMid);
        this.max = null;
        this.min = null;
        this.mid = null;
    }

    public Point2D getMid() {
        if (this.mid == null) {
            this.mid = new Point2D.Double(this.x.getMid(), this.y.getMid());
        }
        return this.mid;
    }

    public Point2D max() {
        if (this.max == null) {
            this.max = new Point2D.Double(this.x.max(), this.y.max());
        }
        return this.max;
    }

    public Point2D min() {
        if (this.min == null) {
            this.min = new Point2D.Double(this.x.min(), this.y.min());
        }
        return this.min;
    }
}

