package pgbennett.jampal;
/*
    Copyright 2004 Peter Bennett

    This file is part of Jampal.

    Jampal is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Jampal is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Jampal.  If not, see <http://www.gnu.org/licenses/>.
*/

import java.io.File;
import javax.swing.*;
import javax.swing.filechooser.*;

/* ImageFilter.java is a 1.4 example used by FileChooserDemo2.java. */
public class ImageFileFilter extends Mp3FileFilter implements java.io.FileFilter {

    //Accept all directories and all mp3 files.
    public boolean accept(File f) {
        if (f.isDirectory()) {
            return true;
        }

        String extension = getExtension(f);
        if ("bmp".equalsIgnoreCase(extension))
            return true;
        if ("gif".equalsIgnoreCase(extension))
            return true;
        if ("jpg".equalsIgnoreCase(extension))
            return true;
        if ("jpeg".equalsIgnoreCase(extension))
            return true;
        return false;
    }

    //The description of this filter
    public String getDescription() {
        return "Image Files";
    }


}

