/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.net.ftp.parser;

import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPFileEntryParser;
import org.apache.commons.net.ftp.FTPFileEntryParserImpl;

public class CompositeFileEntryParser
extends FTPFileEntryParserImpl {
    private final FTPFileEntryParser[] ftpFileEntryParsers;
    private FTPFileEntryParser cachedFtpFileEntryParser = null;

    public CompositeFileEntryParser(FTPFileEntryParser[] fTPFileEntryParserArray) {
        this.ftpFileEntryParsers = fTPFileEntryParserArray;
    }

    public FTPFile parseFTPEntry(String string) {
        if (this.cachedFtpFileEntryParser != null) {
            FTPFile fTPFile = this.cachedFtpFileEntryParser.parseFTPEntry(string);
            if (fTPFile != null) {
                return fTPFile;
            }
        } else {
            int n = 0;
            while (n < this.ftpFileEntryParsers.length) {
                FTPFileEntryParser fTPFileEntryParser = this.ftpFileEntryParsers[n];
                FTPFile fTPFile = fTPFileEntryParser.parseFTPEntry(string);
                if (fTPFile != null) {
                    this.cachedFtpFileEntryParser = fTPFileEntryParser;
                    return fTPFile;
                }
                ++n;
            }
        }
        return null;
    }
}

