#ifndef LANG_CODES_H_
#define LANG_CODES_H_

#include <array>

struct QtvLangCode
{
    const char* const code;
    const char* const lang;
};

static const std::array<QtvLangCode, 13> shortLangList = {
    QtvLangCode{"zho", "Chinese"},   QtvLangCode{"nld", "\"Dutch; Flemish\""},
    QtvLangCode{"eng", "English"},   QtvLangCode{"fin", "Finnish"},
    QtvLangCode{"fre", "French"},    QtvLangCode{"ger", "German"},
    QtvLangCode{"ita", "Italian"},   QtvLangCode{"jpn", "Japanese"},
    QtvLangCode{"nor", "Norwegian"}, QtvLangCode{"por", "Portuguese"},
    QtvLangCode{"rus", "Russian"},   QtvLangCode{"spa", "\"Spanish; Castilian\""},
    QtvLangCode{"swe", "Swedish\""}};

static const std::array<QtvLangCode, 502> fullLangList = {
    QtvLangCode{"ace", "Acehnese, Achinese"},
    QtvLangCode{"ach", "Acoli"},
    QtvLangCode{"ada", "Adangme"},
    QtvLangCode{"ady", "\"Adyghe; Adygei\""},
    QtvLangCode{"aar", "Afar"},
    QtvLangCode{"afh", "Afrihili"},
    QtvLangCode{"afr", "Afrikaans"},
    QtvLangCode{"afa", "Afro-Asiatic (Other)"},
    QtvLangCode{"ain", "Ainu"},
    QtvLangCode{"aka", "Akan"},
    QtvLangCode{"akk", "Akkadian"},
    QtvLangCode{"alb", "Albanian"},
    QtvLangCode{"sqi", "Albanian"},
    QtvLangCode{"ale", "Aleut"},
    QtvLangCode{"alg", "Algonquian languages"},
    QtvLangCode{"tut", "Altaic (Other)"},
    QtvLangCode{"amh", "Amharic"},
    QtvLangCode{"anp", "Angika"},
    QtvLangCode{"apa", "Apache languages"},
    QtvLangCode{"ara", "Arabic"},
    QtvLangCode{"arg", "Aragonese"},
    QtvLangCode{"arc", "Aramaic"},
    QtvLangCode{"arp", "Arapaho"},
    QtvLangCode{"arn", "Araucanian"},
    QtvLangCode{"arw", "Arawak"},
    QtvLangCode{"arm", "Armenian"},
    QtvLangCode{"hye", "Armenian"},
    QtvLangCode{"rup", "\"Aromanian; Arumanian; Macedo-Romanian\""},
    QtvLangCode{"art", "Artificial (Other)"},
    QtvLangCode{"asm", "Assamese"},
    QtvLangCode{"ast", "\"Asturian; Bable\""},
    QtvLangCode{"ath", "Athapascan languages"},
    QtvLangCode{"aus", "Australian languages"},
    QtvLangCode{"bar", "Austro-Bavarian"},
    QtvLangCode{"map", "Austronesian (Other)"},
    QtvLangCode{"ava", "Avaric"},
    QtvLangCode{"ave", "Avestan"},
    QtvLangCode{"awa", "Awadhi"},
    QtvLangCode{"aym", "Aymara"},
    QtvLangCode{"aze", "Azerbaijani"},
    QtvLangCode{"ban", "Balinese"},
    QtvLangCode{"bat", "Baltic (Other)"},
    QtvLangCode{"bal", "Baluchi"},
    QtvLangCode{"bam", "Bambara"},
    QtvLangCode{"bai", "Bamileke languages"},
    QtvLangCode{"bad", "Banda"},
    QtvLangCode{"bnt", "Bantu (Other)"},
    QtvLangCode{"bas", "Basa"},
    QtvLangCode{"bak", "Bashkir"},
    QtvLangCode{"eus", "Basque"},
    QtvLangCode{"eus", "Basque"},
    QtvLangCode{"btk", "Batak (Indonesia)"},
    QtvLangCode{"bej", "Beja"},
    QtvLangCode{"bel", "Belarusian"},
    QtvLangCode{"bem", "Bemba"},
    QtvLangCode{"ben", "Bengali"},
    QtvLangCode{"ber", "Berber (Other)"},
    QtvLangCode{"bho", "Bhojpuri"},
    QtvLangCode{"bih", "Bihari"},
    QtvLangCode{"bik", "Bikol languages"},
    QtvLangCode{"bin", "Bini"},
    QtvLangCode{"bis", "Bislama"},
    QtvLangCode{"byn", "\"Blin; Bilin\""},
    QtvLangCode{"bos", "Bosnian"},
    QtvLangCode{"bra", "Brij Bhasha"},
    QtvLangCode{"bre", "Breton"},
    QtvLangCode{"bug", "Buginese"},
    QtvLangCode{"bul", "Bulgarian"},
    QtvLangCode{"bua", "Buriat"},
    QtvLangCode{"bur", "Burmese"},
    QtvLangCode{"mya", "Burmese"},
    QtvLangCode{"cad", "Caddo"},
    QtvLangCode{"car", "Carib"},
    QtvLangCode{"cat", "\"Catalan; Valencian\""},
    QtvLangCode{"cau", "Caucasian (Other)"},
    QtvLangCode{"ceb", "Cebuano"},
    QtvLangCode{"cel", "Celtic (Other)"},
    QtvLangCode{"cai", "Central American Indian (Other)"},
    QtvLangCode{"chg", "Chagatai"},
    QtvLangCode{"cmc", "Chamic languages"},
    QtvLangCode{"cha", "Chamorro"},
    QtvLangCode{"che", "Chechen"},
    QtvLangCode{"chr", "Cherokee"},
    QtvLangCode{"chy", "Cheyenne"},
    QtvLangCode{"chb", "Chibcha"},
    QtvLangCode{"nya", "\"Chichewa; Chewa; Nyanja\""},
    QtvLangCode{"chi", "Chinese"},
    QtvLangCode{"zho", "Chinese"},
    QtvLangCode{"chn", "Chinook jargon"},
    QtvLangCode{"cho", "Choctaw"},
    QtvLangCode{"chu", "\"Church Slavonic; Church Slavic; Old Church Slavonic; Old Slavonic; Old Bulgarian\""},
    QtvLangCode{"chk", "Chuukese"},
    QtvLangCode{"chv", "Chuvash"},
    QtvLangCode{"nwc", "\"Classical Newari; Old Newari; Classical Nepal Bhasa\""},
    QtvLangCode{"syc", "Classical Syriac"},
    QtvLangCode{"cop", "Coptic"},
    QtvLangCode{"cor", "Cornish"},
    QtvLangCode{"cos", "Corsican"},
    QtvLangCode{"cre", "Cree"},
    QtvLangCode{"mus", "\"Creek; Muskogean\""},
    QtvLangCode{"crp", "Creoles and Pidgins (Other)"},
    QtvLangCode{"cpe", "Creoles and Pidgins, English-based (Other)"},
    QtvLangCode{"cpf", "Creoles and Pidgins, French-based (Other)"},
    QtvLangCode{"cpp", "Creoles and Pidgins, Portuguese-based (Other)"},
    QtvLangCode{"crh", "Crimean Tatar (Crimean Turkish)"},
    QtvLangCode{"scr", "Croatian"},
    QtvLangCode{"hrv", "Croatian"},
    QtvLangCode{"cus", "Cushitic (Other)"},
    QtvLangCode{"cze", "Czech"},
    QtvLangCode{"ces", "Czech"},
    QtvLangCode{"dak", "Dakota"},
    QtvLangCode{"dan", "Danish"},
    QtvLangCode{"dar", "Dargwa"},
    QtvLangCode{"day", "Dayak"},
    QtvLangCode{"del", "Delaware"},
    QtvLangCode{"chp", "Dene Suline"},
    QtvLangCode{"din", "Dinka"},
    QtvLangCode{"div", "\"Divehi; Dhivehi; Maldivian\""},
    QtvLangCode{"doi", "Dogri"},
    QtvLangCode{"dgr", "Dogrib"},
    QtvLangCode{"dra", "Dravidian (Other)"},
    QtvLangCode{"dua", "Duala"},
    QtvLangCode{"dut", "\"Dutch; Flemish\""},
    QtvLangCode{"nld", "\"Dutch; Flemish\""},
    QtvLangCode{"dum", "Dutch, Middle (ca. 1050?1350)"},
    QtvLangCode{"dyu", "Dyula"},
    QtvLangCode{"dzo", "Dzongkha"},
    QtvLangCode{"efi", "Efik"},
    QtvLangCode{"egy", "Egyptian (Ancient)"},
    QtvLangCode{"eka", "Ekajuk"},
    QtvLangCode{"elx", "Elamite"},
    QtvLangCode{"eng", "English"},
    QtvLangCode{"enm", "English, Middle (ca. 1100?1500)"},
    QtvLangCode{"ang", "English, Old (ca. 450?1100)"},
    QtvLangCode{"myv", "Erzya"},
    QtvLangCode{"epo", "Esperanto"},
    QtvLangCode{"est", "Estonian"},
    QtvLangCode{"ewe", "Ewe"},
    QtvLangCode{"ewo", "Ewondo"},
    QtvLangCode{"fan", "Fang"},
    QtvLangCode{"fat", "Fanti"},
    QtvLangCode{"fao", "Faroese"},
    QtvLangCode{"fij", "Fijian"},
    QtvLangCode{"fil", "Filipino"},
    QtvLangCode{"fin", "Finnish"},
    QtvLangCode{"fiu", "Finno-Ugrian (Other)"},
    QtvLangCode{"fon", "Fon"},
    QtvLangCode{"fre", "French"},
    QtvLangCode{"fra", "French"},
    QtvLangCode{"frm", "French, Middle (ca. 1400?1600)"},
    QtvLangCode{"fro", "French, Old (842?ca. 1400)"},
    QtvLangCode{"frs", "Frisian, Eastern"},
    QtvLangCode{"frr", "Frisian, Northern"},
    QtvLangCode{"fry", "Frisian, Western"},
    QtvLangCode{"fur", "Friulian"},
    QtvLangCode{"ful", "Fulah"},
    QtvLangCode{"gaa", "Ga"},
    QtvLangCode{"glg", "Galician"},
    QtvLangCode{"lug", "Ganda"},
    QtvLangCode{"gay", "Gayo"},
    QtvLangCode{"gba", "Gbaya"},
    QtvLangCode{"gez", "Ge'ez"},
    QtvLangCode{"geo", "Georgian"},
    QtvLangCode{"kat", "Georgian"},
    QtvLangCode{"ger", "German"},
    QtvLangCode{"deu", "German"},
    QtvLangCode{"gsw", "German, Alemannic"},
    QtvLangCode{"nds", "\"German, Low; Low German; Saxon, Low; Low Saxon\""},
    QtvLangCode{"gmh", "German, Middle High (ca. 1050?1500)"},
    QtvLangCode{"goh", "German, Old High (ca. 750?1050)"},
    QtvLangCode{"gem", "Germanic (Other)"},
    QtvLangCode{"gil", "\"Gilbertese; Kiribati\""},
    QtvLangCode{"gon", "Gondi"},
    QtvLangCode{"gor", "Gorontalo"},
    QtvLangCode{"got", "Gothic"},
    QtvLangCode{"grb", "Grebo"},
    QtvLangCode{"grc", "Greek, Ancient (to 1453)"},
    QtvLangCode{"gre", "Greek, Modern (1453)"},
    QtvLangCode{"ell", "Greek, Modern (1453)"},
    QtvLangCode{"kal", "\"Greenlandic; Kalaallisut\""},
    QtvLangCode{"grn", "Guarani"},
    QtvLangCode{"guj", "Gujarati"},
    QtvLangCode{"gwi", "Gwich?in"},
    QtvLangCode{"hai", "Haida"},
    QtvLangCode{"hat", "\"Haitian Creole; Haitian\""},
    QtvLangCode{"hau", "Hausa"},
    QtvLangCode{"haw", "Hawaiian"},
    QtvLangCode{"heb", "Hebrew"},
    QtvLangCode{"her", "Herero"},
    QtvLangCode{"hil", "Hiligaynon"},
    QtvLangCode{"him", "Himachali"},
    QtvLangCode{"hin", "Hindi"},
    QtvLangCode{"hmo", "Hiri Motu"},
    QtvLangCode{"hit", "Hittite"},
    QtvLangCode{"hmn", "Hmong"},
    QtvLangCode{"hun", "Hungarian"},
    QtvLangCode{"hup", "Hupa"},
    QtvLangCode{"iba", "Iban"},
    QtvLangCode{"ice", "Icelandic"},
    QtvLangCode{"isl", "Icelandic"},
    QtvLangCode{"ido", "Ido"},
    QtvLangCode{"ibo", "Igbo"},
    QtvLangCode{"ijo", "Ijo"},
    QtvLangCode{"ilo", "Iloko"},
    QtvLangCode{"smn", "Inari Sami"},
    QtvLangCode{"inc", "Indic (Other)"},
    QtvLangCode{"ine", "Indo-European (Other)"},
    QtvLangCode{"ind", "Indonesian"},
    QtvLangCode{"inh", "Ingush"},
    QtvLangCode{"ina", "Interlingua (International Auxiliary Language Association)"},
    QtvLangCode{"ile", "Interlingue"},
    QtvLangCode{"iku", "Inuktitut"},
    QtvLangCode{"ipk", "Inupiaq"},
    QtvLangCode{"ira", "Iranian (Other)"},
    QtvLangCode{"gle", "Irish"},
    QtvLangCode{"mga", "Irish, Middle (900?1200)"},
    QtvLangCode{"sga", "Irish, Old (to 900)"},
    QtvLangCode{"iro", "Iroquoian languages"},
    QtvLangCode{"ita", "Italian"},
    QtvLangCode{"jpn", "Japanese"},
    QtvLangCode{"jav", "Javanese"},
    QtvLangCode{"jrb", "Judeo-Arabic"},
    QtvLangCode{"jpr", "Judeo-Persian"},
    QtvLangCode{"kbd", "Kabardian"},
    QtvLangCode{"kab", "Kabyle"},
    QtvLangCode{"kac", "Kachin"},
    QtvLangCode{"xal", "\"Kalmyk; Oirat\""},
    QtvLangCode{"kam", "Kamba"},
    QtvLangCode{"kan", "Kannada"},
    QtvLangCode{"kau", "Kanuri"},
    QtvLangCode{"krc", "Karachay-Balkar"},
    QtvLangCode{"kaa", "Kara-Kalpak"},
    QtvLangCode{"krl", "Karelian"},
    QtvLangCode{"kar", "Karen"},
    QtvLangCode{"kas", "Kashmiri"},
    QtvLangCode{"csb", "Kashubian"},
    QtvLangCode{"kaw", "Kawi"},
    QtvLangCode{"kaz", "Kazakh"},
    QtvLangCode{"kha", "Khasi"},
    QtvLangCode{"khm", "Khmer"},
    QtvLangCode{"khi", "Khoisan (Other)"},
    QtvLangCode{"kho", "Khotanese"},
    QtvLangCode{"kik", "Kikuyu"},
    QtvLangCode{"kmb", "Kimbundu"},
    QtvLangCode{"kin", "Kinyarwanda"},
    QtvLangCode{"kir", "Kirghiz"},
    QtvLangCode{"tlh", "Klingon"},
    QtvLangCode{"kom", "Komi"},
    QtvLangCode{"kon", "Kongo"},
    QtvLangCode{"kok", "Konkani"},
    QtvLangCode{"kor", "Korean"},
    QtvLangCode{"kos", "Kosraean"},
    QtvLangCode{"kpe", "Kpelle"},
    QtvLangCode{"kro", "Kru"},
    QtvLangCode{"kua", "\"Kuanyama; Kwanyama\""},
    QtvLangCode{"kum", "Kumyk"},
    QtvLangCode{"kur", "Kurdish"},
    QtvLangCode{"kru", "Kurukh"},
    QtvLangCode{"kut", "Kutenai"},
    QtvLangCode{"lad", "Ladino"},
    QtvLangCode{"lah", "Lahnda"},
    QtvLangCode{"lam", "Lamba"},
    QtvLangCode{"lao", "Lao"},
    QtvLangCode{"lat", "Latin"},
    QtvLangCode{"lav", "Latvian"},
    QtvLangCode{"lez", "Lezghian"},
    QtvLangCode{"lim", "\"Limburgish; Limburger; Limburgan\""},
    QtvLangCode{"lin", "Lingala"},
    QtvLangCode{"lit", "Lithuanian"},
    QtvLangCode{"jbo", "Lojban"},
    QtvLangCode{"loz", "Lozi"},
    QtvLangCode{"lub", "Luba-Katanga"},
    QtvLangCode{"lua", "Luba-Lulua"},
    QtvLangCode{"lui", "Luise?o"},
    QtvLangCode{"smj", "Lule Sami"},
    QtvLangCode{"lun", "Lunda"},
    QtvLangCode{"luo", "Luo (Kenya and Tanzania)"},
    QtvLangCode{"lus", "Lushai"},
    QtvLangCode{"ltz", "\"Luxembourgish; Letzeburgesch\""},
    QtvLangCode{"mac", "Macedonian"},
    QtvLangCode{"mkd", "Macedonian"},
    QtvLangCode{"mad", "Madurese"},
    QtvLangCode{"mag", "Magahi"},
    QtvLangCode{"mai", "Maithili"},
    QtvLangCode{"mak", "Makasar"},
    QtvLangCode{"mlg", "Malagasy"},
    QtvLangCode{"may", "Malay"},
    QtvLangCode{"msa", "Malay"},
    QtvLangCode{"mal", "Malayalam"},
    QtvLangCode{"mlt", "Maltese"},
    QtvLangCode{"mnc", "Manchu"},
    QtvLangCode{"mdr", "Mandar"},
    QtvLangCode{"man", "Mandingo"},
    QtvLangCode{"mni", "Manipuri"},
    QtvLangCode{"mno", "Manobo languages"},
    QtvLangCode{"glv", "Manx"},
    QtvLangCode{"mao", "Maori"},
    QtvLangCode{"mri", "Maori"},
    QtvLangCode{"mar", "Marathi"},
    QtvLangCode{"chm", "Mari"},
    QtvLangCode{"mah", "Marshallese"},
    QtvLangCode{"mwr", "Marwari"},
    QtvLangCode{"mas", "Masai"},
    QtvLangCode{"myn", "Mayan languages"},
    QtvLangCode{"men", "Mende"},
    QtvLangCode{"mic", "\"Mi'kmaq; Micmac\""},
    QtvLangCode{"min", "Minangkabau"},
    QtvLangCode{"mwl", "Mirandese"},
    QtvLangCode{"moh", "Mohawk"},
    QtvLangCode{"mdf", "Moksha"},
    QtvLangCode{"mol", "Moldavian"},
    QtvLangCode{"mkh", "Mon-Khmer (Other)"},
    QtvLangCode{"lol", "Mongo"},
    QtvLangCode{"mon", "Mongolian"},
    QtvLangCode{"mos", "Mossi"},
    QtvLangCode{"mun", "Munda languages"},
    QtvLangCode{"nah", "Nahuatl"},
    QtvLangCode{"nau", "Nauruan"},
    QtvLangCode{"nav", "\"Navajo; Navaho\""},
    QtvLangCode{"nde", "Ndebele, North"},
    QtvLangCode{"nbl", "Ndebele, South"},
    QtvLangCode{"ndo", "Ndonga"},
    QtvLangCode{"nap", "Neapolitan"},
    QtvLangCode{"new", "\"Nepal Bhasa; Newari\""},
    QtvLangCode{"nep", "Nepali"},
    QtvLangCode{"nia", "Nias"},
    QtvLangCode{"nic", "Niger-Kordofanian (Other)"},
    QtvLangCode{"ssa", "Nilo-Saharan (Other)"},
    QtvLangCode{"niu", "Niuean"},
    QtvLangCode{"nqo", "N'Ko"},
    QtvLangCode{"nog", "Nogai"},
    QtvLangCode{"non", "Norse, Old"},
    QtvLangCode{"nai", "North American Indian (Other)"},
    QtvLangCode{"sme", "Northern Sami"},
    QtvLangCode{"nor", "Norwegian"},
    QtvLangCode{"nob", "Norwegian Bokm?l"},
    QtvLangCode{"nno", "Norwegian Nynorsk"},
    QtvLangCode{"nub", "Nubian languages"},
    QtvLangCode{"nym", "Nyamwezi"},
    QtvLangCode{"nyn", "Nyankole"},
    QtvLangCode{"nyo", "Nyoro"},
    QtvLangCode{"nzi", "Nzima"},
    QtvLangCode{"oci", "\"Occitan (post 1500); Proven?al\""},
    QtvLangCode{"oji", "Ojibwa, Anishinaabe languages"},
    QtvLangCode{"ori", "Oriya"},
    QtvLangCode{"orm", "Oromo"},
    QtvLangCode{"osa", "Osage"},
    QtvLangCode{"oss", "\"Ossetian; Ossetic\""},
    QtvLangCode{"oto", "Otomian languages"},
    QtvLangCode{"pal", "Pahlavi (Middle Persian)"},
    QtvLangCode{"pau", "Palauan"},
    QtvLangCode{"pli", "Pali"},
    QtvLangCode{"pam", "Pampanga"},
    QtvLangCode{"pag", "Pangasinan"},
    QtvLangCode{"pap", "Papiamento"},
    QtvLangCode{"paa", "Papuan (Other)"},
    QtvLangCode{"per", "Persian"},
    QtvLangCode{"fas", "Persian"},
    QtvLangCode{"peo", "Persian, Old (ca. 600?400 BC)"},
    QtvLangCode{"phi", "Philippine (Other)"},
    QtvLangCode{"phn", "Phoenician"},
    QtvLangCode{"pon", "Pohnpeian"},
    QtvLangCode{"pol", "Polish"},
    QtvLangCode{"por", "Portuguese"},
    QtvLangCode{"pra", "Prakrit languages"},
    QtvLangCode{"pro", "Proven?al, Old (to 1500)"},
    QtvLangCode{"pan", "\"Punjabi; Panjabi\""},
    QtvLangCode{"pus", "Pushto"},
    QtvLangCode{"que", "Quechuan languages"},
    QtvLangCode{"roh", "Raeto-Romance"},
    QtvLangCode{"raj", "Rajasthani"},
    QtvLangCode{"rap", "Rapanui"},
    QtvLangCode{"rar", "Rarotongan"},
    QtvLangCode{"roa", "Romance (Other)"},
    QtvLangCode{"rum", "Romanian"},
    QtvLangCode{"ron", "Romanian"},
    QtvLangCode{"rom", "Romany"},
    QtvLangCode{"run", "Rundi"},
    QtvLangCode{"rus", "Russian"},
    QtvLangCode{"sal", "Salishan languages"},
    QtvLangCode{"sam", "Samaritan Aramaic"},
    QtvLangCode{"smi", "Sami languages (Other)"},
    QtvLangCode{"smo", "Samoan"},
    QtvLangCode{"sad", "Sandawe"},
    QtvLangCode{"sag", "Sango"},
    QtvLangCode{"san", "Sanskrit"},
    QtvLangCode{"sat", "Santali"},
    QtvLangCode{"srd", "Sardinian"},
    QtvLangCode{"sas", "Sasak"},
    QtvLangCode{"sco", "Scots"},
    QtvLangCode{"gla", "\"Scottish Gaelic; Gaelic\""},
    QtvLangCode{"sel", "Selkup"},
    QtvLangCode{"sem", "Semitic (Other)"},
    QtvLangCode{"scc", "Serbian"},
    QtvLangCode{"srp", "Serbian"},
    QtvLangCode{"srr", "Serer"},
    QtvLangCode{"shn", "Shan"},
    QtvLangCode{"sna", "Shona"},
    QtvLangCode{"iii", "Sichuan Yi"},
    QtvLangCode{"scn", "Sicilian"},
    QtvLangCode{"sid", "Sidamo"},
    QtvLangCode{"sgn", "Sign languages"},
    QtvLangCode{"bla", "Siksika"},
    QtvLangCode{"snd", "Sindhi"},
    QtvLangCode{"sin", "\"Sinhalese; Sinhala\""},
    QtvLangCode{"sit", "Sino-Tibetan (Other)"},
    QtvLangCode{"sio", "Siouan languages"},
    QtvLangCode{"sms", "Skolt Sami"},
    QtvLangCode{"den", "Slave (Athapascan)"},
    QtvLangCode{"sla", "Slavic (Other)"},
    QtvLangCode{"slo", "Slovak"},
    QtvLangCode{"slk", "Slovak"},
    QtvLangCode{"slv", "Slovenian"},
    QtvLangCode{"sog", "Sogdian"},
    QtvLangCode{"som", "Somali"},
    QtvLangCode{"son", "Songhai"},
    QtvLangCode{"snk", "Soninke"},
    QtvLangCode{"wen", "Sorbian languages"},
    QtvLangCode{"dsb", "Sorbian, Lower"},
    QtvLangCode{"hsb", "Sorbian, Upper"},
    QtvLangCode{"nso", "\"Sotho; Northern; Pedi; Sepedi\""},
    QtvLangCode{"sot", "Sotho, Southern"},
    QtvLangCode{"sai", "South American Indian (Other)"},
    QtvLangCode{"alt", "Southern Altai"},
    QtvLangCode{"sma", "Southern Sami"},
    QtvLangCode{"spa", "\"Spanish; Castilian\""},
    QtvLangCode{"srn", "Sranan Tongo"},
    QtvLangCode{"suk", "Sukuma"},
    QtvLangCode{"sux", "Sumerian"},
    QtvLangCode{"sun", "Sundanese"},
    QtvLangCode{"sus", "Susu"},
    QtvLangCode{"swa", "Swahili"},
    QtvLangCode{"ssw", "Swati"},
    QtvLangCode{"swe", "Swedish"},
    QtvLangCode{"syr", "Syriac"},
    QtvLangCode{"tgl", "Tagalog"},
    QtvLangCode{"tah", "Tahitian"},
    QtvLangCode{"tai", "Tai (Other)"},
    QtvLangCode{"tgk", "Tajik"},
    QtvLangCode{"tmh", "Tamashek"},
    QtvLangCode{"tam", "Tamil"},
    QtvLangCode{"tat", "Tatar"},
    QtvLangCode{"tel", "Telugu"},
    QtvLangCode{"ter", "Tereno"},
    QtvLangCode{"tet", "Tetum, Lia-Tetun"},
    QtvLangCode{"tha", "Thai"},
    QtvLangCode{"tib", "Tibetan"},
    QtvLangCode{"bod", "Tibetan"},
    QtvLangCode{"tig", "Tigre"},
    QtvLangCode{"tir", "Tigrinya"},
    QtvLangCode{"tem", "Timne"},
    QtvLangCode{"tiv", "Tiv"},
    QtvLangCode{"tli", "Tlingit"},
    QtvLangCode{"tpi", "Tok Pisin"},
    QtvLangCode{"tkl", "Tokelau"},
    QtvLangCode{"tog", "Tonga (Malawi)"},
    QtvLangCode{"ton", "Tongan"},
    QtvLangCode{"tsi", "Tsimshian"},
    QtvLangCode{"tso", "Tsonga"},
    QtvLangCode{"tsn", "Tswana"},
    QtvLangCode{"tum", "Tumbuka"},
    QtvLangCode{"tup", "Tupi languages"},
    QtvLangCode{"tur", "Turkish"},
    QtvLangCode{"ota", "Turkish, Ottoman (1500?1928)"},
    QtvLangCode{"tuk", "Turkmen"},
    QtvLangCode{"tvl", "Tuvalu"},
    QtvLangCode{"tyv", "Tuvinian"},
    QtvLangCode{"twi", "Twi"},
    QtvLangCode{"udm", "Udmurt"},
    QtvLangCode{"uga", "Ugaritic"},
    QtvLangCode{"uig", "\"Uighur; Uyghur\""},
    QtvLangCode{"ukr", "Ukrainian"},
    QtvLangCode{"umb", "Umbundu"},
    QtvLangCode{"urd", "Urdu"},
    QtvLangCode{"uzb", "Uzbek"},
    QtvLangCode{"vai", "Vai"},
    QtvLangCode{"ven", "Venda"},
    QtvLangCode{"vie", "Vietnamese"},
    QtvLangCode{"vol", "Volap?k"},
    QtvLangCode{"vot", "Votic"},
    QtvLangCode{"wak", "Wakashan languages"},
    QtvLangCode{"wal", "Walamo"},
    QtvLangCode{"wln", "Walloon"},
    QtvLangCode{"war", "Waray"},
    QtvLangCode{"was", "Washo"},
    QtvLangCode{"wel", "Welsh"},
    QtvLangCode{"cym", "Welsh"},
    QtvLangCode{"wol", "Wolof"},
    QtvLangCode{"xho", "Xhosa"},
    QtvLangCode{"sah", "Yakut"},
    QtvLangCode{"yao", "Yao"},
    QtvLangCode{"yap", "Yapese"},
    QtvLangCode{"yid", "Yiddish"},
    QtvLangCode{"yor", "Yoruba"},
    QtvLangCode{"ypk", "Yupik languages"},
    QtvLangCode{"znd", "Zande"},
    QtvLangCode{"zza", "\"Zaza; Dimili; Dimli; Kirdki; Kirmanjki; Zazaki\""},
    QtvLangCode{"zap", "Zapotec"},
    QtvLangCode{"zen", "Zenaga"},
    QtvLangCode{"zha", "\"Zhuang; Chuang\""},
    QtvLangCode{"zul", "Zulu"},
    QtvLangCode{"zun", "Zuni'"}};

#endif
