#!/usr/bin/perl -w
use Tk;
use Tk::Dialog;
use Tk::ProgressBar;
use strict;

############ MAIN #############

my $mainw = new MainWindow(-title => "xcutmp3", -background=>'white');
$mainw->optionAdd('*font', 'Helvetica 12');
$mainw->optionAdd('*foreground', '#2e598a');

my $save = $mainw->Frame(-relief => "flat", -borderwidth => "2")->pack(-padx => 5,-pady => 5, -side => "top");
$save->Button(-text => "save file", -command => sub {print("s");} )->pack(-padx => 1, -pady => 1, -side => "left");
# $save->Button(-text => "save file with tag", -command => sub {print("t");} )->pack(-padx => 1, -pady => 1, -side => "left");
# $save->Button(-text => "cut another file", -command => sub { system("killall cutmp3"); system("konsole -e xcutmp3"); } )->pack(-padx => 1, -pady => 1, -side => "left");

my $setmulti = $mainw->Frame(-relief => "flat", -borderwidth => "2")->pack(-padx => 5,-pady => 5, -side => "top");
$setmulti->Button(-text => "set endpoint + save + set startpoint", -command => sub {print("w");} )->pack(-padx => 1, -pady => 1, -side => "left");
# $setmulti->Button(-text => "set endpoint + save with tag + set startpoint", -command => sub {print("W");} )->pack(-padx => 1, -pady => 1, -side => "left");

my $seek = $mainw->Frame(-relief => "flat", -borderwidth => "2")->pack(-padx => 5,-pady => 5, -side => "top");
$seek->Button(-text => "seek ID3 tag", -command => sub {print("T");} )->pack(-padx => 1, -pady => 1, -side => "left");
$seek->Button(-text => "seek to silence end", -command => sub {print("p");} )->pack(-padx => 1, -pady => 1, -side => "left");
$seek->Button(-text => "seek to silence start", -command => sub {print("P");} )->pack(-padx => 1, -pady => 1, -side => "left");

my $oneframe = $mainw->Frame(-relief => "flat", -borderwidth => "2")->pack(-padx => 5,-pady => 5, -side => "top");
$oneframe->Button(-text => "<\n-1 Frame", -command => sub {print(",");} )->pack(-padx => 1, -pady => 1, -side => "left");
$oneframe->Button(-text => ">\n+1 Frame", -command => sub {print(".");} )->pack(-padx => 1, -pady => 1, -side => "left");

my $go = $mainw->Frame(-relief => "flat", -borderwidth => "2")->pack(-padx => 5,-pady => 5, -side => "top");
$go->Button(-text => "<<<<<<\n-10 min", -command => sub {print("1");} )->pack(-padx => 1, -pady => 1, -side => "left");
$go->Button(-text => "<<<<<\n-1 min", -command => sub {print("2");} )->pack(-padx => 1, -pady => 1, -side => "left");
$go->Button(-text => "<<<<\n-10 sec", -command => sub {print("3");} )->pack(-padx => 1, -pady => 1, -side => "left");
$go->Button(-text => "<<<\n-1 sec", -command => sub {print("4");} )->pack(-padx => 1, -pady => 1, -side => "left");
$go->Button(-text => "<<\n-0.1 sec", -command => sub {print("5");} )->pack(-padx => 1, -pady => 1, -side => "left");
$go->Button(-text => ">>\n+0.1 sec", -command => sub {print("6");} )->pack(-padx => 1, -pady => 1, -side => "left");
$go->Button(-text => ">>>\n+1 sec", -command => sub {print("7");} )->pack(-padx => 1, -pady => 1, -side => "left");
$go->Button(-text => ">>>>\n+10 sec", -command => sub {print("8");} )->pack(-padx => 1, -pady => 1, -side => "left");
$go->Button(-text => ">>>>>\n+1 min", -command => sub {print("9");} )->pack(-padx => 1, -pady => 1, -side => "left");
$go->Button(-text => ">>>>>>\n+10 min", -command => sub {print("0");} )->pack(-padx => 1, -pady => 1, -side => "left");

my $setab = $mainw->Frame(-relief => "flat", -borderwidth => "2")->pack(-padx => 5,-pady => 5, -side => "top");
$setab->Button(-text => "set startpoint", -command => sub {print("a");} )->pack(-padx => 1, -pady => 1, -side => "left");
$setab->Button(-text => "replay", -command => sub {print("r");} )->pack(-padx => 1, -pady => 1, -side => "left");
$setab->Button(-text => "set endpoint", -command => sub {print("b");} )->pack(-padx => 1, -pady => 1, -side => "left");

my $goab = $mainw->Frame(-relief => "flat", -borderwidth => "2")->pack(-padx => 5,-pady => 5, -side => "top");
$goab->Button(-text => "go to startpoint", -command => sub {print("A");} )->pack(-padx => 1, -pady => 1, -side => "left");
$goab->Button(-text => "go to endpoint", -command => sub {print("B");} )->pack(-padx => 1, -pady => 1, -side => "left");

# my $id3 = $mainw->Frame(-relief => "flat", -borderwidth => "2")->pack(-padx => 5,-pady => 5, -side => "top");
# $id3->Button(-text => " 1 ", -command => sub {print("1");} )->pack(-padx => 1, -pady => 1, -side => "left");
# $id3->Button(-text => " 2 ", -command => sub {print("2");} )->pack(-padx => 1, -pady => 1, -side => "left");
# $id3->Button(-text => "Enter", -command => sub {print("\n");} )->pack(-padx => 1, -pady => 1, -side => "left");
# $id3->Button(-text => "clear >", -command => sub {print("");} )->pack(-padx => 1, -pady => 1, -side => "left");
# $id3->Button(-text => "< submit", -command => sub {print("");} )->pack(-padx => 1, -pady => 1, -side => "left");

my $volleng = $mainw->Frame(-relief => "flat", -borderwidth => "2")->pack(-padx => 5,-pady => 5, -side => "top");
$volleng->Button(-text => "decrease silence volume", -command => sub {print("-");} )->pack(-padx => 1, -pady => 1, -side => "left");
$volleng->Button(-text => "increase silence volume", -command => sub {print("+");} )->pack(-padx => 1, -pady => 1, -side => "left");
$volleng->Button(-text => "decrease silence length", -command => sub {print("n");} )->pack(-padx => 1, -pady => 1, -side => "left");
$volleng->Button(-text => "increase silence length", -command => sub {print("m");} )->pack(-padx => 1, -pady => 1, -side => "left");

my $conf = $mainw->Frame(-relief => "flat", -borderwidth => "2")->pack(-padx => 5,-pady => 5, -side => "top");
$conf->Button(-text => "show volume", -command => sub {print("v");} )->pack(-padx => 1, -pady => 1, -side => "left");
$conf->Button(-text => "show file info", -command => sub {print("i");} )->pack(-padx => 1, -pady => 1, -side => "left");
$conf->Button(-text => "overwrite on/off", -command => sub {print("o");} )->pack(-padx => 1, -pady => 1, -side => "left");
$conf->Button(-text => "mute on/off", -command => sub {print("#");} )->pack(-padx => 1, -pady => 1, -side => "left");
$conf->Button(-text => "save configuration", -command => sub {print("S");} )->pack(-padx => 1, -pady => 1, -side => "left");
$conf->Button(-text => "QUIT", -command => sub {print("q"); exit;} )->pack(-padx => 20, -pady => 1, -side => "right");

$mainw->bind('<q>' => sub { print("q"); exit });
# $mainw->bind('<s>' => sub { print("s"); });
# $mainw->bind('<S>' => sub { print("S"); });
# $mainw->bind('<o>' => sub { print("o"); });
# $mainw->bind('<i>' => sub { print("i"); });
# $mainw->bind('<v>' => sub { print("v"); });
# $mainw->bind('<->' => sub { print("-"); });
# $mainw->bind('<+>' => sub { print("+"); });
# $mainw->bind('<n>' => sub { print("n"); });
# $mainw->bind('<m>' => sub { print("m"); });
# $mainw->bind('<A>' => sub { print("A"); });
# $mainw->bind('<B>' => sub { print("B"); });
# $mainw->bind('<t>' => sub { print("t"); });
# $mainw->bind('<T>' => sub { print("T"); });
# $mainw->bind('<a>' => sub { print("a"); });
# $mainw->bind('<b>' => sub { print("b"); });
# $mainw->bind('<1>' => sub { print("1"); });
# $mainw->bind('<2>' => sub { print("2"); });
# $mainw->bind('<3>' => sub { print("3"); });
# $mainw->bind('<4>' => sub { print("4"); });
# $mainw->bind('<5>' => sub { print("5"); });
# $mainw->bind('<6>' => sub { print("6"); });
# $mainw->bind('<7>' => sub { print("7"); });
# $mainw->bind('<8>' => sub { print("8"); });
# $mainw->bind('<9>' => sub { print("9"); });
# $mainw->bind('<0>' => sub { print("0"); });
# $mainw->bind('<.>' => sub { print("."); });
# $mainw->bind('<,>' => sub { print(","); });
# $mainw->bind('<r>' => sub { print("r"); });
# $mainw->bind('<w>' => sub { print("w"); });
# $mainw->bind('<W>' => sub { print("W"); });
# $mainw->bind('<p>' => sub { print("p"); });
# $mainw->bind('<P>' => sub { print("P"); });

MainLoop;
