#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2018 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Everspace
# send your bug reports to bugs@dotslashplay.it
###

script_version=20250504.4

PLAYIT_COMPATIBILITY_LEVEL='2.32'

GAME_ID='everspace'
GAME_NAME='Everspace'

ARCHIVE_BASE_3_NAME='everspace_1_3_5_3655_32896.sh'
ARCHIVE_BASE_3_MD5='55c9230b3805c54d13371f940860d4a9'
ARCHIVE_BASE_3_SIZE='10280299'
ARCHIVE_BASE_3_VERSION='1.3.5-gog32896'
ARCHIVE_BASE_3_URL='https://www.gog.com/game/everspace'

ARCHIVE_BASE_2_NAME='everspace_1_3_4_29339.sh'
ARCHIVE_BASE_2_MD5='2010b839534fb5a265eea6116b9193ae'
ARCHIVE_BASE_2_SIZE='11000000'
ARCHIVE_BASE_2_VERSION='1.3.4-gog29339'

ARCHIVE_BASE_1_NAME='everspace_1_3_3_25886.sh'
ARCHIVE_BASE_1_MD5='df8f210059a515ef738f247bfcd61bb2'
ARCHIVE_BASE_1_SIZE='11000000'
ARCHIVE_BASE_1_VERSION='1.3.3-gog25886'

ARCHIVE_BASE_0_NAME='everspace_en_1_3_2_3_22978.sh'
ARCHIVE_BASE_0_MD5='4290b47c1396f140198f45a74bf53abf'
ARCHIVE_BASE_0_SIZE='11000000'
ARCHIVE_BASE_0_VERSION='1.3.2.3-gog22978'

UNREALENGINE4_NAME='RSG'

CONTENT_PATH_DEFAULT='data/noarch/game'

## TODO: Check why a regular symlinks prefix can not be used.
APPLICATIONS_PREFIX_TYPE='none'

APP_MAIN_EXE="${UNREALENGINE4_NAME}/Binaries/Linux/${UNREALENGINE4_NAME}-Linux-Shipping"
APP_MAIN_ICON='../support/icon.png'
## Prevent a segmentation fault when using the wayland backend of SDL.
## Using the system-provided SDL library is not an option, as it leads to a segmentation fault too.
APP_MAIN_PRERUN='
# Prevent a segmentation fault when using the wayland backend of SDL.
if [ "${SDL_VIDEODRIVER:-}" = "wayland" ]; then
	unset SDL_VIDEODRIVER
fi
'

PACKAGES_LIST='
PKG_BIN
PKG_DATA'

PKG_BIN_ARCH='64'
PKG_BIN_DEPENDENCIES_SIBLINGS='
PKG_DATA'
PKG_BIN_DEPENDENCIES_LIBRARIES='
libc.so.6
libdl.so.2
libgcc_s.so.1
libm.so.6
libpthread.so.0
librt.so.1
libstdc++.so.6
libvlc.so.5
libvlccore.so.9
libvlc_pulse.so'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Run the default initialization actions

initialization_default "$@"

# Extract game data

archive_extraction_default
(
	cd "${PLAYIT_WORKDIR}/gamedata/$(content_path_default)"

	## Drop old shipped libraries.
	rm --recursive 'RSG/Plugins'
)

# Include game data

content_inclusion_icons 'PKG_DATA'
content_inclusion_default

# Integrate with system-provided VLC libraries.

libraries_source=$(path_libraries_system)
libraries_destination="$(package_path 'PKG_BIN')$(path_game_data)/RSG/Plugins/VlcMedia/ThirdParty/vlc/Linux/x86_64-unknown-linux-gnu"
mkdir --parents "$libraries_destination"
ln --symbolic "${libraries_source}/libvlc.so.5" "${libraries_destination}/libvlc.so"
ln --symbolic "${libraries_source}/libvlccore.so.9" "${libraries_destination}/libvlccore.so"

# Write launchers

launchers_generation 'PKG_BIN'

# Build packages

packages_generation
print_instructions

# Clean up

working_directory_cleanup

exit 0
