---
title: "Home"
bg: white
color: black
style: center
---

<img src="img/logo.png" alt="JGraphT Logo" width="334" height="185" />

### a Java library of graph theory data structures and algorithms
{: .text-blue}

#### now with [Python bindings](https://pypi.org/project/jgrapht) too!
{: .text-blue}

<br>

### *flexible*

##### **any object** can be used for vertex and edge types, with full **type safety** via generics
##### edges can be **directed** or **undirected**, **weighted** or **unweighted**
##### **simple graphs**, **multigraphs**, and **pseudographs**
##### **unmodifiable** graphs allow modules to provide "read-only" access to internal graphs
##### **listenable** graphs allow external listeners to track modification events
##### live **subgraph** views on other graphs
##### **compositions** and **converter views** for combining and adapting graphs
##### **customizable** incidence and adjacency representations

<br>

### *powerful*
##### specialized **iterators** for graph traversal (**DFS**, **BFS**, etc)
##### **algorithms** for path finding, clique detection, isomorphism detection, coloring, common ancestors, tours, connectivity, matching, cycle detection, partitions, cuts, flows, centrality, spanning, **and the list goes on**
##### **exporters** and **importers** for popular external representations such as GraphViz
##### **live adapters** to other graph libraries such as **JGraphX visualization** and **Guava Graphs**
##### **generators** and **transforms**

<br>

### *efficient*
##### designed for performance, with **near-native** speed in many cases
##### adapters for memory-optimized **fastutil** representation
##### **sparse** representations for immutable graphs

<span id="forkongithub">
  <a href="{{ site.source_link }}" class="bg-blue">
    Fork me on GitHub
  </a>
</span>
