/**
 * \file
 * Define Win32 API subset defaults.
 * Other subsetters can fork this file, or
 * define symbols ahead of it, or after it (with undef).
 *
 * Note that #if of an undefined symbols is defined as if 0,
 * so that an implicit default here.
 *
 * Copyright 2019 Microsoft
 * Licensed under the MIT license. See LICENSE file in the project root for full license information.
 */

#ifndef HAVE_API_SUPPORT_WIN32_BSTR
#if G_HAVE_API_SUPPORT(HAVE_CLASSIC_WINAPI_SUPPORT)
#define HAVE_API_SUPPORT_WIN32_BSTR 1
#else
#define HAVE_API_SUPPORT_WIN32_BSTR 0
#endif
#endif

#ifndef HAVE_API_SUPPORT_WIN32_CANCEL_IO
#if G_HAVE_API_SUPPORT(HAVE_CLASSIC_WINAPI_SUPPORT) || \
	G_HAVE_API_SUPPORT(HAVE_UWP_WINAPI_SUPPORT)
#define HAVE_API_SUPPORT_WIN32_CANCEL_IO 1
#else
#define HAVE_API_SUPPORT_WIN32_CANCEL_IO 0
#endif
#endif

#ifndef HAVE_API_SUPPORT_WIN32_CANCEL_IO_EX
#if G_HAVE_API_SUPPORT(HAVE_CLASSIC_WINAPI_SUPPORT) || \
	G_HAVE_API_SUPPORT(HAVE_UWP_WINAPI_SUPPORT)
#define HAVE_API_SUPPORT_WIN32_CANCEL_IO_EX 1
#else
#define HAVE_API_SUPPORT_WIN32_CANCEL_IO_EX 0
#endif
#endif

#ifndef HAVE_API_SUPPORT_WIN32_CANCEL_SYNCHRONOUS_IO
#if G_HAVE_API_SUPPORT(HAVE_CLASSIC_WINAPI_SUPPORT)
#define HAVE_API_SUPPORT_WIN32_CANCEL_SYNCHRONOUS_IO 1
#else
#define HAVE_API_SUPPORT_WIN32_CANCEL_SYNCHRONOUS_IO 0
#endif
#endif

#ifndef HAVE_API_SUPPORT_WIN32_COMMAND_LINE_TO_ARGV
#if G_HAVE_API_SUPPORT(HAVE_CLASSIC_WINAPI_SUPPORT)
#define HAVE_API_SUPPORT_WIN32_COMMAND_LINE_TO_ARGV 1
#else
#define HAVE_API_SUPPORT_WIN32_COMMAND_LINE_TO_ARGV 0
#endif
#endif

#ifndef HAVE_API_SUPPORT_WIN32_CONSOLE
#if G_HAVE_API_SUPPORT(HAVE_CLASSIC_WINAPI_SUPPORT)
#define HAVE_API_SUPPORT_WIN32_CONSOLE 1
#else
#define HAVE_API_SUPPORT_WIN32_CONSOLE 0
#endif
#endif

#ifndef HAVE_API_SUPPORT_WIN32_COREE
#if G_HAVE_API_SUPPORT(HAVE_CLASSIC_WINAPI_SUPPORT)
#define HAVE_API_SUPPORT_WIN32_COREE 1
#else
#define HAVE_API_SUPPORT_WIN32_COREE 0
#endif
#endif

#ifndef HAVE_API_SUPPORT_WIN32_CREATE_SEMAPHORE
#if G_HAVE_API_SUPPORT(HAVE_CLASSIC_WINAPI_SUPPORT) || \
	G_HAVE_API_SUPPORT(HAVE_UWP_WINAPI_SUPPORT)
#define HAVE_API_SUPPORT_WIN32_CREATE_SEMAPHORE 1
#else
#define HAVE_API_SUPPORT_WIN32_CREATE_SEMAPHORE 0
#endif
#endif

#ifndef HAVE_API_SUPPORT_WIN32_CREATE_SEMAPHORE_EX
#if G_HAVE_API_SUPPORT(HAVE_CLASSIC_WINAPI_SUPPORT) || \
	G_HAVE_API_SUPPORT(HAVE_UWP_WINAPI_SUPPORT)
#define HAVE_API_SUPPORT_WIN32_CREATE_SEMAPHORE_EX 1
#else
#define HAVE_API_SUPPORT_WIN32_CREATE_SEMAPHORE_EX 0
#endif
#endif

#ifndef HAVE_API_SUPPORT_WIN32_ENUM_PROCESS_MODULES
#if G_HAVE_API_SUPPORT(HAVE_CLASSIC_WINAPI_SUPPORT)
#define HAVE_API_SUPPORT_WIN32_ENUM_PROCESS_MODULES 1
#else
#define HAVE_API_SUPPORT_WIN32_ENUM_PROCESS_MODULES 0
#endif
#endif

#ifndef HAVE_API_SUPPORT_WIN32_FILE_MAPPING
#if G_HAVE_API_SUPPORT(HAVE_CLASSIC_WINAPI_SUPPORT)
#define HAVE_API_SUPPORT_WIN32_FILE_MAPPING 1
#else
#define HAVE_API_SUPPORT_WIN32_FILE_MAPPING 0
#endif
#endif

#ifndef HAVE_API_SUPPORT_WIN32_FILE_MAPPING_FROM_APP
#if G_HAVE_API_SUPPORT(HAVE_UWP_WINAPI_SUPPORT)
#define HAVE_API_SUPPORT_WIN32_FILE_MAPPING_FROM_APP 1
#else
#define HAVE_API_SUPPORT_WIN32_FILE_MAPPING_FROM_APP 0
#endif
#endif

#ifndef HAVE_API_SUPPORT_WIN32_FORMAT_MESSAGE
#if G_HAVE_API_SUPPORT(HAVE_CLASSIC_WINAPI_SUPPORT) || \
	G_HAVE_API_SUPPORT(HAVE_UWP_WINAPI_SUPPORT)
#define HAVE_API_SUPPORT_WIN32_FORMAT_MESSAGE 1
#else
#define HAVE_API_SUPPORT_WIN32_FORMAT_MESSAGE 0
#endif
#endif

#ifndef HAVE_API_SUPPORT_WIN32_GET_MODULE_BASE_NAME
#if G_HAVE_API_SUPPORT(HAVE_CLASSIC_WINAPI_SUPPORT) || \
	G_HAVE_API_SUPPORT(HAVE_UWP_WINAPI_SUPPORT)
#define HAVE_API_SUPPORT_WIN32_GET_MODULE_BASE_NAME 1
#else
#define HAVE_API_SUPPORT_WIN32_GET_MODULE_BASE_NAME 0
#endif
#endif

#ifndef HAVE_API_SUPPORT_WIN32_GET_MODULE_FILE_NAME_EX
#if G_HAVE_API_SUPPORT(HAVE_CLASSIC_WINAPI_SUPPORT) || \
	G_HAVE_API_SUPPORT(HAVE_UWP_WINAPI_SUPPORT)
#define HAVE_API_SUPPORT_WIN32_GET_MODULE_FILE_NAME_EX 1
#else
#define HAVE_API_SUPPORT_WIN32_GET_MODULE_FILE_NAME_EX 0
#endif
#endif

#ifndef HAVE_API_SUPPORT_WIN32_GET_MODULE_HANDLE
#if G_HAVE_API_SUPPORT(HAVE_CLASSIC_WINAPI_SUPPORT)
#define HAVE_API_SUPPORT_WIN32_GET_MODULE_HANDLE 1
#else
#define HAVE_API_SUPPORT_WIN32_GET_MODULE_HANDLE 0
#endif
#endif

#ifndef HAVE_API_SUPPORT_WIN32_GET_MODULE_HANDLE_EX
#if G_HAVE_API_SUPPORT(HAVE_CLASSIC_WINAPI_SUPPORT)
#define HAVE_API_SUPPORT_WIN32_GET_MODULE_HANDLE_EX 1
#else
#define HAVE_API_SUPPORT_WIN32_GET_MODULE_HANDLE_EX 0
#endif
#endif

#ifndef HAVE_API_SUPPORT_WIN32_IS_WOW64_PROCESS
#if G_HAVE_API_SUPPORT(HAVE_CLASSIC_WINAPI_SUPPORT)
#define HAVE_API_SUPPORT_WIN32_IS_WOW64_PROCESS 1
#else
#define HAVE_API_SUPPORT_WIN32_IS_WOW64_PROCESS 0
#endif
#endif

#ifndef HAVE_API_SUPPORT_WIN32_LOAD_LIBRARY
#if G_HAVE_API_SUPPORT(HAVE_CLASSIC_WINAPI_SUPPORT)
#define HAVE_API_SUPPORT_WIN32_LOAD_LIBRARY 1
#else
#define HAVE_API_SUPPORT_WIN32_LOAD_LIBRARY 0
#endif
#endif

#ifndef HAVE_API_SUPPORT_WIN32_LOAD_PACKAGED_LIBRARY
#if G_HAVE_API_SUPPORT(HAVE_UWP_WINAPI_SUPPORT)
#define HAVE_API_SUPPORT_WIN32_LOAD_PACKAGED_LIBRARY 1
#else
#define HAVE_API_SUPPORT_WIN32_LOAD_PACKAGED_LIBRARY 0
#endif
#endif

#ifndef HAVE_API_SUPPORT_WIN32_LOCAL_ALLOC_FREE
#if G_HAVE_API_SUPPORT(HAVE_CLASSIC_WINAPI_SUPPORT) || \
	G_HAVE_API_SUPPORT(HAVE_UWP_WINAPI_SUPPORT)
#define HAVE_API_SUPPORT_WIN32_LOCAL_ALLOC_FREE 1
#else
#define HAVE_API_SUPPORT_WIN32_LOCAL_ALLOC_FREE 0
#endif
#endif

#ifndef HAVE_API_SUPPORT_WIN32_OPEN_THREAD
#if G_HAVE_API_SUPPORT(HAVE_CLASSIC_WINAPI_SUPPORT) || \
	G_HAVE_API_SUPPORT(HAVE_UWP_WINAPI_SUPPORT)
#define HAVE_API_SUPPORT_WIN32_OPEN_THREAD 1
#else
#define HAVE_API_SUPPORT_WIN32_OPEN_THREAD 0
#endif
#endif

#ifndef HAVE_API_SUPPORT_WIN32_RESET_STKOFLW
#if G_HAVE_API_SUPPORT(HAVE_CLASSIC_WINAPI_SUPPORT)
#define HAVE_API_SUPPORT_WIN32_RESET_STKOFLW 1
#else
#define HAVE_API_SUPPORT_WIN32_RESET_STKOFLW 0
#endif
#endif

#ifndef HAVE_API_SUPPORT_WIN32_SAFE_ARRAY
#if G_HAVE_API_SUPPORT(HAVE_CLASSIC_WINAPI_SUPPORT)
#define HAVE_API_SUPPORT_WIN32_SAFE_ARRAY 1
#else
#define HAVE_API_SUPPORT_WIN32_SAFE_ARRAY 0
#endif
#endif

#ifndef HAVE_API_SUPPORT_WIN32_SET_ERROR_MODE
#if G_HAVE_API_SUPPORT(HAVE_CLASSIC_WINAPI_SUPPORT) || \
	G_HAVE_API_SUPPORT(HAVE_UWP_WINAPI_SUPPORT)
#define HAVE_API_SUPPORT_WIN32_SET_ERROR_MODE 1
#else
#define HAVE_API_SUPPORT_WIN32_SET_ERROR_MODE 0
#endif
#endif

#ifndef HAVE_API_SUPPORT_WIN32_SET_THREAD_CONTEXT
#if G_HAVE_API_SUPPORT(HAVE_CLASSIC_WINAPI_SUPPORT)
#define HAVE_API_SUPPORT_WIN32_SET_THREAD_CONTEXT 1
#else
#define HAVE_API_SUPPORT_WIN32_SET_THREAD_CONTEXT 0
#endif
#endif

#ifndef HAVE_API_SUPPORT_WIN32_SET_THREAD_DESCRIPTION
#if G_HAVE_API_SUPPORT(HAVE_UWP_WINAPI_SUPPORT)
#define HAVE_API_SUPPORT_WIN32_SET_THREAD_DESCRIPTION 1
#else
#define HAVE_API_SUPPORT_WIN32_SET_THREAD_DESCRIPTION 0
#endif
#endif

#ifndef HAVE_API_SUPPORT_WIN32_SET_THREAD_STACK_GUARANTEE
#if G_HAVE_API_SUPPORT(HAVE_CLASSIC_WINAPI_SUPPORT)
#define HAVE_API_SUPPORT_WIN32_SET_THREAD_STACK_GUARANTEE 1
#else
#define HAVE_API_SUPPORT_WIN32_SET_THREAD_STACK_GUARANTEE 0
#endif
#endif

#ifndef HAVE_API_SUPPORT_WIN32_TIMERS
#if G_HAVE_API_SUPPORT(HAVE_CLASSIC_WINAPI_SUPPORT)
#define HAVE_API_SUPPORT_WIN32_TIMERS 1
#else
#define HAVE_API_SUPPORT_WIN32_TIMERS 0
#endif
#endif

#ifndef HAVE_API_SUPPORT_WIN32_PIPE_OPEN_CLOSE
#if G_HAVE_API_SUPPORT(HAVE_CLASSIC_WINAPI_SUPPORT)
#define HAVE_API_SUPPORT_WIN32_PIPE_OPEN_CLOSE 1
#else
#define HAVE_API_SUPPORT_WIN32_PIPE_OPEN_CLOSE 0
#endif
#endif

#ifndef HAVE_API_SUPPORT_WIN32_CONTEXT_XSTATE
#define HAVE_API_SUPPORT_WIN32_CONTEXT_XSTATE 0
#endif
