// SPDX-License-Identifier: GPL-2.0-only
//
// rt1320-sdw.c -- rt1320 SDCA ALSA SoC amplifier audio driver
//
// Copyright(c) 2024 Realtek Semiconductor Corp.
//
//
#include <linux/delay.h>
#include <linux/device.h>
#include <linux/pm_runtime.h>
#include <linux/mod_devicetable.h>
#include <linux/module.h>
#include <linux/regmap.h>
#include <linux/dmi.h>
#include <linux/firmware.h>
#include <sound/core.h>
#include <sound/pcm.h>
#include <sound/pcm_params.h>
#include <sound/soc-dapm.h>
#include <sound/initval.h>
#include <sound/tlv.h>
#include <sound/sdw.h>
#include "rt1320-sdw.h"

/*
 * The 'blind writes' is an SDCA term to deal with platform-specific initialization.
 * It might include vendor-specific or SDCA control registers.
 */
static const struct reg_sequence rt1320_blind_write[] = {
	{ 0xc003, 0xe0 },
	{ 0xc01b, 0xfc },
	{ 0xc5c3, 0xf2 },
	{ 0xc5c2, 0x00 },
	{ 0xc5c6, 0x10 },
	{ 0xc5c4, 0x12 },
	{ 0xc5c8, 0x03 },
	{ 0xc5d8, 0x0a },
	{ 0xc5f7, 0x22 },
	{ 0xc5f6, 0x22 },
	{ 0xc5d0, 0x0f },
	{ 0xc5d1, 0x89 },
	{ 0xc057, 0x51 },
	{ 0xc054, 0x35 },
	{ 0xc053, 0x55 },
	{ 0xc052, 0x55 },
	{ 0xc051, 0x13 },
	{ 0xc050, 0x15 },
	{ 0xc060, 0x77 },
	{ 0xc061, 0x55 },
	{ 0xc063, 0x55 },
	{ 0xc065, 0xa5 },
	{ 0xc06b, 0x0a },
	{ 0xca05, 0xd6 },
	{ 0xca25, 0xd6 },
	{ 0xcd00, 0x05 },
	{ 0xc604, 0x40 },
	{ 0xc609, 0x40 },
	{ 0xc046, 0xff },
	{ 0xc045, 0xff },
	{ 0xc044, 0xff },
	{ 0xc043, 0xff },
	{ 0xc042, 0xff },
	{ 0xc041, 0xff },
	{ 0xc040, 0xff },
	{ 0xcc10, 0x01 },
	{ 0xc700, 0xf0 },
	{ 0xc701, 0x13 },
	{ 0xc901, 0x04 },
	{ 0xc900, 0x73 },
	{ 0xde03, 0x05 },
	{ 0xdd0b, 0x0d },
	{ 0xdd0a, 0xff },
	{ 0xdd09, 0x0d },
	{ 0xdd08, 0xff },
	{ 0xc570, 0x08 },
	{ 0xe803, 0xbe },
	{ 0xc003, 0xc0 },
	{ 0xc081, 0xfe },
	{ 0xce31, 0x0d },
	{ 0xce30, 0xae },
	{ 0xce37, 0x0b },
	{ 0xce36, 0xd2 },
	{ 0xce39, 0x04 },
	{ 0xce38, 0x80 },
	{ 0xce3f, 0x00 },
	{ 0xce3e, 0x00 },
	{ 0xd470, 0x8b },
	{ 0xd471, 0x18 },
	{ 0xc019, 0x10 },
	{ 0xd487, 0x3f },
	{ 0xd486, 0xc3 },
};

/*
 * The 'patch code' is written to the patch code area.
 * The patch code area is used for SDCA register expansion flexibility.
 */
static const struct reg_sequence rt1320_patch_code_write[] = {
	{ 0x10007000, 0x37 },
	{ 0x10007001, 0x77 },
	{ 0x10007002, 0x00 },
	{ 0x10007003, 0x10 },
	{ 0x10007004, 0xb7 },
	{ 0x10007005, 0xe7 },
	{ 0x10007006, 0x00 },
	{ 0x10007007, 0x10 },
	{ 0x10007008, 0x13 },
	{ 0x10007009, 0x07 },
	{ 0x1000700a, 0x07 },
	{ 0x1000700b, 0x40 },
	{ 0x1000700c, 0x23 },
	{ 0x1000700d, 0xae },
	{ 0x1000700e, 0xe7 },
	{ 0x1000700f, 0xda },
	{ 0x10007010, 0x37 },
	{ 0x10007011, 0x77 },
	{ 0x10007012, 0x00 },
	{ 0x10007013, 0x10 },
	{ 0x10007014, 0x13 },
	{ 0x10007015, 0x07 },
	{ 0x10007016, 0x47 },
	{ 0x10007017, 0x61 },
	{ 0x10007018, 0x23 },
	{ 0x10007019, 0xa4 },
	{ 0x1000701a, 0xe7 },
	{ 0x1000701b, 0xde },
	{ 0x1000701c, 0x37 },
	{ 0x1000701d, 0x77 },
	{ 0x1000701e, 0x00 },
	{ 0x1000701f, 0x10 },
	{ 0x10007020, 0x13 },
	{ 0x10007021, 0x07 },
	{ 0x10007022, 0x07 },
	{ 0x10007023, 0x52 },
	{ 0x10007024, 0x23 },
	{ 0x10007025, 0xae },
	{ 0x10007026, 0xe7 },
	{ 0x10007027, 0xde },
	{ 0x10007028, 0x37 },
	{ 0x10007029, 0x77 },
	{ 0x1000702a, 0x00 },
	{ 0x1000702b, 0x10 },
	{ 0x1000702c, 0x13 },
	{ 0x1000702d, 0x07 },
	{ 0x1000702e, 0x47 },
	{ 0x1000702f, 0x54 },
	{ 0x10007030, 0x23 },
	{ 0x10007031, 0xaa },
	{ 0x10007032, 0xe7 },
	{ 0x10007033, 0xe4 },
	{ 0x10007034, 0x37 },
	{ 0x10007035, 0x87 },
	{ 0x10007036, 0x00 },
	{ 0x10007037, 0x10 },
	{ 0x10007038, 0x13 },
	{ 0x10007039, 0x07 },
	{ 0x1000703a, 0x47 },
	{ 0x1000703b, 0x81 },
	{ 0x1000703c, 0x23 },
	{ 0x1000703d, 0xa2 },
	{ 0x1000703e, 0xe7 },
	{ 0x1000703f, 0xe8 },
	{ 0x10007040, 0x23 },
	{ 0x10007041, 0xa4 },
	{ 0x10007042, 0xe7 },
	{ 0x10007043, 0xe8 },
	{ 0x10007044, 0x37 },
	{ 0x10007045, 0x77 },
	{ 0x10007046, 0x00 },
	{ 0x10007047, 0x10 },
	{ 0x10007048, 0x13 },
	{ 0x10007049, 0x07 },
	{ 0x1000704a, 0x07 },
	{ 0x1000704b, 0x59 },
	{ 0x1000704c, 0x23 },
	{ 0x1000704d, 0xa8 },
	{ 0x1000704e, 0xe7 },
	{ 0x1000704f, 0xea },
	{ 0x10007050, 0x37 },
	{ 0x10007051, 0x77 },
	{ 0x10007052, 0x00 },
	{ 0x10007053, 0x10 },
	{ 0x10007054, 0x13 },
	{ 0x10007055, 0x07 },
	{ 0x10007056, 0x07 },
	{ 0x10007057, 0x78 },
	{ 0x10007058, 0x23 },
	{ 0x10007059, 0xa6 },
	{ 0x1000705a, 0xe7 },
	{ 0x1000705b, 0xec },
	{ 0x1000705c, 0x67 },
	{ 0x1000705d, 0x80 },
	{ 0x1000705e, 0x00 },
	{ 0x1000705f, 0x00 },
	{ 0x10007400, 0x37 },
	{ 0x10007401, 0xd7 },
	{ 0x10007402, 0x00 },
	{ 0x10007403, 0x00 },
	{ 0x10007404, 0x83 },
	{ 0x10007405, 0x27 },
	{ 0x10007406, 0x47 },
	{ 0x10007407, 0x56 },
	{ 0x10007408, 0xb7 },
	{ 0x10007409, 0x06 },
	{ 0x1000740a, 0x00 },
	{ 0x1000740b, 0x02 },
	{ 0x1000740c, 0xb3 },
	{ 0x1000740d, 0xf7 },
	{ 0x1000740e, 0xd7 },
	{ 0x1000740f, 0x00 },
	{ 0x10007410, 0x63 },
	{ 0x10007411, 0x8a },
	{ 0x10007412, 0x07 },
	{ 0x10007413, 0x00 },
	{ 0x10007414, 0x93 },
	{ 0x10007415, 0x06 },
	{ 0x10007416, 0x10 },
	{ 0x10007417, 0x00 },
	{ 0x10007418, 0x23 },
	{ 0x10007419, 0x83 },
	{ 0x1000741a, 0xd1 },
	{ 0x1000741b, 0x44 },
	{ 0x1000741c, 0x93 },
	{ 0x1000741d, 0x07 },
	{ 0x1000741e, 0xf0 },
	{ 0x1000741f, 0xff },
	{ 0x10007420, 0x23 },
	{ 0x10007421, 0x22 },
	{ 0x10007422, 0xf7 },
	{ 0x10007423, 0x56 },
	{ 0x10007424, 0x37 },
	{ 0x10007425, 0xd7 },
	{ 0x10007426, 0x00 },
	{ 0x10007427, 0x00 },
	{ 0x10007428, 0x83 },
	{ 0x10007429, 0x27 },
	{ 0x1000742a, 0x47 },
	{ 0x1000742b, 0x58 },
	{ 0x1000742c, 0x93 },
	{ 0x1000742d, 0xf7 },
	{ 0x1000742e, 0x17 },
	{ 0x1000742f, 0x00 },
	{ 0x10007430, 0x63 },
	{ 0x10007431, 0x86 },
	{ 0x10007432, 0x07 },
	{ 0x10007433, 0x00 },
	{ 0x10007434, 0x93 },
	{ 0x10007435, 0x07 },
	{ 0x10007436, 0x10 },
	{ 0x10007437, 0x00 },
	{ 0x10007438, 0x23 },
	{ 0x10007439, 0x22 },
	{ 0x1000743a, 0xf7 },
	{ 0x1000743b, 0x58 },
	{ 0x1000743c, 0xb7 },
	{ 0x1000743d, 0xd7 },
	{ 0x1000743e, 0x00 },
	{ 0x1000743f, 0x00 },
	{ 0x10007440, 0x03 },
	{ 0x10007441, 0xa7 },
	{ 0x10007442, 0x47 },
	{ 0x10007443, 0x58 },
	{ 0x10007444, 0xb7 },
	{ 0x10007445, 0x07 },
	{ 0x10007446, 0x00 },
	{ 0x10007447, 0x04 },
	{ 0x10007448, 0x33 },
	{ 0x10007449, 0x77 },
	{ 0x1000744a, 0xf7 },
	{ 0x1000744b, 0x00 },
	{ 0x1000744c, 0x93 },
	{ 0x1000744d, 0x07 },
	{ 0x1000744e, 0x00 },
	{ 0x1000744f, 0x00 },
	{ 0x10007450, 0x63 },
	{ 0x10007451, 0x0e },
	{ 0x10007452, 0x07 },
	{ 0x10007453, 0x04 },
	{ 0x10007454, 0x37 },
	{ 0x10007455, 0x07 },
	{ 0x10007456, 0x00 },
	{ 0x10007457, 0x11 },
	{ 0x10007458, 0x03 },
	{ 0x10007459, 0x47 },
	{ 0x1000745a, 0x87 },
	{ 0x1000745b, 0x0e },
	{ 0x1000745c, 0x93 },
	{ 0x1000745d, 0x06 },
	{ 0x1000745e, 0x40 },
	{ 0x1000745f, 0x00 },
	{ 0x10007460, 0x13 },
	{ 0x10007461, 0x77 },
	{ 0x10007462, 0xf7 },
	{ 0x10007463, 0x0f },
	{ 0x10007464, 0x63 },
	{ 0x10007465, 0x02 },
	{ 0x10007466, 0xd7 },
	{ 0x10007467, 0x0a },
	{ 0x10007468, 0x93 },
	{ 0x10007469, 0x06 },
	{ 0x1000746a, 0x70 },
	{ 0x1000746b, 0x00 },
	{ 0x1000746c, 0x63 },
	{ 0x1000746d, 0x10 },
	{ 0x1000746e, 0xd7 },
	{ 0x1000746f, 0x04 },
	{ 0x10007470, 0x93 },
	{ 0x10007471, 0x07 },
	{ 0x10007472, 0x60 },
	{ 0x10007473, 0x06 },
	{ 0x10007474, 0x37 },
	{ 0x10007475, 0xd7 },
	{ 0x10007476, 0x00 },
	{ 0x10007477, 0x00 },
	{ 0x10007478, 0x83 },
	{ 0x10007479, 0x46 },
	{ 0x1000747a, 0x77 },
	{ 0x1000747b, 0xa6 },
	{ 0x1000747c, 0x93 },
	{ 0x1000747d, 0xe6 },
	{ 0x1000747e, 0x06 },
	{ 0x1000747f, 0xf8 },
	{ 0x10007480, 0x93 },
	{ 0x10007481, 0xf6 },
	{ 0x10007482, 0xf6 },
	{ 0x10007483, 0x0f },
	{ 0x10007484, 0xa3 },
	{ 0x10007485, 0x03 },
	{ 0x10007486, 0xd7 },
	{ 0x10007487, 0xa6 },
	{ 0x10007488, 0x83 },
	{ 0x10007489, 0x46 },
	{ 0x1000748a, 0x77 },
	{ 0x1000748b, 0xa8 },
	{ 0x1000748c, 0x93 },
	{ 0x1000748d, 0xe6 },
	{ 0x1000748e, 0x06 },
	{ 0x1000748f, 0xf8 },
	{ 0x10007490, 0x93 },
	{ 0x10007491, 0xf6 },
	{ 0x10007492, 0xf6 },
	{ 0x10007493, 0x0f },
	{ 0x10007494, 0xa3 },
	{ 0x10007495, 0x03 },
	{ 0x10007496, 0xd7 },
	{ 0x10007497, 0xa8 },
	{ 0x10007498, 0xb7 },
	{ 0x10007499, 0xc6 },
	{ 0x1000749a, 0x00 },
	{ 0x1000749b, 0x00 },
	{ 0x1000749c, 0x23 },
	{ 0x1000749d, 0x84 },
	{ 0x1000749e, 0xf6 },
	{ 0x1000749f, 0x06 },
	{ 0x100074a0, 0xa3 },
	{ 0x100074a1, 0x84 },
	{ 0x100074a2, 0xf6 },
	{ 0x100074a3, 0x06 },
	{ 0x100074a4, 0xb7 },
	{ 0x100074a5, 0x06 },
	{ 0x100074a6, 0x00 },
	{ 0x100074a7, 0x04 },
	{ 0x100074a8, 0x23 },
	{ 0x100074a9, 0x22 },
	{ 0x100074aa, 0xd7 },
	{ 0x100074ab, 0x58 },
	{ 0x100074ac, 0x37 },
	{ 0x100074ad, 0xd7 },
	{ 0x100074ae, 0x00 },
	{ 0x100074af, 0x00 },
	{ 0x100074b0, 0x03 },
	{ 0x100074b1, 0x27 },
	{ 0x100074b2, 0x47 },
	{ 0x100074b3, 0x58 },
	{ 0x100074b4, 0xb7 },
	{ 0x100074b5, 0x06 },
	{ 0x100074b6, 0x00 },
	{ 0x100074b7, 0x08 },
	{ 0x100074b8, 0x33 },
	{ 0x100074b9, 0x77 },
	{ 0x100074ba, 0xd7 },
	{ 0x100074bb, 0x00 },
	{ 0x100074bc, 0x63 },
	{ 0x100074bd, 0x04 },
	{ 0x100074be, 0x07 },
	{ 0x100074bf, 0x04 },
	{ 0x100074c0, 0x37 },
	{ 0x100074c1, 0x07 },
	{ 0x100074c2, 0x00 },
	{ 0x100074c3, 0x11 },
	{ 0x100074c4, 0x03 },
	{ 0x100074c5, 0x47 },
	{ 0x100074c6, 0xc7 },
	{ 0x100074c7, 0x0e },
	{ 0x100074c8, 0x93 },
	{ 0x100074c9, 0x06 },
	{ 0x100074ca, 0x40 },
	{ 0x100074cb, 0x00 },
	{ 0x100074cc, 0x13 },
	{ 0x100074cd, 0x77 },
	{ 0x100074ce, 0xf7 },
	{ 0x100074cf, 0x0f },
	{ 0x100074d0, 0x63 },
	{ 0x100074d1, 0x00 },
	{ 0x100074d2, 0xd7 },
	{ 0x100074d3, 0x04 },
	{ 0x100074d4, 0x93 },
	{ 0x100074d5, 0x06 },
	{ 0x100074d6, 0x70 },
	{ 0x100074d7, 0x00 },
	{ 0x100074d8, 0x63 },
	{ 0x100074d9, 0x00 },
	{ 0x100074da, 0xd7 },
	{ 0x100074db, 0x04 },
	{ 0x100074dc, 0x63 },
	{ 0x100074dd, 0x84 },
	{ 0x100074de, 0x07 },
	{ 0x100074df, 0x02 },
	{ 0x100074e0, 0xb7 },
	{ 0x100074e1, 0xd6 },
	{ 0x100074e2, 0x00 },
	{ 0x100074e3, 0x00 },
	{ 0x100074e4, 0x03 },
	{ 0x100074e5, 0xc7 },
	{ 0x100074e6, 0x56 },
	{ 0x100074e7, 0xa4 },
	{ 0x100074e8, 0x13 },
	{ 0x100074e9, 0x67 },
	{ 0x100074ea, 0x07 },
	{ 0x100074eb, 0xf8 },
	{ 0x100074ec, 0x13 },
	{ 0x100074ed, 0x77 },
	{ 0x100074ee, 0xf7 },
	{ 0x100074ef, 0x0f },
	{ 0x100074f0, 0xa3 },
	{ 0x100074f1, 0x82 },
	{ 0x100074f2, 0xe6 },
	{ 0x100074f3, 0xa4 },
	{ 0x100074f4, 0x37 },
	{ 0x100074f5, 0xc7 },
	{ 0x100074f6, 0x00 },
	{ 0x100074f7, 0x00 },
	{ 0x100074f8, 0x23 },
	{ 0x100074f9, 0x02 },
	{ 0x100074fa, 0xf7 },
	{ 0x100074fb, 0x06 },
	{ 0x100074fc, 0xb7 },
	{ 0x100074fd, 0x07 },
	{ 0x100074fe, 0x00 },
	{ 0x100074ff, 0x08 },
	{ 0x10007500, 0x23 },
	{ 0x10007501, 0xa2 },
	{ 0x10007502, 0xf6 },
	{ 0x10007503, 0x58 },
	{ 0x10007504, 0x67 },
	{ 0x10007505, 0x80 },
	{ 0x10007506, 0x00 },
	{ 0x10007507, 0x00 },
	{ 0x10007508, 0x93 },
	{ 0x10007509, 0x07 },
	{ 0x1000750a, 0x80 },
	{ 0x1000750b, 0x08 },
	{ 0x1000750c, 0x6f },
	{ 0x1000750d, 0xf0 },
	{ 0x1000750e, 0x9f },
	{ 0x1000750f, 0xf6 },
	{ 0x10007510, 0x93 },
	{ 0x10007511, 0x07 },
	{ 0x10007512, 0x80 },
	{ 0x10007513, 0x08 },
	{ 0x10007514, 0x6f },
	{ 0x10007515, 0xf0 },
	{ 0x10007516, 0xdf },
	{ 0x10007517, 0xfc },
	{ 0x10007518, 0x93 },
	{ 0x10007519, 0x07 },
	{ 0x1000751a, 0x60 },
	{ 0x1000751b, 0x06 },
	{ 0x1000751c, 0x6f },
	{ 0x1000751d, 0xf0 },
	{ 0x1000751e, 0x5f },
	{ 0x1000751f, 0xfc },
	{ 0x10007520, 0x37 },
	{ 0x10007521, 0xd7 },
	{ 0x10007522, 0x00 },
	{ 0x10007523, 0x00 },
	{ 0x10007524, 0x83 },
	{ 0x10007525, 0x27 },
	{ 0x10007526, 0x07 },
	{ 0x10007527, 0x53 },
	{ 0x10007528, 0xb7 },
	{ 0x10007529, 0x06 },
	{ 0x1000752a, 0x02 },
	{ 0x1000752b, 0x00 },
	{ 0x1000752c, 0xb3 },
	{ 0x1000752d, 0xf7 },
	{ 0x1000752e, 0xd7 },
	{ 0x1000752f, 0x00 },
	{ 0x10007530, 0x63 },
	{ 0x10007531, 0x88 },
	{ 0x10007532, 0x07 },
	{ 0x10007533, 0x00 },
	{ 0x10007534, 0x13 },
	{ 0x10007535, 0x06 },
	{ 0x10007536, 0xa0 },
	{ 0x10007537, 0x05 },
	{ 0x10007538, 0x23 },
	{ 0x10007539, 0xa8 },
	{ 0x1000753a, 0xc1 },
	{ 0x1000753b, 0x56 },
	{ 0x1000753c, 0x23 },
	{ 0x1000753d, 0x28 },
	{ 0x1000753e, 0xd7 },
	{ 0x1000753f, 0x52 },
	{ 0x10007540, 0x67 },
	{ 0x10007541, 0x80 },
	{ 0x10007542, 0x00 },
	{ 0x10007543, 0x00 },
	{ 0x10007544, 0x37 },
	{ 0x10007545, 0xd7 },
	{ 0x10007546, 0x00 },
	{ 0x10007547, 0x10 },
	{ 0x10007548, 0x83 },
	{ 0x10007549, 0x47 },
	{ 0x1000754a, 0x07 },
	{ 0x1000754b, 0xd9 },
	{ 0x1000754c, 0x93 },
	{ 0x1000754d, 0x06 },
	{ 0x1000754e, 0x20 },
	{ 0x1000754f, 0x00 },
	{ 0x10007550, 0x93 },
	{ 0x10007551, 0xf7 },
	{ 0x10007552, 0xf7 },
	{ 0x10007553, 0x0f },
	{ 0x10007554, 0x63 },
	{ 0x10007555, 0x9c },
	{ 0x10007556, 0xd7 },
	{ 0x10007557, 0x02 },
	{ 0x10007558, 0xb7 },
	{ 0x10007559, 0xc6 },
	{ 0x1000755a, 0x00 },
	{ 0x1000755b, 0x00 },
	{ 0x1000755c, 0x83 },
	{ 0x1000755d, 0xc7 },
	{ 0x1000755e, 0x26 },
	{ 0x1000755f, 0x04 },
	{ 0x10007560, 0x93 },
	{ 0x10007561, 0xf7 },
	{ 0x10007562, 0xf7 },
	{ 0x10007563, 0x07 },
	{ 0x10007564, 0x23 },
	{ 0x10007565, 0x81 },
	{ 0x10007566, 0xf6 },
	{ 0x10007567, 0x04 },
	{ 0x10007568, 0xb7 },
	{ 0x10007569, 0xd6 },
	{ 0x1000756a, 0x00 },
	{ 0x1000756b, 0x00 },
	{ 0x1000756c, 0x83 },
	{ 0x1000756d, 0xc7 },
	{ 0x1000756e, 0xa6 },
	{ 0x1000756f, 0xe1 },
	{ 0x10007570, 0x93 },
	{ 0x10007571, 0xf7 },
	{ 0x10007572, 0xf7 },
	{ 0x10007573, 0x07 },
	{ 0x10007574, 0x23 },
	{ 0x10007575, 0x8d },
	{ 0x10007576, 0xf6 },
	{ 0x10007577, 0xe0 },
	{ 0x10007578, 0x23 },
	{ 0x10007579, 0x08 },
	{ 0x1000757a, 0x07 },
	{ 0x1000757b, 0xd8 },
	{ 0x1000757c, 0x83 },
	{ 0x1000757d, 0x47 },
	{ 0x1000757e, 0x47 },
	{ 0x1000757f, 0xd9 },
	{ 0x10007580, 0x93 },
	{ 0x10007581, 0x87 },
	{ 0x10007582, 0x17 },
	{ 0x10007583, 0x00 },
	{ 0x10007584, 0x93 },
	{ 0x10007585, 0xf7 },
	{ 0x10007586, 0xf7 },
	{ 0x10007587, 0x0f },
	{ 0x10007588, 0x23 },
	{ 0x10007589, 0x0a },
	{ 0x1000758a, 0xf7 },
	{ 0x1000758b, 0xd8 },
	{ 0x1000758c, 0x67 },
	{ 0x1000758d, 0x80 },
	{ 0x1000758e, 0x00 },
	{ 0x1000758f, 0x00 },
	{ 0x10007590, 0xb7 },
	{ 0x10007591, 0xd7 },
	{ 0x10007592, 0x00 },
	{ 0x10007593, 0x00 },
	{ 0x10007594, 0x83 },
	{ 0x10007595, 0xc7 },
	{ 0x10007596, 0x07 },
	{ 0x10007597, 0x47 },
	{ 0x10007598, 0x93 },
	{ 0x10007599, 0xf7 },
	{ 0x1000759a, 0x07 },
	{ 0x1000759b, 0x01 },
	{ 0x1000759c, 0x63 },
	{ 0x1000759d, 0x8a },
	{ 0x1000759e, 0x07 },
	{ 0x1000759f, 0x06 },
	{ 0x100075a0, 0x63 },
	{ 0x100075a1, 0x02 },
	{ 0x100075a2, 0x05 },
	{ 0x100075a3, 0x06 },
	{ 0x100075a4, 0x37 },
	{ 0x100075a5, 0xc7 },
	{ 0x100075a6, 0x00 },
	{ 0x100075a7, 0x00 },
	{ 0x100075a8, 0x83 },
	{ 0x100075a9, 0x27 },
	{ 0x100075aa, 0xc7 },
	{ 0x100075ab, 0x5f },
	{ 0x100075ac, 0x23 },
	{ 0x100075ad, 0xae },
	{ 0x100075ae, 0xf1 },
	{ 0x100075af, 0x40 },
	{ 0x100075b0, 0xb7 },
	{ 0x100075b1, 0x06 },
	{ 0x100075b2, 0x00 },
	{ 0x100075b3, 0x10 },
	{ 0x100075b4, 0xb3 },
	{ 0x100075b5, 0xf7 },
	{ 0x100075b6, 0xd7 },
	{ 0x100075b7, 0x00 },
	{ 0x100075b8, 0x63 },
	{ 0x100075b9, 0x8c },
	{ 0x100075ba, 0x07 },
	{ 0x100075bb, 0x04 },
	{ 0x100075bc, 0x83 },
	{ 0x100075bd, 0x47 },
	{ 0x100075be, 0x07 },
	{ 0x100075bf, 0x56 },
	{ 0x100075c0, 0x93 },
	{ 0x100075c1, 0xf7 },
	{ 0x100075c2, 0x87 },
	{ 0x100075c3, 0x01 },
	{ 0x100075c4, 0x63 },
	{ 0x100075c5, 0x86 },
	{ 0x100075c6, 0x07 },
	{ 0x100075c7, 0x04 },
	{ 0x100075c8, 0x83 },
	{ 0x100075c9, 0x47 },
	{ 0x100075ca, 0x17 },
	{ 0x100075cb, 0x08 },
	{ 0x100075cc, 0x93 },
	{ 0x100075cd, 0xf7 },
	{ 0x100075ce, 0x47 },
	{ 0x100075cf, 0x00 },
	{ 0x100075d0, 0x63 },
	{ 0x100075d1, 0x80 },
	{ 0x100075d2, 0x07 },
	{ 0x100075d3, 0x04 },
	{ 0x100075d4, 0xb7 },
	{ 0x100075d5, 0xc7 },
	{ 0x100075d6, 0xc2 },
	{ 0x100075d7, 0x3f },
	{ 0x100075d8, 0x93 },
	{ 0x100075d9, 0x87 },
	{ 0x100075da, 0x07 },
	{ 0x100075db, 0xfc },
	{ 0x100075dc, 0x83 },
	{ 0x100075dd, 0xa7 },
	{ 0x100075de, 0x47 },
	{ 0x100075df, 0x00 },
	{ 0x100075e0, 0x93 },
	{ 0x100075e1, 0xd7 },
	{ 0x100075e2, 0x17 },
	{ 0x100075e3, 0x00 },
	{ 0x100075e4, 0x93 },
	{ 0x100075e5, 0xf7 },
	{ 0x100075e6, 0x17 },
	{ 0x100075e7, 0x00 },
	{ 0x100075e8, 0x63 },
	{ 0x100075e9, 0x84 },
	{ 0x100075ea, 0x07 },
	{ 0x100075eb, 0x02 },
	{ 0x100075ec, 0x23 },
	{ 0x100075ed, 0x8a },
	{ 0x100075ee, 0xf1 },
	{ 0x100075ef, 0x40 },
	{ 0x100075f0, 0xb7 },
	{ 0x100075f1, 0x07 },
	{ 0x100075f2, 0x00 },
	{ 0x100075f3, 0xc0 },
	{ 0x100075f4, 0x37 },
	{ 0x100075f5, 0xf7 },
	{ 0x100075f6, 0x00 },
	{ 0x100075f7, 0x00 },
	{ 0x100075f8, 0x93 },
	{ 0x100075f9, 0x87 },
	{ 0x100075fa, 0xf7 },
	{ 0x100075fb, 0xff },
	{ 0x100075fc, 0x23 },
	{ 0x100075fd, 0x2c },
	{ 0x100075fe, 0xf7 },
	{ 0x100075ff, 0x06 },
	{ 0x10007600, 0x67 },
	{ 0x10007601, 0x80 },
	{ 0x10007602, 0x00 },
	{ 0x10007603, 0x00 },
	{ 0x10007604, 0x23 },
	{ 0x10007605, 0x8a },
	{ 0x10007606, 0x01 },
	{ 0x10007607, 0x40 },
	{ 0x10007608, 0xb7 },
	{ 0x10007609, 0xf7 },
	{ 0x1000760a, 0x00 },
	{ 0x1000760b, 0x00 },
	{ 0x1000760c, 0x23 },
	{ 0x1000760d, 0xac },
	{ 0x1000760e, 0x07 },
	{ 0x1000760f, 0x06 },
	{ 0x10007610, 0x67 },
	{ 0x10007611, 0x80 },
	{ 0x10007612, 0x00 },
	{ 0x10007613, 0x00 },
	{ 0x10007614, 0x13 },
	{ 0x10007615, 0x01 },
	{ 0x10007616, 0x01 },
	{ 0x10007617, 0xff },
	{ 0x10007618, 0x23 },
	{ 0x10007619, 0x26 },
	{ 0x1000761a, 0x11 },
	{ 0x1000761b, 0x00 },
	{ 0x1000761c, 0x23 },
	{ 0x1000761d, 0x24 },
	{ 0x1000761e, 0x81 },
	{ 0x1000761f, 0x00 },
	{ 0x10007620, 0x37 },
	{ 0x10007621, 0xc7 },
	{ 0x10007622, 0x00 },
	{ 0x10007623, 0x00 },
	{ 0x10007624, 0x83 },
	{ 0x10007625, 0x47 },
	{ 0x10007626, 0x07 },
	{ 0x10007627, 0x56 },
	{ 0x10007628, 0x93 },
	{ 0x10007629, 0xf7 },
	{ 0x1000762a, 0x17 },
	{ 0x1000762b, 0x00 },
	{ 0x1000762c, 0x63 },
	{ 0x1000762d, 0x98 },
	{ 0x1000762e, 0x07 },
	{ 0x1000762f, 0x00 },
	{ 0x10007630, 0x83 },
	{ 0x10007631, 0x47 },
	{ 0x10007632, 0x07 },
	{ 0x10007633, 0x56 },
	{ 0x10007634, 0x93 },
	{ 0x10007635, 0xf7 },
	{ 0x10007636, 0x27 },
	{ 0x10007637, 0x00 },
	{ 0x10007638, 0x63 },
	{ 0x10007639, 0x82 },
	{ 0x1000763a, 0x07 },
	{ 0x1000763b, 0x08 },
	{ 0x1000763c, 0x37 },
	{ 0x1000763d, 0xd4 },
	{ 0x1000763e, 0x00 },
	{ 0x1000763f, 0x00 },
	{ 0x10007640, 0x83 },
	{ 0x10007641, 0x47 },
	{ 0x10007642, 0x14 },
	{ 0x10007643, 0x47 },
	{ 0x10007644, 0x93 },
	{ 0x10007645, 0xf7 },
	{ 0x10007646, 0x27 },
	{ 0x10007647, 0x00 },
	{ 0x10007648, 0x63 },
	{ 0x10007649, 0x8a },
	{ 0x1000764a, 0x07 },
	{ 0x1000764b, 0x06 },
	{ 0x1000764c, 0x93 },
	{ 0x1000764d, 0x05 },
	{ 0x1000764e, 0x10 },
	{ 0x1000764f, 0x00 },
	{ 0x10007650, 0x13 },
	{ 0x10007651, 0x05 },
	{ 0x10007652, 0x20 },
	{ 0x10007653, 0x10 },
	{ 0x10007654, 0xef },
	{ 0x10007655, 0xa0 },
	{ 0x10007656, 0x8f },
	{ 0x10007657, 0x9a },
	{ 0x10007658, 0x37 },
	{ 0x10007659, 0x05 },
	{ 0x1000765a, 0x01 },
	{ 0x1000765b, 0x00 },
	{ 0x1000765c, 0x93 },
	{ 0x1000765d, 0x05 },
	{ 0x1000765e, 0x00 },
	{ 0x1000765f, 0x01 },
	{ 0x10007660, 0x13 },
	{ 0x10007661, 0x05 },
	{ 0x10007662, 0xb5 },
	{ 0x10007663, 0xa0 },
	{ 0x10007664, 0xef },
	{ 0x10007665, 0xa0 },
	{ 0x10007666, 0x8f },
	{ 0x10007667, 0x99 },
	{ 0x10007668, 0x83 },
	{ 0x10007669, 0x47 },
	{ 0x1000766a, 0x24 },
	{ 0x1000766b, 0xe0 },
	{ 0x1000766c, 0x13 },
	{ 0x1000766d, 0x05 },
	{ 0x1000766e, 0x80 },
	{ 0x1000766f, 0x3e },
	{ 0x10007670, 0x93 },
	{ 0x10007671, 0x05 },
	{ 0x10007672, 0x00 },
	{ 0x10007673, 0x00 },
	{ 0x10007674, 0x93 },
	{ 0x10007675, 0xe7 },
	{ 0x10007676, 0x07 },
	{ 0x10007677, 0xf8 },
	{ 0x10007678, 0x93 },
	{ 0x10007679, 0xf7 },
	{ 0x1000767a, 0xf7 },
	{ 0x1000767b, 0x0f },
	{ 0x1000767c, 0x23 },
	{ 0x1000767d, 0x01 },
	{ 0x1000767e, 0xf4 },
	{ 0x1000767f, 0xe0 },
	{ 0x10007680, 0x83 },
	{ 0x10007681, 0x47 },
	{ 0x10007682, 0x24 },
	{ 0x10007683, 0xe0 },
	{ 0x10007684, 0x93 },
	{ 0x10007685, 0xf7 },
	{ 0x10007686, 0xf7 },
	{ 0x10007687, 0x0f },
	{ 0x10007688, 0x93 },
	{ 0x10007689, 0xe7 },
	{ 0x1000768a, 0x07 },
	{ 0x1000768b, 0x04 },
	{ 0x1000768c, 0x23 },
	{ 0x1000768d, 0x01 },
	{ 0x1000768e, 0xf4 },
	{ 0x1000768f, 0xe0 },
	{ 0x10007690, 0xef },
	{ 0x10007691, 0xe0 },
	{ 0x10007692, 0x8f },
	{ 0x10007693, 0xb9 },
	{ 0x10007694, 0x83 },
	{ 0x10007695, 0x47 },
	{ 0x10007696, 0x34 },
	{ 0x10007697, 0xe0 },
	{ 0x10007698, 0x93 },
	{ 0x10007699, 0xf7 },
	{ 0x1000769a, 0x07 },
	{ 0x1000769b, 0x02 },
	{ 0x1000769c, 0xe3 },
	{ 0x1000769d, 0x9c },
	{ 0x1000769e, 0x07 },
	{ 0x1000769f, 0xfe },
	{ 0x100076a0, 0x37 },
	{ 0x100076a1, 0x05 },
	{ 0x100076a2, 0x01 },
	{ 0x100076a3, 0x00 },
	{ 0x100076a4, 0x93 },
	{ 0x100076a5, 0x05 },
	{ 0x100076a6, 0x00 },
	{ 0x100076a7, 0x00 },
	{ 0x100076a8, 0x13 },
	{ 0x100076a9, 0x05 },
	{ 0x100076aa, 0xb5 },
	{ 0x100076ab, 0xa0 },
	{ 0x100076ac, 0xef },
	{ 0x100076ad, 0xa0 },
	{ 0x100076ae, 0x0f },
	{ 0x100076af, 0x95 },
	{ 0x100076b0, 0x83 },
	{ 0x100076b1, 0x47 },
	{ 0x100076b2, 0x14 },
	{ 0x100076b3, 0x47 },
	{ 0x100076b4, 0x93 },
	{ 0x100076b5, 0xf7 },
	{ 0x100076b6, 0xd7 },
	{ 0x100076b7, 0x0f },
	{ 0x100076b8, 0xa3 },
	{ 0x100076b9, 0x08 },
	{ 0x100076ba, 0xf4 },
	{ 0x100076bb, 0x46 },
	{ 0x100076bc, 0x03 },
	{ 0x100076bd, 0xa7 },
	{ 0x100076be, 0x01 },
	{ 0x100076bf, 0x57 },
	{ 0x100076c0, 0x93 },
	{ 0x100076c1, 0x07 },
	{ 0x100076c2, 0xa0 },
	{ 0x100076c3, 0x05 },
	{ 0x100076c4, 0x63 },
	{ 0x100076c5, 0x14 },
	{ 0x100076c6, 0xf7 },
	{ 0x100076c7, 0x04 },
	{ 0x100076c8, 0x37 },
	{ 0x100076c9, 0x07 },
	{ 0x100076ca, 0x00 },
	{ 0x100076cb, 0x11 },
	{ 0x100076cc, 0x83 },
	{ 0x100076cd, 0x47 },
	{ 0x100076ce, 0x07 },
	{ 0x100076cf, 0x01 },
	{ 0x100076d0, 0x13 },
	{ 0x100076d1, 0x06 },
	{ 0x100076d2, 0x30 },
	{ 0x100076d3, 0x00 },
	{ 0x100076d4, 0x93 },
	{ 0x100076d5, 0xf7 },
	{ 0x100076d6, 0xf7 },
	{ 0x100076d7, 0x0f },
	{ 0x100076d8, 0x63 },
	{ 0x100076d9, 0x9a },
	{ 0x100076da, 0xc7 },
	{ 0x100076db, 0x02 },
	{ 0x100076dc, 0x03 },
	{ 0x100076dd, 0x47 },
	{ 0x100076de, 0x87 },
	{ 0x100076df, 0x01 },
	{ 0x100076e0, 0x13 },
	{ 0x100076e1, 0x77 },
	{ 0x100076e2, 0xf7 },
	{ 0x100076e3, 0x0f },
	{ 0x100076e4, 0x63 },
	{ 0x100076e5, 0x14 },
	{ 0x100076e6, 0xf7 },
	{ 0x100076e7, 0x02 },
	{ 0x100076e8, 0x37 },
	{ 0x100076e9, 0xd7 },
	{ 0x100076ea, 0x00 },
	{ 0x100076eb, 0x00 },
	{ 0x100076ec, 0x83 },
	{ 0x100076ed, 0x47 },
	{ 0x100076ee, 0x37 },
	{ 0x100076ef, 0x54 },
	{ 0x100076f0, 0x93 },
	{ 0x100076f1, 0xf7 },
	{ 0x100076f2, 0xf7 },
	{ 0x100076f3, 0x0f },
	{ 0x100076f4, 0x93 },
	{ 0x100076f5, 0xe7 },
	{ 0x100076f6, 0x07 },
	{ 0x100076f7, 0x02 },
	{ 0x100076f8, 0xa3 },
	{ 0x100076f9, 0x01 },
	{ 0x100076fa, 0xf7 },
	{ 0x100076fb, 0x54 },
	{ 0x100076fc, 0x83 },
	{ 0x100076fd, 0x47 },
	{ 0x100076fe, 0x37 },
	{ 0x100076ff, 0x54 },
	{ 0x10007700, 0x93 },
	{ 0x10007701, 0xf7 },
	{ 0x10007702, 0xf7 },
	{ 0x10007703, 0x0d },
	{ 0x10007704, 0xa3 },
	{ 0x10007705, 0x01 },
	{ 0x10007706, 0xf7 },
	{ 0x10007707, 0x54 },
	{ 0x10007708, 0x23 },
	{ 0x10007709, 0xa8 },
	{ 0x1000770a, 0x01 },
	{ 0x1000770b, 0x56 },
	{ 0x1000770c, 0xb7 },
	{ 0x1000770d, 0xd7 },
	{ 0x1000770e, 0x00 },
	{ 0x1000770f, 0x10 },
	{ 0x10007710, 0x03 },
	{ 0x10007711, 0xc7 },
	{ 0x10007712, 0x07 },
	{ 0x10007713, 0xd9 },
	{ 0x10007714, 0x93 },
	{ 0x10007715, 0x06 },
	{ 0x10007716, 0x10 },
	{ 0x10007717, 0x00 },
	{ 0x10007718, 0x13 },
	{ 0x10007719, 0x77 },
	{ 0x1000771a, 0xf7 },
	{ 0x1000771b, 0x0f },
	{ 0x1000771c, 0x63 },
	{ 0x1000771d, 0x1a },
	{ 0x1000771e, 0xd7 },
	{ 0x1000771f, 0x04 },
	{ 0x10007720, 0x03 },
	{ 0x10007721, 0xc7 },
	{ 0x10007722, 0x27 },
	{ 0x10007723, 0xd9 },
	{ 0x10007724, 0x13 },
	{ 0x10007725, 0x07 },
	{ 0x10007726, 0x17 },
	{ 0x10007727, 0x00 },
	{ 0x10007728, 0x13 },
	{ 0x10007729, 0x77 },
	{ 0x1000772a, 0xf7 },
	{ 0x1000772b, 0x0f },
	{ 0x1000772c, 0x23 },
	{ 0x1000772d, 0x89 },
	{ 0x1000772e, 0xe7 },
	{ 0x1000772f, 0xd8 },
	{ 0x10007730, 0x83 },
	{ 0x10007731, 0xc6 },
	{ 0x10007732, 0x27 },
	{ 0x10007733, 0xd9 },
	{ 0x10007734, 0x03 },
	{ 0x10007735, 0xc7 },
	{ 0x10007736, 0x17 },
	{ 0x10007737, 0xd9 },
	{ 0x10007738, 0x93 },
	{ 0x10007739, 0xf6 },
	{ 0x1000773a, 0xf6 },
	{ 0x1000773b, 0x0f },
	{ 0x1000773c, 0x13 },
	{ 0x1000773d, 0x77 },
	{ 0x1000773e, 0xf7 },
	{ 0x1000773f, 0x0f },
	{ 0x10007740, 0x63 },
	{ 0x10007741, 0xe8 },
	{ 0x10007742, 0xe6 },
	{ 0x10007743, 0x02 },
	{ 0x10007744, 0xb7 },
	{ 0x10007745, 0xd6 },
	{ 0x10007746, 0x00 },
	{ 0x10007747, 0x00 },
	{ 0x10007748, 0x03 },
	{ 0x10007749, 0xc7 },
	{ 0x1000774a, 0xa6 },
	{ 0x1000774b, 0xe1 },
	{ 0x1000774c, 0x13 },
	{ 0x1000774d, 0x67 },
	{ 0x1000774e, 0x07 },
	{ 0x1000774f, 0xf8 },
	{ 0x10007750, 0x13 },
	{ 0x10007751, 0x77 },
	{ 0x10007752, 0xf7 },
	{ 0x10007753, 0x0f },
	{ 0x10007754, 0x23 },
	{ 0x10007755, 0x8d },
	{ 0x10007756, 0xe6 },
	{ 0x10007757, 0xe0 },
	{ 0x10007758, 0x03 },
	{ 0x10007759, 0xc7 },
	{ 0x1000775a, 0x37 },
	{ 0x1000775b, 0xd9 },
	{ 0x1000775c, 0x13 },
	{ 0x1000775d, 0x07 },
	{ 0x1000775e, 0x17 },
	{ 0x1000775f, 0x00 },
	{ 0x10007760, 0x13 },
	{ 0x10007761, 0x77 },
	{ 0x10007762, 0xf7 },
	{ 0x10007763, 0x0f },
	{ 0x10007764, 0xa3 },
	{ 0x10007765, 0x89 },
	{ 0x10007766, 0xe7 },
	{ 0x10007767, 0xd8 },
	{ 0x10007768, 0x13 },
	{ 0x10007769, 0x07 },
	{ 0x1000776a, 0x20 },
	{ 0x1000776b, 0x00 },
	{ 0x1000776c, 0x23 },
	{ 0x1000776d, 0x88 },
	{ 0x1000776e, 0xe7 },
	{ 0x1000776f, 0xd8 },
	{ 0x10007770, 0x83 },
	{ 0x10007771, 0x20 },
	{ 0x10007772, 0xc1 },
	{ 0x10007773, 0x00 },
	{ 0x10007774, 0x03 },
	{ 0x10007775, 0x24 },
	{ 0x10007776, 0x81 },
	{ 0x10007777, 0x00 },
	{ 0x10007778, 0x13 },
	{ 0x10007779, 0x01 },
	{ 0x1000777a, 0x01 },
	{ 0x1000777b, 0x01 },
	{ 0x1000777c, 0x67 },
	{ 0x1000777d, 0x80 },
	{ 0x1000777e, 0x00 },
	{ 0x1000777f, 0x00 },
	{ 0x10007780, 0x03 },
	{ 0x10007781, 0xc7 },
	{ 0x10007782, 0xa1 },
	{ 0x10007783, 0x40 },
	{ 0x10007784, 0x93 },
	{ 0x10007785, 0x06 },
	{ 0x10007786, 0x10 },
	{ 0x10007787, 0x00 },
	{ 0x10007788, 0x63 },
	{ 0x10007789, 0x16 },
	{ 0x1000778a, 0xd7 },
	{ 0x1000778b, 0x00 },
	{ 0x1000778c, 0xb7 },
	{ 0x1000778d, 0xd6 },
	{ 0x1000778e, 0x00 },
	{ 0x1000778f, 0x10 },
	{ 0x10007790, 0xa3 },
	{ 0x10007791, 0x8a },
	{ 0x10007792, 0xe6 },
	{ 0x10007793, 0xd8 },
	{ 0x10007794, 0x83 },
	{ 0x10007795, 0xc7 },
	{ 0x10007796, 0xa1 },
	{ 0x10007797, 0x40 },
	{ 0x10007798, 0x63 },
	{ 0x10007799, 0x9c },
	{ 0x1000779a, 0x07 },
	{ 0x1000779b, 0x06 },
	{ 0x1000779c, 0x13 },
	{ 0x1000779d, 0x01 },
	{ 0x1000779e, 0x01 },
	{ 0x1000779f, 0xff },
	{ 0x100077a0, 0x23 },
	{ 0x100077a1, 0x22 },
	{ 0x100077a2, 0x91 },
	{ 0x100077a3, 0x00 },
	{ 0x100077a4, 0x23 },
	{ 0x100077a5, 0x26 },
	{ 0x100077a6, 0x11 },
	{ 0x100077a7, 0x00 },
	{ 0x100077a8, 0x23 },
	{ 0x100077a9, 0x24 },
	{ 0x100077aa, 0x81 },
	{ 0x100077ab, 0x00 },
	{ 0x100077ac, 0xb7 },
	{ 0x100077ad, 0xc4 },
	{ 0x100077ae, 0x00 },
	{ 0x100077af, 0x00 },
	{ 0x100077b0, 0x83 },
	{ 0x100077b1, 0xc7 },
	{ 0x100077b2, 0x04 },
	{ 0x100077b3, 0x56 },
	{ 0x100077b4, 0x13 },
	{ 0x100077b5, 0x07 },
	{ 0x100077b6, 0x80 },
	{ 0x100077b7, 0x01 },
	{ 0x100077b8, 0x93 },
	{ 0x100077b9, 0xf7 },
	{ 0x100077ba, 0xf7 },
	{ 0x100077bb, 0x0f },
	{ 0x100077bc, 0x63 },
	{ 0x100077bd, 0x70 },
	{ 0x100077be, 0xf7 },
	{ 0x100077bf, 0x04 },
	{ 0x100077c0, 0x37 },
	{ 0x100077c1, 0xd4 },
	{ 0x100077c2, 0x00 },
	{ 0x100077c3, 0x10 },
	{ 0x100077c4, 0x83 },
	{ 0x100077c5, 0x47 },
	{ 0x100077c6, 0x54 },
	{ 0x100077c7, 0xd9 },
	{ 0x100077c8, 0x93 },
	{ 0x100077c9, 0xf7 },
	{ 0x100077ca, 0xf7 },
	{ 0x100077cb, 0x0f },
	{ 0x100077cc, 0x63 },
	{ 0x100077cd, 0x88 },
	{ 0x100077ce, 0x07 },
	{ 0x100077cf, 0x02 },
	{ 0x100077d0, 0x93 },
	{ 0x100077d1, 0x07 },
	{ 0x100077d2, 0x10 },
	{ 0x100077d3, 0x00 },
	{ 0x100077d4, 0x23 },
	{ 0x100077d5, 0x82 },
	{ 0x100077d6, 0xf4 },
	{ 0x100077d7, 0x58 },
	{ 0x100077d8, 0x03 },
	{ 0x100077d9, 0x45 },
	{ 0x100077da, 0x64 },
	{ 0x100077db, 0xd9 },
	{ 0x100077dc, 0xb7 },
	{ 0x100077dd, 0x15 },
	{ 0x100077de, 0x00 },
	{ 0x100077df, 0x00 },
	{ 0x100077e0, 0x93 },
	{ 0x100077e1, 0x85 },
	{ 0x100077e2, 0x85 },
	{ 0x100077e3, 0x38 },
	{ 0x100077e4, 0x13 },
	{ 0x100077e5, 0x75 },
	{ 0x100077e6, 0xf5 },
	{ 0x100077e7, 0x0f },
	{ 0x100077e8, 0xef },
	{ 0x100077e9, 0xe0 },
	{ 0x100077ea, 0x9f },
	{ 0x100077eb, 0xd0 },
	{ 0x100077ec, 0x93 },
	{ 0x100077ed, 0x55 },
	{ 0x100077ee, 0xf5 },
	{ 0x100077ef, 0x41 },
	{ 0x100077f0, 0xef },
	{ 0x100077f1, 0xe0 },
	{ 0x100077f2, 0x8f },
	{ 0x100077f3, 0xa3 },
	{ 0x100077f4, 0x23 },
	{ 0x100077f5, 0x82 },
	{ 0x100077f6, 0x04 },
	{ 0x100077f7, 0x58 },
	{ 0x100077f8, 0xa3 },
	{ 0x100077f9, 0x0a },
	{ 0x100077fa, 0x04 },
	{ 0x100077fb, 0xd8 },
	{ 0x100077fc, 0x83 },
	{ 0x100077fd, 0x20 },
	{ 0x100077fe, 0xc1 },
	{ 0x100077ff, 0x00 },
	{ 0x10007800, 0x03 },
	{ 0x10007801, 0x24 },
	{ 0x10007802, 0x81 },
	{ 0x10007803, 0x00 },
	{ 0x10007804, 0x83 },
	{ 0x10007805, 0x24 },
	{ 0x10007806, 0x41 },
	{ 0x10007807, 0x00 },
	{ 0x10007808, 0x13 },
	{ 0x10007809, 0x01 },
	{ 0x1000780a, 0x01 },
	{ 0x1000780b, 0x01 },
	{ 0x1000780c, 0x67 },
	{ 0x1000780d, 0x80 },
	{ 0x1000780e, 0x00 },
	{ 0x1000780f, 0x00 },
	{ 0x10007810, 0x67 },
	{ 0x10007811, 0x80 },
	{ 0x10007812, 0x00 },
	{ 0x10007813, 0x00 },
	{ 0x10007814, 0x13 },
	{ 0x10007815, 0x01 },
	{ 0x10007816, 0x01 },
	{ 0x10007817, 0xff },
	{ 0x10007818, 0x23 },
	{ 0x10007819, 0x26 },
	{ 0x1000781a, 0x11 },
	{ 0x1000781b, 0x00 },
	{ 0x1000781c, 0xef },
	{ 0x1000781d, 0xd0 },
	{ 0x1000781e, 0x8f },
	{ 0x1000781f, 0x86 },
	{ 0x10007820, 0x83 },
	{ 0x10007821, 0xc7 },
	{ 0x10007822, 0x11 },
	{ 0x10007823, 0x42 },
	{ 0x10007824, 0x63 },
	{ 0x10007825, 0x86 },
	{ 0x10007826, 0x07 },
	{ 0x10007827, 0x00 },
	{ 0x10007828, 0x03 },
	{ 0x10007829, 0xc7 },
	{ 0x1000782a, 0x01 },
	{ 0x1000782b, 0x42 },
	{ 0x1000782c, 0x63 },
	{ 0x1000782d, 0x10 },
	{ 0x1000782e, 0x07 },
	{ 0x1000782f, 0x02 },
	{ 0x10007830, 0x83 },
	{ 0x10007831, 0xc6 },
	{ 0x10007832, 0x21 },
	{ 0x10007833, 0x41 },
	{ 0x10007834, 0x13 },
	{ 0x10007835, 0x07 },
	{ 0x10007836, 0xf0 },
	{ 0x10007837, 0x01 },
	{ 0x10007838, 0x13 },
	{ 0x10007839, 0x05 },
	{ 0x1000783a, 0xf0 },
	{ 0x1000783b, 0x01 },
	{ 0x1000783c, 0x63 },
	{ 0x1000783d, 0x98 },
	{ 0x1000783e, 0xe6 },
	{ 0x1000783f, 0x02 },
	{ 0x10007840, 0x63 },
	{ 0x10007841, 0x8a },
	{ 0x10007842, 0x07 },
	{ 0x10007843, 0x02 },
	{ 0x10007844, 0x83 },
	{ 0x10007845, 0xc7 },
	{ 0x10007846, 0x01 },
	{ 0x10007847, 0x42 },
	{ 0x10007848, 0x63 },
	{ 0x10007849, 0x86 },
	{ 0x1000784a, 0x07 },
	{ 0x1000784b, 0x02 },
	{ 0x1000784c, 0x83 },
	{ 0x1000784d, 0xc7 },
	{ 0x1000784e, 0x31 },
	{ 0x1000784f, 0x42 },
	{ 0x10007850, 0x63 },
	{ 0x10007851, 0x86 },
	{ 0x10007852, 0x07 },
	{ 0x10007853, 0x00 },
	{ 0x10007854, 0x83 },
	{ 0x10007855, 0xc7 },
	{ 0x10007856, 0x21 },
	{ 0x10007857, 0x42 },
	{ 0x10007858, 0x63 },
	{ 0x10007859, 0x9e },
	{ 0x1000785a, 0x07 },
	{ 0x1000785b, 0x00 },
	{ 0x1000785c, 0x03 },
	{ 0x1000785d, 0xc7 },
	{ 0x1000785e, 0x21 },
	{ 0x1000785f, 0x41 },
	{ 0x10007860, 0x93 },
	{ 0x10007861, 0x07 },
	{ 0x10007862, 0xb0 },
	{ 0x10007863, 0x01 },
	{ 0x10007864, 0x63 },
	{ 0x10007865, 0x08 },
	{ 0x10007866, 0xf7 },
	{ 0x10007867, 0x00 },
	{ 0x10007868, 0x13 },
	{ 0x10007869, 0x05 },
	{ 0x1000786a, 0xb0 },
	{ 0x1000786b, 0x01 },
	{ 0x1000786c, 0xef },
	{ 0x1000786d, 0xd0 },
	{ 0x1000786e, 0x0f },
	{ 0x1000786f, 0xcf },
	{ 0x10007870, 0xef },
	{ 0x10007871, 0xd0 },
	{ 0x10007872, 0x8f },
	{ 0x10007873, 0xa4 },
	{ 0x10007874, 0x93 },
	{ 0x10007875, 0x06 },
	{ 0x10007876, 0x10 },
	{ 0x10007877, 0x00 },
	{ 0x10007878, 0xa3 },
	{ 0x10007879, 0x89 },
	{ 0x1000787a, 0xd1 },
	{ 0x1000787b, 0x40 },
	{ 0x1000787c, 0x37 },
	{ 0x1000787d, 0xd7 },
	{ 0x1000787e, 0x00 },
	{ 0x1000787f, 0x10 },
	{ 0x10007880, 0x83 },
	{ 0x10007881, 0x47 },
	{ 0x10007882, 0x07 },
	{ 0x10007883, 0xd9 },
	{ 0x10007884, 0x93 },
	{ 0x10007885, 0xf7 },
	{ 0x10007886, 0xf7 },
	{ 0x10007887, 0x0f },
	{ 0x10007888, 0x63 },
	{ 0x10007889, 0x90 },
	{ 0x1000788a, 0x07 },
	{ 0x1000788b, 0x02 },
	{ 0x1000788c, 0x37 },
	{ 0x1000788d, 0xc6 },
	{ 0x1000788e, 0x00 },
	{ 0x1000788f, 0x00 },
	{ 0x10007890, 0x83 },
	{ 0x10007891, 0x47 },
	{ 0x10007892, 0x26 },
	{ 0x10007893, 0x04 },
	{ 0x10007894, 0x93 },
	{ 0x10007895, 0xe7 },
	{ 0x10007896, 0x07 },
	{ 0x10007897, 0xf8 },
	{ 0x10007898, 0x93 },
	{ 0x10007899, 0xf7 },
	{ 0x1000789a, 0xf7 },
	{ 0x1000789b, 0x0f },
	{ 0x1000789c, 0x23 },
	{ 0x1000789d, 0x01 },
	{ 0x1000789e, 0xf6 },
	{ 0x1000789f, 0x04 },
	{ 0x100078a0, 0x23 },
	{ 0x100078a1, 0x08 },
	{ 0x100078a2, 0xd7 },
	{ 0x100078a3, 0xd8 },
	{ 0x100078a4, 0x23 },
	{ 0x100078a5, 0x09 },
	{ 0x100078a6, 0x07 },
	{ 0x100078a7, 0xd8 },
	{ 0x100078a8, 0x83 },
	{ 0x100078a9, 0x20 },
	{ 0x100078aa, 0xc1 },
	{ 0x100078ab, 0x00 },
	{ 0x100078ac, 0x13 },
	{ 0x100078ad, 0x01 },
	{ 0x100078ae, 0x01 },
	{ 0x100078af, 0x01 },
	{ 0x100078b0, 0x67 },
	{ 0x100078b1, 0x80 },
	{ 0x100078b2, 0x00 },
	{ 0x100078b3, 0x00 },
	{ 0x3fc2bfc7, 0x00 },
	{ 0x3fc2bfc6, 0x00 },
	{ 0x3fc2bfc5, 0x00 },
	{ 0x3fc2bfc4, 0x01 },
	{ 0x0000d486, 0x43 },
	{ 0x1000db00, 0x02 },
	{ 0x1000db01, 0x00 },
	{ 0x1000db02, 0x11 },
	{ 0x1000db03, 0x00 },
	{ 0x1000db04, 0x00 },
	{ 0x1000db05, 0x82 },
	{ 0x1000db06, 0x04 },
	{ 0x1000db07, 0xf1 },
	{ 0x1000db08, 0x00 },
	{ 0x1000db09, 0x00 },
	{ 0x1000db0a, 0x40 },
	{ 0x0000d540, 0x01 },
};

static const struct reg_default rt1320_reg_defaults[] = {
	{ SDW_SDCA_CTL(FUNC_NUM_AMP, RT1320_SDCA_ENT_FU21, RT1320_SDCA_CTL_FU_MUTE, CH_01), 0x01 },
	{ SDW_SDCA_CTL(FUNC_NUM_AMP, RT1320_SDCA_ENT_FU21, RT1320_SDCA_CTL_FU_MUTE, CH_02), 0x01 },
	{ SDW_SDCA_CTL(FUNC_NUM_AMP, RT1320_SDCA_ENT_PPU21, RT1320_SDCA_CTL_POSTURE_NUMBER, 0), 0x00 },
	{ SDW_SDCA_CTL(FUNC_NUM_AMP, RT1320_SDCA_ENT_CS113, RT1320_SDCA_CTL_SAMPLE_FREQ_INDEX, 0), 0x09 },
	{ SDW_SDCA_CTL(FUNC_NUM_AMP, RT1320_SDCA_ENT_CS14, RT1320_SDCA_CTL_SAMPLE_FREQ_INDEX, 0), 0x0b },
	{ SDW_SDCA_CTL(FUNC_NUM_AMP, RT1320_SDCA_ENT_CS21, RT1320_SDCA_CTL_SAMPLE_FREQ_INDEX, 0), 0x09 },
	{ SDW_SDCA_CTL(FUNC_NUM_AMP, RT1320_SDCA_ENT_PDE27, RT1320_SDCA_CTL_REQ_POWER_STATE, 0), 0x03 },
	{ SDW_SDCA_CTL(FUNC_NUM_AMP, RT1320_SDCA_ENT_PDE23, RT1320_SDCA_CTL_REQ_POWER_STATE, 0), 0x03 },
};

static const struct reg_default rt1320_mbq_defaults[] = {
	{ SDW_SDCA_CTL(FUNC_NUM_AMP, RT1320_SDCA_ENT_FU21, RT1320_SDCA_CTL_FU_VOLUME, CH_01), 0x0000 },
	{ SDW_SDCA_CTL(FUNC_NUM_AMP, RT1320_SDCA_ENT_FU21, RT1320_SDCA_CTL_FU_VOLUME, CH_02), 0x0000 },
};

static bool rt1320_readable_register(struct device *dev, unsigned int reg)
{
	switch (reg) {
	case 0xc000 ... 0xc086:
	case 0xc400 ... 0xc409:
	case 0xc480 ... 0xc48f:
	case 0xc4c0 ... 0xc4c4:
	case 0xc4e0 ... 0xc4e7:
	case 0xc500:
	case 0xc560 ... 0xc56b:
	case 0xc570:
	case 0xc580 ... 0xc59a:
	case 0xc5b0 ... 0xc60f:
	case 0xc640 ... 0xc64f:
	case 0xc670:
	case 0xc680 ... 0xc683:
	case 0xc700 ... 0xc76f:
	case 0xc800 ... 0xc801:
	case 0xc820:
	case 0xc900 ... 0xc901:
	case 0xc920 ... 0xc921:
	case 0xca00 ... 0xca07:
	case 0xca20 ... 0xca27:
	case 0xca40 ... 0xca4b:
	case 0xca60 ... 0xca68:
	case 0xca80 ... 0xca88:
	case 0xcb00 ... 0xcb0c:
	case 0xcc00 ... 0xcc12:
	case 0xcc80 ... 0xcc81:
	case 0xcd00:
	case 0xcd80 ... 0xcd82:
	case 0xce00 ... 0xce4d:
	case 0xcf00 ... 0xcf25:
	case 0xd000 ... 0xd0ff:
	case 0xd100 ... 0xd1ff:
	case 0xd200 ... 0xd2ff:
	case 0xd300 ... 0xd3ff:
	case 0xd400 ... 0xd403:
	case 0xd410 ... 0xd417:
	case 0xd470 ... 0xd497:
	case 0xd4dc ... 0xd50f:
	case 0xd520 ... 0xd543:
	case 0xd560 ... 0xd5ef:
	case 0xd600 ... 0xd663:
	case 0xda00 ... 0xda6e:
	case 0xda80 ... 0xda9e:
	case 0xdb00 ... 0xdb7f:
	case 0xdc00:
	case 0xdc20 ... 0xdc21:
	case 0xdd00 ... 0xdd17:
	case 0xde00 ... 0xde09:
	case 0xdf00 ... 0xdf1b:
	case 0xe000 ... 0xe847:
	case 0xf717 ... 0xf719:
	case 0xf720 ... 0xf723:
	case 0x1000f008:
	case 0x3fe2e000 ... 0x3fe2e003:
	case SDW_SDCA_CTL(FUNC_NUM_AMP, RT1320_SDCA_ENT0, RT1320_SDCA_CTL_FUNC_STATUS, 0):
	case SDW_SDCA_CTL(FUNC_NUM_AMP, RT1320_SDCA_ENT_FU21, RT1320_SDCA_CTL_FU_MUTE, CH_01):
	case SDW_SDCA_CTL(FUNC_NUM_AMP, RT1320_SDCA_ENT_FU21, RT1320_SDCA_CTL_FU_MUTE, CH_02):
	case SDW_SDCA_CTL(FUNC_NUM_AMP, RT1320_SDCA_ENT_PPU21, RT1320_SDCA_CTL_POSTURE_NUMBER, 0):
	case SDW_SDCA_CTL(FUNC_NUM_AMP, RT1320_SDCA_ENT_PDE23, RT1320_SDCA_CTL_REQ_POWER_STATE, 0):
	case SDW_SDCA_CTL(FUNC_NUM_AMP, RT1320_SDCA_ENT_PDE27, RT1320_SDCA_CTL_REQ_POWER_STATE, 0):
	case SDW_SDCA_CTL(FUNC_NUM_AMP, RT1320_SDCA_ENT_CS113, RT1320_SDCA_CTL_SAMPLE_FREQ_INDEX, 0):
	case SDW_SDCA_CTL(FUNC_NUM_AMP, RT1320_SDCA_ENT_CS14, RT1320_SDCA_CTL_SAMPLE_FREQ_INDEX, 0):
	case SDW_SDCA_CTL(FUNC_NUM_AMP, RT1320_SDCA_ENT_CS21, RT1320_SDCA_CTL_SAMPLE_FREQ_INDEX, 0):
	case SDW_SDCA_CTL(FUNC_NUM_AMP, RT1320_SDCA_ENT_SAPU, RT1320_SDCA_CTL_SAPU_PROTECTION_MODE, 0):
	case SDW_SDCA_CTL(FUNC_NUM_AMP, RT1320_SDCA_ENT_SAPU, RT1320_SDCA_CTL_SAPU_PROTECTION_STATUS, 0):
		return true;
	default:
		return false;
	}
}

static bool rt1320_volatile_register(struct device *dev, unsigned int reg)
{
	switch (reg) {
	case 0xc402 ... 0xc406:
	case 0xc48c ... 0xc48f:
	case 0xc560:
	case 0xc5b5 ... 0xc5b7:
	case 0xc5fc ... 0xc5ff:
	case 0xc820:
	case 0xc900:
	case 0xc920:
	case 0xca42:
	case 0xca62:
	case 0xca82:
	case 0xcd00:
	case 0xce03:
	case 0xce10:
	case 0xce14 ... 0xce17:
	case 0xce44 ... 0xce49:
	case 0xce4c ... 0xce4d:
	case 0xcf0c:
	case 0xcf10 ... 0xcf25:
	case 0xd486 ... 0xd487:
	case 0xd4e5 ... 0xd4e6:
	case 0xd4e8 ... 0xd4ff:
	case 0xd530:
	case 0xd540:
	case 0xd543:
	case 0xdb58 ... 0xdb5f:
	case 0xdb60 ... 0xdb63:
	case 0xdb68 ... 0xdb69:
	case 0xdb6d:
	case 0xdb70 ... 0xdb71:
	case 0xdb76:
	case 0xdb7a:
	case 0xdb7c ... 0xdb7f:
	case 0xdd0c ... 0xdd13:
	case 0xde02:
	case 0xdf14 ... 0xdf1b:
	case 0xe83c ... 0xe847:
	case 0xf717 ... 0xf719:
	case 0xf720 ... 0xf723:
	case 0x10000000 ... 0x10007fff:
	case 0x1000c000 ... 0x1000dfff:
	case 0x1000f008:
	case 0x3fc2bfc4 ... 0x3fc2bfc7:
	case 0x3fe2e000 ... 0x3fe2e003:
	case SDW_SDCA_CTL(FUNC_NUM_AMP, RT1320_SDCA_ENT0, RT1320_SDCA_CTL_FUNC_STATUS, 0):
	case SDW_SDCA_CTL(FUNC_NUM_AMP, RT1320_SDCA_ENT_SAPU, RT1320_SDCA_CTL_SAPU_PROTECTION_MODE, 0):
	case SDW_SDCA_CTL(FUNC_NUM_AMP, RT1320_SDCA_ENT_SAPU, RT1320_SDCA_CTL_SAPU_PROTECTION_STATUS, 0):
		return true;
	default:
		return false;
	}
}

static bool rt1320_mbq_readable_register(struct device *dev, unsigned int reg)
{
	switch (reg) {
	case SDW_SDCA_CTL(FUNC_NUM_AMP, RT1320_SDCA_ENT_FU21, RT1320_SDCA_CTL_FU_VOLUME, CH_01):
	case SDW_SDCA_CTL(FUNC_NUM_AMP, RT1320_SDCA_ENT_FU21, RT1320_SDCA_CTL_FU_VOLUME, CH_02):
		return true;
	default:
		return false;
	}
}

static const struct regmap_config rt1320_sdw_regmap = {
	.reg_bits = 32,
	.val_bits = 8,
	.readable_reg = rt1320_readable_register,
	.volatile_reg = rt1320_volatile_register,
	.max_register = 0x41081488,
	.reg_defaults = rt1320_reg_defaults,
	.num_reg_defaults = ARRAY_SIZE(rt1320_reg_defaults),
	.cache_type = REGCACHE_MAPLE,
	.use_single_read = true,
	.use_single_write = true,
};

static const struct regmap_config rt1320_mbq_regmap = {
	.name = "sdw-mbq",
	.reg_bits = 32,
	.val_bits = 16,
	.readable_reg = rt1320_mbq_readable_register,
	.max_register = 0x41000192,
	.reg_defaults = rt1320_mbq_defaults,
	.num_reg_defaults = ARRAY_SIZE(rt1320_mbq_defaults),
	.cache_type = REGCACHE_MAPLE,
	.use_single_read = true,
	.use_single_write = true,
};

static int rt1320_read_prop(struct sdw_slave *slave)
{
	struct sdw_slave_prop *prop = &slave->prop;
	int nval;
	int i, j;
	u32 bit;
	unsigned long addr;
	struct sdw_dpn_prop *dpn;

	/*
	 * Due to support the multi-lane, we call 'sdw_slave_read_prop' to get the lane mapping
	 */
	sdw_slave_read_prop(slave);

	prop->scp_int1_mask = SDW_SCP_INT1_BUS_CLASH | SDW_SCP_INT1_PARITY;
	prop->quirks = SDW_SLAVE_QUIRKS_INVALID_INITIAL_PARITY;

	prop->paging_support = true;
	prop->lane_control_support = true;

	/* first we need to allocate memory for set bits in port lists */
	prop->source_ports = BIT(4);
	prop->sink_ports = BIT(1);

	nval = hweight32(prop->source_ports);
	prop->src_dpn_prop = devm_kcalloc(&slave->dev, nval,
		sizeof(*prop->src_dpn_prop), GFP_KERNEL);
	if (!prop->src_dpn_prop)
		return -ENOMEM;

	i = 0;
	dpn = prop->src_dpn_prop;
	addr = prop->source_ports;
	for_each_set_bit(bit, &addr, 32) {
		dpn[i].num = bit;
		dpn[i].type = SDW_DPN_FULL;
		dpn[i].simple_ch_prep_sm = true;
		dpn[i].ch_prep_timeout = 10;
		i++;
	}

	/* do this again for sink now */
	nval = hweight32(prop->sink_ports);
	prop->sink_dpn_prop = devm_kcalloc(&slave->dev, nval,
		sizeof(*prop->sink_dpn_prop), GFP_KERNEL);
	if (!prop->sink_dpn_prop)
		return -ENOMEM;

	j = 0;
	dpn = prop->sink_dpn_prop;
	addr = prop->sink_ports;
	for_each_set_bit(bit, &addr, 32) {
		dpn[j].num = bit;
		dpn[j].type = SDW_DPN_FULL;
		dpn[j].simple_ch_prep_sm = true;
		dpn[j].ch_prep_timeout = 10;
		j++;
	}

	/* set the timeout values */
	prop->clk_stop_timeout = 64;

	return 0;
}

static int rt1320_io_init(struct device *dev, struct sdw_slave *slave)
{
	struct rt1320_sdw_priv *rt1320 = dev_get_drvdata(dev);
	unsigned int amp_func_status, val, tmp;

	if (rt1320->hw_init)
		return 0;

	regcache_cache_only(rt1320->regmap, false);
	regcache_cache_only(rt1320->mbq_regmap, false);
	if (rt1320->first_hw_init) {
		regcache_cache_bypass(rt1320->regmap, true);
		regcache_cache_bypass(rt1320->mbq_regmap, true);
	} else {
		/*
		 * PM runtime status is marked as 'active' only when a Slave reports as Attached
		 */
		/* update count of parent 'active' children */
		pm_runtime_set_active(&slave->dev);
	}

	pm_runtime_get_noresume(&slave->dev);

	if (rt1320->version_id < 0) {
		regmap_read(rt1320->regmap, RT1320_DEV_VERSION_ID_1, &val);
		rt1320->version_id = val;
	}

	regmap_read(rt1320->regmap,
		SDW_SDCA_CTL(FUNC_NUM_AMP, RT1320_SDCA_ENT0, RT1320_SDCA_CTL_FUNC_STATUS, 0), &amp_func_status);
	dev_dbg(dev, "%s amp func_status=0x%x\n", __func__, amp_func_status);

	/* initialization write */
	if ((amp_func_status & FUNCTION_NEEDS_INITIALIZATION) || (!rt1320->first_hw_init)) {
		regmap_multi_reg_write(rt1320->regmap, rt1320_blind_write, ARRAY_SIZE(rt1320_blind_write));
		regmap_multi_reg_write(rt1320->regmap, rt1320_patch_code_write,
			ARRAY_SIZE(rt1320_patch_code_write));

		regmap_write(rt1320->regmap,
			SDW_SDCA_CTL(FUNC_NUM_AMP, RT1320_SDCA_ENT0, RT1320_SDCA_CTL_FUNC_STATUS, 0),
			FUNCTION_NEEDS_INITIALIZATION);
	}
	if (!rt1320->first_hw_init) {
		regmap_write(rt1320->regmap, SDW_SDCA_CTL(FUNC_NUM_AMP, RT1320_SDCA_ENT_PDE23,
			RT1320_SDCA_CTL_REQ_POWER_STATE, 0), 0);
		regmap_read(rt1320->regmap, RT1320_HIFI_VER_0, &val);
		regmap_read(rt1320->regmap, RT1320_HIFI_VER_1, &tmp);
		val = (tmp << 8) | val;
		regmap_read(rt1320->regmap, RT1320_HIFI_VER_2, &tmp);
		val = (tmp << 16) | val;
		regmap_read(rt1320->regmap, RT1320_HIFI_VER_3, &tmp);
		val = (tmp << 24) | val;
		dev_dbg(dev, "%s ROM version=0x%x\n", __func__, val);
		/*
		 * We call the version b which has the new DSP ROM code against version a.
		 * Therefore, we read the DSP address to check the ID.
		 */
		if (val == RT1320_VER_B_ID)
			rt1320->version_id = RT1320_VB;
		regmap_write(rt1320->regmap, SDW_SDCA_CTL(FUNC_NUM_AMP, RT1320_SDCA_ENT_PDE23,
			RT1320_SDCA_CTL_REQ_POWER_STATE, 0), 3);
	}
	dev_dbg(dev, "%s version_id=%d\n", __func__, rt1320->version_id);

	if (rt1320->first_hw_init) {
		regcache_cache_bypass(rt1320->regmap, false);
		regcache_cache_bypass(rt1320->mbq_regmap, false);
		regcache_mark_dirty(rt1320->regmap);
		regcache_mark_dirty(rt1320->mbq_regmap);
	}

	/* Mark Slave initialization complete */
	rt1320->first_hw_init = true;
	rt1320->hw_init = true;

	pm_runtime_mark_last_busy(&slave->dev);
	pm_runtime_put_autosuspend(&slave->dev);

	dev_dbg(&slave->dev, "%s hw_init complete\n", __func__);
	return 0;
}

static int rt1320_update_status(struct sdw_slave *slave,
					enum sdw_slave_status status)
{
	struct  rt1320_sdw_priv *rt1320 = dev_get_drvdata(&slave->dev);

	if (status == SDW_SLAVE_UNATTACHED)
		rt1320->hw_init = false;

	/*
	 * Perform initialization only if slave status is present and
	 * hw_init flag is false
	 */
	if (rt1320->hw_init || status != SDW_SLAVE_ATTACHED)
		return 0;

	/* perform I/O transfers required for Slave initialization */
	return rt1320_io_init(&slave->dev, slave);
}

static int rt1320_pde23_event(struct snd_soc_dapm_widget *w,
	struct snd_kcontrol *kcontrol, int event)
{
	struct snd_soc_component *component =
		snd_soc_dapm_to_component(w->dapm);
	struct rt1320_sdw_priv *rt1320 = snd_soc_component_get_drvdata(component);
	unsigned char ps0 = 0x0, ps3 = 0x3;

	switch (event) {
	case SND_SOC_DAPM_POST_PMU:
		regmap_write(rt1320->regmap,
			SDW_SDCA_CTL(FUNC_NUM_AMP, RT1320_SDCA_ENT_PDE23,
				RT1320_SDCA_CTL_REQ_POWER_STATE, 0),
				ps0);
		break;
	case SND_SOC_DAPM_PRE_PMD:
		regmap_write(rt1320->regmap,
			SDW_SDCA_CTL(FUNC_NUM_AMP, RT1320_SDCA_ENT_PDE23,
				RT1320_SDCA_CTL_REQ_POWER_STATE, 0),
				ps3);
		break;
	default:
		break;
	}

	return 0;
}

static int rt1320_set_gain_put(struct snd_kcontrol *kcontrol,
		struct snd_ctl_elem_value *ucontrol)
{
	struct snd_soc_component *component = snd_kcontrol_chip(kcontrol);
	struct soc_mixer_control *mc =
		(struct soc_mixer_control *)kcontrol->private_value;
	struct rt1320_sdw_priv *rt1320 = snd_soc_component_get_drvdata(component);
	unsigned int read_l, read_r, gain_l_val, gain_r_val;
	unsigned int lvalue, rvalue;
	const unsigned int interval_offset = 0xc0;

	regmap_read(rt1320->mbq_regmap, mc->reg, &lvalue);
	regmap_read(rt1320->mbq_regmap, mc->rreg, &rvalue);

	/* L Channel */
	gain_l_val = ucontrol->value.integer.value[0];
	if (gain_l_val > mc->max)
		gain_l_val = mc->max;
	gain_l_val = 0 - ((mc->max - gain_l_val) * interval_offset);
	gain_l_val &= 0xffff;

	/* R Channel */
	gain_r_val = ucontrol->value.integer.value[1];
	if (gain_r_val > mc->max)
		gain_r_val = mc->max;
	gain_r_val = 0 - ((mc->max - gain_r_val) * interval_offset);
	gain_r_val &= 0xffff;

	if (lvalue == gain_l_val && rvalue == gain_r_val)
		return 0;

	/* Lch*/
	regmap_write(rt1320->mbq_regmap, mc->reg, gain_l_val);
	/* Rch */
	regmap_write(rt1320->mbq_regmap, mc->rreg, gain_r_val);

	regmap_read(rt1320->mbq_regmap, mc->reg, &read_l);
	regmap_read(rt1320->mbq_regmap, mc->rreg, &read_r);
	if (read_r == gain_r_val && read_l == gain_l_val)
		return 1;

	return -EIO;
}

static int rt1320_set_gain_get(struct snd_kcontrol *kcontrol,
		struct snd_ctl_elem_value *ucontrol)
{
	struct snd_soc_component *component = snd_kcontrol_chip(kcontrol);
	struct rt1320_sdw_priv *rt1320 = snd_soc_component_get_drvdata(component);
	struct soc_mixer_control *mc =
		(struct soc_mixer_control *)kcontrol->private_value;
	unsigned int read_l, read_r, ctl_l = 0, ctl_r = 0;
	const unsigned int interval_offset = 0xc0;

	regmap_read(rt1320->mbq_regmap, mc->reg, &read_l);
	regmap_read(rt1320->mbq_regmap, mc->rreg, &read_r);

	ctl_l = mc->max - (((0 - read_l) & 0xffff) / interval_offset);

	if (read_l != read_r)
		ctl_r = mc->max - (((0 - read_r) & 0xffff) / interval_offset);
	else
		ctl_r = ctl_l;

	ucontrol->value.integer.value[0] = ctl_l;
	ucontrol->value.integer.value[1] = ctl_r;
	return 0;
}

static const char * const rt1320_rx_data_ch_select[] = {
	"L,R",
	"R,L",
	"L,L",
	"R,R",
	"L,L+R",
	"R,L+R",
	"L+R,L",
	"L+R,R",
	"L+R,L+R",
};

static SOC_ENUM_SINGLE_DECL(rt1320_rx_data_ch_enum,
	SDW_SDCA_CTL(FUNC_NUM_AMP, RT1320_SDCA_ENT_PPU21, RT1320_SDCA_CTL_POSTURE_NUMBER, 0), 0,
	rt1320_rx_data_ch_select);

static const DECLARE_TLV_DB_SCALE(out_vol_tlv, -6525, 75, 0);

static const struct snd_kcontrol_new rt1320_snd_controls[] = {
	SOC_DOUBLE_R_EXT_TLV("FU21 Playback Volume",
		SDW_SDCA_CTL(FUNC_NUM_AMP, RT1320_SDCA_ENT_FU21, RT1320_SDCA_CTL_FU_VOLUME, CH_01),
		SDW_SDCA_CTL(FUNC_NUM_AMP, RT1320_SDCA_ENT_FU21, RT1320_SDCA_CTL_FU_VOLUME, CH_02),
		0, 0x57, 0, rt1320_set_gain_get, rt1320_set_gain_put, out_vol_tlv),
	SOC_ENUM("RX Channel Select", rt1320_rx_data_ch_enum),
};

static const struct snd_kcontrol_new rt1320_spk_l_dac =
	SOC_DAPM_SINGLE_AUTODISABLE("Switch",
		SDW_SDCA_CTL(FUNC_NUM_AMP, RT1320_SDCA_ENT_FU21, RT1320_SDCA_CTL_FU_MUTE, CH_01),
		0, 1, 1);
static const struct snd_kcontrol_new rt1320_spk_r_dac =
	SOC_DAPM_SINGLE_AUTODISABLE("Switch",
		SDW_SDCA_CTL(FUNC_NUM_AMP, RT1320_SDCA_ENT_FU21, RT1320_SDCA_CTL_FU_MUTE, CH_02),
		0, 1, 1);

static const struct snd_soc_dapm_widget rt1320_dapm_widgets[] = {
	/* Audio Interface */
	SND_SOC_DAPM_AIF_IN("DP1RX", "DP1 Playback", 0, SND_SOC_NOPM, 0, 0),
	SND_SOC_DAPM_AIF_OUT("DP4TX", "DP4 Capture", 0, SND_SOC_NOPM, 0, 0),

	/* Digital Interface */
	SND_SOC_DAPM_PGA("FU21", SND_SOC_NOPM, 0, 0, NULL, 0),
	SND_SOC_DAPM_SUPPLY("PDE 23", SND_SOC_NOPM, 0, 0,
		rt1320_pde23_event,
		SND_SOC_DAPM_POST_PMU | SND_SOC_DAPM_PRE_PMD),

	/* Output */
	SND_SOC_DAPM_SWITCH("OT23 L", SND_SOC_NOPM, 0, 0, &rt1320_spk_l_dac),
	SND_SOC_DAPM_SWITCH("OT23 R", SND_SOC_NOPM, 0, 0, &rt1320_spk_r_dac),
	SND_SOC_DAPM_OUTPUT("SPOL"),
	SND_SOC_DAPM_OUTPUT("SPOR"),

	/* Input */
	SND_SOC_DAPM_PGA("AEC Data", SND_SOC_NOPM, 0, 0, NULL, 0),
	SND_SOC_DAPM_SIGGEN("AEC Gen"),
};

static const struct snd_soc_dapm_route rt1320_dapm_routes[] = {
	{ "FU21", NULL, "DP1RX" },
	{ "FU21", NULL, "PDE 23" },
	{ "OT23 L", "Switch", "FU21" },
	{ "OT23 R", "Switch", "FU21" },
	{ "SPOL", NULL, "OT23 L" },
	{ "SPOR", NULL, "OT23 R" },

	{ "AEC Data", NULL, "AEC Gen" },
	{ "DP4TX", NULL, "AEC Data" },
};

static int rt1320_set_sdw_stream(struct snd_soc_dai *dai, void *sdw_stream,
				int direction)
{
	snd_soc_dai_dma_data_set(dai, direction, sdw_stream);
	return 0;
}

static void rt1320_sdw_shutdown(struct snd_pcm_substream *substream,
				struct snd_soc_dai *dai)
{
	snd_soc_dai_set_dma_data(dai, substream, NULL);
}

static int rt1320_sdw_hw_params(struct snd_pcm_substream *substream,
	struct snd_pcm_hw_params *params, struct snd_soc_dai *dai)
{
	struct snd_soc_component *component = dai->component;
	struct rt1320_sdw_priv *rt1320 =
		snd_soc_component_get_drvdata(component);
	struct sdw_stream_config stream_config;
	struct sdw_port_config port_config;
	struct sdw_stream_runtime *sdw_stream;
	int retval;
	unsigned int sampling_rate;

	dev_dbg(dai->dev, "%s %s", __func__, dai->name);
	sdw_stream = snd_soc_dai_get_dma_data(dai, substream);

	if (!sdw_stream)
		return -EINVAL;

	if (!rt1320->sdw_slave)
		return -EINVAL;

	/* SoundWire specific configuration */
	snd_sdw_params_to_config(substream, params, &stream_config, &port_config);

	if (substream->stream == SNDRV_PCM_STREAM_PLAYBACK) {
		if (dai->id == RT1320_AIF1)
			port_config.num = 1;
		else
			return -EINVAL;
	} else {
		if (dai->id == RT1320_AIF1)
			port_config.num = 4;
		else
			return -EINVAL;
	}

	retval = sdw_stream_add_slave(rt1320->sdw_slave, &stream_config,
				&port_config, 1, sdw_stream);
	if (retval) {
		dev_err(dai->dev, "%s: Unable to configure port\n", __func__);
		return retval;
	}

	/* sampling rate configuration */
	switch (params_rate(params)) {
	case 16000:
		sampling_rate = RT1320_SDCA_RATE_16000HZ;
		break;
	case 32000:
		sampling_rate = RT1320_SDCA_RATE_32000HZ;
		break;
	case 44100:
		sampling_rate = RT1320_SDCA_RATE_44100HZ;
		break;
	case 48000:
		sampling_rate = RT1320_SDCA_RATE_48000HZ;
		break;
	case 96000:
		sampling_rate = RT1320_SDCA_RATE_96000HZ;
		break;
	case 192000:
		sampling_rate = RT1320_SDCA_RATE_192000HZ;
		break;
	default:
		dev_err(component->dev, "%s: Rate %d is not supported\n",
			__func__, params_rate(params));
		return -EINVAL;
	}

	/* set sampling frequency */
	regmap_write(rt1320->regmap,
		SDW_SDCA_CTL(FUNC_NUM_AMP, RT1320_SDCA_ENT_CS21, RT1320_SDCA_CTL_SAMPLE_FREQ_INDEX, 0),
		sampling_rate);

	return 0;
}

static int rt1320_sdw_pcm_hw_free(struct snd_pcm_substream *substream,
				struct snd_soc_dai *dai)
{
	struct snd_soc_component *component = dai->component;
	struct rt1320_sdw_priv *rt1320 =
		snd_soc_component_get_drvdata(component);
	struct sdw_stream_runtime *sdw_stream =
		snd_soc_dai_get_dma_data(dai, substream);

	if (!rt1320->sdw_slave)
		return -EINVAL;

	sdw_stream_remove_slave(rt1320->sdw_slave, sdw_stream);
	return 0;
}

/*
 * slave_ops: callbacks for get_clock_stop_mode, clock_stop and
 * port_prep are not defined for now
 */
static const struct sdw_slave_ops rt1320_slave_ops = {
	.read_prop = rt1320_read_prop,
	.update_status = rt1320_update_status,
};

static int rt1320_sdw_component_probe(struct snd_soc_component *component)
{
	int ret;
	struct rt1320_sdw_priv *rt1320 = snd_soc_component_get_drvdata(component);

	rt1320->component = component;

	if (!rt1320->first_hw_init)
		return 0;

	ret = pm_runtime_resume(component->dev);
	dev_dbg(&rt1320->sdw_slave->dev, "%s pm_runtime_resume, ret=%d", __func__, ret);
	if (ret < 0 && ret != -EACCES)
		return ret;

	return 0;
}

static const struct snd_soc_component_driver soc_component_sdw_rt1320 = {
	.probe = rt1320_sdw_component_probe,
	.controls = rt1320_snd_controls,
	.num_controls = ARRAY_SIZE(rt1320_snd_controls),
	.dapm_widgets = rt1320_dapm_widgets,
	.num_dapm_widgets = ARRAY_SIZE(rt1320_dapm_widgets),
	.dapm_routes = rt1320_dapm_routes,
	.num_dapm_routes = ARRAY_SIZE(rt1320_dapm_routes),
	.endianness = 1,
};

static const struct snd_soc_dai_ops rt1320_aif_dai_ops = {
	.hw_params = rt1320_sdw_hw_params,
	.hw_free	= rt1320_sdw_pcm_hw_free,
	.set_stream	= rt1320_set_sdw_stream,
	.shutdown	= rt1320_sdw_shutdown,
};

#define RT1320_STEREO_RATES (SNDRV_PCM_RATE_16000 | SNDRV_PCM_RATE_32000 | SNDRV_PCM_RATE_44100 | \
	SNDRV_PCM_RATE_48000 | SNDRV_PCM_RATE_96000 | SNDRV_PCM_RATE_192000)
#define RT1320_FORMATS (SNDRV_PCM_FMTBIT_S16_LE | SNDRV_PCM_FMTBIT_S24_LE | \
	SNDRV_PCM_FMTBIT_S32_LE)

static struct snd_soc_dai_driver rt1320_sdw_dai[] = {
	{
		.name = "rt1320-aif1",
		.id = RT1320_AIF1,
		.playback = {
			.stream_name = "DP1 Playback",
			.channels_min = 1,
			.channels_max = 2,
			.rates = RT1320_STEREO_RATES,
			.formats = RT1320_FORMATS,
		},
		.capture = {
			.stream_name = "DP4 Capture",
			.channels_min = 1,
			.channels_max = 2,
			.rates = RT1320_STEREO_RATES,
			.formats = RT1320_FORMATS,
		},
		.ops = &rt1320_aif_dai_ops,
	},
};

static int rt1320_sdw_init(struct device *dev, struct regmap *regmap,
				struct regmap *mbq_regmap, struct sdw_slave *slave)
{
	struct rt1320_sdw_priv *rt1320;
	int ret;

	rt1320 = devm_kzalloc(dev, sizeof(*rt1320), GFP_KERNEL);
	if (!rt1320)
		return -ENOMEM;

	dev_set_drvdata(dev, rt1320);
	rt1320->sdw_slave = slave;
	rt1320->mbq_regmap = mbq_regmap;
	rt1320->regmap = regmap;

	regcache_cache_only(rt1320->regmap, true);
	regcache_cache_only(rt1320->mbq_regmap, true);

	/*
	 * Mark hw_init to false
	 * HW init will be performed when device reports present
	 */
	rt1320->hw_init = false;
	rt1320->first_hw_init = false;
	rt1320->version_id = -1;

	ret =  devm_snd_soc_register_component(dev,
				&soc_component_sdw_rt1320,
				rt1320_sdw_dai,
				ARRAY_SIZE(rt1320_sdw_dai));
	if (ret < 0)
		return ret;

	/* set autosuspend parameters */
	pm_runtime_set_autosuspend_delay(dev, 3000);
	pm_runtime_use_autosuspend(dev);

	/* make sure the device does not suspend immediately */
	pm_runtime_mark_last_busy(dev);

	pm_runtime_enable(dev);

	/* important note: the device is NOT tagged as 'active' and will remain
	 * 'suspended' until the hardware is enumerated/initialized. This is required
	 * to make sure the ASoC framework use of pm_runtime_get_sync() does not silently
	 * fail with -EACCESS because of race conditions between card creation and enumeration
	 */

	dev_dbg(dev, "%s\n", __func__);

	return ret;
}

static int rt1320_sdw_probe(struct sdw_slave *slave,
				const struct sdw_device_id *id)
{
	struct regmap *regmap, *mbq_regmap;

	/* Regmap Initialization */
	mbq_regmap = devm_regmap_init_sdw_mbq(slave, &rt1320_mbq_regmap);
	if (IS_ERR(mbq_regmap))
		return PTR_ERR(mbq_regmap);

	regmap = devm_regmap_init_sdw(slave, &rt1320_sdw_regmap);
	if (IS_ERR(regmap))
		return PTR_ERR(regmap);

	return rt1320_sdw_init(&slave->dev, regmap, mbq_regmap, slave);
}

static int rt1320_sdw_remove(struct sdw_slave *slave)
{
	pm_runtime_disable(&slave->dev);

	return 0;
}

/*
 * Version A/B will use the class id 0
 * The newer version than A/B will use the class id 1, so add it in advance
 */
static const struct sdw_device_id rt1320_id[] = {
	SDW_SLAVE_ENTRY_EXT(0x025d, 0x1320, 0x3, 0x0, 0),
	SDW_SLAVE_ENTRY_EXT(0x025d, 0x1320, 0x3, 0x1, 0),
	{},
};
MODULE_DEVICE_TABLE(sdw, rt1320_id);

static int __maybe_unused rt1320_dev_suspend(struct device *dev)
{
	struct rt1320_sdw_priv *rt1320 = dev_get_drvdata(dev);

	if (!rt1320->hw_init)
		return 0;

	regcache_cache_only(rt1320->regmap, true);
	regcache_cache_only(rt1320->mbq_regmap, true);
	return 0;
}

#define RT1320_PROBE_TIMEOUT 5000

static int __maybe_unused rt1320_dev_resume(struct device *dev)
{
	struct sdw_slave *slave = dev_to_sdw_dev(dev);
	struct rt1320_sdw_priv *rt1320 = dev_get_drvdata(dev);
	unsigned long time;

	if (!rt1320->first_hw_init)
		return 0;

	if (!slave->unattach_request)
		goto regmap_sync;

	time = wait_for_completion_timeout(&slave->initialization_complete,
				msecs_to_jiffies(RT1320_PROBE_TIMEOUT));
	if (!time) {
		dev_err(&slave->dev, "%s: Initialization not complete, timed out\n", __func__);
		return -ETIMEDOUT;
	}

regmap_sync:
	slave->unattach_request = 0;
	regcache_cache_only(rt1320->regmap, false);
	regcache_sync(rt1320->regmap);
	regcache_cache_only(rt1320->mbq_regmap, false);
	regcache_sync(rt1320->mbq_regmap);
	return 0;
}

static const struct dev_pm_ops rt1320_pm = {
	SET_SYSTEM_SLEEP_PM_OPS(rt1320_dev_suspend, rt1320_dev_resume)
	SET_RUNTIME_PM_OPS(rt1320_dev_suspend, rt1320_dev_resume, NULL)
};

static struct sdw_driver rt1320_sdw_driver = {
	.driver = {
		.name = "rt1320-sdca",
		.pm = &rt1320_pm,
	},
	.probe = rt1320_sdw_probe,
	.remove = rt1320_sdw_remove,
	.ops = &rt1320_slave_ops,
	.id_table = rt1320_id,
};
module_sdw_driver(rt1320_sdw_driver);

MODULE_DESCRIPTION("ASoC RT1320 driver SDCA SDW");
MODULE_AUTHOR("Shuming Fan <shumingf@realtek.com>");
MODULE_LICENSE("GPL");
