#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2019 BetaRays
# SPDX-FileCopyrightText: © 2022 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Shenzhen I/O
###

script_version=20240718.1

PLAYIT_COMPATIBILITY_LEVEL='2.30'

GAME_ID='shenzhen-io'
GAME_NAME='Shenzhen I/O'

ARCHIVE_BASE_2_NAME='shenzhen_i_o_gog_4_26_03_2023_63470.sh'
ARCHIVE_BASE_2_MD5='50afcbddbb5226c26d1bd4a2fc780f58'
ARCHIVE_BASE_2_SIZE='449123'
ARCHIVE_BASE_2_VERSION='2023.03.26-gog63470'
ARCHIVE_BASE_2_URL='https://www.gog.com/game/shenzhen_io'

ARCHIVE_BASE_1_NAME='shenzhen_i_o_gog_3_11_14_2020_43142.sh'
ARCHIVE_BASE_1_MD5='e804f591f8a65193e54964d9186ab6e8'
ARCHIVE_BASE_1_SIZE='460000'
ARCHIVE_BASE_1_VERSION='2020.11.14-gog43142'

ARCHIVE_BASE_0_NAME='shenzhen_io_en_13_02_18613.sh'
ARCHIVE_BASE_0_MD5='d7a3ccb58512bdc511d4fe8977480ff9'
ARCHIVE_BASE_0_SIZE='450000'
ARCHIVE_BASE_0_VERSION='13.02-gog18613'

CONTENT_PATH_DEFAULT='data/noarch/game'
CONTENT_GAME_BIN64_FILES='
Shenzhen.bin.x86_64'
CONTENT_GAME_BIN32_FILES='
Shenzhen.bin.x86'
CONTENT_GAME_DATA_FILES='
Shenzhen.exe
Shenzhen.exe.config
Content
PackedContent
monoconfig
monomachineconfig
*.dll'
CONTENT_DOC_DATA_FILES='
LICENSE.txt'

## Write access to some files is required.
USER_PERSISTENT_DIRECTORIES='
Content/textures
PackedContent/fonts'

## The shipped binaries are used instead of system-provided mono to avoid a crash when using the in-game command editor.
## See notes/shenzhen-io for details.
APP_MAIN_EXE_BIN64='Shenzhen.bin.x86_64'
APP_MAIN_EXE_BIN32='Shenzhen.bin.x86'
APP_MAIN_ICON='Content/icon.png'

PACKAGES_LIST='
PKG_BIN64
PKG_BIN32
PKG_DATA'

PKG_BIN64_ARCH='64'
PKG_BIN32_ARCH='32'
PKG_BIN_DEPENDENCIES_SIBLINGS='
PKG_DATA'
PKG_BIN64_DEPENDENCIES_SIBLINGS="$PKG_BIN_DEPENDENCIES_SIBLINGS"
PKG_BIN32_DEPENDENCIES_SIBLINGS="$PKG_BIN_DEPENDENCIES_SIBLINGS"
PKG_BIN_DEPENDENCIES_LIBRARIES='
ld-linux-x86-64.so.2
libc.so.6
libdl.so.2
libgcc_s.so.1
libm.so.6
libpthread.so.0
librt.so.1
libSDL2-2.0.so.0
libSDL2_image-2.0.so.0
libSDL2_mixer-2.0.so.0
libvorbisfile.so.3'
PKG_BIN64_DEPENDENCIES_LIBRARIES="$PKG_BIN_DEPENDENCIES_LIBRARIES"
PKG_BIN32_DEPENDENCIES_LIBRARIES="$PKG_BIN_DEPENDENCIES_LIBRARIES"

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction_default

# Include game data

content_inclusion_icons 'PKG_DATA'
content_inclusion_default

# Write launchers

## Apply common Mono tweaks.
APP_MAIN_PRERUN="$(application_prerun 'APP_MAIN')
$(mono_launcher_tweaks)"

launchers_generation 'PKG_BIN64'
launchers_generation 'PKG_BIN32'

# Build packages

packages_generation
print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
