package vpc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateVirtualPhysicalConnection invokes the vpc.UpdateVirtualPhysicalConnection API synchronously
func (client *Client) UpdateVirtualPhysicalConnection(request *UpdateVirtualPhysicalConnectionRequest) (response *UpdateVirtualPhysicalConnectionResponse, err error) {
	response = CreateUpdateVirtualPhysicalConnectionResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateVirtualPhysicalConnectionWithChan invokes the vpc.UpdateVirtualPhysicalConnection API asynchronously
func (client *Client) UpdateVirtualPhysicalConnectionWithChan(request *UpdateVirtualPhysicalConnectionRequest) (<-chan *UpdateVirtualPhysicalConnectionResponse, <-chan error) {
	responseChan := make(chan *UpdateVirtualPhysicalConnectionResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateVirtualPhysicalConnection(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateVirtualPhysicalConnectionWithCallback invokes the vpc.UpdateVirtualPhysicalConnection API asynchronously
func (client *Client) UpdateVirtualPhysicalConnectionWithCallback(request *UpdateVirtualPhysicalConnectionRequest, callback func(response *UpdateVirtualPhysicalConnectionResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateVirtualPhysicalConnectionResponse
		var err error
		defer close(result)
		response, err = client.UpdateVirtualPhysicalConnection(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateVirtualPhysicalConnectionRequest is the request struct for api UpdateVirtualPhysicalConnection
type UpdateVirtualPhysicalConnectionRequest struct {
	*requests.RpcRequest
	DryRun     requests.Boolean `position:"Query" name:"DryRun"`
	VlanId     requests.Integer `position:"Query" name:"VlanId"`
	Token      string           `position:"Query" name:"Token"`
	InstanceId string           `position:"Query" name:"InstanceId"`
	ExpectSpec string           `position:"Query" name:"ExpectSpec"`
}

// UpdateVirtualPhysicalConnectionResponse is the response struct for api UpdateVirtualPhysicalConnection
type UpdateVirtualPhysicalConnectionResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   string `json:"Success" xml:"Success"`
}

// CreateUpdateVirtualPhysicalConnectionRequest creates a request to invoke UpdateVirtualPhysicalConnection API
func CreateUpdateVirtualPhysicalConnectionRequest() (request *UpdateVirtualPhysicalConnectionRequest) {
	request = &UpdateVirtualPhysicalConnectionRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Vpc", "2016-04-28", "UpdateVirtualPhysicalConnection", "vpc", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUpdateVirtualPhysicalConnectionResponse creates a response to parse from UpdateVirtualPhysicalConnection response
func CreateUpdateVirtualPhysicalConnectionResponse() (response *UpdateVirtualPhysicalConnectionResponse) {
	response = &UpdateVirtualPhysicalConnectionResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
