use strict;
use warnings;

use RT::Test tests => undef;
use Email::Abstract;

my $msg = Email::Abstract->new(<<'MSG')->cast("MIME::Entity");
From: somebody@example.com
To: rt@example.com
Precedence: never-bounce
Precedence: bulk
Subject: testing precedence

I am bulk mail, hear me roar!
MSG

ok RT::Interface::Email::CheckForAutoGenerated($msg->head), "Is AutoGenerated";

$msg->head->delete("Precedence", 1);
ok !RT::Interface::Email::CheckForAutoGenerated($msg->head), "Isn't AutoGenerated";

done_testing;
