/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ugraphic.color;

import net.sourceforge.plantuml.ThemeStyle;
import net.sourceforge.plantuml.ugraphic.color.HColor;
import net.sourceforge.plantuml.ugraphic.color.HColorAbstract;
import net.sourceforge.plantuml.ugraphic.color.HColorUtils;

public class HColorAutomatic
extends HColorAbstract
implements HColor {
    private final HColor colorForLight;
    private final HColor colorForDark;
    private final HColor colorForTransparent;
    private final ThemeStyle themeStyle;

    public HColorAutomatic(ThemeStyle themeStyle, HColor colorForLight, HColor colorForDark, HColor colorForTransparent) {
        this.themeStyle = themeStyle;
        this.colorForLight = colorForLight;
        this.colorForDark = colorForDark;
        this.colorForTransparent = colorForTransparent;
    }

    public HColor getAppropriateColor(HColor back) {
        if (back == null || HColorUtils.isTransparent(back)) {
            if (this.colorForTransparent != null) {
                return this.colorForTransparent;
            }
            return this.themeStyle == ThemeStyle.LIGHT ? this.colorForLight : this.colorForDark;
        }
        if (back.isDark()) {
            return this.colorForDark;
        }
        return this.colorForLight;
    }
}

