// NOLINTBEGIN(*)

#include "IOStr2.h"

//+----------------------------------------------------------------------------
//
// method : 		IOStr2::IOStr2()
//
// description : 	constructor for the IOStr2 command of the
//			DevTest.
//
// In : - name : The command name
//	- in : The input parameter type
//	- out : The output parameter type
//	- in_desc : The input parameter description
//	- out_desc : The output parameter description
//
//-----------------------------------------------------------------------------

IOStr2::IOStr2(
    const char *name, Tango::CmdArgType in, Tango::CmdArgType out, const char *in_desc, const char *out_desc) :
    Command(name, in, out, in_desc, out_desc)
{
}

//+----------------------------------------------------------------------------
//
// method : 		IOStr2::is_allowed()
//
// description : 	method to test whether command is allowed or not in this
//			state. In this case, the command is allowed only if
//			the device is in ON state
//
// in : - device : The device on which the command must be excuted
//	- in_any : The command input data
//
// returns :	boolean - true == is allowed , false == not allowed
//
//-----------------------------------------------------------------------------

bool IOStr2::is_allowed(Tango::DeviceImpl *device, TANGO_UNUSED(const CORBA::Any &in_any))
{
    //
    // command allowed only if the device is on
    //

    if(device->get_state() == Tango::ON)
    {
        return (true);
    }
    else
    {
        return (false);
    }
}

//+----------------------------------------------------------------------------
//
// method : 		IOStr2::execute()
//
// description : 	method to trigger the execution of the IOStr2
//			command
//
// in : - device : The device on which the command must be excuted
//	- in_any : The command input data
//
// returns : The command output data (packed in the Any object)
//
//-----------------------------------------------------------------------------

CORBA::Any *IOStr2::execute(TANGO_UNUSED(Tango::DeviceImpl *device), TANGO_UNUSED(const CORBA::Any &in_any))
{
    try
    {
        const char *argout;

        argout = "Hello from IOStr2";
        return insert(argout);
    }
    catch(CORBA::Exception &e)
    {
        Tango::Except::print_exception(e);
        throw;
    }
}

// NOLINTEND(*)
