/*----- PROTECTED REGION ID(DataBaseClass.cpp) ENABLED START -----*/
static const char *RcsId      = "$Id$";
static const char *TagName    = "$Name: Database-Release-4.17 $";
static const char *CvsPath    = "$Source:  $";
static const char *SvnPath    = "$HeadURL$";
static const char *HttpServer = "http://www.esrf.eu/computing/cs/tango/tango_doc/ds_doc/";
//=============================================================================
//
// file :        DataBaseClass.cpp
//
// description : C++ source for the DataBaseClass. A singleton
//               class derived from DeviceClass. It implements the
//               command list and all properties and methods required
//               by the �name� once per process.
//
// project :     TANGO.
//
// $Author$
//
// Copyright (C) :      2004,2005,2006,2007,2008,2009,2010,2011,2012,2013
//						European Synchrotron Radiation Facility
//                      BP 220, Grenoble 38043
//                      FRANCE
//
// This file is part of Tango.
//
// Tango is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
// 
// Tango is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with Tango.  If not, see <http://www.gnu.org/licenses/>.
//
// $Revision$
// $Date$
//
// $HeadURL$
//
//=============================================================================
//                This file is generated by POGO
//        (Program Obviously used to Generate tango Object)
//=============================================================================


#include <tango.h>
#include <DataBase.h>
#include <DataBaseClass.h>

/*----- PROTECTED REGION END -----*/	//	DataBaseClass.cpp

//-------------------------------------------------------------------
/**
 *	Create DataBaseClass singleton and
 *	return it in a C function for Python usage
 */
//-------------------------------------------------------------------
extern "C" {
#ifdef _TG_WINDOWS_

__declspec(dllexport)

#endif

	Tango::DeviceClass *_create_DataBase_class(const char *name) {
		return DataBase_ns::DataBaseClass::init(name);
	}
}

namespace DataBase_ns
{
//===================================================================
//	Initialize pointer for singleton pattern
//===================================================================
DataBaseClass *DataBaseClass::_instance = NULL;

//--------------------------------------------------------
/**
 * method : 		DataBaseClass::DataBaseClass(string &s)
 * description : 	constructor for the DataBaseClass
 *
 * @param s	The class name
 */
//--------------------------------------------------------
DataBaseClass::DataBaseClass(string &s):Tango::DeviceClass(s)
{
	cout2 << "Entering DataBaseClass constructor" << endl;
	set_default_property();
	write_class_property();

	/*----- PROTECTED REGION ID(DataBaseClass::constructor) ENABLED START -----*/
	string str_rcs(RcsId);
	/*----- PROTECTED REGION END -----*/	//	DataBaseClass::constructor

	cout2 << "Leaving DataBaseClass constructor" << endl;
}

//--------------------------------------------------------
/**
 * method : 		DataBaseClass::~DataBaseClass()
 * description : 	destructor for the DataBaseClass
 */
//--------------------------------------------------------
DataBaseClass::~DataBaseClass()
{
	/*----- PROTECTED REGION ID(DataBaseClass::destructor) ENABLED START -----*/

	/*----- PROTECTED REGION END -----*/	//	DataBaseClass::destructor

	_instance = NULL;
}


//--------------------------------------------------------
/**
 * method : 		DataBaseClass::init
 * description : 	Create the object if not already done.
 *                  Otherwise, just return a pointer to the object
 *
 * @param	name	The class name
 */
//--------------------------------------------------------
DataBaseClass *DataBaseClass::init(const char *name)
{
	if (_instance == NULL)
	{
		try
		{
			string s(name);
			_instance = new DataBaseClass(s);
		}
		catch (bad_alloc &)
		{
			throw;
		}
	}
	return _instance;
}

//--------------------------------------------------------
/**
 * method : 		DataBaseClass::instance
 * description : 	Check if object already created,
 *                  and return a pointer to the object
 */
//--------------------------------------------------------
DataBaseClass *DataBaseClass::instance()
{
	if (_instance == NULL)
	{
		cerr << "Class is not initialised !!" << endl;
		exit(-1);
	}
	return _instance;
}



//===================================================================
//	Command execution method calls
//===================================================================
//--------------------------------------------------------
/**
 * method : 		DbAddDeviceClass::execute()
 * description : 	method to trigger the execution of the command.
 *
 * @param	device	The device on which the command must be executed
 * @param	in_any	The command input data
 *
 *	returns The command output data (packed in the Any object)
 */
//--------------------------------------------------------
CORBA::Any *DbAddDeviceClass::execute(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
	cout2 << "DbAddDeviceClass::execute(): arrived" << endl;
	const Tango::DevVarStringArray *argin;
	extract(in_any, argin);
	((static_cast<DataBase *>(device))->db_add_device(argin));
	return new CORBA::Any();
}

//--------------------------------------------------------
/**
 * method : 		DbAddServerClass::execute()
 * description : 	method to trigger the execution of the command.
 *
 * @param	device	The device on which the command must be executed
 * @param	in_any	The command input data
 *
 *	returns The command output data (packed in the Any object)
 */
//--------------------------------------------------------
CORBA::Any *DbAddServerClass::execute(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
	cout2 << "DbAddServerClass::execute(): arrived" << endl;
	const Tango::DevVarStringArray *argin;
	extract(in_any, argin);
	((static_cast<DataBase *>(device))->db_add_server(argin));
	return new CORBA::Any();
}

//--------------------------------------------------------
/**
 * method : 		DbDeleteAttributeAliasClass::execute()
 * description : 	method to trigger the execution of the command.
 *
 * @param	device	The device on which the command must be executed
 * @param	in_any	The command input data
 *
 *	returns The command output data (packed in the Any object)
 */
//--------------------------------------------------------
CORBA::Any *DbDeleteAttributeAliasClass::execute(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
	cout2 << "DbDeleteAttributeAliasClass::execute(): arrived" << endl;
	Tango::DevString argin;
	extract(in_any, argin);
	((static_cast<DataBase *>(device))->db_delete_attribute_alias(argin));
	return new CORBA::Any();
}

//--------------------------------------------------------
/**
 * method : 		DbDeleteClassAttributeClass::execute()
 * description : 	method to trigger the execution of the command.
 *
 * @param	device	The device on which the command must be executed
 * @param	in_any	The command input data
 *
 *	returns The command output data (packed in the Any object)
 */
//--------------------------------------------------------
CORBA::Any *DbDeleteClassAttributeClass::execute(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
	cout2 << "DbDeleteClassAttributeClass::execute(): arrived" << endl;
	const Tango::DevVarStringArray *argin;
	extract(in_any, argin);
	((static_cast<DataBase *>(device))->db_delete_class_attribute(argin));
	return new CORBA::Any();
}

//--------------------------------------------------------
/**
 * method : 		DbDeleteClassAttributePropertyClass::execute()
 * description : 	method to trigger the execution of the command.
 *
 * @param	device	The device on which the command must be executed
 * @param	in_any	The command input data
 *
 *	returns The command output data (packed in the Any object)
 */
//--------------------------------------------------------
CORBA::Any *DbDeleteClassAttributePropertyClass::execute(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
	cout2 << "DbDeleteClassAttributePropertyClass::execute(): arrived" << endl;
	const Tango::DevVarStringArray *argin;
	extract(in_any, argin);
	((static_cast<DataBase *>(device))->db_delete_class_attribute_property(argin));
	return new CORBA::Any();
}

//--------------------------------------------------------
/**
 * method : 		DbDeleteClassPropertyClass::execute()
 * description : 	method to trigger the execution of the command.
 *
 * @param	device	The device on which the command must be executed
 * @param	in_any	The command input data
 *
 *	returns The command output data (packed in the Any object)
 */
//--------------------------------------------------------
CORBA::Any *DbDeleteClassPropertyClass::execute(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
	cout2 << "DbDeleteClassPropertyClass::execute(): arrived" << endl;
	const Tango::DevVarStringArray *argin;
	extract(in_any, argin);
	((static_cast<DataBase *>(device))->db_delete_class_property(argin));
	return new CORBA::Any();
}

//--------------------------------------------------------
/**
 * method : 		DbDeleteDeviceClass::execute()
 * description : 	method to trigger the execution of the command.
 *
 * @param	device	The device on which the command must be executed
 * @param	in_any	The command input data
 *
 *	returns The command output data (packed in the Any object)
 */
//--------------------------------------------------------
CORBA::Any *DbDeleteDeviceClass::execute(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
	cout2 << "DbDeleteDeviceClass::execute(): arrived" << endl;
	Tango::DevString argin;
	extract(in_any, argin);
	((static_cast<DataBase *>(device))->db_delete_device(argin));
	return new CORBA::Any();
}

//--------------------------------------------------------
/**
 * method : 		DbDeleteDeviceAliasClass::execute()
 * description : 	method to trigger the execution of the command.
 *
 * @param	device	The device on which the command must be executed
 * @param	in_any	The command input data
 *
 *	returns The command output data (packed in the Any object)
 */
//--------------------------------------------------------
CORBA::Any *DbDeleteDeviceAliasClass::execute(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
	cout2 << "DbDeleteDeviceAliasClass::execute(): arrived" << endl;
	Tango::DevString argin;
	extract(in_any, argin);
	((static_cast<DataBase *>(device))->db_delete_device_alias(argin));
	return new CORBA::Any();
}

//--------------------------------------------------------
/**
 * method : 		DbDeleteDeviceAttributeClass::execute()
 * description : 	method to trigger the execution of the command.
 *
 * @param	device	The device on which the command must be executed
 * @param	in_any	The command input data
 *
 *	returns The command output data (packed in the Any object)
 */
//--------------------------------------------------------
CORBA::Any *DbDeleteDeviceAttributeClass::execute(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
	cout2 << "DbDeleteDeviceAttributeClass::execute(): arrived" << endl;
	const Tango::DevVarStringArray *argin;
	extract(in_any, argin);
	((static_cast<DataBase *>(device))->db_delete_device_attribute(argin));
	return new CORBA::Any();
}

//--------------------------------------------------------
/**
 * method : 		DbDeleteDeviceAttributePropertyClass::execute()
 * description : 	method to trigger the execution of the command.
 *
 * @param	device	The device on which the command must be executed
 * @param	in_any	The command input data
 *
 *	returns The command output data (packed in the Any object)
 */
//--------------------------------------------------------
CORBA::Any *DbDeleteDeviceAttributePropertyClass::execute(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
	cout2 << "DbDeleteDeviceAttributePropertyClass::execute(): arrived" << endl;
	const Tango::DevVarStringArray *argin;
	extract(in_any, argin);
	((static_cast<DataBase *>(device))->db_delete_device_attribute_property(argin));
	return new CORBA::Any();
}

//--------------------------------------------------------
/**
 * method : 		DbDeleteDevicePropertyClass::execute()
 * description : 	method to trigger the execution of the command.
 *
 * @param	device	The device on which the command must be executed
 * @param	in_any	The command input data
 *
 *	returns The command output data (packed in the Any object)
 */
//--------------------------------------------------------
CORBA::Any *DbDeleteDevicePropertyClass::execute(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
	cout2 << "DbDeleteDevicePropertyClass::execute(): arrived" << endl;
	const Tango::DevVarStringArray *argin;
	extract(in_any, argin);
	((static_cast<DataBase *>(device))->db_delete_device_property(argin));
	return new CORBA::Any();
}

//--------------------------------------------------------
/**
 * method : 		DbDeletePropertyClass::execute()
 * description : 	method to trigger the execution of the command.
 *
 * @param	device	The device on which the command must be executed
 * @param	in_any	The command input data
 *
 *	returns The command output data (packed in the Any object)
 */
//--------------------------------------------------------
CORBA::Any *DbDeletePropertyClass::execute(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
	cout2 << "DbDeletePropertyClass::execute(): arrived" << endl;
	const Tango::DevVarStringArray *argin;
	extract(in_any, argin);
	((static_cast<DataBase *>(device))->db_delete_property(argin));
	return new CORBA::Any();
}

//--------------------------------------------------------
/**
 * method : 		DbDeleteServerClass::execute()
 * description : 	method to trigger the execution of the command.
 *
 * @param	device	The device on which the command must be executed
 * @param	in_any	The command input data
 *
 *	returns The command output data (packed in the Any object)
 */
//--------------------------------------------------------
CORBA::Any *DbDeleteServerClass::execute(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
	cout2 << "DbDeleteServerClass::execute(): arrived" << endl;
	Tango::DevString argin;
	extract(in_any, argin);
	((static_cast<DataBase *>(device))->db_delete_server(argin));
	return new CORBA::Any();
}

//--------------------------------------------------------
/**
 * method : 		DbDeleteServerInfoClass::execute()
 * description : 	method to trigger the execution of the command.
 *
 * @param	device	The device on which the command must be executed
 * @param	in_any	The command input data
 *
 *	returns The command output data (packed in the Any object)
 */
//--------------------------------------------------------
CORBA::Any *DbDeleteServerInfoClass::execute(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
	cout2 << "DbDeleteServerInfoClass::execute(): arrived" << endl;
	Tango::DevString argin;
	extract(in_any, argin);
	((static_cast<DataBase *>(device))->db_delete_server_info(argin));
	return new CORBA::Any();
}

//--------------------------------------------------------
/**
 * method : 		DbExportDeviceClass::execute()
 * description : 	method to trigger the execution of the command.
 *
 * @param	device	The device on which the command must be executed
 * @param	in_any	The command input data
 *
 *	returns The command output data (packed in the Any object)
 */
//--------------------------------------------------------
CORBA::Any *DbExportDeviceClass::execute(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
	cout2 << "DbExportDeviceClass::execute(): arrived" << endl;
	const Tango::DevVarStringArray *argin;
	extract(in_any, argin);
	((static_cast<DataBase *>(device))->db_export_device(argin));
	return new CORBA::Any();
}

//--------------------------------------------------------
/**
 * method : 		DbExportEventClass::execute()
 * description : 	method to trigger the execution of the command.
 *
 * @param	device	The device on which the command must be executed
 * @param	in_any	The command input data
 *
 *	returns The command output data (packed in the Any object)
 */
//--------------------------------------------------------
CORBA::Any *DbExportEventClass::execute(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
	cout2 << "DbExportEventClass::execute(): arrived" << endl;
	const Tango::DevVarStringArray *argin;
	extract(in_any, argin);
	((static_cast<DataBase *>(device))->db_export_event(argin));
	return new CORBA::Any();
}

//--------------------------------------------------------
/**
 * method : 		DbGetAliasDeviceClass::execute()
 * description : 	method to trigger the execution of the command.
 *
 * @param	device	The device on which the command must be executed
 * @param	in_any	The command input data
 *
 *	returns The command output data (packed in the Any object)
 */
//--------------------------------------------------------
CORBA::Any *DbGetAliasDeviceClass::execute(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
	cout2 << "DbGetAliasDeviceClass::execute(): arrived" << endl;
	Tango::DevString argin;
	extract(in_any, argin);
	return insert((static_cast<DataBase *>(device))->db_get_alias_device(argin));
}

//--------------------------------------------------------
/**
 * method : 		DbGetAttributeAliasClass::execute()
 * description : 	method to trigger the execution of the command.
 *
 * @param	device	The device on which the command must be executed
 * @param	in_any	The command input data
 *
 *	returns The command output data (packed in the Any object)
 */
//--------------------------------------------------------
CORBA::Any *DbGetAttributeAliasClass::execute(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
	cout2 << "DbGetAttributeAliasClass::execute(): arrived" << endl;
	Tango::DevString argin;
	extract(in_any, argin);
	return insert((static_cast<DataBase *>(device))->db_get_attribute_alias(argin));
}

//--------------------------------------------------------
/**
 * method : 		DbGetAttributeAliasListClass::execute()
 * description : 	method to trigger the execution of the command.
 *
 * @param	device	The device on which the command must be executed
 * @param	in_any	The command input data
 *
 *	returns The command output data (packed in the Any object)
 */
//--------------------------------------------------------
CORBA::Any *DbGetAttributeAliasListClass::execute(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
	cout2 << "DbGetAttributeAliasListClass::execute(): arrived" << endl;
	Tango::DevString argin;
	extract(in_any, argin);
	return insert((static_cast<DataBase *>(device))->db_get_attribute_alias_list(argin));
}

//--------------------------------------------------------
/**
 * method : 		DbGetClassAttributeListClass::execute()
 * description : 	method to trigger the execution of the command.
 *
 * @param	device	The device on which the command must be executed
 * @param	in_any	The command input data
 *
 *	returns The command output data (packed in the Any object)
 */
//--------------------------------------------------------
CORBA::Any *DbGetClassAttributeListClass::execute(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
	cout2 << "DbGetClassAttributeListClass::execute(): arrived" << endl;
	const Tango::DevVarStringArray *argin;
	extract(in_any, argin);
	return insert((static_cast<DataBase *>(device))->db_get_class_attribute_list(argin));
}

//--------------------------------------------------------
/**
 * method : 		DbGetClassAttributePropertyClass::execute()
 * description : 	method to trigger the execution of the command.
 *
 * @param	device	The device on which the command must be executed
 * @param	in_any	The command input data
 *
 *	returns The command output data (packed in the Any object)
 */
//--------------------------------------------------------
CORBA::Any *DbGetClassAttributePropertyClass::execute(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
	cout2 << "DbGetClassAttributePropertyClass::execute(): arrived" << endl;
	const Tango::DevVarStringArray *argin;
	extract(in_any, argin);
	return insert((static_cast<DataBase *>(device))->db_get_class_attribute_property(argin));
}

//--------------------------------------------------------
/**
 * method : 		DbGetClassAttributeProperty2Class::execute()
 * description : 	method to trigger the execution of the command.
 *
 * @param	device	The device on which the command must be executed
 * @param	in_any	The command input data
 *
 *	returns The command output data (packed in the Any object)
 */
//--------------------------------------------------------
CORBA::Any *DbGetClassAttributeProperty2Class::execute(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
	cout2 << "DbGetClassAttributeProperty2Class::execute(): arrived" << endl;
	const Tango::DevVarStringArray *argin;
	extract(in_any, argin);
	return insert((static_cast<DataBase *>(device))->db_get_class_attribute_property2(argin));
}

//--------------------------------------------------------
/**
 * method : 		DbGetClassAttributePropertyHistClass::execute()
 * description : 	method to trigger the execution of the command.
 *
 * @param	device	The device on which the command must be executed
 * @param	in_any	The command input data
 *
 *	returns The command output data (packed in the Any object)
 */
//--------------------------------------------------------
CORBA::Any *DbGetClassAttributePropertyHistClass::execute(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
	cout2 << "DbGetClassAttributePropertyHistClass::execute(): arrived" << endl;
	const Tango::DevVarStringArray *argin;
	extract(in_any, argin);
	return insert((static_cast<DataBase *>(device))->db_get_class_attribute_property_hist(argin));
}

//--------------------------------------------------------
/**
 * method : 		DbGetClassForDeviceClass::execute()
 * description : 	method to trigger the execution of the command.
 *
 * @param	device	The device on which the command must be executed
 * @param	in_any	The command input data
 *
 *	returns The command output data (packed in the Any object)
 */
//--------------------------------------------------------
CORBA::Any *DbGetClassForDeviceClass::execute(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
	cout2 << "DbGetClassForDeviceClass::execute(): arrived" << endl;
	Tango::DevString argin;
	extract(in_any, argin);
	return insert((static_cast<DataBase *>(device))->db_get_class_for_device(argin));
}

//--------------------------------------------------------
/**
 * method : 		DbGetClassInheritanceForDeviceClass::execute()
 * description : 	method to trigger the execution of the command.
 *
 * @param	device	The device on which the command must be executed
 * @param	in_any	The command input data
 *
 *	returns The command output data (packed in the Any object)
 */
//--------------------------------------------------------
CORBA::Any *DbGetClassInheritanceForDeviceClass::execute(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
	cout2 << "DbGetClassInheritanceForDeviceClass::execute(): arrived" << endl;
	Tango::DevString argin;
	extract(in_any, argin);
	return insert((static_cast<DataBase *>(device))->db_get_class_inheritance_for_device(argin));
}

//--------------------------------------------------------
/**
 * method : 		DbGetClassListClass::execute()
 * description : 	method to trigger the execution of the command.
 *
 * @param	device	The device on which the command must be executed
 * @param	in_any	The command input data
 *
 *	returns The command output data (packed in the Any object)
 */
//--------------------------------------------------------
CORBA::Any *DbGetClassListClass::execute(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
	cout2 << "DbGetClassListClass::execute(): arrived" << endl;
	Tango::DevString argin;
	extract(in_any, argin);
	return insert((static_cast<DataBase *>(device))->db_get_class_list(argin));
}

//--------------------------------------------------------
/**
 * method : 		DbGetClassPropertyClass::execute()
 * description : 	method to trigger the execution of the command.
 *
 * @param	device	The device on which the command must be executed
 * @param	in_any	The command input data
 *
 *	returns The command output data (packed in the Any object)
 */
//--------------------------------------------------------
CORBA::Any *DbGetClassPropertyClass::execute(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
	cout2 << "DbGetClassPropertyClass::execute(): arrived" << endl;
	const Tango::DevVarStringArray *argin;
	extract(in_any, argin);
	return insert((static_cast<DataBase *>(device))->db_get_class_property(argin));
}

//--------------------------------------------------------
/**
 * method : 		DbGetClassPropertyHistClass::execute()
 * description : 	method to trigger the execution of the command.
 *
 * @param	device	The device on which the command must be executed
 * @param	in_any	The command input data
 *
 *	returns The command output data (packed in the Any object)
 */
//--------------------------------------------------------
CORBA::Any *DbGetClassPropertyHistClass::execute(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
	cout2 << "DbGetClassPropertyHistClass::execute(): arrived" << endl;
	const Tango::DevVarStringArray *argin;
	extract(in_any, argin);
	return insert((static_cast<DataBase *>(device))->db_get_class_property_hist(argin));
}

//--------------------------------------------------------
/**
 * method : 		DbGetClassPropertyListClass::execute()
 * description : 	method to trigger the execution of the command.
 *
 * @param	device	The device on which the command must be executed
 * @param	in_any	The command input data
 *
 *	returns The command output data (packed in the Any object)
 */
//--------------------------------------------------------
CORBA::Any *DbGetClassPropertyListClass::execute(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
	cout2 << "DbGetClassPropertyListClass::execute(): arrived" << endl;
	Tango::DevString argin;
	extract(in_any, argin);
	return insert((static_cast<DataBase *>(device))->db_get_class_property_list(argin));
}

//--------------------------------------------------------
/**
 * method : 		DbGetDeviceAliasClass::execute()
 * description : 	method to trigger the execution of the command.
 *
 * @param	device	The device on which the command must be executed
 * @param	in_any	The command input data
 *
 *	returns The command output data (packed in the Any object)
 */
//--------------------------------------------------------
CORBA::Any *DbGetDeviceAliasClass::execute(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
	cout2 << "DbGetDeviceAliasClass::execute(): arrived" << endl;
	Tango::DevString argin;
	extract(in_any, argin);
	return insert((static_cast<DataBase *>(device))->db_get_device_alias(argin));
}

//--------------------------------------------------------
/**
 * method : 		DbGetDeviceAliasListClass::execute()
 * description : 	method to trigger the execution of the command.
 *
 * @param	device	The device on which the command must be executed
 * @param	in_any	The command input data
 *
 *	returns The command output data (packed in the Any object)
 */
//--------------------------------------------------------
CORBA::Any *DbGetDeviceAliasListClass::execute(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
	cout2 << "DbGetDeviceAliasListClass::execute(): arrived" << endl;
	Tango::DevString argin;
	extract(in_any, argin);
	return insert((static_cast<DataBase *>(device))->db_get_device_alias_list(argin));
}

//--------------------------------------------------------
/**
 * method : 		DbGetDeviceAttributeListClass::execute()
 * description : 	method to trigger the execution of the command.
 *
 * @param	device	The device on which the command must be executed
 * @param	in_any	The command input data
 *
 *	returns The command output data (packed in the Any object)
 */
//--------------------------------------------------------
CORBA::Any *DbGetDeviceAttributeListClass::execute(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
	cout2 << "DbGetDeviceAttributeListClass::execute(): arrived" << endl;
	const Tango::DevVarStringArray *argin;
	extract(in_any, argin);
	return insert((static_cast<DataBase *>(device))->db_get_device_attribute_list(argin));
}

//--------------------------------------------------------
/**
 * method : 		DbGetDeviceAttributePropertyClass::execute()
 * description : 	method to trigger the execution of the command.
 *
 * @param	device	The device on which the command must be executed
 * @param	in_any	The command input data
 *
 *	returns The command output data (packed in the Any object)
 */
//--------------------------------------------------------
CORBA::Any *DbGetDeviceAttributePropertyClass::execute(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
	cout2 << "DbGetDeviceAttributePropertyClass::execute(): arrived" << endl;
	const Tango::DevVarStringArray *argin;
	extract(in_any, argin);
	return insert((static_cast<DataBase *>(device))->db_get_device_attribute_property(argin));
}

//--------------------------------------------------------
/**
 * method : 		DbGetDeviceAttributeProperty2Class::execute()
 * description : 	method to trigger the execution of the command.
 *
 * @param	device	The device on which the command must be executed
 * @param	in_any	The command input data
 *
 *	returns The command output data (packed in the Any object)
 */
//--------------------------------------------------------
CORBA::Any *DbGetDeviceAttributeProperty2Class::execute(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
	cout2 << "DbGetDeviceAttributeProperty2Class::execute(): arrived" << endl;
	const Tango::DevVarStringArray *argin;
	extract(in_any, argin);
	return insert((static_cast<DataBase *>(device))->db_get_device_attribute_property2(argin));
}

//--------------------------------------------------------
/**
 * method : 		DbGetDeviceAttributePropertyHistClass::execute()
 * description : 	method to trigger the execution of the command.
 *
 * @param	device	The device on which the command must be executed
 * @param	in_any	The command input data
 *
 *	returns The command output data (packed in the Any object)
 */
//--------------------------------------------------------
CORBA::Any *DbGetDeviceAttributePropertyHistClass::execute(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
	cout2 << "DbGetDeviceAttributePropertyHistClass::execute(): arrived" << endl;
	const Tango::DevVarStringArray *argin;
	extract(in_any, argin);
	return insert((static_cast<DataBase *>(device))->db_get_device_attribute_property_hist(argin));
}

//--------------------------------------------------------
/**
 * method : 		DbGetDeviceClassListClass::execute()
 * description : 	method to trigger the execution of the command.
 *
 * @param	device	The device on which the command must be executed
 * @param	in_any	The command input data
 *
 *	returns The command output data (packed in the Any object)
 */
//--------------------------------------------------------
CORBA::Any *DbGetDeviceClassListClass::execute(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
	cout2 << "DbGetDeviceClassListClass::execute(): arrived" << endl;
	Tango::DevString argin;
	extract(in_any, argin);
	return insert((static_cast<DataBase *>(device))->db_get_device_class_list(argin));
}

//--------------------------------------------------------
/**
 * method : 		DbGetDeviceDomainListClass::execute()
 * description : 	method to trigger the execution of the command.
 *
 * @param	device	The device on which the command must be executed
 * @param	in_any	The command input data
 *
 *	returns The command output data (packed in the Any object)
 */
//--------------------------------------------------------
CORBA::Any *DbGetDeviceDomainListClass::execute(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
	cout2 << "DbGetDeviceDomainListClass::execute(): arrived" << endl;
	Tango::DevString argin;
	extract(in_any, argin);
	return insert((static_cast<DataBase *>(device))->db_get_device_domain_list(argin));
}

//--------------------------------------------------------
/**
 * method : 		DbGetDeviceExportedListClass::execute()
 * description : 	method to trigger the execution of the command.
 *
 * @param	device	The device on which the command must be executed
 * @param	in_any	The command input data
 *
 *	returns The command output data (packed in the Any object)
 */
//--------------------------------------------------------
CORBA::Any *DbGetDeviceExportedListClass::execute(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
	cout2 << "DbGetDeviceExportedListClass::execute(): arrived" << endl;
	Tango::DevString argin;
	extract(in_any, argin);
	return insert((static_cast<DataBase *>(device))->db_get_device_exported_list(argin));
}

//--------------------------------------------------------
/**
 * method : 		DbGetDeviceFamilyListClass::execute()
 * description : 	method to trigger the execution of the command.
 *
 * @param	device	The device on which the command must be executed
 * @param	in_any	The command input data
 *
 *	returns The command output data (packed in the Any object)
 */
//--------------------------------------------------------
CORBA::Any *DbGetDeviceFamilyListClass::execute(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
	cout2 << "DbGetDeviceFamilyListClass::execute(): arrived" << endl;
	Tango::DevString argin;
	extract(in_any, argin);
	return insert((static_cast<DataBase *>(device))->db_get_device_family_list(argin));
}

//--------------------------------------------------------
/**
 * method : 		DbGetDeviceInfoClass::execute()
 * description : 	method to trigger the execution of the command.
 *
 * @param	device	The device on which the command must be executed
 * @param	in_any	The command input data
 *
 *	returns The command output data (packed in the Any object)
 */
//--------------------------------------------------------
CORBA::Any *DbGetDeviceInfoClass::execute(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
	cout2 << "DbGetDeviceInfoClass::execute(): arrived" << endl;
	Tango::DevString argin;
	extract(in_any, argin);
	return insert((static_cast<DataBase *>(device))->db_get_device_info(argin));
}

//--------------------------------------------------------
/**
 * method : 		DbGetDeviceListClass::execute()
 * description : 	method to trigger the execution of the command.
 *
 * @param	device	The device on which the command must be executed
 * @param	in_any	The command input data
 *
 *	returns The command output data (packed in the Any object)
 */
//--------------------------------------------------------
CORBA::Any *DbGetDeviceListClass::execute(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
	cout2 << "DbGetDeviceListClass::execute(): arrived" << endl;
	const Tango::DevVarStringArray *argin;
	extract(in_any, argin);
	return insert((static_cast<DataBase *>(device))->db_get_device_list(argin));
}

//--------------------------------------------------------
/**
 * method : 		DbGetDeviceWideListClass::execute()
 * description : 	method to trigger the execution of the command.
 *
 * @param	device	The device on which the command must be executed
 * @param	in_any	The command input data
 *
 *	returns The command output data (packed in the Any object)
 */
//--------------------------------------------------------
CORBA::Any *DbGetDeviceWideListClass::execute(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
	cout2 << "DbGetDeviceWideListClass::execute(): arrived" << endl;
	Tango::DevString argin;
	extract(in_any, argin);
	return insert((static_cast<DataBase *>(device))->db_get_device_wide_list(argin));
}

//--------------------------------------------------------
/**
 * method : 		DbGetDeviceMemberListClass::execute()
 * description : 	method to trigger the execution of the command.
 *
 * @param	device	The device on which the command must be executed
 * @param	in_any	The command input data
 *
 *	returns The command output data (packed in the Any object)
 */
//--------------------------------------------------------
CORBA::Any *DbGetDeviceMemberListClass::execute(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
	cout2 << "DbGetDeviceMemberListClass::execute(): arrived" << endl;
	Tango::DevString argin;
	extract(in_any, argin);
	return insert((static_cast<DataBase *>(device))->db_get_device_member_list(argin));
}

//--------------------------------------------------------
/**
 * method : 		DbGetDevicePropertyClass::execute()
 * description : 	method to trigger the execution of the command.
 *
 * @param	device	The device on which the command must be executed
 * @param	in_any	The command input data
 *
 *	returns The command output data (packed in the Any object)
 */
//--------------------------------------------------------
CORBA::Any *DbGetDevicePropertyClass::execute(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
	cout2 << "DbGetDevicePropertyClass::execute(): arrived" << endl;
	const Tango::DevVarStringArray *argin;
	extract(in_any, argin);
	return insert((static_cast<DataBase *>(device))->db_get_device_property(argin));
}

//--------------------------------------------------------
/**
 * method : 		DbGetDevicePropertyHistClass::execute()
 * description : 	method to trigger the execution of the command.
 *
 * @param	device	The device on which the command must be executed
 * @param	in_any	The command input data
 *
 *	returns The command output data (packed in the Any object)
 */
//--------------------------------------------------------
CORBA::Any *DbGetDevicePropertyHistClass::execute(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
	cout2 << "DbGetDevicePropertyHistClass::execute(): arrived" << endl;
	const Tango::DevVarStringArray *argin;
	extract(in_any, argin);
	return insert((static_cast<DataBase *>(device))->db_get_device_property_hist(argin));
}

//--------------------------------------------------------
/**
 * method : 		DbGetDevicePropertyListClass::execute()
 * description : 	method to trigger the execution of the command.
 *
 * @param	device	The device on which the command must be executed
 * @param	in_any	The command input data
 *
 *	returns The command output data (packed in the Any object)
 */
//--------------------------------------------------------
CORBA::Any *DbGetDevicePropertyListClass::execute(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
	cout2 << "DbGetDevicePropertyListClass::execute(): arrived" << endl;
	const Tango::DevVarStringArray *argin;
	extract(in_any, argin);
	return insert((static_cast<DataBase *>(device))->db_get_device_property_list(argin));
}

//--------------------------------------------------------
/**
 * method : 		DbGetDeviceServerClassListClass::execute()
 * description : 	method to trigger the execution of the command.
 *
 * @param	device	The device on which the command must be executed
 * @param	in_any	The command input data
 *
 *	returns The command output data (packed in the Any object)
 */
//--------------------------------------------------------
CORBA::Any *DbGetDeviceServerClassListClass::execute(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
	cout2 << "DbGetDeviceServerClassListClass::execute(): arrived" << endl;
	Tango::DevString argin;
	extract(in_any, argin);
	return insert((static_cast<DataBase *>(device))->db_get_device_server_class_list(argin));
}

//--------------------------------------------------------
/**
 * method : 		DbGetExportdDeviceListForClassClass::execute()
 * description : 	method to trigger the execution of the command.
 *
 * @param	device	The device on which the command must be executed
 * @param	in_any	The command input data
 *
 *	returns The command output data (packed in the Any object)
 */
//--------------------------------------------------------
CORBA::Any *DbGetExportdDeviceListForClassClass::execute(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
	cout2 << "DbGetExportdDeviceListForClassClass::execute(): arrived" << endl;
	Tango::DevString argin;
	extract(in_any, argin);
	return insert((static_cast<DataBase *>(device))->db_get_exportd_device_list_for_class(argin));
}

//--------------------------------------------------------
/**
 * method : 		DbGetHostListClass::execute()
 * description : 	method to trigger the execution of the command.
 *
 * @param	device	The device on which the command must be executed
 * @param	in_any	The command input data
 *
 *	returns The command output data (packed in the Any object)
 */
//--------------------------------------------------------
CORBA::Any *DbGetHostListClass::execute(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
	cout2 << "DbGetHostListClass::execute(): arrived" << endl;
	Tango::DevString argin;
	extract(in_any, argin);
	return insert((static_cast<DataBase *>(device))->db_get_host_list(argin));
}

//--------------------------------------------------------
/**
 * method : 		DbGetHostServerListClass::execute()
 * description : 	method to trigger the execution of the command.
 *
 * @param	device	The device on which the command must be executed
 * @param	in_any	The command input data
 *
 *	returns The command output data (packed in the Any object)
 */
//--------------------------------------------------------
CORBA::Any *DbGetHostServerListClass::execute(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
	cout2 << "DbGetHostServerListClass::execute(): arrived" << endl;
	Tango::DevString argin;
	extract(in_any, argin);
	return insert((static_cast<DataBase *>(device))->db_get_host_server_list(argin));
}

//--------------------------------------------------------
/**
 * method : 		DbGetHostServersInfoClass::execute()
 * description : 	method to trigger the execution of the command.
 *
 * @param	device	The device on which the command must be executed
 * @param	in_any	The command input data
 *
 *	returns The command output data (packed in the Any object)
 */
//--------------------------------------------------------
CORBA::Any *DbGetHostServersInfoClass::execute(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
	cout2 << "DbGetHostServersInfoClass::execute(): arrived" << endl;
	Tango::DevString argin;
	extract(in_any, argin);
	return insert((static_cast<DataBase *>(device))->db_get_host_servers_info(argin));
}

//--------------------------------------------------------
/**
 * method : 		DbGetInstanceNameListClass::execute()
 * description : 	method to trigger the execution of the command.
 *
 * @param	device	The device on which the command must be executed
 * @param	in_any	The command input data
 *
 *	returns The command output data (packed in the Any object)
 */
//--------------------------------------------------------
CORBA::Any *DbGetInstanceNameListClass::execute(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
	cout2 << "DbGetInstanceNameListClass::execute(): arrived" << endl;
	Tango::DevString argin;
	extract(in_any, argin);
	return insert((static_cast<DataBase *>(device))->db_get_instance_name_list(argin));
}

//--------------------------------------------------------
/**
 * method : 		DbGetObjectListClass::execute()
 * description : 	method to trigger the execution of the command.
 *
 * @param	device	The device on which the command must be executed
 * @param	in_any	The command input data
 *
 *	returns The command output data (packed in the Any object)
 */
//--------------------------------------------------------
CORBA::Any *DbGetObjectListClass::execute(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
	cout2 << "DbGetObjectListClass::execute(): arrived" << endl;
	Tango::DevString argin;
	extract(in_any, argin);
	return insert((static_cast<DataBase *>(device))->db_get_object_list(argin));
}

//--------------------------------------------------------
/**
 * method : 		DbGetPropertyClass::execute()
 * description : 	method to trigger the execution of the command.
 *
 * @param	device	The device on which the command must be executed
 * @param	in_any	The command input data
 *
 *	returns The command output data (packed in the Any object)
 */
//--------------------------------------------------------
CORBA::Any *DbGetPropertyClass::execute(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
	cout2 << "DbGetPropertyClass::execute(): arrived" << endl;
	const Tango::DevVarStringArray *argin;
	extract(in_any, argin);
	return insert((static_cast<DataBase *>(device))->db_get_property(argin));
}

//--------------------------------------------------------
/**
 * method : 		DbGetPropertyHistClass::execute()
 * description : 	method to trigger the execution of the command.
 *
 * @param	device	The device on which the command must be executed
 * @param	in_any	The command input data
 *
 *	returns The command output data (packed in the Any object)
 */
//--------------------------------------------------------
CORBA::Any *DbGetPropertyHistClass::execute(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
	cout2 << "DbGetPropertyHistClass::execute(): arrived" << endl;
	const Tango::DevVarStringArray *argin;
	extract(in_any, argin);
	return insert((static_cast<DataBase *>(device))->db_get_property_hist(argin));
}

//--------------------------------------------------------
/**
 * method : 		DbGetPropertyListClass::execute()
 * description : 	method to trigger the execution of the command.
 *
 * @param	device	The device on which the command must be executed
 * @param	in_any	The command input data
 *
 *	returns The command output data (packed in the Any object)
 */
//--------------------------------------------------------
CORBA::Any *DbGetPropertyListClass::execute(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
	cout2 << "DbGetPropertyListClass::execute(): arrived" << endl;
	const Tango::DevVarStringArray *argin;
	extract(in_any, argin);
	return insert((static_cast<DataBase *>(device))->db_get_property_list(argin));
}

//--------------------------------------------------------
/**
 * method : 		DbGetServerInfoClass::execute()
 * description : 	method to trigger the execution of the command.
 *
 * @param	device	The device on which the command must be executed
 * @param	in_any	The command input data
 *
 *	returns The command output data (packed in the Any object)
 */
//--------------------------------------------------------
CORBA::Any *DbGetServerInfoClass::execute(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
	cout2 << "DbGetServerInfoClass::execute(): arrived" << endl;
	Tango::DevString argin;
	extract(in_any, argin);
	return insert((static_cast<DataBase *>(device))->db_get_server_info(argin));
}

//--------------------------------------------------------
/**
 * method : 		DbGetServerListClass::execute()
 * description : 	method to trigger the execution of the command.
 *
 * @param	device	The device on which the command must be executed
 * @param	in_any	The command input data
 *
 *	returns The command output data (packed in the Any object)
 */
//--------------------------------------------------------
CORBA::Any *DbGetServerListClass::execute(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
	cout2 << "DbGetServerListClass::execute(): arrived" << endl;
	Tango::DevString argin;
	extract(in_any, argin);
	return insert((static_cast<DataBase *>(device))->db_get_server_list(argin));
}

//--------------------------------------------------------
/**
 * method : 		DbGetServerNameListClass::execute()
 * description : 	method to trigger the execution of the command.
 *
 * @param	device	The device on which the command must be executed
 * @param	in_any	The command input data
 *
 *	returns The command output data (packed in the Any object)
 */
//--------------------------------------------------------
CORBA::Any *DbGetServerNameListClass::execute(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
	cout2 << "DbGetServerNameListClass::execute(): arrived" << endl;
	Tango::DevString argin;
	extract(in_any, argin);
	return insert((static_cast<DataBase *>(device))->db_get_server_name_list(argin));
}

//--------------------------------------------------------
/**
 * method : 		DbImportDeviceClass::execute()
 * description : 	method to trigger the execution of the command.
 *
 * @param	device	The device on which the command must be executed
 * @param	in_any	The command input data
 *
 *	returns The command output data (packed in the Any object)
 */
//--------------------------------------------------------
CORBA::Any *DbImportDeviceClass::execute(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
	cout2 << "DbImportDeviceClass::execute(): arrived" << endl;
	Tango::DevString argin;
	extract(in_any, argin);
	return insert((static_cast<DataBase *>(device))->db_import_device(argin));
}

//--------------------------------------------------------
/**
 * method : 		DbImportEventClass::execute()
 * description : 	method to trigger the execution of the command.
 *
 * @param	device	The device on which the command must be executed
 * @param	in_any	The command input data
 *
 *	returns The command output data (packed in the Any object)
 */
//--------------------------------------------------------
CORBA::Any *DbImportEventClass::execute(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
	cout2 << "DbImportEventClass::execute(): arrived" << endl;
	Tango::DevString argin;
	extract(in_any, argin);
	return insert((static_cast<DataBase *>(device))->db_import_event(argin));
}

//--------------------------------------------------------
/**
 * method : 		DbInfoClass::execute()
 * description : 	method to trigger the execution of the command.
 *
 * @param	device	The device on which the command must be executed
 * @param	in_any	The command input data
 *
 *	returns The command output data (packed in the Any object)
 */
//--------------------------------------------------------
CORBA::Any *DbInfoClass::execute(Tango::DeviceImpl *device, TANGO_UNUSED(const CORBA::Any &in_any))
{
	cout2 << "DbInfoClass::execute(): arrived" << endl;
	return insert((static_cast<DataBase *>(device))->db_info());
}

//--------------------------------------------------------
/**
 * method : 		DbPutAttributeAliasClass::execute()
 * description : 	method to trigger the execution of the command.
 *
 * @param	device	The device on which the command must be executed
 * @param	in_any	The command input data
 *
 *	returns The command output data (packed in the Any object)
 */
//--------------------------------------------------------
CORBA::Any *DbPutAttributeAliasClass::execute(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
	cout2 << "DbPutAttributeAliasClass::execute(): arrived" << endl;
	const Tango::DevVarStringArray *argin;
	extract(in_any, argin);
	((static_cast<DataBase *>(device))->db_put_attribute_alias(argin));
	return new CORBA::Any();
}

//--------------------------------------------------------
/**
 * method : 		DbPutClassAttributePropertyClass::execute()
 * description : 	method to trigger the execution of the command.
 *
 * @param	device	The device on which the command must be executed
 * @param	in_any	The command input data
 *
 *	returns The command output data (packed in the Any object)
 */
//--------------------------------------------------------
CORBA::Any *DbPutClassAttributePropertyClass::execute(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
	cout2 << "DbPutClassAttributePropertyClass::execute(): arrived" << endl;
	const Tango::DevVarStringArray *argin;
	extract(in_any, argin);
	((static_cast<DataBase *>(device))->db_put_class_attribute_property(argin));
	return new CORBA::Any();
}

//--------------------------------------------------------
/**
 * method : 		DbPutClassAttributeProperty2Class::execute()
 * description : 	method to trigger the execution of the command.
 *
 * @param	device	The device on which the command must be executed
 * @param	in_any	The command input data
 *
 *	returns The command output data (packed in the Any object)
 */
//--------------------------------------------------------
CORBA::Any *DbPutClassAttributeProperty2Class::execute(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
	cout2 << "DbPutClassAttributeProperty2Class::execute(): arrived" << endl;
	const Tango::DevVarStringArray *argin;
	extract(in_any, argin);
	((static_cast<DataBase *>(device))->db_put_class_attribute_property2(argin));
	return new CORBA::Any();
}

//--------------------------------------------------------
/**
 * method : 		DbPutClassPropertyClass::execute()
 * description : 	method to trigger the execution of the command.
 *
 * @param	device	The device on which the command must be executed
 * @param	in_any	The command input data
 *
 *	returns The command output data (packed in the Any object)
 */
//--------------------------------------------------------
CORBA::Any *DbPutClassPropertyClass::execute(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
	cout2 << "DbPutClassPropertyClass::execute(): arrived" << endl;
	const Tango::DevVarStringArray *argin;
	extract(in_any, argin);
	((static_cast<DataBase *>(device))->db_put_class_property(argin));
	return new CORBA::Any();
}

//--------------------------------------------------------
/**
 * method : 		DbPutDeviceAliasClass::execute()
 * description : 	method to trigger the execution of the command.
 *
 * @param	device	The device on which the command must be executed
 * @param	in_any	The command input data
 *
 *	returns The command output data (packed in the Any object)
 */
//--------------------------------------------------------
CORBA::Any *DbPutDeviceAliasClass::execute(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
	cout2 << "DbPutDeviceAliasClass::execute(): arrived" << endl;
	const Tango::DevVarStringArray *argin;
	extract(in_any, argin);
	((static_cast<DataBase *>(device))->db_put_device_alias(argin));
	return new CORBA::Any();
}

//--------------------------------------------------------
/**
 * method : 		DbPutDeviceAttributePropertyClass::execute()
 * description : 	method to trigger the execution of the command.
 *
 * @param	device	The device on which the command must be executed
 * @param	in_any	The command input data
 *
 *	returns The command output data (packed in the Any object)
 */
//--------------------------------------------------------
CORBA::Any *DbPutDeviceAttributePropertyClass::execute(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
	cout2 << "DbPutDeviceAttributePropertyClass::execute(): arrived" << endl;
	const Tango::DevVarStringArray *argin;
	extract(in_any, argin);
	((static_cast<DataBase *>(device))->db_put_device_attribute_property(argin));
	return new CORBA::Any();
}

//--------------------------------------------------------
/**
 * method : 		DbPutDeviceAttributeProperty2Class::execute()
 * description : 	method to trigger the execution of the command.
 *
 * @param	device	The device on which the command must be executed
 * @param	in_any	The command input data
 *
 *	returns The command output data (packed in the Any object)
 */
//--------------------------------------------------------
CORBA::Any *DbPutDeviceAttributeProperty2Class::execute(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
	cout2 << "DbPutDeviceAttributeProperty2Class::execute(): arrived" << endl;
	const Tango::DevVarStringArray *argin;
	extract(in_any, argin);
	((static_cast<DataBase *>(device))->db_put_device_attribute_property2(argin));
	return new CORBA::Any();
}

//--------------------------------------------------------
/**
 * method : 		DbPutDevicePropertyClass::execute()
 * description : 	method to trigger the execution of the command.
 *
 * @param	device	The device on which the command must be executed
 * @param	in_any	The command input data
 *
 *	returns The command output data (packed in the Any object)
 */
//--------------------------------------------------------
CORBA::Any *DbPutDevicePropertyClass::execute(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
	cout2 << "DbPutDevicePropertyClass::execute(): arrived" << endl;
	const Tango::DevVarStringArray *argin;
	extract(in_any, argin);
	((static_cast<DataBase *>(device))->db_put_device_property(argin));
	return new CORBA::Any();
}

//--------------------------------------------------------
/**
 * method : 		DbPutPropertyClass::execute()
 * description : 	method to trigger the execution of the command.
 *
 * @param	device	The device on which the command must be executed
 * @param	in_any	The command input data
 *
 *	returns The command output data (packed in the Any object)
 */
//--------------------------------------------------------
CORBA::Any *DbPutPropertyClass::execute(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
	cout2 << "DbPutPropertyClass::execute(): arrived" << endl;
	const Tango::DevVarStringArray *argin;
	extract(in_any, argin);
	((static_cast<DataBase *>(device))->db_put_property(argin));
	return new CORBA::Any();
}

//--------------------------------------------------------
/**
 * method : 		DbPutServerInfoClass::execute()
 * description : 	method to trigger the execution of the command.
 *
 * @param	device	The device on which the command must be executed
 * @param	in_any	The command input data
 *
 *	returns The command output data (packed in the Any object)
 */
//--------------------------------------------------------
CORBA::Any *DbPutServerInfoClass::execute(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
	cout2 << "DbPutServerInfoClass::execute(): arrived" << endl;
	const Tango::DevVarStringArray *argin;
	extract(in_any, argin);
	((static_cast<DataBase *>(device))->db_put_server_info(argin));
	return new CORBA::Any();
}

//--------------------------------------------------------
/**
 * method : 		DbUnExportDeviceClass::execute()
 * description : 	method to trigger the execution of the command.
 *
 * @param	device	The device on which the command must be executed
 * @param	in_any	The command input data
 *
 *	returns The command output data (packed in the Any object)
 */
//--------------------------------------------------------
CORBA::Any *DbUnExportDeviceClass::execute(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
	cout2 << "DbUnExportDeviceClass::execute(): arrived" << endl;
	Tango::DevString argin;
	extract(in_any, argin);
	((static_cast<DataBase *>(device))->db_un_export_device(argin));
	return new CORBA::Any();
}

//--------------------------------------------------------
/**
 * method : 		DbUnExportEventClass::execute()
 * description : 	method to trigger the execution of the command.
 *
 * @param	device	The device on which the command must be executed
 * @param	in_any	The command input data
 *
 *	returns The command output data (packed in the Any object)
 */
//--------------------------------------------------------
CORBA::Any *DbUnExportEventClass::execute(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
	cout2 << "DbUnExportEventClass::execute(): arrived" << endl;
	Tango::DevString argin;
	extract(in_any, argin);
	((static_cast<DataBase *>(device))->db_un_export_event(argin));
	return new CORBA::Any();
}

//--------------------------------------------------------
/**
 * method : 		DbUnExportServerClass::execute()
 * description : 	method to trigger the execution of the command.
 *
 * @param	device	The device on which the command must be executed
 * @param	in_any	The command input data
 *
 *	returns The command output data (packed in the Any object)
 */
//--------------------------------------------------------
CORBA::Any *DbUnExportServerClass::execute(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
	cout2 << "DbUnExportServerClass::execute(): arrived" << endl;
	Tango::DevString argin;
	extract(in_any, argin);
	((static_cast<DataBase *>(device))->db_un_export_server(argin));
	return new CORBA::Any();
}

//--------------------------------------------------------
/**
 * method : 		ResetTimingValuesClass::execute()
 * description : 	method to trigger the execution of the command.
 *
 * @param	device	The device on which the command must be executed
 * @param	in_any	The command input data
 *
 *	returns The command output data (packed in the Any object)
 */
//--------------------------------------------------------
CORBA::Any *ResetTimingValuesClass::execute(Tango::DeviceImpl *device, TANGO_UNUSED(const CORBA::Any &in_any))
{
	cout2 << "ResetTimingValuesClass::execute(): arrived" << endl;
	((static_cast<DataBase *>(device))->reset_timing_values());
	return new CORBA::Any();
}

//--------------------------------------------------------
/**
 * method : 		DbGetDataForServerCacheClass::execute()
 * description : 	method to trigger the execution of the command.
 *
 * @param	device	The device on which the command must be executed
 * @param	in_any	The command input data
 *
 *	returns The command output data (packed in the Any object)
 */
//--------------------------------------------------------
CORBA::Any *DbGetDataForServerCacheClass::execute(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
	cout2 << "DbGetDataForServerCacheClass::execute(): arrived" << endl;
	const Tango::DevVarStringArray *argin;
	extract(in_any, argin);
	return insert((static_cast<DataBase *>(device))->db_get_data_for_server_cache(argin));
}

//--------------------------------------------------------
/**
 * method : 		DbDeleteAllDeviceAttributePropertyClass::execute()
 * description : 	method to trigger the execution of the command.
 *
 * @param	device	The device on which the command must be executed
 * @param	in_any	The command input data
 *
 *	returns The command output data (packed in the Any object)
 */
//--------------------------------------------------------
CORBA::Any *DbDeleteAllDeviceAttributePropertyClass::execute(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
	cout2 << "DbDeleteAllDeviceAttributePropertyClass::execute(): arrived" << endl;
	const Tango::DevVarStringArray *argin;
	extract(in_any, argin);
	((static_cast<DataBase *>(device))->db_delete_all_device_attribute_property(argin));
	return new CORBA::Any();
}

//--------------------------------------------------------
/**
 * method : 		DbMySqlSelectClass::execute()
 * description : 	method to trigger the execution of the command.
 *
 * @param	device	The device on which the command must be executed
 * @param	in_any	The command input data
 *
 *	returns The command output data (packed in the Any object)
 */
//--------------------------------------------------------
CORBA::Any *DbMySqlSelectClass::execute(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
	cout2 << "DbMySqlSelectClass::execute(): arrived" << endl;
	Tango::DevString argin;
	extract(in_any, argin);
	return insert((static_cast<DataBase *>(device))->db_my_sql_select(argin));
}

//--------------------------------------------------------
/**
 * method : 		DbGetCSDbServerListClass::execute()
 * description : 	method to trigger the execution of the command.
 *
 * @param	device	The device on which the command must be executed
 * @param	in_any	The command input data
 *
 *	returns The command output data (packed in the Any object)
 */
//--------------------------------------------------------
CORBA::Any *DbGetCSDbServerListClass::execute(Tango::DeviceImpl *device, TANGO_UNUSED(const CORBA::Any &in_any))
{
	cout2 << "DbGetCSDbServerListClass::execute(): arrived" << endl;
	return insert((static_cast<DataBase *>(device))->db_get_csdb_server_list());
}

//--------------------------------------------------------
/**
 * method : 		DbGetAttributeAlias2Class::execute()
 * description : 	method to trigger the execution of the command.
 *
 * @param	device	The device on which the command must be executed
 * @param	in_any	The command input data
 *
 *	returns The command output data (packed in the Any object)
 */
//--------------------------------------------------------
CORBA::Any *DbGetAttributeAlias2Class::execute(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
	cout2 << "DbGetAttributeAlias2Class::execute(): arrived" << endl;
	Tango::DevString argin;
	extract(in_any, argin);
	return insert((static_cast<DataBase *>(device))->db_get_attribute_alias2(argin));
}

//--------------------------------------------------------
/**
 * method : 		DbGetAliasAttributeClass::execute()
 * description : 	method to trigger the execution of the command.
 *
 * @param	device	The device on which the command must be executed
 * @param	in_any	The command input data
 *
 *	returns The command output data (packed in the Any object)
 */
//--------------------------------------------------------
CORBA::Any *DbGetAliasAttributeClass::execute(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
	cout2 << "DbGetAliasAttributeClass::execute(): arrived" << endl;
	Tango::DevString argin;
	extract(in_any, argin);
	return insert((static_cast<DataBase *>(device))->db_get_alias_attribute(argin));
}

//--------------------------------------------------------
/**
 * method : 		DbRenameServerClass::execute()
 * description : 	method to trigger the execution of the command.
 *
 * @param	device	The device on which the command must be executed
 * @param	in_any	The command input data
 *
 *	returns The command output data (packed in the Any object)
 */
//--------------------------------------------------------
CORBA::Any *DbRenameServerClass::execute(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
	cout2 << "DbRenameServerClass::execute(): arrived" << endl;
	const Tango::DevVarStringArray *argin;
	extract(in_any, argin);
	((static_cast<DataBase *>(device))->db_rename_server(argin));
	return new CORBA::Any();
}

//--------------------------------------------------------
/**
 * method : 		DbGetClassPipePropertyClass::execute()
 * description : 	method to trigger the execution of the command.
 *
 * @param	device	The device on which the command must be executed
 * @param	in_any	The command input data
 *
 *	returns The command output data (packed in the Any object)
 */
//--------------------------------------------------------
CORBA::Any *DbGetClassPipePropertyClass::execute(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
	cout2 << "DbGetClassPipePropertyClass::execute(): arrived" << endl;
	const Tango::DevVarStringArray *argin;
	extract(in_any, argin);
	return insert((static_cast<DataBase *>(device))->db_get_class_pipe_property(argin));
}

//--------------------------------------------------------
/**
 * method : 		DbGetDevicePipePropertyClass::execute()
 * description : 	method to trigger the execution of the command.
 *
 * @param	device	The device on which the command must be executed
 * @param	in_any	The command input data
 *
 *	returns The command output data (packed in the Any object)
 */
//--------------------------------------------------------
CORBA::Any *DbGetDevicePipePropertyClass::execute(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
	cout2 << "DbGetDevicePipePropertyClass::execute(): arrived" << endl;
	const Tango::DevVarStringArray *argin;
	extract(in_any, argin);
	return insert((static_cast<DataBase *>(device))->db_get_device_pipe_property(argin));
}

//--------------------------------------------------------
/**
 * method : 		DbDeleteClassPipeClass::execute()
 * description : 	method to trigger the execution of the command.
 *
 * @param	device	The device on which the command must be executed
 * @param	in_any	The command input data
 *
 *	returns The command output data (packed in the Any object)
 */
//--------------------------------------------------------
CORBA::Any *DbDeleteClassPipeClass::execute(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
	cout2 << "DbDeleteClassPipeClass::execute(): arrived" << endl;
	const Tango::DevVarStringArray *argin;
	extract(in_any, argin);
	((static_cast<DataBase *>(device))->db_delete_class_pipe(argin));
	return new CORBA::Any();
}

//--------------------------------------------------------
/**
 * method : 		DbDeleteDevicePipeClass::execute()
 * description : 	method to trigger the execution of the command.
 *
 * @param	device	The device on which the command must be executed
 * @param	in_any	The command input data
 *
 *	returns The command output data (packed in the Any object)
 */
//--------------------------------------------------------
CORBA::Any *DbDeleteDevicePipeClass::execute(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
	cout2 << "DbDeleteDevicePipeClass::execute(): arrived" << endl;
	const Tango::DevVarStringArray *argin;
	extract(in_any, argin);
	((static_cast<DataBase *>(device))->db_delete_device_pipe(argin));
	return new CORBA::Any();
}

//--------------------------------------------------------
/**
 * method : 		DbDeleteClassPipePropertyClass::execute()
 * description : 	method to trigger the execution of the command.
 *
 * @param	device	The device on which the command must be executed
 * @param	in_any	The command input data
 *
 *	returns The command output data (packed in the Any object)
 */
//--------------------------------------------------------
CORBA::Any *DbDeleteClassPipePropertyClass::execute(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
	cout2 << "DbDeleteClassPipePropertyClass::execute(): arrived" << endl;
	const Tango::DevVarStringArray *argin;
	extract(in_any, argin);
	((static_cast<DataBase *>(device))->db_delete_class_pipe_property(argin));
	return new CORBA::Any();
}

//--------------------------------------------------------
/**
 * method : 		DbDeleteDevicePipePropertyClass::execute()
 * description : 	method to trigger the execution of the command.
 *
 * @param	device	The device on which the command must be executed
 * @param	in_any	The command input data
 *
 *	returns The command output data (packed in the Any object)
 */
//--------------------------------------------------------
CORBA::Any *DbDeleteDevicePipePropertyClass::execute(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
	cout2 << "DbDeleteDevicePipePropertyClass::execute(): arrived" << endl;
	const Tango::DevVarStringArray *argin;
	extract(in_any, argin);
	((static_cast<DataBase *>(device))->db_delete_device_pipe_property(argin));
	return new CORBA::Any();
}

//--------------------------------------------------------
/**
 * method : 		DbGetClassPipeListClass::execute()
 * description : 	method to trigger the execution of the command.
 *
 * @param	device	The device on which the command must be executed
 * @param	in_any	The command input data
 *
 *	returns The command output data (packed in the Any object)
 */
//--------------------------------------------------------
CORBA::Any *DbGetClassPipeListClass::execute(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
	cout2 << "DbGetClassPipeListClass::execute(): arrived" << endl;
	const Tango::DevVarStringArray *argin;
	extract(in_any, argin);
	return insert((static_cast<DataBase *>(device))->db_get_class_pipe_list(argin));
}

//--------------------------------------------------------
/**
 * method : 		DbGetDevicePipeListClass::execute()
 * description : 	method to trigger the execution of the command.
 *
 * @param	device	The device on which the command must be executed
 * @param	in_any	The command input data
 *
 *	returns The command output data (packed in the Any object)
 */
//--------------------------------------------------------
CORBA::Any *DbGetDevicePipeListClass::execute(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
	cout2 << "DbGetDevicePipeListClass::execute(): arrived" << endl;
	const Tango::DevVarStringArray *argin;
	extract(in_any, argin);
	return insert((static_cast<DataBase *>(device))->db_get_device_pipe_list(argin));
}

//--------------------------------------------------------
/**
 * method : 		DbDeleteAllDevicePipePropertyClass::execute()
 * description : 	method to trigger the execution of the command.
 *
 * @param	device	The device on which the command must be executed
 * @param	in_any	The command input data
 *
 *	returns The command output data (packed in the Any object)
 */
//--------------------------------------------------------
CORBA::Any *DbDeleteAllDevicePipePropertyClass::execute(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
	cout2 << "DbDeleteAllDevicePipePropertyClass::execute(): arrived" << endl;
	const Tango::DevVarStringArray *argin;
	extract(in_any, argin);
	((static_cast<DataBase *>(device))->db_delete_all_device_pipe_property(argin));
	return new CORBA::Any();
}

//--------------------------------------------------------
/**
 * method : 		DbPutClassPipePropertyClass::execute()
 * description : 	method to trigger the execution of the command.
 *
 * @param	device	The device on which the command must be executed
 * @param	in_any	The command input data
 *
 *	returns The command output data (packed in the Any object)
 */
//--------------------------------------------------------
CORBA::Any *DbPutClassPipePropertyClass::execute(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
	cout2 << "DbPutClassPipePropertyClass::execute(): arrived" << endl;
	const Tango::DevVarStringArray *argin;
	extract(in_any, argin);
	((static_cast<DataBase *>(device))->db_put_class_pipe_property(argin));
	return new CORBA::Any();
}

//--------------------------------------------------------
/**
 * method : 		DbPutDevicePipePropertyClass::execute()
 * description : 	method to trigger the execution of the command.
 *
 * @param	device	The device on which the command must be executed
 * @param	in_any	The command input data
 *
 *	returns The command output data (packed in the Any object)
 */
//--------------------------------------------------------
CORBA::Any *DbPutDevicePipePropertyClass::execute(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
	cout2 << "DbPutDevicePipePropertyClass::execute(): arrived" << endl;
	const Tango::DevVarStringArray *argin;
	extract(in_any, argin);
	((static_cast<DataBase *>(device))->db_put_device_pipe_property(argin));
	return new CORBA::Any();
}

//--------------------------------------------------------
/**
 * method : 		DbGetClassPipePropertyHistClass::execute()
 * description : 	method to trigger the execution of the command.
 *
 * @param	device	The device on which the command must be executed
 * @param	in_any	The command input data
 *
 *	returns The command output data (packed in the Any object)
 */
//--------------------------------------------------------
CORBA::Any *DbGetClassPipePropertyHistClass::execute(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
	cout2 << "DbGetClassPipePropertyHistClass::execute(): arrived" << endl;
	const Tango::DevVarStringArray *argin;
	extract(in_any, argin);
	return insert((static_cast<DataBase *>(device))->db_get_class_pipe_property_hist(argin));
}

//--------------------------------------------------------
/**
 * method : 		DbGetDevicePipePropertyHistClass::execute()
 * description : 	method to trigger the execution of the command.
 *
 * @param	device	The device on which the command must be executed
 * @param	in_any	The command input data
 *
 *	returns The command output data (packed in the Any object)
 */
//--------------------------------------------------------
CORBA::Any *DbGetDevicePipePropertyHistClass::execute(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
	cout2 << "DbGetDevicePipePropertyHistClass::execute(): arrived" << endl;
	const Tango::DevVarStringArray *argin;
	extract(in_any, argin);
	return insert((static_cast<DataBase *>(device))->db_get_device_pipe_property_hist(argin));
}

//--------------------------------------------------------
/**
 * method : 		DbGetForwardedAttributeListForDeviceClass::execute()
 * description : 	method to trigger the execution of the command.
 *
 * @param	device	The device on which the command must be executed
 * @param	in_any	The command input data
 *
 *	returns The command output data (packed in the Any object)
 */
//--------------------------------------------------------
CORBA::Any *DbGetForwardedAttributeListForDeviceClass::execute(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
	cout2 << "DbGetForwardedAttributeListForDeviceClass::execute(): arrived" << endl;
	Tango::DevString argin;
	extract(in_any, argin);
	return insert((static_cast<DataBase *>(device))->db_get_forwarded_attribute_list_for_device(argin));
}


//===================================================================
//	Properties management
//===================================================================
//--------------------------------------------------------
/**
 *	Method      : DataBaseClass::get_class_property()
 *	Description : Get the class property for specified name.
 */
//--------------------------------------------------------
Tango::DbDatum DataBaseClass::get_class_property(string &prop_name)
{
	for (unsigned int i=0 ; i<cl_prop.size() ; i++)
		if (cl_prop[i].name == prop_name)
			return cl_prop[i];
	//	if not found, returns  an empty DbDatum
	return Tango::DbDatum(prop_name);
}

//--------------------------------------------------------
/**
 *	Method      : DataBaseClass::get_default_device_property()
 *	Description : Return the default value for device property.
 */
//--------------------------------------------------------
Tango::DbDatum DataBaseClass::get_default_device_property(string &prop_name)
{
	for (unsigned int i=0 ; i<dev_def_prop.size() ; i++)
		if (dev_def_prop[i].name == prop_name)
			return dev_def_prop[i];
	//	if not found, return  an empty DbDatum
	return Tango::DbDatum(prop_name);
}

//--------------------------------------------------------
/**
 *	Method      : DataBaseClass::get_default_class_property()
 *	Description : Return the default value for class property.
 */
//--------------------------------------------------------
Tango::DbDatum DataBaseClass::get_default_class_property(string &prop_name)
{
	for (unsigned int i=0 ; i<cl_def_prop.size() ; i++)
		if (cl_def_prop[i].name == prop_name)
			return cl_def_prop[i];
	//	if not found, return  an empty DbDatum
	return Tango::DbDatum(prop_name);
}


//--------------------------------------------------------
/**
 *	Method      : DataBaseClass::set_default_property()
 *	Description : Set default property (class and device) for wizard.
 *                For each property, add to wizard property name and description.
 *                If default value has been set, add it to wizard property and
 *                store it in a DbDatum.
 */
//--------------------------------------------------------
void DataBaseClass::set_default_property()
{
	string	prop_name;
	string	prop_desc;
	string	prop_def;
	vector<string>	vect_data;

	//	Set Default Class Properties

	//	Set Default device Properties
}

//--------------------------------------------------------
/**
 *	Method      : DataBaseClass::write_class_property()
 *	Description : Set class description fields as property in database
 */
//--------------------------------------------------------
void DataBaseClass::write_class_property()
{
	//	First time, check if database used
	if (Tango::Util::_UseDb == false)
		return;

	Tango::DbData	data;
	string	classname = get_name();
	string	header;
	string::size_type	start, end;

	//	Put title
	Tango::DbDatum	title("ProjectTitle");
	string	str_title("TANGO");
	title << str_title;
	data.push_back(title);

	//	Put Description
	Tango::DbDatum	description("Description");
	vector<string>	str_desc;
	str_desc.push_back("This class manage the TANGO database.");
	description << str_desc;
	data.push_back(description);

	//	put cvs or svn location
	string	filename("DataBase");
	filename += "Class.cpp";

	// check for cvs information
	string	src_path(CvsPath);
	start = src_path.find("/");
	if (start!=string::npos)
	{
		end   = src_path.find(filename);
		if (end>start)
		{
			string	strloc = src_path.substr(start, end-start);
			//	Check if specific repository
			start = strloc.find("/cvsroot/");
			if (start!=string::npos && start>0)
			{
				string	repository = strloc.substr(0, start);
				if (repository.find("/segfs/")!=string::npos)
					strloc = "ESRF:" + strloc.substr(start, strloc.length()-start);
			}
			Tango::DbDatum	cvs_loc("cvs_location");
			cvs_loc << strloc;
			data.push_back(cvs_loc);
		}
	}

	// check for svn information
	else
	{
		string	src_path(SvnPath);
		start = src_path.find("://");
		if (start!=string::npos)
		{
			end = src_path.find(filename);
			if (end>start)
			{
				header = "$HeadURL: ";
				start = header.length();
				string	strloc = src_path.substr(start, (end-start));
				
				Tango::DbDatum	svn_loc("svn_location");
				svn_loc << strloc;
				data.push_back(svn_loc);
			}
		}
	}

	//	Get CVS or SVN revision tag
	
	// CVS tag
	string	tagname(TagName);
	header = "$Name: ";
	start = header.length();
	string	endstr(" $");
	
	end   = tagname.find(endstr);
	if (end!=string::npos && end>start)
	{
		string	strtag = tagname.substr(start, end-start);
		Tango::DbDatum	cvs_tag("cvs_tag");
		cvs_tag << strtag;
		data.push_back(cvs_tag);
	}
	
	// SVN tag
	string	svnpath(SvnPath);
	header = "$HeadURL: ";
	start = header.length();
	
	end   = svnpath.find(endstr);
	if (end!=string::npos && end>start)
	{
		string	strloc = svnpath.substr(start, end-start);
		
		string tagstr ("/tags/");
		start = strloc.find(tagstr);
		if ( start!=string::npos )
		{
			start = start + tagstr.length();
			end   = strloc.find(filename);
			string	strtag = strloc.substr(start, end-start-1);
			
			Tango::DbDatum	svn_tag("svn_tag");
			svn_tag << strtag;
			data.push_back(svn_tag);
		}
	}

	//	Get URL location
	string	httpServ(HttpServer);
	if (httpServ.length()>0)
	{
		Tango::DbDatum	db_doc_url("doc_url");
		db_doc_url << httpServ;
		data.push_back(db_doc_url);
	}

	//  Put inheritance
	Tango::DbDatum	inher_datum("InheritedFrom");
	vector<string> inheritance;
	inheritance.push_back("TANGO_BASE_CLASS");
	inher_datum << inheritance;
	data.push_back(inher_datum);

	//	Call database and and values
	get_db_class()->put_property(data);
}

//===================================================================
//	Factory methods
//===================================================================

//--------------------------------------------------------
/**
 *	Method      : DataBaseClass::device_factory()
 *	Description : Create the device object(s)
 *                and store them in the device list
 */
//--------------------------------------------------------
void DataBaseClass::device_factory(const Tango::DevVarStringArray *devlist_ptr)
{
device_list.push_back(new DataBase(this, DataBase::db_name.c_str(),
									"TANGO database device server"));
export_device(device_list[0],"database");
}
//--------------------------------------------------------
/**
 *	Method      : DataBaseClass::attribute_factory()
 *	Description : Create the attribute object(s)
 *                and store them in the attribute list
 */
//--------------------------------------------------------
void DataBaseClass::attribute_factory(vector<Tango::Attr *> &att_list)
{
	/*----- PROTECTED REGION ID(DataBaseClass::attribute_factory_before) ENABLED START -----*/

	//	Add your own code

	/*----- PROTECTED REGION END -----*/	//	DataBaseClass::attribute_factory_before
	//	Attribute : StoredProcedureRelease
	StoredProcedureReleaseAttrib	*storedprocedurerelease = new StoredProcedureReleaseAttrib();
	Tango::UserDefaultAttrProp	storedprocedurerelease_prop;
	//	description	not set for StoredProcedureRelease
	//	label	not set for StoredProcedureRelease
	//	unit	not set for StoredProcedureRelease
	//	standard_unit	not set for StoredProcedureRelease
	//	display_unit	not set for StoredProcedureRelease
	//	format	not set for StoredProcedureRelease
	//	max_value	not set for StoredProcedureRelease
	//	min_value	not set for StoredProcedureRelease
	//	max_alarm	not set for StoredProcedureRelease
	//	min_alarm	not set for StoredProcedureRelease
	//	max_warning	not set for StoredProcedureRelease
	//	min_warning	not set for StoredProcedureRelease
	//	delta_t	not set for StoredProcedureRelease
	//	delta_val	not set for StoredProcedureRelease
	
	storedprocedurerelease->set_default_properties(storedprocedurerelease_prop);
	//	Not Polled
	storedprocedurerelease->set_disp_level(Tango::OPERATOR);
	//	Not Memorized
	att_list.push_back(storedprocedurerelease);

	//	Attribute : Timing_average
	Timing_averageAttrib	*timing_average = new Timing_averageAttrib();
	Tango::UserDefaultAttrProp	timing_average_prop;
	//	description	not set for Timing_average
	//	label	not set for Timing_average
	//	unit	not set for Timing_average
	//	standard_unit	not set for Timing_average
	//	display_unit	not set for Timing_average
	//	format	not set for Timing_average
	//	max_value	not set for Timing_average
	//	min_value	not set for Timing_average
	//	max_alarm	not set for Timing_average
	//	min_alarm	not set for Timing_average
	//	max_warning	not set for Timing_average
	//	min_warning	not set for Timing_average
	//	delta_t	not set for Timing_average
	//	delta_val	not set for Timing_average
	
	timing_average->set_default_properties(timing_average_prop);
	//	Not Polled
	timing_average->set_disp_level(Tango::OPERATOR);
	//	Not Memorized
	att_list.push_back(timing_average);

	//	Attribute : Timing_minimum
	Timing_minimumAttrib	*timing_minimum = new Timing_minimumAttrib();
	Tango::UserDefaultAttrProp	timing_minimum_prop;
	//	description	not set for Timing_minimum
	//	label	not set for Timing_minimum
	//	unit	not set for Timing_minimum
	//	standard_unit	not set for Timing_minimum
	//	display_unit	not set for Timing_minimum
	//	format	not set for Timing_minimum
	//	max_value	not set for Timing_minimum
	//	min_value	not set for Timing_minimum
	//	max_alarm	not set for Timing_minimum
	//	min_alarm	not set for Timing_minimum
	//	max_warning	not set for Timing_minimum
	//	min_warning	not set for Timing_minimum
	//	delta_t	not set for Timing_minimum
	//	delta_val	not set for Timing_minimum
	
	timing_minimum->set_default_properties(timing_minimum_prop);
	//	Not Polled
	timing_minimum->set_disp_level(Tango::OPERATOR);
	//	Not Memorized
	att_list.push_back(timing_minimum);

	//	Attribute : Timing_maximum
	Timing_maximumAttrib	*timing_maximum = new Timing_maximumAttrib();
	Tango::UserDefaultAttrProp	timing_maximum_prop;
	//	description	not set for Timing_maximum
	//	label	not set for Timing_maximum
	//	unit	not set for Timing_maximum
	//	standard_unit	not set for Timing_maximum
	//	display_unit	not set for Timing_maximum
	//	format	not set for Timing_maximum
	//	max_value	not set for Timing_maximum
	//	min_value	not set for Timing_maximum
	//	max_alarm	not set for Timing_maximum
	//	min_alarm	not set for Timing_maximum
	//	max_warning	not set for Timing_maximum
	//	min_warning	not set for Timing_maximum
	//	delta_t	not set for Timing_maximum
	//	delta_val	not set for Timing_maximum
	
	timing_maximum->set_default_properties(timing_maximum_prop);
	//	Not Polled
	timing_maximum->set_disp_level(Tango::OPERATOR);
	//	Not Memorized
	att_list.push_back(timing_maximum);

	//	Attribute : Timing_calls
	Timing_callsAttrib	*timing_calls = new Timing_callsAttrib();
	Tango::UserDefaultAttrProp	timing_calls_prop;
	//	description	not set for Timing_calls
	//	label	not set for Timing_calls
	//	unit	not set for Timing_calls
	//	standard_unit	not set for Timing_calls
	//	display_unit	not set for Timing_calls
	//	format	not set for Timing_calls
	//	max_value	not set for Timing_calls
	//	min_value	not set for Timing_calls
	//	max_alarm	not set for Timing_calls
	//	min_alarm	not set for Timing_calls
	//	max_warning	not set for Timing_calls
	//	min_warning	not set for Timing_calls
	//	delta_t	not set for Timing_calls
	//	delta_val	not set for Timing_calls
	
	timing_calls->set_default_properties(timing_calls_prop);
	//	Not Polled
	timing_calls->set_disp_level(Tango::OPERATOR);
	//	Not Memorized
	att_list.push_back(timing_calls);

	//	Attribute : Timing_index
	Timing_indexAttrib	*timing_index = new Timing_indexAttrib();
	Tango::UserDefaultAttrProp	timing_index_prop;
	//	description	not set for Timing_index
	//	label	not set for Timing_index
	//	unit	not set for Timing_index
	//	standard_unit	not set for Timing_index
	//	display_unit	not set for Timing_index
	//	format	not set for Timing_index
	//	max_value	not set for Timing_index
	//	min_value	not set for Timing_index
	//	max_alarm	not set for Timing_index
	//	min_alarm	not set for Timing_index
	//	max_warning	not set for Timing_index
	//	min_warning	not set for Timing_index
	//	delta_t	not set for Timing_index
	//	delta_val	not set for Timing_index
	
	timing_index->set_default_properties(timing_index_prop);
	//	Not Polled
	timing_index->set_disp_level(Tango::OPERATOR);
	//	Not Memorized
	att_list.push_back(timing_index);

	//	Attribute : Timing_info
	Timing_infoAttrib	*timing_info = new Timing_infoAttrib();
	Tango::UserDefaultAttrProp	timing_info_prop;
	//	description	not set for Timing_info
	//	label	not set for Timing_info
	//	unit	not set for Timing_info
	//	standard_unit	not set for Timing_info
	//	display_unit	not set for Timing_info
	//	format	not set for Timing_info
	//	max_value	not set for Timing_info
	//	min_value	not set for Timing_info
	//	max_alarm	not set for Timing_info
	//	min_alarm	not set for Timing_info
	//	max_warning	not set for Timing_info
	//	min_warning	not set for Timing_info
	//	delta_t	not set for Timing_info
	//	delta_val	not set for Timing_info
	
	timing_info->set_default_properties(timing_info_prop);
	//	Not Polled
	timing_info->set_disp_level(Tango::OPERATOR);
	//	Not Memorized
	att_list.push_back(timing_info);


	//	Create a list of static attributes
	create_static_attribute_list(get_class_attr()->get_attr_list());
	/*----- PROTECTED REGION ID(DataBaseClass::attribute_factory_after) ENABLED START -----*/

	//	Add your own code

	/*----- PROTECTED REGION END -----*/	//	DataBaseClass::attribute_factory_after
}
//--------------------------------------------------------
/**
 *	Method      : DataBaseClass::pipe_factory()
 *	Description : Create the pipe object(s)
 *                and store them in the pipe list
 */
//--------------------------------------------------------
void DataBaseClass::pipe_factory()
{
	/*----- PROTECTED REGION ID(DataBaseClass::pipe_factory_before) ENABLED START -----*/
	
	//	Add your own code
	
	/*----- PROTECTED REGION END -----*/	//	DataBaseClass::pipe_factory_before
	/*----- PROTECTED REGION ID(DataBaseClass::pipe_factory_after) ENABLED START -----*/
	
	//	Add your own code
	
	/*----- PROTECTED REGION END -----*/	//	DataBaseClass::pipe_factory_after
}
//--------------------------------------------------------
/**
 *	Method      : DataBaseClass::command_factory()
 *	Description : Create the command object(s)
 *                and store them in the command list
 */
//--------------------------------------------------------
void DataBaseClass::command_factory()
{
	/*----- PROTECTED REGION ID(DataBaseClass::command_factory_before) ENABLED START -----*/

	/*----- PROTECTED REGION END -----*/	//	DataBaseClass::command_factory_before


	//	Command DbAddDevice
	DbAddDeviceClass	*pDbAddDeviceCmd =
		new DbAddDeviceClass("DbAddDevice",
			Tango::DEVVAR_STRINGARRAY, Tango::DEV_VOID,
			"Str[0] = Full device server process name\nStr[1] = Device name\nStr[2] = Tango class name",
			"",
			Tango::OPERATOR);
	command_list.push_back(pDbAddDeviceCmd);

	//	Command DbAddServer
	DbAddServerClass	*pDbAddServerCmd =
		new DbAddServerClass("DbAddServer",
			Tango::DEVVAR_STRINGARRAY, Tango::DEV_VOID,
			"Str[0] = Full device server name\nStr[1] = Device(s) name\nStr[2] = Tango class name\nStr[n] = Device name\nStr[n + 1] = Tango class name",
			"",
			Tango::OPERATOR);
	command_list.push_back(pDbAddServerCmd);

	//	Command DbDeleteAttributeAlias
	DbDeleteAttributeAliasClass	*pDbDeleteAttributeAliasCmd =
		new DbDeleteAttributeAliasClass("DbDeleteAttributeAlias",
			Tango::DEV_STRING, Tango::DEV_VOID,
			"Attriibute alias name.",
			"",
			Tango::OPERATOR);
	command_list.push_back(pDbDeleteAttributeAliasCmd);

	//	Command DbDeleteClassAttribute
	DbDeleteClassAttributeClass	*pDbDeleteClassAttributeCmd =
		new DbDeleteClassAttributeClass("DbDeleteClassAttribute",
			Tango::DEVVAR_STRINGARRAY, Tango::DEV_VOID,
			"Str[0] = Tango class name\nStr[1] = Attribute name",
			"",
			Tango::OPERATOR);
	command_list.push_back(pDbDeleteClassAttributeCmd);

	//	Command DbDeleteClassAttributeProperty
	DbDeleteClassAttributePropertyClass	*pDbDeleteClassAttributePropertyCmd =
		new DbDeleteClassAttributePropertyClass("DbDeleteClassAttributeProperty",
			Tango::DEVVAR_STRINGARRAY, Tango::DEV_VOID,
			"Str[0] = Tango class name\nStr[1] = Attribute name\nStr[2] = Property name\nStr[n] = Property name",
			"",
			Tango::OPERATOR);
	command_list.push_back(pDbDeleteClassAttributePropertyCmd);

	//	Command DbDeleteClassProperty
	DbDeleteClassPropertyClass	*pDbDeleteClassPropertyCmd =
		new DbDeleteClassPropertyClass("DbDeleteClassProperty",
			Tango::DEVVAR_STRINGARRAY, Tango::DEV_VOID,
			"Str[0] = Tango class name\nStr[1] = Property name\nStr[n] = Property name",
			"",
			Tango::OPERATOR);
	command_list.push_back(pDbDeleteClassPropertyCmd);

	//	Command DbDeleteDevice
	DbDeleteDeviceClass	*pDbDeleteDeviceCmd =
		new DbDeleteDeviceClass("DbDeleteDevice",
			Tango::DEV_STRING, Tango::DEV_VOID,
			"device name",
			"",
			Tango::OPERATOR);
	command_list.push_back(pDbDeleteDeviceCmd);

	//	Command DbDeleteDeviceAlias
	DbDeleteDeviceAliasClass	*pDbDeleteDeviceAliasCmd =
		new DbDeleteDeviceAliasClass("DbDeleteDeviceAlias",
			Tango::DEV_STRING, Tango::DEV_VOID,
			"device alias name",
			"",
			Tango::OPERATOR);
	command_list.push_back(pDbDeleteDeviceAliasCmd);

	//	Command DbDeleteDeviceAttribute
	DbDeleteDeviceAttributeClass	*pDbDeleteDeviceAttributeCmd =
		new DbDeleteDeviceAttributeClass("DbDeleteDeviceAttribute",
			Tango::DEVVAR_STRINGARRAY, Tango::DEV_VOID,
			"Str[0] = Device name\nStr[1] = Attribute name",
			"",
			Tango::OPERATOR);
	command_list.push_back(pDbDeleteDeviceAttributeCmd);

	//	Command DbDeleteDeviceAttributeProperty
	DbDeleteDeviceAttributePropertyClass	*pDbDeleteDeviceAttributePropertyCmd =
		new DbDeleteDeviceAttributePropertyClass("DbDeleteDeviceAttributeProperty",
			Tango::DEVVAR_STRINGARRAY, Tango::DEV_VOID,
			"Str[0] = Device name\nStr[1] = Attribute name\nStr[2] = Property name\nStr[n] = Property name",
			"",
			Tango::OPERATOR);
	command_list.push_back(pDbDeleteDeviceAttributePropertyCmd);

	//	Command DbDeleteDeviceProperty
	DbDeleteDevicePropertyClass	*pDbDeleteDevicePropertyCmd =
		new DbDeleteDevicePropertyClass("DbDeleteDeviceProperty",
			Tango::DEVVAR_STRINGARRAY, Tango::DEV_VOID,
			"Str[0] = Device name\nStr[1] = Property name\nStr[n] = Property name",
			"",
			Tango::OPERATOR);
	command_list.push_back(pDbDeleteDevicePropertyCmd);

	//	Command DbDeleteProperty
	DbDeletePropertyClass	*pDbDeletePropertyCmd =
		new DbDeletePropertyClass("DbDeleteProperty",
			Tango::DEVVAR_STRINGARRAY, Tango::DEV_VOID,
			"Str[0]  = Object name\nStr[1] = Property name\nStr[n] = Property name",
			"",
			Tango::OPERATOR);
	command_list.push_back(pDbDeletePropertyCmd);

	//	Command DbDeleteServer
	DbDeleteServerClass	*pDbDeleteServerCmd =
		new DbDeleteServerClass("DbDeleteServer",
			Tango::DEV_STRING, Tango::DEV_VOID,
			"Device server name",
			"",
			Tango::OPERATOR);
	command_list.push_back(pDbDeleteServerCmd);

	//	Command DbDeleteServerInfo
	DbDeleteServerInfoClass	*pDbDeleteServerInfoCmd =
		new DbDeleteServerInfoClass("DbDeleteServerInfo",
			Tango::DEV_STRING, Tango::DEV_VOID,
			"Device server name",
			"",
			Tango::OPERATOR);
	command_list.push_back(pDbDeleteServerInfoCmd);

	//	Command DbExportDevice
	DbExportDeviceClass	*pDbExportDeviceCmd =
		new DbExportDeviceClass("DbExportDevice",
			Tango::DEVVAR_STRINGARRAY, Tango::DEV_VOID,
			"Str[0] = Device name\nStr[1] = CORBA IOR\nStr[2] = Device server process host name\nStr[3] = Device server process PID or string ``null``\nStr[4] = Device server process version",
			"",
			Tango::OPERATOR);
	command_list.push_back(pDbExportDeviceCmd);

	//	Command DbExportEvent
	DbExportEventClass	*pDbExportEventCmd =
		new DbExportEventClass("DbExportEvent",
			Tango::DEVVAR_STRINGARRAY, Tango::DEV_VOID,
			"Str[0] = event channel name (or factory name)\nStr[1] = CORBA IOR\nStr[2] = Notifd host name\nStr[3] = Notifd pid\nStr[4] = Notifd version",
			"",
			Tango::OPERATOR);
	command_list.push_back(pDbExportEventCmd);

	//	Command DbGetAliasDevice
	DbGetAliasDeviceClass	*pDbGetAliasDeviceCmd =
		new DbGetAliasDeviceClass("DbGetAliasDevice",
			Tango::DEV_STRING, Tango::DEV_STRING,
			"Alias name",
			"Device name",
			Tango::OPERATOR);
	command_list.push_back(pDbGetAliasDeviceCmd);

	//	Command DbGetAttributeAlias
	DbGetAttributeAliasClass	*pDbGetAttributeAliasCmd =
		new DbGetAttributeAliasClass("DbGetAttributeAlias",
			Tango::DEV_STRING, Tango::DEV_STRING,
			"The attribute alias name",
			"The attribute name (device/attribute)",
			Tango::OPERATOR);
	command_list.push_back(pDbGetAttributeAliasCmd);

	//	Command DbGetAttributeAliasList
	DbGetAttributeAliasListClass	*pDbGetAttributeAliasListCmd =
		new DbGetAttributeAliasListClass("DbGetAttributeAliasList",
			Tango::DEV_STRING, Tango::DEVVAR_STRINGARRAY,
			"attribute alias filter string (eg: att*)",
			"attribute aliases",
			Tango::OPERATOR);
	command_list.push_back(pDbGetAttributeAliasListCmd);

	//	Command DbGetClassAttributeList
	DbGetClassAttributeListClass	*pDbGetClassAttributeListCmd =
		new DbGetClassAttributeListClass("DbGetClassAttributeList",
			Tango::DEVVAR_STRINGARRAY, Tango::DEVVAR_STRINGARRAY,
			"Str[0] = Tango class name\nStr[1] = Attribute name filter (eg: att*)",
			"Str[0] = Class attribute name\nStr[n] = Class attribute name",
			Tango::OPERATOR);
	command_list.push_back(pDbGetClassAttributeListCmd);

	//	Command DbGetClassAttributeProperty
	DbGetClassAttributePropertyClass	*pDbGetClassAttributePropertyCmd =
		new DbGetClassAttributePropertyClass("DbGetClassAttributeProperty",
			Tango::DEVVAR_STRINGARRAY, Tango::DEVVAR_STRINGARRAY,
			"Str[0] = Tango class name\nStr[1] = Attribute name\nStr[n] = Attribute name",
			"Str[0] = Tango class name\nStr[1] = Attribute property  number\nStr[2] = Attribute property 1 name\nStr[3] = Attribute property 1 value\nStr[n + 1] = Attribute property 2 name\nStr[n + 2] = Attribute property 2 value",
			Tango::OPERATOR);
	command_list.push_back(pDbGetClassAttributePropertyCmd);

	//	Command DbGetClassAttributeProperty2
	DbGetClassAttributeProperty2Class	*pDbGetClassAttributeProperty2Cmd =
		new DbGetClassAttributeProperty2Class("DbGetClassAttributeProperty2",
			Tango::DEVVAR_STRINGARRAY, Tango::DEVVAR_STRINGARRAY,
			"Str[0] = Tango class name\nStr[1] = Attribute name\nStr[n] = Attribute name",
			"Str[0] = Tango class name\nStr[1] = Attribute property  number\nStr[2] = Attribute property 1 name\nStr[3] = Attribute property 1 value number (array case)\nStr[4] = Attribute property 1 value\nStr[n] = Attribute property 1 value (array case)\nStr[n + 1] = Attribute property 2 name\nStr[n + 2] = Attribute property 2 value number (array case)\nStr[n + 3] = Attribute property 2 value\nStr[n + m] = Attribute property 2 value (array case)",
			Tango::OPERATOR);
	command_list.push_back(pDbGetClassAttributeProperty2Cmd);

	//	Command DbGetClassAttributePropertyHist
	DbGetClassAttributePropertyHistClass	*pDbGetClassAttributePropertyHistCmd =
		new DbGetClassAttributePropertyHistClass("DbGetClassAttributePropertyHist",
			Tango::DEVVAR_STRINGARRAY, Tango::DEVVAR_STRINGARRAY,
			"Str[0] = Tango class\nStr[1] = Attribute name\nStr[2] = Property name",
			"Str[0] = Attribute name\nStr[1] = Property name\nStr[2] = date\nStr[3] = Property value number (array case)\nStr[4] = Property value 1\nStr[n] = Property value n",
			Tango::OPERATOR);
	command_list.push_back(pDbGetClassAttributePropertyHistCmd);

	//	Command DbGetClassForDevice
	DbGetClassForDeviceClass	*pDbGetClassForDeviceCmd =
		new DbGetClassForDeviceClass("DbGetClassForDevice",
			Tango::DEV_STRING, Tango::DEV_STRING,
			"Device name",
			"Device Tango class",
			Tango::OPERATOR);
	command_list.push_back(pDbGetClassForDeviceCmd);

	//	Command DbGetClassInheritanceForDevice
	DbGetClassInheritanceForDeviceClass	*pDbGetClassInheritanceForDeviceCmd =
		new DbGetClassInheritanceForDeviceClass("DbGetClassInheritanceForDevice",
			Tango::DEV_STRING, Tango::DEVVAR_STRINGARRAY,
			"Device name",
			"Classes off the specified device.\n[0] - is the class of the device.\n[1] - is the class from the device class is inherited.\n........and so on",
			Tango::OPERATOR);
	command_list.push_back(pDbGetClassInheritanceForDeviceCmd);

	//	Command DbGetClassList
	DbGetClassListClass	*pDbGetClassListCmd =
		new DbGetClassListClass("DbGetClassList",
			Tango::DEV_STRING, Tango::DEVVAR_STRINGARRAY,
			"Filter",
			"Class list",
			Tango::OPERATOR);
	command_list.push_back(pDbGetClassListCmd);

	//	Command DbGetClassProperty
	DbGetClassPropertyClass	*pDbGetClassPropertyCmd =
		new DbGetClassPropertyClass("DbGetClassProperty",
			Tango::DEVVAR_STRINGARRAY, Tango::DEVVAR_STRINGARRAY,
			"Str[0] = Tango class\nStr[1] = Property name\nStr[2] = Property name",
			"Str[0] = Tango class\nStr[1] = Property number\nStr[2] = Property name\nStr[3] = Property value number (array case)\nStr[4] = Property value\nStr[n] = Property value (array case)\n....",
			Tango::OPERATOR);
	command_list.push_back(pDbGetClassPropertyCmd);

	//	Command DbGetClassPropertyHist
	DbGetClassPropertyHistClass	*pDbGetClassPropertyHistCmd =
		new DbGetClassPropertyHistClass("DbGetClassPropertyHist",
			Tango::DEVVAR_STRINGARRAY, Tango::DEVVAR_STRINGARRAY,
			"Str[0] = Tango class\nStr[1] = Property name",
			"Str[0] = Property name\nStr[1] = date\nStr[2] = Property value number (array case)\nStr[3] = Property value 1\nStr[n] = Property value n",
			Tango::OPERATOR);
	command_list.push_back(pDbGetClassPropertyHistCmd);

	//	Command DbGetClassPropertyList
	DbGetClassPropertyListClass	*pDbGetClassPropertyListCmd =
		new DbGetClassPropertyListClass("DbGetClassPropertyList",
			Tango::DEV_STRING, Tango::DEVVAR_STRINGARRAY,
			"The filter",
			"Property name list",
			Tango::OPERATOR);
	command_list.push_back(pDbGetClassPropertyListCmd);

	//	Command DbGetDeviceAlias
	DbGetDeviceAliasClass	*pDbGetDeviceAliasCmd =
		new DbGetDeviceAliasClass("DbGetDeviceAlias",
			Tango::DEV_STRING, Tango::DEV_STRING,
			"The device name",
			"The alias found",
			Tango::OPERATOR);
	command_list.push_back(pDbGetDeviceAliasCmd);

	//	Command DbGetDeviceAliasList
	DbGetDeviceAliasListClass	*pDbGetDeviceAliasListCmd =
		new DbGetDeviceAliasListClass("DbGetDeviceAliasList",
			Tango::DEV_STRING, Tango::DEVVAR_STRINGARRAY,
			"The filter",
			"Device alias list",
			Tango::OPERATOR);
	command_list.push_back(pDbGetDeviceAliasListCmd);

	//	Command DbGetDeviceAttributeList
	DbGetDeviceAttributeListClass	*pDbGetDeviceAttributeListCmd =
		new DbGetDeviceAttributeListClass("DbGetDeviceAttributeList",
			Tango::DEVVAR_STRINGARRAY, Tango::DEVVAR_STRINGARRAY,
			"Str[0] = Device name\nStr[1] = Wildcard",
			"attribute name list",
			Tango::OPERATOR);
	command_list.push_back(pDbGetDeviceAttributeListCmd);

	//	Command DbGetDeviceAttributeProperty
	DbGetDeviceAttributePropertyClass	*pDbGetDeviceAttributePropertyCmd =
		new DbGetDeviceAttributePropertyClass("DbGetDeviceAttributeProperty",
			Tango::DEVVAR_STRINGARRAY, Tango::DEVVAR_STRINGARRAY,
			"Str[0] = Device name\nStr[1] = Attribute name\nStr[n] = Attribute name",
			"Str[0] = Device name\nStr[1] = Attribute property  number\nStr[2] = Attribute property 1 name\nStr[3] = Attribute property 1 value\nStr[n + 1] = Attribute property 2 name\nStr[n + 2] = Attribute property 2 value",
			Tango::OPERATOR);
	command_list.push_back(pDbGetDeviceAttributePropertyCmd);

	//	Command DbGetDeviceAttributeProperty2
	DbGetDeviceAttributeProperty2Class	*pDbGetDeviceAttributeProperty2Cmd =
		new DbGetDeviceAttributeProperty2Class("DbGetDeviceAttributeProperty2",
			Tango::DEVVAR_STRINGARRAY, Tango::DEVVAR_STRINGARRAY,
			"Str[0] = Device name\nStr[1] = Attribute name\nStr[n] = Attribute name",
			"Str[0] = Device name\nStr[1] = Attribute property  number\nStr[2] = Attribute property 1 name\nStr[3] = Attribute property 1 value number (array case)\nStr[4] = Attribute property 1 value\nStr[n] = Attribute property 1 value (array case)\nStr[n + 1] = Attribute property 2 name\nStr[n + 2] = Attribute property 2 value number (array case)\nStr[n + 3] = Attribute property 2 value\nStr[n + m] = Attribute property 2 value (array case)",
			Tango::OPERATOR);
	command_list.push_back(pDbGetDeviceAttributeProperty2Cmd);

	//	Command DbGetDeviceAttributePropertyHist
	DbGetDeviceAttributePropertyHistClass	*pDbGetDeviceAttributePropertyHistCmd =
		new DbGetDeviceAttributePropertyHistClass("DbGetDeviceAttributePropertyHist",
			Tango::DEVVAR_STRINGARRAY, Tango::DEVVAR_STRINGARRAY,
			"Str[0] = Device name\nStr[1] = Attribute name\nStr[2] = Property name",
			"Str[0] = Attribute name\nStr[1] = Property name\nStr[2] = date\nStr[3] = Property value number (array case)\nStr[4] = Property value 1\nStr[n] = Property value n",
			Tango::OPERATOR);
	command_list.push_back(pDbGetDeviceAttributePropertyHistCmd);

	//	Command DbGetDeviceClassList
	DbGetDeviceClassListClass	*pDbGetDeviceClassListCmd =
		new DbGetDeviceClassListClass("DbGetDeviceClassList",
			Tango::DEV_STRING, Tango::DEVVAR_STRINGARRAY,
			"Device server process name",
			"Str[0] = Device name\nStr[1] = Tango class\nStr[n] = Device name\nStr[n + 1] = Tango class",
			Tango::OPERATOR);
	command_list.push_back(pDbGetDeviceClassListCmd);

	//	Command DbGetDeviceDomainList
	DbGetDeviceDomainListClass	*pDbGetDeviceDomainListCmd =
		new DbGetDeviceDomainListClass("DbGetDeviceDomainList",
			Tango::DEV_STRING, Tango::DEVVAR_STRINGARRAY,
			"The wildcard",
			"Device name domain list",
			Tango::OPERATOR);
	command_list.push_back(pDbGetDeviceDomainListCmd);

	//	Command DbGetDeviceExportedList
	DbGetDeviceExportedListClass	*pDbGetDeviceExportedListCmd =
		new DbGetDeviceExportedListClass("DbGetDeviceExportedList",
			Tango::DEV_STRING, Tango::DEVVAR_STRINGARRAY,
			"filter",
			"list of exported devices",
			Tango::OPERATOR);
	command_list.push_back(pDbGetDeviceExportedListCmd);

	//	Command DbGetDeviceFamilyList
	DbGetDeviceFamilyListClass	*pDbGetDeviceFamilyListCmd =
		new DbGetDeviceFamilyListClass("DbGetDeviceFamilyList",
			Tango::DEV_STRING, Tango::DEVVAR_STRINGARRAY,
			"The wildcard",
			"Family list",
			Tango::OPERATOR);
	command_list.push_back(pDbGetDeviceFamilyListCmd);

	//	Command DbGetDeviceInfo
	DbGetDeviceInfoClass	*pDbGetDeviceInfoCmd =
		new DbGetDeviceInfoClass("DbGetDeviceInfo",
			Tango::DEV_STRING, Tango::DEVVAR_LONGSTRINGARRAY,
			"Device name",
			"Str[0] = Device name\nStr[1] = CORBA IOR\nStr[2] = Device version\nStr[3] = Device Server name\nStr[4] = Device Server process host name\nStr[5] = Started date (or ? if not set)\nStr[6] = Stopped date (or ? if not set)\nStr[7] = Device class\n\nLg[0] = Device exported flag\nLg[1] = Device Server process PID (or -1 if not set)",
			Tango::OPERATOR);
	command_list.push_back(pDbGetDeviceInfoCmd);

	//	Command DbGetDeviceList
	DbGetDeviceListClass	*pDbGetDeviceListCmd =
		new DbGetDeviceListClass("DbGetDeviceList",
			Tango::DEVVAR_STRINGARRAY, Tango::DEVVAR_STRINGARRAY,
			"argin[0] : server name\nargin[1] : class name",
			"The list of devices for specified server and class.",
			Tango::OPERATOR);
	command_list.push_back(pDbGetDeviceListCmd);

	//	Command DbGetDeviceWideList
	DbGetDeviceWideListClass	*pDbGetDeviceWideListCmd =
		new DbGetDeviceWideListClass("DbGetDeviceWideList",
			Tango::DEV_STRING, Tango::DEVVAR_STRINGARRAY,
			"filter",
			"list of exported devices",
			Tango::OPERATOR);
	command_list.push_back(pDbGetDeviceWideListCmd);

	//	Command DbGetDeviceMemberList
	DbGetDeviceMemberListClass	*pDbGetDeviceMemberListCmd =
		new DbGetDeviceMemberListClass("DbGetDeviceMemberList",
			Tango::DEV_STRING, Tango::DEVVAR_STRINGARRAY,
			"The filter",
			"Device names member list",
			Tango::OPERATOR);
	command_list.push_back(pDbGetDeviceMemberListCmd);

	//	Command DbGetDeviceProperty
	DbGetDevicePropertyClass	*pDbGetDevicePropertyCmd =
		new DbGetDevicePropertyClass("DbGetDeviceProperty",
			Tango::DEVVAR_STRINGARRAY, Tango::DEVVAR_STRINGARRAY,
			"Str[0] = Device name\nStr[1] = Property name\nStr[n] = Property name",
			"Str[0] = Device name\nStr[1] = Property number\nStr[2] = Property name\nStr[3] = Property value number (array case)\nStr[4] = Property value 1\nStr[n] = Property value n (array case)\nStr[n + 1] = Property name\nStr[n + 2] = Property value number (array case)\nStr[n + 3] = Property value 1\nStr[n + m] = Property value m",
			Tango::OPERATOR);
	command_list.push_back(pDbGetDevicePropertyCmd);

	//	Command DbGetDevicePropertyHist
	DbGetDevicePropertyHistClass	*pDbGetDevicePropertyHistCmd =
		new DbGetDevicePropertyHistClass("DbGetDevicePropertyHist",
			Tango::DEVVAR_STRINGARRAY, Tango::DEVVAR_STRINGARRAY,
			"Str[0] = Device name\nStr[2] = Property name",
			"Str[0] = Property name\nStr[1] = date\nStr[2] = Property value number (array case)\nStr[3] = Property value 1\nStr[n] = Property value n",
			Tango::OPERATOR);
	command_list.push_back(pDbGetDevicePropertyHistCmd);

	//	Command DbGetDevicePropertyList
	DbGetDevicePropertyListClass	*pDbGetDevicePropertyListCmd =
		new DbGetDevicePropertyListClass("DbGetDevicePropertyList",
			Tango::DEVVAR_STRINGARRAY, Tango::DEVVAR_STRINGARRAY,
			"Str[0] = device name\nStr[1] = Filter",
			"Property name list",
			Tango::OPERATOR);
	command_list.push_back(pDbGetDevicePropertyListCmd);

	//	Command DbGetDeviceServerClassList
	DbGetDeviceServerClassListClass	*pDbGetDeviceServerClassListCmd =
		new DbGetDeviceServerClassListClass("DbGetDeviceServerClassList",
			Tango::DEV_STRING, Tango::DEVVAR_STRINGARRAY,
			"device server process name",
			"list of classes for this device server",
			Tango::OPERATOR);
	command_list.push_back(pDbGetDeviceServerClassListCmd);

	//	Command DbGetExportdDeviceListForClass
	DbGetExportdDeviceListForClassClass	*pDbGetExportdDeviceListForClassCmd =
		new DbGetExportdDeviceListForClassClass("DbGetExportdDeviceListForClass",
			Tango::DEV_STRING, Tango::DEVVAR_STRINGARRAY,
			"Class name",
			"Device exported list",
			Tango::OPERATOR);
	command_list.push_back(pDbGetExportdDeviceListForClassCmd);

	//	Command DbGetHostList
	DbGetHostListClass	*pDbGetHostListCmd =
		new DbGetHostListClass("DbGetHostList",
			Tango::DEV_STRING, Tango::DEVVAR_STRINGARRAY,
			"The filter",
			"Host name list",
			Tango::OPERATOR);
	command_list.push_back(pDbGetHostListCmd);

	//	Command DbGetHostServerList
	DbGetHostServerListClass	*pDbGetHostServerListCmd =
		new DbGetHostServerListClass("DbGetHostServerList",
			Tango::DEV_STRING, Tango::DEVVAR_STRINGARRAY,
			"The filter",
			"Device server process name list",
			Tango::OPERATOR);
	command_list.push_back(pDbGetHostServerListCmd);

	//	Command DbGetHostServersInfo
	DbGetHostServersInfoClass	*pDbGetHostServersInfoCmd =
		new DbGetHostServersInfoClass("DbGetHostServersInfo",
			Tango::DEV_STRING, Tango::DEVVAR_STRINGARRAY,
			"Host name",
			"Server info for all servers running on specified host",
			Tango::OPERATOR);
	command_list.push_back(pDbGetHostServersInfoCmd);

	//	Command DbGetInstanceNameList
	DbGetInstanceNameListClass	*pDbGetInstanceNameListCmd =
		new DbGetInstanceNameListClass("DbGetInstanceNameList",
			Tango::DEV_STRING, Tango::DEVVAR_STRINGARRAY,
			"Server name",
			"The instance names found for specified server.",
			Tango::OPERATOR);
	command_list.push_back(pDbGetInstanceNameListCmd);

	//	Command DbGetObjectList
	DbGetObjectListClass	*pDbGetObjectListCmd =
		new DbGetObjectListClass("DbGetObjectList",
			Tango::DEV_STRING, Tango::DEVVAR_STRINGARRAY,
			"The filter",
			"Object name list",
			Tango::OPERATOR);
	command_list.push_back(pDbGetObjectListCmd);

	//	Command DbGetProperty
	DbGetPropertyClass	*pDbGetPropertyCmd =
		new DbGetPropertyClass("DbGetProperty",
			Tango::DEVVAR_STRINGARRAY, Tango::DEVVAR_STRINGARRAY,
			"Str[0] = Object name\nStr[1] = Property name\nStr[n] = Property name",
			"Str[0] = Object name\nStr[1] = Property number\nStr[2] = Property name\nStr[3] = Property value number (array case)\nStr[4] = Property value 1\nStr[n] = Property value n (array case)\nStr[n + 1] = Property name\nStr[n + 2] = Property value number (array case)\nStr[n + 3] = Property value 1\nStr[n + m] = Property value m",
			Tango::OPERATOR);
	command_list.push_back(pDbGetPropertyCmd);

	//	Command DbGetPropertyHist
	DbGetPropertyHistClass	*pDbGetPropertyHistCmd =
		new DbGetPropertyHistClass("DbGetPropertyHist",
			Tango::DEVVAR_STRINGARRAY, Tango::DEVVAR_STRINGARRAY,
			"Str[0] = Object name\nStr[2] = Property name",
			"Str[0] = Property name\nStr[1] = date\nStr[2] = Property value number (array case)\nStr[3] = Property value 1\nStr[n] = Property value n",
			Tango::OPERATOR);
	command_list.push_back(pDbGetPropertyHistCmd);

	//	Command DbGetPropertyList
	DbGetPropertyListClass	*pDbGetPropertyListCmd =
		new DbGetPropertyListClass("DbGetPropertyList",
			Tango::DEVVAR_STRINGARRAY, Tango::DEVVAR_STRINGARRAY,
			"Str[0] = Object name\nStr[1] = filter",
			"Property name list",
			Tango::OPERATOR);
	command_list.push_back(pDbGetPropertyListCmd);

	//	Command DbGetServerInfo
	DbGetServerInfoClass	*pDbGetServerInfoCmd =
		new DbGetServerInfoClass("DbGetServerInfo",
			Tango::DEV_STRING, Tango::DEVVAR_STRINGARRAY,
			"server name",
			"server info",
			Tango::OPERATOR);
	command_list.push_back(pDbGetServerInfoCmd);

	//	Command DbGetServerList
	DbGetServerListClass	*pDbGetServerListCmd =
		new DbGetServerListClass("DbGetServerList",
			Tango::DEV_STRING, Tango::DEVVAR_STRINGARRAY,
			"The filter",
			"Device server process name list",
			Tango::OPERATOR);
	command_list.push_back(pDbGetServerListCmd);

	//	Command DbGetServerNameList
	DbGetServerNameListClass	*pDbGetServerNameListCmd =
		new DbGetServerNameListClass("DbGetServerNameList",
			Tango::DEV_STRING, Tango::DEVVAR_STRINGARRAY,
			"wildcard for server names.",
			"server names found.",
			Tango::OPERATOR);
	command_list.push_back(pDbGetServerNameListCmd);

	//	Command DbImportDevice
	DbImportDeviceClass	*pDbImportDeviceCmd =
		new DbImportDeviceClass("DbImportDevice",
			Tango::DEV_STRING, Tango::DEVVAR_LONGSTRINGARRAY,
			"Device name (or alias)",
			"Str[0] = device name\nStr[1] = CORBA IOR\nStr[2] = device version\nStr[3] = device server process name\nStr[4] = host name\nStr[5] = Tango class name\n\nLg[0] = Exported flag\nLg[1] = Device server process PID",
			Tango::OPERATOR);
	command_list.push_back(pDbImportDeviceCmd);

	//	Command DbImportEvent
	DbImportEventClass	*pDbImportEventCmd =
		new DbImportEventClass("DbImportEvent",
			Tango::DEV_STRING, Tango::DEVVAR_LONGSTRINGARRAY,
			"name of event channel or factory",
			"export information e.g. IOR",
			Tango::OPERATOR);
	command_list.push_back(pDbImportEventCmd);

	//	Command DbInfo
	DbInfoClass	*pDbInfoCmd =
		new DbInfoClass("DbInfo",
			Tango::DEV_VOID, Tango::DEVVAR_STRINGARRAY,
			"",
			"Miscellaneous info like:\n- Device defined in database\n- Device marked as exported in database\n- Device server process defined in database\n- Device server process marked as exported in database\n- Device properties defined in database\n- Class properties defined in database\n- Device attribute properties defined in database\n- Class attribute properties defined in database\n- Object properties defined in database",
			Tango::OPERATOR);
	command_list.push_back(pDbInfoCmd);

	//	Command DbPutAttributeAlias
	DbPutAttributeAliasClass	*pDbPutAttributeAliasCmd =
		new DbPutAttributeAliasClass("DbPutAttributeAlias",
			Tango::DEVVAR_STRINGARRAY, Tango::DEV_VOID,
			"Str[0] = attribute name\nStr[1] = attribute alias",
			"",
			Tango::OPERATOR);
	command_list.push_back(pDbPutAttributeAliasCmd);

	//	Command DbPutClassAttributeProperty
	DbPutClassAttributePropertyClass	*pDbPutClassAttributePropertyCmd =
		new DbPutClassAttributePropertyClass("DbPutClassAttributeProperty",
			Tango::DEVVAR_STRINGARRAY, Tango::DEV_VOID,
			"Str[0] = Tango class name\nStr[1] = Attribute number\nStr[2] = Attribute name\nStr[3] = Property number\nStr[4] = Property name\nStr[5] = Property value\n.....",
			"",
			Tango::OPERATOR);
	command_list.push_back(pDbPutClassAttributePropertyCmd);

	//	Command DbPutClassAttributeProperty2
	DbPutClassAttributeProperty2Class	*pDbPutClassAttributeProperty2Cmd =
		new DbPutClassAttributeProperty2Class("DbPutClassAttributeProperty2",
			Tango::DEVVAR_STRINGARRAY, Tango::DEV_VOID,
			"Str[0] = Tango class name\nStr[1] = Attribute number\nStr[2] = Attribute name\nStr[3] = Property number\nStr[4] = Property name\nStr[5] = Property value number (array case)\nStr[5] = Property value 1\nStr[n] = Property value n (array case)\n.....",
			"",
			Tango::OPERATOR);
	command_list.push_back(pDbPutClassAttributeProperty2Cmd);

	//	Command DbPutClassProperty
	DbPutClassPropertyClass	*pDbPutClassPropertyCmd =
		new DbPutClassPropertyClass("DbPutClassProperty",
			Tango::DEVVAR_STRINGARRAY, Tango::DEV_VOID,
			"Str[0] = Tango class name\nStr[1] = Property number\nStr[2] = Property name\nStr[3] = Property value number\nStr[4] = Property value 1\nStr[n] = Property value n\n....",
			"",
			Tango::OPERATOR);
	command_list.push_back(pDbPutClassPropertyCmd);

	//	Command DbPutDeviceAlias
	DbPutDeviceAliasClass	*pDbPutDeviceAliasCmd =
		new DbPutDeviceAliasClass("DbPutDeviceAlias",
			Tango::DEVVAR_STRINGARRAY, Tango::DEV_VOID,
			"Str[0] = device name\nStr[1] = alias name",
			"",
			Tango::OPERATOR);
	command_list.push_back(pDbPutDeviceAliasCmd);

	//	Command DbPutDeviceAttributeProperty
	DbPutDeviceAttributePropertyClass	*pDbPutDeviceAttributePropertyCmd =
		new DbPutDeviceAttributePropertyClass("DbPutDeviceAttributeProperty",
			Tango::DEVVAR_STRINGARRAY, Tango::DEV_VOID,
			"Str[0] = Device name\nStr[1] = Attribute number\nStr[2] = Attribute name\nStr[3] = Property number\nStr[4] = Property name\nStr[5] = Property value\n.....",
			"",
			Tango::OPERATOR);
	command_list.push_back(pDbPutDeviceAttributePropertyCmd);

	//	Command DbPutDeviceAttributeProperty2
	DbPutDeviceAttributeProperty2Class	*pDbPutDeviceAttributeProperty2Cmd =
		new DbPutDeviceAttributeProperty2Class("DbPutDeviceAttributeProperty2",
			Tango::DEVVAR_STRINGARRAY, Tango::DEV_VOID,
			"Str[0] = Device name\nStr[1] = Attribute number\nStr[2] = Attribute name\nStr[3] = Property number\nStr[4] = Property name\nStr[5] = Property value number (array case)\nStr[5] = Property value 1\nStr[n] = Property value n (array case)\n.....",
			"",
			Tango::OPERATOR);
	command_list.push_back(pDbPutDeviceAttributeProperty2Cmd);

	//	Command DbPutDeviceProperty
	DbPutDevicePropertyClass	*pDbPutDevicePropertyCmd =
		new DbPutDevicePropertyClass("DbPutDeviceProperty",
			Tango::DEVVAR_STRINGARRAY, Tango::DEV_VOID,
			"Str[0] = Tango device name\nStr[1] = Property number\nStr[2] = Property name\nStr[3] = Property value number\nStr[4] = Property value 1\nStr[n] = Property value n\n....",
			"",
			Tango::OPERATOR);
	command_list.push_back(pDbPutDevicePropertyCmd);

	//	Command DbPutProperty
	DbPutPropertyClass	*pDbPutPropertyCmd =
		new DbPutPropertyClass("DbPutProperty",
			Tango::DEVVAR_STRINGARRAY, Tango::DEV_VOID,
			"Str[0] = Object name\nStr[1] = Property number\nStr[2] = Property name\nStr[3] = Property value number\nStr[4] = Property value 1\nStr[n] = Property value n\n....",
			"",
			Tango::OPERATOR);
	command_list.push_back(pDbPutPropertyCmd);

	//	Command DbPutServerInfo
	DbPutServerInfoClass	*pDbPutServerInfoCmd =
		new DbPutServerInfoClass("DbPutServerInfo",
			Tango::DEVVAR_STRINGARRAY, Tango::DEV_VOID,
			"server info",
			"",
			Tango::OPERATOR);
	command_list.push_back(pDbPutServerInfoCmd);

	//	Command DbUnExportDevice
	DbUnExportDeviceClass	*pDbUnExportDeviceCmd =
		new DbUnExportDeviceClass("DbUnExportDevice",
			Tango::DEV_STRING, Tango::DEV_VOID,
			"Device name",
			"",
			Tango::OPERATOR);
	command_list.push_back(pDbUnExportDeviceCmd);

	//	Command DbUnExportEvent
	DbUnExportEventClass	*pDbUnExportEventCmd =
		new DbUnExportEventClass("DbUnExportEvent",
			Tango::DEV_STRING, Tango::DEV_VOID,
			"name of event channel or factory to unexport",
			"none",
			Tango::OPERATOR);
	command_list.push_back(pDbUnExportEventCmd);

	//	Command DbUnExportServer
	DbUnExportServerClass	*pDbUnExportServerCmd =
		new DbUnExportServerClass("DbUnExportServer",
			Tango::DEV_STRING, Tango::DEV_VOID,
			"Device server name (executable/instance)",
			"",
			Tango::OPERATOR);
	command_list.push_back(pDbUnExportServerCmd);

	//	Command ResetTimingValues
	ResetTimingValuesClass	*pResetTimingValuesCmd =
		new ResetTimingValuesClass("ResetTimingValues",
			Tango::DEV_VOID, Tango::DEV_VOID,
			"",
			"",
			Tango::OPERATOR);
	command_list.push_back(pResetTimingValuesCmd);

	//	Command DbGetDataForServerCache
	DbGetDataForServerCacheClass	*pDbGetDataForServerCacheCmd =
		new DbGetDataForServerCacheClass("DbGetDataForServerCache",
			Tango::DEVVAR_STRINGARRAY, Tango::DEVVAR_STRINGARRAY,
			"Elt[0] = DS name (exec_name/inst_name), Elt[1] = Host name",
			"All the data needed by the device server during its startup sequence. Precise list depend on the device server",
			Tango::OPERATOR);
	command_list.push_back(pDbGetDataForServerCacheCmd);

	//	Command DbDeleteAllDeviceAttributeProperty
	DbDeleteAllDeviceAttributePropertyClass	*pDbDeleteAllDeviceAttributePropertyCmd =
		new DbDeleteAllDeviceAttributePropertyClass("DbDeleteAllDeviceAttributeProperty",
			Tango::DEVVAR_STRINGARRAY, Tango::DEV_VOID,
			"str[0] = device name\nStr[1]...str[n] = attribute name(s)",
			"",
			Tango::OPERATOR);
	command_list.push_back(pDbDeleteAllDeviceAttributePropertyCmd);

	//	Command DbMySqlSelect
	DbMySqlSelectClass	*pDbMySqlSelectCmd =
		new DbMySqlSelectClass("DbMySqlSelect",
			Tango::DEV_STRING, Tango::DEVVAR_LONGSTRINGARRAY,
			"MySql Select command",
			"MySql Select command result\n - svalues : select results\n - lvalue[n] : =0 if svalue[n] is null else =1\n (last lvalue -1) is number of rows, (last lvalue) is number of fields",
			Tango::OPERATOR);
	command_list.push_back(pDbMySqlSelectCmd);

	//	Command DbGetCSDbServerList
	DbGetCSDbServerListClass	*pDbGetCSDbServerListCmd =
		new DbGetCSDbServerListClass("DbGetCSDbServerList",
			Tango::DEV_VOID, Tango::DEVVAR_STRINGARRAY,
			"",
			"List of host:port with one element for each database server",
			Tango::OPERATOR);
	command_list.push_back(pDbGetCSDbServerListCmd);

	//	Command DbGetAttributeAlias2
	DbGetAttributeAlias2Class	*pDbGetAttributeAlias2Cmd =
		new DbGetAttributeAlias2Class("DbGetAttributeAlias2",
			Tango::DEV_STRING, Tango::DEV_STRING,
			"The attribute name (dev_name/att_name)",
			"The attribute alias name (or empty string)",
			Tango::OPERATOR);
	command_list.push_back(pDbGetAttributeAlias2Cmd);

	//	Command DbGetAliasAttribute
	DbGetAliasAttributeClass	*pDbGetAliasAttributeCmd =
		new DbGetAliasAttributeClass("DbGetAliasAttribute",
			Tango::DEV_STRING, Tango::DEV_STRING,
			"The attribute alias",
			"The attribute name (dev_name/att_name)",
			Tango::OPERATOR);
	command_list.push_back(pDbGetAliasAttributeCmd);

	//	Command DbRenameServer
	DbRenameServerClass	*pDbRenameServerCmd =
		new DbRenameServerClass("DbRenameServer",
			Tango::DEVVAR_STRINGARRAY, Tango::DEV_VOID,
			"s[0] = old device server name (exec/instance)\ns[1] = new device server name (exec/instance)",
			"",
			Tango::OPERATOR);
	command_list.push_back(pDbRenameServerCmd);

	//	Command DbGetClassPipeProperty
	DbGetClassPipePropertyClass	*pDbGetClassPipePropertyCmd =
		new DbGetClassPipePropertyClass("DbGetClassPipeProperty",
			Tango::DEVVAR_STRINGARRAY, Tango::DEVVAR_STRINGARRAY,
			"Str[0] = Tango class name\nStr[1] = Pipe name\nStr[n] = Pipe name",
			"Str[0] = Tango class name\nStr[1] = Pipe property  number\nStr[2] = Pipe property 1 name\nStr[3] = Pipe property 1 value number (array case)\nStr[4] = Pipe property 1 value\nStr[n] = Pipe property 1 value (array case)\nStr[n + 1] = Pipe property 2 name\nStr[n + 2] = Pipe property 2 value number (array case)\nStr[n + 3] = Pipe property 2 value\nStr[n + m] = Pipe property 2 value (array case)",
			Tango::OPERATOR);
	command_list.push_back(pDbGetClassPipePropertyCmd);

	//	Command DbGetDevicePipeProperty
	DbGetDevicePipePropertyClass	*pDbGetDevicePipePropertyCmd =
		new DbGetDevicePipePropertyClass("DbGetDevicePipeProperty",
			Tango::DEVVAR_STRINGARRAY, Tango::DEVVAR_STRINGARRAY,
			"Str[0] = Device name\nStr[1] = Pipe name\nStr[n] = Pipe name",
			"Str[0] = Device name\nStr[1] = Pipe property  number\nStr[2] = Pipe property 1 name\nStr[3] = Pipe property 1 value number (array case)\nStr[4] = Pipe property 1 value\nStr[n] = Pipe property 1 value (array case)\nStr[n + 1] = Pipe property 2 name\nStr[n + 2] = Pipe property 2 value number (array case)\nStr[n + 3] = Pipe property 2 value\nStr[n + m] = Pipe property 2 value (array case)",
			Tango::OPERATOR);
	command_list.push_back(pDbGetDevicePipePropertyCmd);

	//	Command DbDeleteClassPipe
	DbDeleteClassPipeClass	*pDbDeleteClassPipeCmd =
		new DbDeleteClassPipeClass("DbDeleteClassPipe",
			Tango::DEVVAR_STRINGARRAY, Tango::DEV_VOID,
			"Str[0] = Tango class name\nStr[1] = Pipe name",
			"",
			Tango::OPERATOR);
	command_list.push_back(pDbDeleteClassPipeCmd);

	//	Command DbDeleteDevicePipe
	DbDeleteDevicePipeClass	*pDbDeleteDevicePipeCmd =
		new DbDeleteDevicePipeClass("DbDeleteDevicePipe",
			Tango::DEVVAR_STRINGARRAY, Tango::DEV_VOID,
			"Str[0] = Device name\nStr[1] = Pipe name",
			"",
			Tango::OPERATOR);
	command_list.push_back(pDbDeleteDevicePipeCmd);

	//	Command DbDeleteClassPipeProperty
	DbDeleteClassPipePropertyClass	*pDbDeleteClassPipePropertyCmd =
		new DbDeleteClassPipePropertyClass("DbDeleteClassPipeProperty",
			Tango::DEVVAR_STRINGARRAY, Tango::DEV_VOID,
			"Str[0] = Tango class name\nStr[1] = Pipe name\nStr[2] = Property name\nStr[n] = Property name",
			"",
			Tango::OPERATOR);
	command_list.push_back(pDbDeleteClassPipePropertyCmd);

	//	Command DbDeleteDevicePipeProperty
	DbDeleteDevicePipePropertyClass	*pDbDeleteDevicePipePropertyCmd =
		new DbDeleteDevicePipePropertyClass("DbDeleteDevicePipeProperty",
			Tango::DEVVAR_STRINGARRAY, Tango::DEV_VOID,
			"Str[0] = Device name\nStr[1] = Pipe name\nStr[2] = Property name\nStr[n] = Property name",
			"",
			Tango::OPERATOR);
	command_list.push_back(pDbDeleteDevicePipePropertyCmd);

	//	Command DbGetClassPipeList
	DbGetClassPipeListClass	*pDbGetClassPipeListCmd =
		new DbGetClassPipeListClass("DbGetClassPipeList",
			Tango::DEVVAR_STRINGARRAY, Tango::DEVVAR_STRINGARRAY,
			"Str[0] = Tango class name\nStr[1] = Pipe name filter (eg: pip*)",
			"Str[0] = Class pipe name\nStr[n] = Class pipe name",
			Tango::OPERATOR);
	command_list.push_back(pDbGetClassPipeListCmd);

	//	Command DbGetDevicePipeList
	DbGetDevicePipeListClass	*pDbGetDevicePipeListCmd =
		new DbGetDevicePipeListClass("DbGetDevicePipeList",
			Tango::DEVVAR_STRINGARRAY, Tango::DEVVAR_STRINGARRAY,
			"Str[0] = Device name\nStr[1] = Wildcard",
			"Pipe name list",
			Tango::OPERATOR);
	command_list.push_back(pDbGetDevicePipeListCmd);

	//	Command DbDeleteAllDevicePipeProperty
	DbDeleteAllDevicePipePropertyClass	*pDbDeleteAllDevicePipePropertyCmd =
		new DbDeleteAllDevicePipePropertyClass("DbDeleteAllDevicePipeProperty",
			Tango::DEVVAR_STRINGARRAY, Tango::DEV_VOID,
			"str[0] = device name\nStr[1]...str[n] = pipe name(s)",
			"",
			Tango::OPERATOR);
	command_list.push_back(pDbDeleteAllDevicePipePropertyCmd);

	//	Command DbPutClassPipeProperty
	DbPutClassPipePropertyClass	*pDbPutClassPipePropertyCmd =
		new DbPutClassPipePropertyClass("DbPutClassPipeProperty",
			Tango::DEVVAR_STRINGARRAY, Tango::DEV_VOID,
			"Str[0] = Tango class name\nStr[1] = Pipe number\nStr[2] = Pipe name\nStr[3] = Property number\nStr[4] = Property name\nStr[5] = Property value number (array case)\nStr[5] = Property value 1\nStr[n] = Property value n (array case)",
			"",
			Tango::OPERATOR);
	command_list.push_back(pDbPutClassPipePropertyCmd);

	//	Command DbPutDevicePipeProperty
	DbPutDevicePipePropertyClass	*pDbPutDevicePipePropertyCmd =
		new DbPutDevicePipePropertyClass("DbPutDevicePipeProperty",
			Tango::DEVVAR_STRINGARRAY, Tango::DEV_VOID,
			"Str[0] = Device name\nStr[1] = Pipe number\nStr[2] = Pipe name\nStr[3] = Property number\nStr[4] = Property name\nStr[5] = Property value number (array case)\nStr[6] = Property value 1\nStr[n] = Property value n (array case)",
			"",
			Tango::OPERATOR);
	command_list.push_back(pDbPutDevicePipePropertyCmd);

	//	Command DbGetClassPipePropertyHist
	DbGetClassPipePropertyHistClass	*pDbGetClassPipePropertyHistCmd =
		new DbGetClassPipePropertyHistClass("DbGetClassPipePropertyHist",
			Tango::DEVVAR_STRINGARRAY, Tango::DEVVAR_STRINGARRAY,
			"Str[0] = Tango class\nStr[1] = Pipe name\nStr[2] = Property name",
			"Str[0] = Pipe name\nStr[1] = Property name\nStr[2] = date\nStr[3] = Property value number (array case)\nStr[4] = Property value 1\nStr[n] = Property value n",
			Tango::OPERATOR);
	command_list.push_back(pDbGetClassPipePropertyHistCmd);

	//	Command DbGetDevicePipePropertyHist
	DbGetDevicePipePropertyHistClass	*pDbGetDevicePipePropertyHistCmd =
		new DbGetDevicePipePropertyHistClass("DbGetDevicePipePropertyHist",
			Tango::DEVVAR_STRINGARRAY, Tango::DEVVAR_STRINGARRAY,
			"Str[0] = Device name\nStr[1] = Pipe name\nStr[2] = Property name",
			"Str[0] = Pipe name\nStr[1] = Property name\nStr[2] = date\nStr[3] = Property value number (array case)\nStr[4] = Property value 1\nStr[n] = Property value n",
			Tango::OPERATOR);
	command_list.push_back(pDbGetDevicePipePropertyHistCmd);

	//	Command DbGetForwardedAttributeListForDevice
	DbGetForwardedAttributeListForDeviceClass	*pDbGetForwardedAttributeListForDeviceCmd =
		new DbGetForwardedAttributeListForDeviceClass("DbGetForwardedAttributeListForDevice",
			Tango::DEV_STRING, Tango::DEVVAR_STRINGARRAY,
			"The specified device name",
			"argout[n]     : device name\nargout[n+1] :the forwardef attribute\nargout[n+2] :the root attribute (__root_att)",
			Tango::OPERATOR);
	command_list.push_back(pDbGetForwardedAttributeListForDeviceCmd);

	/*----- PROTECTED REGION ID(DataBaseClass::command_factory_after) ENABLED START -----*/

	/*----- PROTECTED REGION END -----*/	//	DataBaseClass::command_factory_after
}

//===================================================================
//	Dynamic attributes related methods
//===================================================================

//--------------------------------------------------------
/**
 * method : 		DataBaseClass::create_static_attribute_list
 * description : 	Create the a list of static attributes
 *
 * @param	att_list	the ceated attribute list
 */
//--------------------------------------------------------
void DataBaseClass::create_static_attribute_list(vector<Tango::Attr *> &att_list)
{
	for (unsigned long i=0 ; i<att_list.size() ; i++)
	{
		string att_name(att_list[i]->get_name());
		transform(att_name.begin(), att_name.end(), att_name.begin(), ::tolower);
		defaultAttList.push_back(att_name);
	}

	cout2 << defaultAttList.size() << " attributes in default list" << endl;

	/*----- PROTECTED REGION ID(DataBaseClass::create_static_att_list) ENABLED START -----*/

	/*----- PROTECTED REGION END -----*/	//	DataBaseClass::create_static_att_list
}


//--------------------------------------------------------
/**
 * method : 		DataBaseClass::erase_dynamic_attributes
 * description : 	delete the dynamic attributes if any.
 *
 * @param	devlist_ptr	the device list pointer
 * @param	list of all attributes
 */
//--------------------------------------------------------
void DataBaseClass::erase_dynamic_attributes(const Tango::DevVarStringArray *devlist_ptr, vector<Tango::Attr *> &att_list)
{
	Tango::Util *tg = Tango::Util::instance();

	for (unsigned long i=0 ; i<devlist_ptr->length() ; i++)
	{
		Tango::DeviceImpl *dev_impl = tg->get_device_by_name(((string)(*devlist_ptr)[i]).c_str());
		DataBase *dev = static_cast<DataBase *> (dev_impl);

		vector<Tango::Attribute *> &dev_att_list = dev->get_device_attr()->get_attribute_list();
		vector<Tango::Attribute *>::iterator ite_att;
		for (ite_att=dev_att_list.begin() ; ite_att != dev_att_list.end() ; ++ite_att)
		{
			string att_name((*ite_att)->get_name_lower());
			if ((att_name == "state") || (att_name == "status"))
				continue;
			vector<string>::iterator ite_str = find(defaultAttList.begin(), defaultAttList.end(), att_name);
			if (ite_str == defaultAttList.end())
			{
				cout2 << att_name << " is a UNWANTED dynamic attribute for device " << (*devlist_ptr)[i] << endl;
				Tango::Attribute &att = dev->get_device_attr()->get_attr_by_name(att_name.c_str());
				dev->remove_attribute(att_list[att.get_attr_idx()], true, false);
				--ite_att;
			}
		}
	}
	/*----- PROTECTED REGION ID(DataBaseClass::erase_dynamic_attributes) ENABLED START -----*/

	/*----- PROTECTED REGION END -----*/	//	DataBaseClass::erase_dynamic_attributes
}

//--------------------------------------------------------
/**
 *	Method      : DataBaseClass::get_attr_by_name()
 *	Description : returns Tango::Attr * object found by name
 */
//--------------------------------------------------------
Tango::Attr *DataBaseClass::get_attr_object_by_name(vector<Tango::Attr *> &att_list, string attname)
{
	vector<Tango::Attr *>::iterator it;
	for (it=att_list.begin() ; it<att_list.end() ; ++it)
		if ((*it)->get_name()==attname)
			return (*it);
	//	Attr does not exist
	return NULL;
}


/*----- PROTECTED REGION ID(DataBaseClass::Additional Methods) ENABLED START -----*/

	/*----- PROTECTED REGION END -----*/	//	DataBaseClass::Additional Methods
} //	namespace
