from enum import Enum


class SoundFile(Enum):
    """
    Paths to standard EV3 sounds.

    Note:
        Expressions: BOING, BOO, CHEERING, CRUNCHING, CRYING, FANFARE, KUNG_FU, LAUGHING_1, LAUGHING_2, MAGIC_WAND, OUCH, SHOUTING, SMACK, SNEEZING, SNORING, UH_OH

        Information: ACTIVATE, ANALYZE, BACKWARDS, COLOR, DETECTED, DOWN, ERROR, ERROR_ALARM, FLASHING, FORWARD, LEFT, OBJECT, RIGHT, SEARCHING, START, STOP, TOUCH, TURN, UP

        Communication: BRAVO, EV3, FANTASTIC, GAME_OVER, GO, GOOD_JOB, GOOD, GOODBYE, HELLO, HI, LEGO, MINDSTORMS,MORNING, NO, OKAY, OKEY_DOKEY, SORRY, THANK_YOU, YES

        Movements: SPEED_DOWN, SPEED_IDLE, SPEED_UP

        Color: BLACK, BLUE, BROWN, GREEN, RED, WHITE, YELLOW

        Mechanical: AIR_RELEASE, AIRBRAKE, BACKING_ALERT, HORN_1, HORN_2, LASER, MOTOR_IDLE, MOTOR_START, MOTOR_STOP, RATCHET, SONAR, TICK_TACK

        Animal sounds: CAT_PURR, DOG_BARK_1, DOG_BARK_2, DOG_GROWL, DOG_SNIFF, DOG_WHINE, ELEPHANT_CALL, INSECT_BUZZ_1,INSECT_BUZZ_2, INSECT_CHIRP, SNAKE_HISS, SNAKE_RATTLE, T_REX_ROAR

        Numbers: ZERO, ONE, TWO, THREE, FOUR, FIVE, SIX, SEVEN, EIGHT, NINE, TEN

        System sounds: CLICK, CONFIRM, GENERAL_ALERT, OVERPOWER, READY
    """
    BOING = "BOING"
    BOO = "BOO"
    CHEERING = "CHEERING"
    CRUNCHING = "CRUNCHING"
    CRYING = "CRYING"
    FANFARE = "FANFARE"
    KUNG_FU = "KUNG_FU"
    LAUGHING_1 = "LAUGHING_1"
    LAUGHING_2 = "LAUGHING_2"
    MAGIC_WAND = "MAGIC_WAND"
    OUCH = "OUCH"
    SHOUTING = "SHOUTING"
    SMACK = "SMACK"
    SNEEZING = "SNEEZING"
    SNORING = "SNORING"
    UH_OH = "UH_OH"

    ACTIVATE = "ACTIVATE"
    ANALYZE = "ANALYZE"
    BACKWARDS = "BACKWARDS"
    COLOR = "COLOR"
    DETECTED = "DETECTED"
    DOWN = "DOWN"
    ERROR = "ERROR"
    ERROR_ALARM = "ERROR_ALARM"
    FLASHING = "FLASHING"
    FORWARD = "FORWARD"
    LEFT = "LEFT"
    OBJECT = "OBJECT"
    RIGHT = "RIGHT"
    SEARCHING = "SEARCHING"
    START = "START"
    STOP = "STOP"
    TOUCH = "TOUCH"
    TURN = "TURN"
    UP = "UP"

    BRAVO = "BRAVO"
    EV3 = "EV3"
    FANTASTIC = "FANTASTIC"
    GAME_OVER = "GAME_OVER"
    GO = "GO"
    GOOD_JOB = "GOOD_JOB"
    GOOD = "GOOD"
    GOODBYE = "GOODBYE"
    HELLO = "HELLO"
    HI = "HI"
    LEGO = "LEGO"
    MINDSTORMS = "MINDSTORMS"
    MORNING = "MORNING"
    NO = "NO"
    OKAY = "OKAY"
    OKEY_DOKEY = "OKEY_DOKEY"
    SORRY = "SORRY"
    THANK_YOU = "THANK_YOU"
    YES = "YES"

    SPEED_DOWN = "SPEED_DOWN"
    SPEED_IDLE = "SPEED_IDLE"
    SPEED_UP = "SPEED_UP"

    BLACK = "BLACK"
    BLUE = "BLUE"
    BROWN = "BROWN"
    GREEN = "GREEN"
    RED = "RED"
    WHITE = "WHITE"
    YELLOW = "YELLOW"

    AIR_RELEASE = "AIR_RELEASE"
    AIRBRAKE = "AIRBRAKE"
    BACKING_ALERT = "BACKING_ALERT"
    HORN_1 = "HORN_1"
    HORN_2 = "HORN_2"
    LASER = "LASER"
    MOTOR_IDLE = "MOTOR_IDLE"
    MOTOR_START = "MOTOR_START"
    MOTOR_STOP = "MOTOR_STOP"
    RATCHET = "RATCHET"
    SONAR = "SONAR"
    TICK_TACK = "TICK_TACK"

    CAT_PURR = "CAT_PURR"
    DOG_BARK_1 = "DOG_BARK_1"
    DOG_BARK_2 = "DOG_BARK_2"
    DOG_GROWL = "DOG_GROWL"
    DOG_SNIFF = "DOG_SNIFF"
    DOG_WHINE = "DOG_WHINE"
    ELEPHANT_CALL = "ELEPHANT_CALL"
    INSECT_BUZZ_1 = "INSECT_BUZZ_1"
    INSECT_BUZZ_2 = "INSECT_BUZZ_2"
    INSECT_CHIRP = "INSECT_CHIRP"
    SNAKE_HISS = "SNAKE_HISS"
    SNAKE_RATTLE = "SNAKE_RATTLE"
    T_REX_ROAR = "T_REX_ROAR"

    ZERO = "ZERO"
    ONE = "ONE"
    TWO = "TWO"
    THREE = "THREE"
    FOUR = "FOUR"
    FIVE = "FIVE"
    SIX = "SIX"
    SEVEN = "SEVEN"
    EIGHT = "EIGHT"
    NINE = "NINE"
    TEN = "TEN"

    CLICK = "CLICK"
    CONFIRM = "CONFIRM"
    GENERAL_ALERT = "GENERAL_ALERT"
    OVERPOWER = "OVERPOWER"
    READY = "READY"
