#!/usr/bin/perl
#*
#*******************************************************************************
#*   Copyright (C) 2004, International Business Machines
#*   Corporation and others.  All Rights Reserved.
#*******************************************************************************
#*
#*   file name:  gendraft.pl
#*   encoding:   US-ASCII
#*   tab size:   8 (not used)
#*   indentation:4
#*
#*   Created by: Ram Viswanadha
#*
#*  This tool filters the DraftAPI txt file generated by Doxygen and generates udarft.h
#*  udeprctd.h and uobslete.h
#*

use File::Find;
use File::Basename;
use IO::File;
use Cwd;
use File::Copy;
use Getopt::Long;
use File::Path;
use File::Copy;

$draftHeaderName = "udraft.h";
$draftAppend = "DRAFT_API_DO_NOT_USE";
$draftDefine = "U_HIDE_DRAFT_API";

$deprecatedHeaderName = "udeprctd.h";
$deprecatedAppend = "DEPRECATED_API_DO_NOT_USE";
$deprecatedDefine = "U_HIDE_DEPRECATED_API";

$obsoleteHeaderName = "uobslete.h";
$obsoleteAppend = "OBSOLETE_API_DO_NOT_USE";
$obsoleteDefine = "U_HIDE_OBSOLETE_API";

$versionAppend="";

#run the program
main();

#---------------------------------------------------------------------
# The main program

sub main(){
  GetOptions(
           "--draft-file=s" => \$draftFile,
           "--deprecated-file=s" => \$deprecatedFile,
           "--obsolete-file=s" => \$obsoleteFile,
           "--destdir=s" => \$destDir,
           "--version=s"  => \$version,
           );
  usage() unless defined $draftFile;
  usage() unless defined $deprecatedFile;
  usage() unless defined $obsoleteFile;
  usage() unless defined $destDir;
  usage() unless defined $version;
  
  $versionAppend = $version;
  $versionAppend=~ s/\./_/;

  writeFile($draftFile, $draftHeaderName, $destDir, $draftAppend, $draftDefine);
  writeFile($deprecatedFile, $deprecatedHeaderName, $destDir, $deprecatedAppend, $deprecatedDefine);
  writeFile($obsoleteFile, $obsoleteHeaderName, $destDir, $obsoleteAppend, $obsoleteDefine);
}

#-----------------------------------------------------------------------
sub getHeaderDef{
    ($headerName) = @_;
    $headerDef = uc($headerName);  # this is building the constant for #define
    $headerDef =~ s/\./_/;
    return $headerDef;
}

#-----------------------------------------------------------------------
sub writeFile{
  ($inFileName,$outFileName,$destDir, $symbolAppend, $symbolDef) = @_;

  $outFN = $destDir."/".$outFileName;

  $inFH = IO::File->new($inFileName,"r")
            or die  "could not open the file $infile for reading: $! \n";
  $outFH = IO::File->new($outFN,"w")
            or die  "could not open the file $outfile for writing: $! \n";

  $headerDef = getHeaderDef($outFileName);

  printHeader($outFH, $outFileName, $headerDef, $symbolDef);
  parseWriteFile($inFH, $outFH, $symbolAppend);
  printFooter($outFH, $headerDef, $symbolDef);
  close($inFH);
  close($outFH);
}

#-----------------------------------------------------------------------
sub printHeader{
      ($outFH, $headername, $HEADERDEF, $symbolDef) = @_;
#We will print our copyright here + warnings
print $outFH <<END_HEADER_COMMENT;
/*
*******************************************************************************
*   Copyright (C) 2004, International Business Machines
*   Corporation and others.  All Rights Reserved.
*******************************************************************************
*
*   file name:  $headername
*   encoding:   US-ASCII
*   tab size:   8 (not used)
*   indentation:4
*
*   Created by: gendraft.pl, a perl script written by Ram Viswanadha
*
*  Contains data for commenting out APIs.
*  Gets included by umachine.h
*
*  THIS FILE IS MACHINE-GENERATED, DON'T PLAY WITH IT IF YOU DON'T KNOW WHAT
*  YOU ARE DOING, OTHERWISE VERY BAD THINGS WILL HAPPEN!
*/

#ifndef $HEADERDEF
#define $HEADERDEF

#ifdef $symbolDef

END_HEADER_COMMENT
}

#-----------------------------------------------------------------------
sub parseWriteFile{
    ($inFH, $outFH, $symbolAppend) = @_;
    while (defined ($line = <$inFH>)){
          ($a,$b,$c) = split( /\t/, $line);
          #just process C APIs for now
          if($b =~ /^[uU]/){
            $realSymbol = $b."_".$versionAppend;
            $nonExSymbol = $b."_".$symbolAppend;
            print $outFH "#define ".$realSymbol." ".$nonExSymbol."\n";
          }
    }
}

#-----------------------------------------------------------------------
sub printFooter{

      ($outFH, $headerDef, $symbolDef ) = @_;
#print the footer
print $outFH <<END_FOOTER;

#endif /* $symbolDef */
#endif /* $headerDef */

END_FOOTER
}
#-----------------------------------------------------------------------
sub usage {
    print << "END";
Usage:
gendraft.pl
Options:
        --draft-file=<path and name of output file of Doxygen containing draft API symbols>
        --deprecated-file=<path and name of output file of Doxygen containing deprecated API symbols>
        --obsolete-file=<path and name of output file of Doxygen containing obsolete API symbols>
        --destdir=<directory>
        --version=<current version of ICU>

e.g.: gendraft.pl  --draft-file=c:\blah\DraftAPI.txt --deprecated-file=c:\blah\DeprecatedAPI.txt  --obsolete-file=c:\blah\ObsoleteFile.txt --destdir=<icu>/source/common/unicode --version=2.8
END
  exit(0);
}
