/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing.google;

import com.google.common.annotations.GwtCompatible;
import com.google.common.collect.testing.Helpers;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.features.MapFeature;
import com.google.common.collect.testing.google.AbstractBiMapTester;
import java.util.Map;

@GwtCompatible
public class BiMapPutTester<K, V>
extends AbstractBiMapTester<K, V> {
    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT})
    @CollectionSize.Require(value={CollectionSize.ZERO})
    public void testPutWithSameValueFails() {
        Object k0 = ((Map.Entry)this.samples.e0).getKey();
        Object k1 = ((Map.Entry)this.samples.e1).getKey();
        Object v0 = ((Map.Entry)this.samples.e0).getValue();
        this.getMap().put(k0, v0);
        try {
            this.getMap().put(k1, v0);
            BiMapPutTester.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
        this.expectAdded((Map.Entry)this.samples.e0);
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT})
    @CollectionSize.Require(value={CollectionSize.ZERO})
    public void testPutPresentKeyDifferentValue() {
        Object k0 = ((Map.Entry)this.samples.e0).getKey();
        Object v0 = ((Map.Entry)this.samples.e0).getValue();
        Object v1 = ((Map.Entry)this.samples.e1).getValue();
        this.getMap().put(k0, v0);
        this.getMap().put(k0, v1);
        this.expectContents(Helpers.mapEntry(k0, v1));
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT})
    @CollectionSize.Require(value={CollectionSize.ZERO})
    public void putDistinctKeysDistinctValues() {
        this.getMap().put(((Map.Entry)this.samples.e0).getKey(), ((Map.Entry)this.samples.e0).getValue());
        this.getMap().put(((Map.Entry)this.samples.e1).getKey(), ((Map.Entry)this.samples.e1).getValue());
        this.expectAdded((Map.Entry)this.samples.e0, (Map.Entry)this.samples.e1);
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT})
    @CollectionSize.Require(value={CollectionSize.ZERO})
    public void testForcePutOverwritesOldValueEntry() {
        Object k0 = ((Map.Entry)this.samples.e0).getKey();
        Object k1 = ((Map.Entry)this.samples.e1).getKey();
        Object v0 = ((Map.Entry)this.samples.e0).getValue();
        this.getMap().put(k0, v0);
        this.getMap().forcePut(k1, v0);
        this.expectAdded(Helpers.mapEntry(k1, v0));
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT})
    @CollectionSize.Require(value={CollectionSize.ZERO})
    public void testInversePut() {
        Object k0 = ((Map.Entry)this.samples.e0).getKey();
        Object v0 = ((Map.Entry)this.samples.e0).getValue();
        Object k1 = ((Map.Entry)this.samples.e1).getKey();
        Object v1 = ((Map.Entry)this.samples.e1).getValue();
        this.getMap().put(k0, v0);
        this.getMap().inverse().put(v1, k1);
        this.expectAdded((Map.Entry)this.samples.e0, (Map.Entry)this.samples.e1);
    }
}

