/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.logging;

import it.unimi.dsi.Util;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public final class ProgressLogger {
    public static final long ONE_SECOND = 1000L;
    public static final long TEN_SECONDS = 10000L;
    public static final long ONE_MINUTE = 60000L;
    public static final long TEN_MINUTES = 600000L;
    public static final long ONE_HOUR = 3600000L;
    public static final long DEFAULT_LOG_INTERVAL = 10000L;
    private static final Runtime RUNTIME = Runtime.getRuntime();
    public final int LIGHT_UPDATE_MASK = 1023;
    public final Logger logger;
    public Level priority = Level.INFO;
    public long logInterval;
    public Object info;
    public long count;
    public long expectedUpdates;
    public String itemsName;
    public boolean displayFreeMemory;
    private long start;
    private long stop;
    private long lastLog;

    public ProgressLogger() {
        this(Logger.getRootLogger());
    }

    public ProgressLogger(Logger logger) {
        this(logger, 10000L);
    }

    public ProgressLogger(Logger logger, String itemsName) {
        this(logger, 10000L, itemsName);
    }

    public ProgressLogger(Logger logger, long logInterval) {
        this(logger, logInterval, "items");
    }

    public ProgressLogger(Logger logger, long logInterval, String itemsName) {
        this.logger = logger;
        this.logInterval = logInterval;
        this.itemsName = itemsName;
        this.expectedUpdates = -1L;
    }

    public void update() {
        this.update(1L);
    }

    public void update(long count) {
        this.count += count;
        long time = System.currentTimeMillis();
        if (time - this.lastLog >= this.logInterval) {
            this.updateInternal(time);
        }
    }

    public void updateAndDisplay() {
        this.updateAndDisplay(1L);
    }

    public void set(long count) {
        this.count = count;
        long time = System.currentTimeMillis();
        if (time - this.lastLog >= this.logInterval) {
            this.updateInternal(time);
        }
    }

    public void setAndDisplay(long count) {
        this.count = count;
        this.updateInternal(System.currentTimeMillis());
    }

    public void updateAndDisplay(long count) {
        this.count += count;
        this.updateInternal(System.currentTimeMillis());
    }

    private String freeMemory() {
        return this.displayFreeMemory ? "; used/avail/free/total/max mem: " + Util.formatSize(RUNTIME.totalMemory() - RUNTIME.freeMemory()) + "/" + Util.formatSize(RUNTIME.freeMemory() + (RUNTIME.maxMemory() - RUNTIME.totalMemory())) + "/" + Util.formatSize(RUNTIME.freeMemory()) + "/" + Util.formatSize(RUNTIME.totalMemory()) + "/" + Util.formatSize(RUNTIME.maxMemory()) : "";
    }

    private String itemsPerTimeInterval(long currentTime) {
        double itemsPerSecond = (double)this.count * 1000.0 / (double)(currentTime - this.start);
        if (itemsPerSecond >= 1.0) {
            return Util.format(itemsPerSecond) + " " + this.itemsName + "/s";
        }
        if (itemsPerSecond * 60.0 >= 1.0) {
            return Util.format(itemsPerSecond * 60.0) + " " + this.itemsName + "/m";
        }
        if (itemsPerSecond * 3600.0 >= 1.0) {
            return Util.format(itemsPerSecond * 3600.0) + " " + this.itemsName + "/h";
        }
        return Util.format(itemsPerSecond * 86400.0) + " " + this.itemsName + "/d";
    }

    private void updateInternal(long currentTime) {
        long millisToEnd = Math.round((double)(this.expectedUpdates - this.count) * ((double)(currentTime - this.start) / ((double)this.count + 1.0)));
        if (this.logger.isEnabledFor(this.priority)) {
            this.logger.log(this.priority, Util.format(this.count) + " " + this.itemsName + ", " + this.millis2hms(this.millis()) + ", " + this.itemsPerTimeInterval(currentTime) + (this.expectedUpdates > 0L ? "; " + Util.format(100L * this.count / this.expectedUpdates) + "% done, " + this.millis2hms(millisToEnd) + " to end" : "") + this.freeMemory() + (this.info != null ? "; " + this.info : ""));
        }
        this.lastLog = currentTime;
    }

    public final void lightUpdate() {
        long time;
        if ((++this.count & 0x3FFL) == 0L && (time = System.currentTimeMillis()) - this.lastLog >= this.logInterval) {
            this.updateInternal(time);
        }
    }

    public void start(CharSequence message) {
        if (message != null) {
            this.logger.log(this.priority, message);
        }
        this.start = this.lastLog = System.currentTimeMillis();
        this.count = 0L;
        this.stop = -1L;
    }

    public void start() {
        this.start(null);
    }

    public void stop(CharSequence message) {
        if (this.stop != -1L) {
            return;
        }
        if (message != null) {
            this.logger.log(this.priority, message);
        }
        this.stop = System.currentTimeMillis();
        this.expectedUpdates = -1L;
    }

    public void stop() {
        this.stop(null);
    }

    public void done() {
        this.stop("Completed.");
        this.logger.log(this.priority, this);
    }

    public void done(long count) {
        this.count = count;
        this.stop("Completed.");
        this.logger.log(this.priority, this);
    }

    public long millis() {
        if (this.stop != -1L) {
            return this.stop - this.start;
        }
        return System.currentTimeMillis() - this.start;
    }

    private String millis2hms(long t) {
        if (t < 1000L) {
            return t + "ms";
        }
        long s = t / 1000L % 60L;
        long m = t / 1000L / 60L % 60L;
        long h = t / 3600000L;
        if (h == 0L && m == 0L) {
            return s + "s";
        }
        if (h == 0L) {
            return m + "m " + s + "s";
        }
        return h + "h " + m + "m " + s + "s";
    }

    public String toString() {
        long t = this.stop - this.start + 1L;
        if (t <= 0L) {
            return "Illegal progress logger state";
        }
        return "Elapsed: " + this.millis2hms(t) + (this.count != 0L ? " [" + Util.format(this.count) + " " + this.itemsName + ", " + this.itemsPerTimeInterval(System.currentTimeMillis()) + "]" : "") + this.freeMemory();
    }
}

