/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.plaf.LookAndFeelFactory;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.swing.StyleRange;
import java.awt.Dimension;
import java.util.List;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.UIManager;

public class StyledLabel
extends JLabel {
    private static final String uiClassID = "StyledLabelUI";
    private List<StyleRange> _styleRanges;
    private boolean _lineWrap;
    private int _rows;
    private int _maxRows;
    private int _minRows;
    private int _preferredWidth;
    private int _rowGap;
    private boolean _truncated = false;
    private boolean _ignoreColorSettings;
    public static final String PROPERTY_STYLE_RANGE = "styleRange";
    public static final String PROPERTY_IGNORE_COLOR_SETTINGS = "ignoreColorSettings";

    public StyledLabel() {
        this.setMaximumSize(null);
    }

    public StyledLabel(Icon icon) {
        super(icon);
        this.setMaximumSize(null);
    }

    public StyledLabel(Icon icon, int n) {
        super(icon, n);
        this.setMaximumSize(null);
    }

    public StyledLabel(String string) {
        super(string);
        this.setMaximumSize(null);
    }

    public StyledLabel(String string, int n) {
        super(string, n);
        this.setMaximumSize(null);
    }

    public StyledLabel(String string, Icon icon, int n) {
        super(string, icon, n);
        this.setMaximumSize(null);
    }

    @Override
    public void updateUI() {
        if (UIDefaultsLookup.get(uiClassID) == null) {
            LookAndFeelFactory.installJideExtension();
        }
        this.setUI(UIManager.getUI(this));
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }

    public synchronized void addStyleRange(StyleRange styleRange) {
        if (styleRange == null) {
            throw new IllegalArgumentException("StyleRange cannot be null.");
        }
        List<StyleRange> list = this.internalGetStyleRanges();
        for (int i = list.size() - 1; i >= 0; --i) {
            StyleRange styleRange2 = list.get(i);
            if (styleRange2.getStart() != styleRange.getStart() || styleRange2.getLength() != styleRange.getLength()) continue;
            list.remove(i);
        }
        this.internalGetStyleRanges().add(styleRange);
        this.firePropertyChange(PROPERTY_STYLE_RANGE, null, styleRange);
    }

    public synchronized void setStyleRanges(StyleRange[] styleRangeArray) {
        this.internalGetStyleRanges().clear();
        this.addStyleRanges(styleRangeArray);
    }

    public synchronized void addStyleRanges(StyleRange[] styleRangeArray) {
        if (styleRangeArray != null) {
            for (StyleRange styleRange : styleRangeArray) {
                this.internalGetStyleRanges().add(styleRange);
            }
            this.firePropertyChange(PROPERTY_STYLE_RANGE, null, styleRangeArray);
        } else {
            this.firePropertyChange(PROPERTY_STYLE_RANGE, null, null);
        }
    }

    public synchronized StyleRange[] getStyleRanges() {
        List<StyleRange> list = this.internalGetStyleRanges();
        return list.toArray(new StyleRange[list.size()]);
    }

    private List<StyleRange> internalGetStyleRanges() {
        if (this._styleRanges == null) {
            this._styleRanges = new Vector<StyleRange>();
        }
        return this._styleRanges;
    }

    public synchronized void clearStyleRange(StyleRange styleRange) {
        if (this.internalGetStyleRanges().remove(styleRange)) {
            this.firePropertyChange(PROPERTY_STYLE_RANGE, styleRange, null);
        }
    }

    public synchronized void clearStyleRanges() {
        this.internalGetStyleRanges().clear();
        this.firePropertyChange(PROPERTY_STYLE_RANGE, null, null);
    }

    public boolean isIgnoreColorSettings() {
        return this._ignoreColorSettings;
    }

    public void setIgnoreColorSettings(boolean bl) {
        boolean bl2 = this._ignoreColorSettings;
        if (bl2 != bl) {
            this._ignoreColorSettings = bl;
            this.firePropertyChange(PROPERTY_IGNORE_COLOR_SETTINGS, bl2, bl);
        }
    }

    @Override
    public Dimension getMinimumSize() {
        return this.isLineWrap() ? new Dimension(1, 1) : super.getMinimumSize();
    }

    @Override
    public Dimension getMaximumSize() {
        return this.isLineWrap() ? new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE) : super.getMaximumSize();
    }

    public void setPreferredWidth(int n) {
        this._preferredWidth = n;
    }

    public int getPreferredWidth() {
        return this._preferredWidth;
    }

    public boolean isLineWrap() {
        return this._lineWrap;
    }

    public void setLineWrap(boolean bl) {
        this._lineWrap = bl;
    }

    public int getRows() {
        return this._rows;
    }

    public void setRows(int n) {
        this._rows = n;
    }

    public int getRowGap() {
        return this._rowGap;
    }

    public void setRowGap(int n) {
        this._rowGap = n;
    }

    public int getMaxRows() {
        return this._maxRows;
    }

    public void setMaxRows(int n) {
        this._maxRows = n;
    }

    public int getMinRows() {
        return this._minRows;
    }

    public void setMinRows(int n) {
        this._minRows = n;
    }

    public boolean isTruncated() {
        return this._truncated;
    }

    public void setTruncated(boolean bl) {
        this._truncated = bl;
    }
}

