#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2022 Mopi
# SPDX-FileCopyrightText: © 2022 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Cinders
# send your bug reports to contact@dotslashplay.it
###

script_version=20240211.1

PLAYIT_COMPATIBILITY_LEVEL='2.18'

GAME_ID='cinders'
GAME_NAME='Cinders'

ARCHIVE_BASE_0='setup_cinders_1.2.7_(27636).exe'
ARCHIVE_BASE_0_MD5='511b82f5b2b9ca06636fe424980ff1bf'
ARCHIVE_BASE_0_TYPE='innosetup'
ARCHIVE_BASE_0_SIZE='280000'
ARCHIVE_BASE_0_VERSION='1.2.7-gog27636'
ARCHIVE_BASE_0_URL='https://www.gog.com/en/game/cinders'

CONTENT_PATH_DEFAULT='.'
CONTENT_GAME_BIN_FILES='
cinders.exe'
CONTENT_GAME_DATA_FILES='
*.ogg
data.win'

APP_MAIN_TYPE='wine'
APP_MAIN_EXE='cinders.exe'
APP_MAIN_ICON='cinders.exe'

APP_WINE_LINK_DIRS='
userdata:users/${USER}/AppData/Roaming/Cinders'
USER_PERSISTENT_FILES='
userdata/*.sav'

PACKAGES_LIST='
PKG_BIN
PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

PKG_BIN_ARCH='32'
PKG_BIN_DEPS="$PKG_DATA_ID"

# Work around audio issues

PKG_BIN_DEPS="$PKG_BIN_DEPS winetricks"
APP_WINETRICKS="$APP_WINETRICKS dsound"

## FIXME: This game should setup a WINE virtual desktop on first launch.

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction 'SOURCE_ARCHIVE'

# Include game data

PKG='PKG_DATA'
icons_inclusion
content_inclusion_default
rm --recursive "${PLAYIT_WORKDIR}/gamedata"

# Write launchers

PKG='PKG_BIN'
launchers_write

# Build packages

write_metadata
build_pkg
print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
