// -*- indent-tabs-mode: nil -*-

#include <string>
#include <fstream>
#include <iostream>
#include <sstream>

#include <unistd.h>

#include "../canl-c++/canlxx.h"

int main(int argc, char *argv[]) {
  std::string interface = "";
  int port;
  std::string capath; 
  std::string certpath;
  std::string keypath;

  if(argc < 5) { std::cout<<"Usage: ./test_ionetwork_server 29999 ../canl-c++/test/trusted_certificates/ ../canl-c++/test/testCA/certs/cert.pem ../canl-c++/test/testCA/certs/key.pem"<<std::endl; exit(1); }

  port = atoi(argv[1]);
  capath = argv[2];
  certpath = argv[3];
  keypath = argv[4];

  std::cout<<"port: "<<port<<" capath: "<<capath<<" certpath: "<<certpath<<" keypath: "<<keypath<<std::endl;

  AuthN::Context ctx(AuthN::Context::EmptyContext);  
  ctx.SetCredentials(certpath, keypath);
  ctx.SetCAPath(capath);

  AuthN::IONetwork io(ctx);
  io.SetTimeout(10000);

  AuthN::Credentials cred(ctx);
  io.SetOwnCredentials(cred);

  AuthN::IO& connected_io = io.Accept(interface, port);
  if((bool)io) std::cout<<"Accept setup succeeded"<<std::endl;
  else std::cout<<"Accept setup failed"<<std::endl;

  sleep(1);

  AuthN::Status st;
  std::string str;
  st = connected_io.Read(str);

  if(!st) std::cerr<<"Server: Read failed: "<<st.GetCode()<<std::endl;
  else std::cout<<"Server: Read succeeded: "<<str<<std::endl;

  std::string res_str;
  res_str = "Echo from server: "; res_str += str;
  st = connected_io.Write(res_str);
  if(!st) std::cerr<<"Server: Write failed: "<<st.GetCode()<<": "<<st.GetDescription()<<std::endl;
  else std::cout<<"Server: Write succeeded"<<std::endl;

  io.Close();

  return 0;
}
