{ -*- buffer-read-only: t -*-

  Copyright 2015-2021 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal .

  The documentation for properties should go to x3dnodes_documentation.txt . }

{$ifdef read_interface}

  strict private
    function GetInnerRadius: Single;
    procedure SetInnerRadius(const Value: Single);
    function GetOuterRadius: Single;
    procedure SetOuterRadius(const Value: Single);
  public
    procedure CreateNode; override;
    class function ClassX3DType: string; override;

    strict private FFdInnerRadius: TSFFloat;
    { X3D field "innerRadius". } { }
    public property FdInnerRadius: TSFFloat read FFdInnerRadius;
    { X3D field "innerRadius". } { }
    property InnerRadius: Single read GetInnerRadius write SetInnerRadius;

    strict private FFdOuterRadius: TSFFloat;
    { X3D field "outerRadius". } { }
    public property FdOuterRadius: TSFFloat read FFdOuterRadius;
    { X3D field "outerRadius". } { }
    property OuterRadius: Single read GetOuterRadius write SetOuterRadius;

    strict private FFdSolid: TSFBool;
    { X3D field "solid". } { }
    public property FdSolid: TSFBool read FFdSolid;

{$endif read_interface}

{$ifdef read_implementation}

{ TDisk2DNode ----------------------------------------------- }

function TDisk2DNode.GetInnerRadius: Single;
begin
  Result := FdInnerRadius.Value;
end;

procedure TDisk2DNode.SetInnerRadius(const Value: Single);
begin
  FdInnerRadius.Send(Value);
end;

function TDisk2DNode.GetOuterRadius: Single;
begin
  Result := FdOuterRadius.Value;
end;

procedure TDisk2DNode.SetOuterRadius(const Value: Single);
begin
  FdOuterRadius.Send(Value);
end;

class function TDisk2DNode.ClassX3DType: String;
begin
  Result := 'Disk2D';
end;

procedure TDisk2DNode.CreateNode;
begin
  inherited;

  FFdInnerRadius := TSFFloat.Create(Self, False, 'innerRadius', 0);
   FdInnerRadius.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdInnerRadius);
  { X3D specification comment: [0,Inf) }

  FFdOuterRadius := TSFFloat.Create(Self, False, 'outerRadius', 1);
   FdOuterRadius.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdOuterRadius);
  { X3D specification comment: (0,Inf) }

  FFdSolid := TSFBool.Create(Self, False, 'solid', false);
   FdSolid.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdSolid);
end;

{$endif read_implementation}
