{ -*- buffer-read-only: t -*-

  Copyright 2015-2021 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal .

  The documentation for properties should go to x3dnodes_documentation.txt . }

{$ifdef read_interface}

  strict private
    function GetTimeOriginAtLoad: Boolean;
    procedure SetTimeOriginAtLoad(const Value: Boolean);
    function GetOctreeRendering: TKambiOctreePropertiesNode;
    procedure SetOctreeRendering(const Value: TKambiOctreePropertiesNode);
    function GetOctreeDynamicCollisions: TKambiOctreePropertiesNode;
    procedure SetOctreeDynamicCollisions(const Value: TKambiOctreePropertiesNode);
    function GetOctreeVisibleTriangles: TKambiOctreePropertiesNode;
    procedure SetOctreeVisibleTriangles(const Value: TKambiOctreePropertiesNode);
    function GetOctreeStaticCollisions: TKambiOctreePropertiesNode;
    procedure SetOctreeStaticCollisions(const Value: TKambiOctreePropertiesNode);
    function GetHeadBobbing: Single;
    procedure SetHeadBobbing(const Value: Single);
    function GetHeadBobbingTime: Single;
    procedure SetHeadBobbingTime(const Value: Single);
    function GetHeadlightNode: TAbstractLightNode;
    procedure SetHeadlightNode(const Value: TAbstractLightNode);
  public
    { X3D field "timeOriginAtLoad". } { }
    property TimeOriginAtLoad: Boolean read GetTimeOriginAtLoad write SetTimeOriginAtLoad;
    { X3D field "octreeRendering". } { }
    property OctreeRendering: TKambiOctreePropertiesNode read GetOctreeRendering write SetOctreeRendering;
    { X3D field "octreeDynamicCollisions". } { }
    property OctreeDynamicCollisions: TKambiOctreePropertiesNode read GetOctreeDynamicCollisions write SetOctreeDynamicCollisions;
    { X3D field "octreeVisibleTriangles". } { }
    property OctreeVisibleTriangles: TKambiOctreePropertiesNode read GetOctreeVisibleTriangles write SetOctreeVisibleTriangles;
    { X3D field "octreeStaticCollisions". } { }
    property OctreeStaticCollisions: TKambiOctreePropertiesNode read GetOctreeStaticCollisions write SetOctreeStaticCollisions;
    { X3D field "headBobbing". } { }
    property HeadBobbing: Single read GetHeadBobbing write SetHeadBobbing;
    { X3D field "headBobbingTime". } { }
    property HeadBobbingTime: Single read GetHeadBobbingTime write SetHeadBobbingTime;
    { X3D field "headlightNode". } { }
    property HeadlightNode: TAbstractLightNode read GetHeadlightNode write SetHeadlightNode;

{$endif read_interface}

{$ifdef read_implementation}

{ TKambiNavigationInfoNode ----------------------------------------------- }

function TKambiNavigationInfoNode.GetTimeOriginAtLoad: Boolean;
begin
  Result := FdTimeOriginAtLoad.Value;
end;

procedure TKambiNavigationInfoNode.SetTimeOriginAtLoad(const Value: Boolean);
begin
  FdTimeOriginAtLoad.Send(Value);
end;

function TKambiNavigationInfoNode.GetOctreeRendering: TKambiOctreePropertiesNode;
begin
  if FdOctreeRendering.Value is TKambiOctreePropertiesNode then
    Result := TKambiOctreePropertiesNode(FdOctreeRendering.Value)
  else
    Result := nil;
end;

procedure TKambiNavigationInfoNode.SetOctreeRendering(const Value: TKambiOctreePropertiesNode);
begin
  FdOctreeRendering.Send(Value);
end;

function TKambiNavigationInfoNode.GetOctreeDynamicCollisions: TKambiOctreePropertiesNode;
begin
  if FdOctreeDynamicCollisions.Value is TKambiOctreePropertiesNode then
    Result := TKambiOctreePropertiesNode(FdOctreeDynamicCollisions.Value)
  else
    Result := nil;
end;

procedure TKambiNavigationInfoNode.SetOctreeDynamicCollisions(const Value: TKambiOctreePropertiesNode);
begin
  FdOctreeDynamicCollisions.Send(Value);
end;

function TKambiNavigationInfoNode.GetOctreeVisibleTriangles: TKambiOctreePropertiesNode;
begin
  if FdOctreeVisibleTriangles.Value is TKambiOctreePropertiesNode then
    Result := TKambiOctreePropertiesNode(FdOctreeVisibleTriangles.Value)
  else
    Result := nil;
end;

procedure TKambiNavigationInfoNode.SetOctreeVisibleTriangles(const Value: TKambiOctreePropertiesNode);
begin
  FdOctreeVisibleTriangles.Send(Value);
end;

function TKambiNavigationInfoNode.GetOctreeStaticCollisions: TKambiOctreePropertiesNode;
begin
  if FdOctreeStaticCollisions.Value is TKambiOctreePropertiesNode then
    Result := TKambiOctreePropertiesNode(FdOctreeStaticCollisions.Value)
  else
    Result := nil;
end;

procedure TKambiNavigationInfoNode.SetOctreeStaticCollisions(const Value: TKambiOctreePropertiesNode);
begin
  FdOctreeStaticCollisions.Send(Value);
end;

function TKambiNavigationInfoNode.GetHeadBobbing: Single;
begin
  Result := FdHeadBobbing.Value;
end;

procedure TKambiNavigationInfoNode.SetHeadBobbing(const Value: Single);
begin
  FdHeadBobbing.Send(Value);
end;

function TKambiNavigationInfoNode.GetHeadBobbingTime: Single;
begin
  Result := FdHeadBobbingTime.Value;
end;

procedure TKambiNavigationInfoNode.SetHeadBobbingTime(const Value: Single);
begin
  FdHeadBobbingTime.Send(Value);
end;

function TKambiNavigationInfoNode.GetHeadlightNode: TAbstractLightNode;
begin
  if FdHeadlightNode.Value is TAbstractLightNode then
    Result := TAbstractLightNode(FdHeadlightNode.Value)
  else
    Result := nil;
end;

procedure TKambiNavigationInfoNode.SetHeadlightNode(const Value: TAbstractLightNode);
begin
  FdHeadlightNode.Send(Value);
end;

{$endif read_implementation}
