/*
//
//  Copyright 1997-2010 Torsten Rohlfing
//
//  Copyright 2004-2011 SRI International
//
//  This file is part of the Computational Morphometry Toolkit.
//
//  http://www.nitrc.org/projects/cmtk/
//
//  The Computational Morphometry Toolkit is free software: you can
//  redistribute it and/or modify it under the terms of the GNU General Public
//  License as published by the Free Software Foundation, either version 3 of
//  the License, or (at your option) any later version.
//
//  The Computational Morphometry Toolkit is distributed in the hope that it
//  will be useful, but WITHOUT ANY WARRANTY; without even the implied
//  warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License along
//  with the Computational Morphometry Toolkit.  If not, see
//  <http://www.gnu.org/licenses/>.
//
//  $Revision: 2765 $
//
//  $LastChangedDate: 2011-01-18 16:17:56 -0800 (Tue, 18 Jan 2011) $
//
//  $LastChangedBy: torstenrohlfing $
//
*/

#include <cmtkconfig.h>

#include <System/cmtkExitException.h>

#include <Segmentation/cmtkSimpleLevelsetCommandLine.h>
#include <Segmentation/cmtkSimpleLevelset.h>

int
doMain( const int argc, const char* argv[] )
{
  cmtk::SimpleLevelsetCommandLine<cmtk::SimpleLevelset> levelset;

  const int init = levelset.Init( argc, argv );
  if ( init )
    return init;

  levelset.Execute();
  return 0;
}

#include "cmtkSafeMain"
