/***************************************************************
 *
 * Copyright (C) 1990-2007, Condor Team, Computer Sciences Department,
 * University of Wisconsin-Madison, WI.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you
 * may not use this file except in compliance with the License.  You may
 * obtain a copy of the License at
 * 
 *    http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ***************************************************************/

#ifndef CREDENTIAL_H
#define CREDENTIAL_H

#ifdef X509_AUTHENTICATION

#define SYSTEM 1
#define USER 2

#include "reli_sock.h"
// In order to avoid a warning generated by including the Globus header files
// we undefine IOV_MAX. The Globus header files will redefine it for us. 
// Not only do we not use IOV_MAX in the source code, but the redefinition 
// is going to be used anyway, so we might as well get rid of the warning.
#undef IOV_MAX 
#include "globus_gss_assist.h"
#include "sslutils.h"

enum Cred_status {
	ENV_NOT_SET = 1,
	CRED_NOT_SET,
	CRED_EXPIRED,
	CRED_SUCCESS
};

#define MAX_BUF_LENGTH 1024



typedef int CREDENTIAL_TYPE; 
typedef int Process_Type;

class X509_Credential{
	private :
		
		char *crd_name; //path to the credential file
		Process_Type my_type; //SYSTEM or USER
		Cred_status c_stat; //Valid or if failed why ?
		
	public :
			
		X509_Credential();
		X509_Credential(Process_Type,char*);
		X509_Credential(char*);
		int forward_credential(ReliSock*);
		int receive_credential(ReliSock*,char*);
		bool isvalid();
		int SetupEnv();
 		void erase_env();
};


#endif

#endif /* CREDENTIAL_H */
