//go:build !no_grpc

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.2.0
// - protoc             v3.20.1
// source: github.com/containerd/containerd/api/services/containers/v1/containers.proto

package containers

import (
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

// ContainersClient is the client API for Containers service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type ContainersClient interface {
	Get(ctx context.Context, in *GetContainerRequest, opts ...grpc.CallOption) (*GetContainerResponse, error)
	List(ctx context.Context, in *ListContainersRequest, opts ...grpc.CallOption) (*ListContainersResponse, error)
	ListStream(ctx context.Context, in *ListContainersRequest, opts ...grpc.CallOption) (Containers_ListStreamClient, error)
	Create(ctx context.Context, in *CreateContainerRequest, opts ...grpc.CallOption) (*CreateContainerResponse, error)
	Update(ctx context.Context, in *UpdateContainerRequest, opts ...grpc.CallOption) (*UpdateContainerResponse, error)
	Delete(ctx context.Context, in *DeleteContainerRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
}

type containersClient struct {
	cc grpc.ClientConnInterface
}

func NewContainersClient(cc grpc.ClientConnInterface) ContainersClient {
	return &containersClient{cc}
}

func (c *containersClient) Get(ctx context.Context, in *GetContainerRequest, opts ...grpc.CallOption) (*GetContainerResponse, error) {
	out := new(GetContainerResponse)
	err := c.cc.Invoke(ctx, "/containerd.services.containers.v1.Containers/Get", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *containersClient) List(ctx context.Context, in *ListContainersRequest, opts ...grpc.CallOption) (*ListContainersResponse, error) {
	out := new(ListContainersResponse)
	err := c.cc.Invoke(ctx, "/containerd.services.containers.v1.Containers/List", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *containersClient) ListStream(ctx context.Context, in *ListContainersRequest, opts ...grpc.CallOption) (Containers_ListStreamClient, error) {
	stream, err := c.cc.NewStream(ctx, &Containers_ServiceDesc.Streams[0], "/containerd.services.containers.v1.Containers/ListStream", opts...)
	if err != nil {
		return nil, err
	}
	x := &containersListStreamClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type Containers_ListStreamClient interface {
	Recv() (*ListContainerMessage, error)
	grpc.ClientStream
}

type containersListStreamClient struct {
	grpc.ClientStream
}

func (x *containersListStreamClient) Recv() (*ListContainerMessage, error) {
	m := new(ListContainerMessage)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *containersClient) Create(ctx context.Context, in *CreateContainerRequest, opts ...grpc.CallOption) (*CreateContainerResponse, error) {
	out := new(CreateContainerResponse)
	err := c.cc.Invoke(ctx, "/containerd.services.containers.v1.Containers/Create", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *containersClient) Update(ctx context.Context, in *UpdateContainerRequest, opts ...grpc.CallOption) (*UpdateContainerResponse, error) {
	out := new(UpdateContainerResponse)
	err := c.cc.Invoke(ctx, "/containerd.services.containers.v1.Containers/Update", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *containersClient) Delete(ctx context.Context, in *DeleteContainerRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/containerd.services.containers.v1.Containers/Delete", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ContainersServer is the server API for Containers service.
// All implementations must embed UnimplementedContainersServer
// for forward compatibility
type ContainersServer interface {
	Get(context.Context, *GetContainerRequest) (*GetContainerResponse, error)
	List(context.Context, *ListContainersRequest) (*ListContainersResponse, error)
	ListStream(*ListContainersRequest, Containers_ListStreamServer) error
	Create(context.Context, *CreateContainerRequest) (*CreateContainerResponse, error)
	Update(context.Context, *UpdateContainerRequest) (*UpdateContainerResponse, error)
	Delete(context.Context, *DeleteContainerRequest) (*emptypb.Empty, error)
	mustEmbedUnimplementedContainersServer()
}

// UnimplementedContainersServer must be embedded to have forward compatible implementations.
type UnimplementedContainersServer struct {
}

func (UnimplementedContainersServer) Get(context.Context, *GetContainerRequest) (*GetContainerResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Get not implemented")
}
func (UnimplementedContainersServer) List(context.Context, *ListContainersRequest) (*ListContainersResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method List not implemented")
}
func (UnimplementedContainersServer) ListStream(*ListContainersRequest, Containers_ListStreamServer) error {
	return status.Errorf(codes.Unimplemented, "method ListStream not implemented")
}
func (UnimplementedContainersServer) Create(context.Context, *CreateContainerRequest) (*CreateContainerResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Create not implemented")
}
func (UnimplementedContainersServer) Update(context.Context, *UpdateContainerRequest) (*UpdateContainerResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Update not implemented")
}
func (UnimplementedContainersServer) Delete(context.Context, *DeleteContainerRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Delete not implemented")
}
func (UnimplementedContainersServer) mustEmbedUnimplementedContainersServer() {}

// UnsafeContainersServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to ContainersServer will
// result in compilation errors.
type UnsafeContainersServer interface {
	mustEmbedUnimplementedContainersServer()
}

func RegisterContainersServer(s grpc.ServiceRegistrar, srv ContainersServer) {
	s.RegisterService(&Containers_ServiceDesc, srv)
}

func _Containers_Get_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetContainerRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ContainersServer).Get(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/containerd.services.containers.v1.Containers/Get",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ContainersServer).Get(ctx, req.(*GetContainerRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Containers_List_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListContainersRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ContainersServer).List(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/containerd.services.containers.v1.Containers/List",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ContainersServer).List(ctx, req.(*ListContainersRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Containers_ListStream_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(ListContainersRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(ContainersServer).ListStream(m, &containersListStreamServer{stream})
}

type Containers_ListStreamServer interface {
	Send(*ListContainerMessage) error
	grpc.ServerStream
}

type containersListStreamServer struct {
	grpc.ServerStream
}

func (x *containersListStreamServer) Send(m *ListContainerMessage) error {
	return x.ServerStream.SendMsg(m)
}

func _Containers_Create_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateContainerRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ContainersServer).Create(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/containerd.services.containers.v1.Containers/Create",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ContainersServer).Create(ctx, req.(*CreateContainerRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Containers_Update_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateContainerRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ContainersServer).Update(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/containerd.services.containers.v1.Containers/Update",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ContainersServer).Update(ctx, req.(*UpdateContainerRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Containers_Delete_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteContainerRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ContainersServer).Delete(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/containerd.services.containers.v1.Containers/Delete",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ContainersServer).Delete(ctx, req.(*DeleteContainerRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// Containers_ServiceDesc is the grpc.ServiceDesc for Containers service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var Containers_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "containerd.services.containers.v1.Containers",
	HandlerType: (*ContainersServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Get",
			Handler:    _Containers_Get_Handler,
		},
		{
			MethodName: "List",
			Handler:    _Containers_List_Handler,
		},
		{
			MethodName: "Create",
			Handler:    _Containers_Create_Handler,
		},
		{
			MethodName: "Update",
			Handler:    _Containers_Update_Handler,
		},
		{
			MethodName: "Delete",
			Handler:    _Containers_Delete_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "ListStream",
			Handler:       _Containers_ListStream_Handler,
			ServerStreams: true,
		},
	},
	Metadata: "github.com/containerd/containerd/api/services/containers/v1/containers.proto",
}
