#ifndef INAPPBROWSER_H
#define INAPPBROWSER_H

#include <QtCore>
#include "../cplugin.h"

class InAppBrowser: public CPlugin {
    Q_OBJECT
public:
    InAppBrowser(Cordova *cordova);

    virtual const QString fullName() override {
        return InAppBrowser::fullID();
    }

    virtual const QString shortName() override {
        return "InAppBrowser";
    }

    static const QString fullID() {
        return "com.cordova.InAppBrowser";
    }

public slots:
    void loadUrl(int loadEndCb, int closeCb, QString url);
    void close(int, int);
    void loadFinished();

private:
    bool open;
    int m_closeCb, m_loadFinishedCb;
};

#endif // INAPPBROWSER_H
