/*
 * Decompiled with CFR 0.152.
 */
package dumphd.util;

import dumphd.util.ByteArray;
import dumphd.util.PESParserException;
import java.util.Arrays;
import java.util.Vector;

public final class PESPack {
    public static final String[] S_ID_NAMES = new String[256];
    public static final String[] PS1_ID_NAMES = new String[256];
    public static final String[] PS2_ID_NAMES = new String[256];
    public static final int PACK_LENGTH = 2048;
    private byte[] pack = null;
    private int packOffset = 0;
    private Vector<PESPacket> packets = new Vector(8);
    private int packetCount = 0;

    static {
        int i = 0;
        while (i < 256) {
            String nameString;
            PESPack.S_ID_NAMES[i] = nameString = String.format("0x%1$02X", i);
            PESPack.PS1_ID_NAMES[i] = nameString;
            PESPack.PS2_ID_NAMES[i] = nameString;
            ++i;
        }
        PESPack.S_ID_NAMES[186] = "PACK_HEADER";
        PESPack.S_ID_NAMES[187] = "SYSTEM_HEADER";
        PESPack.S_ID_NAMES[189] = "PRIVATE_STREAM_1";
        PESPack.S_ID_NAMES[190] = "PADDING_STREAM";
        PESPack.S_ID_NAMES[191] = "PRIVATE_STREAM_2";
        PESPack.S_ID_NAMES[224] = "MPEG-2_VIDEO_STREAM_FOR_MAIN";
        PESPack.S_ID_NAMES[225] = "MPEG-2_VIDEO_STREAM_FOR_SUB";
        PESPack.S_ID_NAMES[226] = "MPEG-4-AVC_VIDEO_STREAM_FOR_MAIN";
        PESPack.S_ID_NAMES[227] = "MPEG-4-AVC_VIDEO_STREAM_FOR_SUB";
        PESPack.S_ID_NAMES[253] = "VC-1_VIDEO_STREAM";
        PESPack.PS1_ID_NAMES[32] = "SUBPICTURE_STREAM_#01";
        PESPack.PS1_ID_NAMES[33] = "SUBPICTURE_STREAM_#02";
        PESPack.PS1_ID_NAMES[34] = "SUBPICTURE_STREAM_#03";
        PESPack.PS1_ID_NAMES[35] = "SUBPICTURE_STREAM_#04";
        PESPack.PS1_ID_NAMES[36] = "SUBPICTURE_STREAM_#05";
        PESPack.PS1_ID_NAMES[37] = "SUBPICTURE_STREAM_#06";
        PESPack.PS1_ID_NAMES[38] = "SUBPICTURE_STREAM_#07";
        PESPack.PS1_ID_NAMES[39] = "SUBPICTURE_STREAM_#08";
        PESPack.PS1_ID_NAMES[40] = "SUBPICTURE_STREAM_#09";
        PESPack.PS1_ID_NAMES[41] = "SUBPICTURE_STREAM_#10";
        PESPack.PS1_ID_NAMES[42] = "SUBPICTURE_STREAM_#11";
        PESPack.PS1_ID_NAMES[43] = "SUBPICTURE_STREAM_#12";
        PESPack.PS1_ID_NAMES[44] = "SUBPICTURE_STREAM_#13";
        PESPack.PS1_ID_NAMES[45] = "SUBPICTURE_STREAM_#14";
        PESPack.PS1_ID_NAMES[46] = "SUBPICTURE_STREAM_#15";
        PESPack.PS1_ID_NAMES[47] = "SUBPICTURE_STREAM_#16";
        PESPack.PS1_ID_NAMES[48] = "SUBPICTURE_STREAM_#17";
        PESPack.PS1_ID_NAMES[49] = "SUBPICTURE_STREAM_#18";
        PESPack.PS1_ID_NAMES[50] = "SUBPICTURE_STREAM_#19";
        PESPack.PS1_ID_NAMES[51] = "SUBPICTURE_STREAM_#20";
        PESPack.PS1_ID_NAMES[52] = "SUBPICTURE_STREAM_#21";
        PESPack.PS1_ID_NAMES[53] = "SUBPICTURE_STREAM_#22";
        PESPack.PS1_ID_NAMES[54] = "SUBPICTURE_STREAM_#23";
        PESPack.PS1_ID_NAMES[55] = "SUBPICTURE_STREAM_#24";
        PESPack.PS1_ID_NAMES[56] = "SUBPICTURE_STREAM_#25";
        PESPack.PS1_ID_NAMES[57] = "SUBPICTURE_STREAM_#26";
        PESPack.PS1_ID_NAMES[58] = "SUBPICTURE_STREAM_#27";
        PESPack.PS1_ID_NAMES[59] = "SUBPICTURE_STREAM_#28";
        PESPack.PS1_ID_NAMES[60] = "SUBPICTURE_STREAM_#29";
        PESPack.PS1_ID_NAMES[61] = "SUBPICTURE_STREAM_#30";
        PESPack.PS1_ID_NAMES[62] = "SUBPICTURE_STREAM_#31";
        PESPack.PS1_ID_NAMES[63] = "SUBPICTURE_STREAM_#32";
        PESPack.PS1_ID_NAMES[192] = "DD+_AUDIO_STREAM_FOR_MAIN_#01";
        PESPack.PS1_ID_NAMES[193] = "DD+_AUDIO_STREAM_FOR_MAIN_#02";
        PESPack.PS1_ID_NAMES[194] = "DD+_AUDIO_STREAM_FOR_MAIN_#03";
        PESPack.PS1_ID_NAMES[195] = "DD+_AUDIO_STREAM_FOR_MAIN_#04";
        PESPack.PS1_ID_NAMES[196] = "DD+_AUDIO_STREAM_FOR_MAIN_#05";
        PESPack.PS1_ID_NAMES[197] = "DD+_AUDIO_STREAM_FOR_MAIN_#06";
        PESPack.PS1_ID_NAMES[198] = "DD+_AUDIO_STREAM_FOR_MAIN_#07";
        PESPack.PS1_ID_NAMES[199] = "DD+_AUDIO_STREAM_FOR_MAIN_#08";
        PESPack.PS1_ID_NAMES[200] = "DD+_AUDIO_STREAM_FOR_SUB_#01";
        PESPack.PS1_ID_NAMES[201] = "DD+_AUDIO_STREAM_FOR_SUB_#02";
        PESPack.PS1_ID_NAMES[202] = "DD+_AUDIO_STREAM_FOR_SUB_#03";
        PESPack.PS1_ID_NAMES[203] = "DD+_AUDIO_STREAM_FOR_SUB_#04";
        PESPack.PS1_ID_NAMES[204] = "DD+_AUDIO_STREAM_FOR_SUB_#05";
        PESPack.PS1_ID_NAMES[205] = "DD+_AUDIO_STREAM_FOR_SUB_#06";
        PESPack.PS1_ID_NAMES[206] = "DD+_AUDIO_STREAM_FOR_SUB_#07";
        PESPack.PS1_ID_NAMES[207] = "DD+_AUDIO_STREAM_FOR_SUB_#08";
        PESPack.PS2_ID_NAMES[0] = "PCI_PKT";
        PESPack.PS2_ID_NAMES[1] = "DSI_PKT";
        PESPack.PS2_ID_NAMES[4] = "GCI_PKT";
        PESPack.PS2_ID_NAMES[8] = "HL_PCK";
        PESPack.PS2_ID_NAMES[128] = "ADV_PCK";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void parse(byte[] pack, int offset, boolean quickScan) throws PESParserException {
        int pos = 0;
        int endOffset = offset + 2048;
        if (endOffset > pack.length) throw new PESParserException("Pack data too small");
        if (ByteArray.getVarLong(pack, offset, 4) != 442L) throw new PESParserException(String.format("Invalid pack start code and /or pack identifier: 0x%1$08X", ByteArray.getVarLong(pack, offset, 4)));
        pos = offset + 14 + (pack[offset + 13] & 7);
        this.pack = pack;
        this.packOffset = offset;
        this.packetCount = 0;
        block0: while (pos + 6 <= endOffset) {
            if (ByteArray.getVarLong(pack, pos, 3) == 1L) {
                if (this.packets.size() <= this.packetCount) {
                    this.packets.add(new PESPacket());
                }
                PESPacket currentPacket = this.packets.get(this.packetCount);
                ++this.packetCount;
                currentPacket.packetOffset = pos;
                currentPacket.stream_id = ByteArray.getUByte(pack, pos += 3);
                currentPacket.stream_idOffset = pos;
                if (currentPacket.stream_id == 187 || currentPacket.stream_id == 190 || currentPacket.stream_id == 191) {
                    currentPacket.hasExtension = false;
                } else {
                    currentPacket.hasExtension = true;
                }
                currentPacket.length = ByteArray.getUShort(pack, ++pos);
                if ((pos += 2) + currentPacket.length > endOffset) throw new PESParserException("Packet size exceeds pack size at: 0x" + Integer.toHexString(pos - offset).toUpperCase());
                if (currentPacket.hasExtension) {
                    if (pos + 3 > endOffset) throw new PESParserException("Packet too small for extension at: 0x" + Integer.toHexString(pos - offset).toUpperCase());
                    if (quickScan) {
                        int phl;
                        pos += 2;
                        if (++pos + (phl = ByteArray.getUByte(pack, pos)) > endOffset) throw new PESParserException("Packet header size exceeds packet size at: 0x" + Integer.toHexString(pos - offset).toUpperCase());
                        pos = currentPacket.stream_id == 253 ? (pos += phl - 1) : (pos += phl);
                    } else {
                        currentPacket.ptsdts = pack[++pos] >>> 6 & 3;
                        currentPacket.escr = pack[pos] >>> 5 & 1;
                        currentPacket.esr = pack[pos] >>> 4 & 1;
                        currentPacket.aci = pack[pos] >>> 2 & 1;
                        currentPacket.pescrc = pack[pos] >>> 1 & 1;
                        currentPacket.pesext1 = pack[pos] & 1;
                        if (currentPacket.ptsdts > 0) {
                            PESPacket pESPacket = currentPacket;
                            pESPacket.ptsdts = pESPacket.ptsdts - 1;
                        }
                        int pesEndOffset = ++pos + 1 + ByteArray.getUByte(pack, pos);
                        pos += 1 + currentPacket.ptsdts * 5 + currentPacket.escr * 6 + currentPacket.esr * 3 + currentPacket.aci * 1 + currentPacket.pescrc * 2;
                        if (pesEndOffset > endOffset) throw new PESParserException("Packet header size exceeds packet size at: 0x" + Integer.toHexString(pos - offset).toUpperCase());
                        if (currentPacket.pesext1 == 1) {
                            if (pos >= pesEndOffset) throw new PESParserException("Packet header too small for pes_extension_1 at: 0x" + Integer.toHexString(pos - offset).toUpperCase());
                            currentPacket.pesext1Offset = pos;
                            currentPacket.pespd = pack[pos] >>> 7 & 1;
                            currentPacket.phf = pack[pos] >>> 6 & 1;
                            currentPacket.ppsc = pack[pos] >>> 5 & 1;
                            currentPacket.pstdb = pack[pos] >>> 4 & 1;
                            currentPacket.pesext2 = pack[pos] & 1;
                            pos += 1 + currentPacket.pespd * 16 + currentPacket.phf * 1 + currentPacket.ppsc * 2 + currentPacket.pstdb * 2;
                            if (currentPacket.pesext2 == 1) {
                                if (pos >= pesEndOffset) throw new PESParserException("Packet header too small for pes_extension_2 at: 0x" + Integer.toHexString(pos - offset).toUpperCase());
                                currentPacket.pesext2Offset = pos;
                                currentPacket.pefl = pack[pos] & 0x7F;
                                if (pos + currentPacket.pefl >= pesEndOffset) throw new PESParserException("Packet header too small for pes_extension_2 data at: 0x" + Integer.toHexString(pos - offset).toUpperCase());
                                pos = currentPacket.stream_id == 253 ? ++pos : (pos += 1 + currentPacket.pefl);
                            }
                        }
                    }
                }
                if (currentPacket.stream_id == 189 || currentPacket.stream_id == 191 || currentPacket.stream_id == 253) {
                    if (pos >= endOffset) throw new PESParserException("Packet too small for substream_id at: 0x" + Integer.toHexString(pos - offset).toUpperCase());
                    currentPacket.substream_id = ByteArray.getUByte(pack, pos);
                    currentPacket.substream_idOffset = pos;
                    ++pos;
                }
                currentPacket.payloadOffset = pos;
                if (this.isScrambledImpl(currentPacket)) {
                    pos = endOffset;
                    continue;
                }
                pos = currentPacket.packetOffset + 6 + currentPacket.length;
                continue;
            }
            int searchPointer = pos;
            while (searchPointer < endOffset) {
                if (pack[searchPointer] != 0) {
                    if (searchPointer - pos < 2 || endOffset - searchPointer < 6) throw new PESParserException("Invalid packet start code at: 0x" + Integer.toHexString(pos - offset).toUpperCase());
                    pos = searchPointer - 2;
                    continue block0;
                }
                ++searchPointer;
            }
        }
    }

    public String toString() {
        StringBuffer idString = new StringBuffer(64);
        idString.append("PES-Pack :: ");
        int i = 0;
        while (i < this.packetCount) {
            PESPacket currentPacket = this.packets.get(i);
            idString.append("stream_id: ");
            idString.append(S_ID_NAMES[currentPacket.stream_id]);
            if (currentPacket.stream_id == 189) {
                idString.append(", substream_id: ");
                idString.append(PS1_ID_NAMES[currentPacket.substream_id]);
            } else if (currentPacket.stream_id == 191) {
                idString.append(", substream_id: ");
                idString.append(PS2_ID_NAMES[currentPacket.substream_id]);
            } else if (currentPacket.stream_id == 253) {
                if (currentPacket.substream_id == 85) {
                    idString.append("_FOR_MAIN");
                } else if (currentPacket.substream_id == 86) {
                    idString.append("_FOR_SUB");
                } else {
                    idString.append(", stream_id_extension: 0x");
                    idString.append(Integer.toHexString(currentPacket.substream_id).toUpperCase());
                    idString.append(" (INVALID)");
                }
            }
            if (i + 1 < this.packetCount) {
                idString.append(" :: ");
            }
            ++i;
        }
        return idString.toString();
    }

    public boolean isScrambled() {
        return this.isScrambledImpl(this.packets.get(0));
    }

    private boolean isScrambledImpl(PESPacket packet) {
        if (packet.hasExtension) {
            return (this.pack[packet.packetOffset + 6] >>> 4 & 3) != 0;
        }
        return this.isHlPckImpl(packet);
    }

    public void setScrambled(boolean scrambled) {
        PESPacket tmp = this.packets.get(0);
        if (tmp.hasExtension) {
            this.pack[((PESPacket)tmp).packetOffset + 6] = (byte)(this.pack[tmp.packetOffset + 6] & 0xCF);
            if (scrambled) {
                this.pack[((PESPacket)tmp).packetOffset + 6] = (byte)(this.pack[tmp.packetOffset + 6] | 0x10);
            }
        }
    }

    public boolean isNavPck() {
        if (this.packetCount == 3) {
            PESPacket gci = this.packets.get(1);
            PESPacket dsi = this.packets.get(2);
            if (this.packets.get(0).stream_id == 187 && gci.stream_id == 191 && gci.substream_id == 4 && dsi.stream_id == 191 && dsi.substream_id == 1) {
                return true;
            }
        } else if (this.packetCount == 4) {
            PESPacket gci = this.packets.get(1);
            PESPacket pci = this.packets.get(2);
            PESPacket dsi = this.packets.get(3);
            if (this.packets.get(0).stream_id == 187 && gci.stream_id == 191 && gci.substream_id == 4 && pci.stream_id == 191 && pci.substream_id == 0 && dsi.stream_id == 191 && dsi.substream_id == 1) {
                return true;
            }
        }
        return false;
    }

    public boolean isAdvPck() {
        PESPacket tmp = this.packets.get(0);
        return tmp.stream_id == 191 && tmp.substream_id == 128;
    }

    public boolean isHlPck() {
        return this.isHlPckImpl(this.packets.get(0));
    }

    private boolean isHlPckImpl(PESPacket packet) {
        return packet.stream_id == 191 && packet.substream_id == 8;
    }

    public int packetCount() {
        return this.packetCount;
    }

    public PESPacket getPacket(int index) {
        if (index >= 0 && index < this.packetCount) {
            return this.packets.get(index);
        }
        return null;
    }

    public boolean pad(int index) {
        if (index >= -1 && index < this.packetCount) {
            int paddingOffset = 0;
            if (index == -1) {
                paddingOffset = this.packets.get(0).packetOffset;
            } else {
                PESPacket padPacket = this.packets.get(0);
                paddingOffset = padPacket.packetOffset + 6 + padPacket.length;
            }
            int paddingEndOffset = this.packOffset + 2048;
            int padAmount = paddingEndOffset - paddingOffset;
            if (padAmount < 6) {
                Arrays.fill(this.pack, paddingOffset, paddingEndOffset, (byte)0);
            } else {
                ByteArray.setInt(this.pack, paddingOffset, 446);
                ByteArray.setShort(this.pack, paddingOffset + 4, padAmount - 6);
                Arrays.fill(this.pack, paddingOffset + 6, paddingEndOffset, (byte)-1);
            }
            return true;
        }
        return false;
    }

    public final class PESPacket {
        private int packetOffset = 0;
        private int stream_idOffset = 0;
        private int substream_idOffset = 0;
        private int stream_id = 0;
        private int substream_id = -1;
        private int length = 0;
        private int payloadOffset = 0;
        private boolean hasExtension = false;
        private int ptsdts = 0;
        private int escr = 0;
        private int esr = 0;
        private int aci = 0;
        private int pescrc = 0;
        private int pesext1 = 0;
        private int pesext1Offset = 0;
        private int pespd = 0;
        private int phf = 0;
        private int ppsc = 0;
        private int pstdb = 0;
        private int pesext2 = 0;
        private int pesext2Offset = 0;
        private int pefl = 0;

        private PESPacket() {
        }

        public int getStreamId() {
            return this.stream_id;
        }

        public void setStreamId(int stream_id) {
            this.stream_id = stream_id;
            ByteArray.setByte(PESPack.this.pack, this.stream_idOffset, stream_id);
        }

        public boolean hasExtension() {
            return this.hasExtension;
        }

        public boolean hasSubstreamId() {
            return this.substream_idOffset != 0;
        }

        public int getSubstreamId() {
            return this.substream_id;
        }

        public boolean setSubstreamId(int substream_id) {
            if (this.substream_idOffset != 0) {
                this.substream_id = substream_id;
                ByteArray.setByte(PESPack.this.pack, this.substream_idOffset, substream_id);
                return true;
            }
            return false;
        }

        public int length() {
            return this.length;
        }

        public int payloadOffset() {
            return this.payloadOffset;
        }

        public int getPayloadLength() {
            return this.packetOffset + 6 + this.length - this.payloadOffset;
        }

        public boolean setPayloadLength(int payloadLength) {
            if (payloadLength >= 0 && this.payloadOffset + payloadLength <= PESPack.this.packOffset + 2048) {
                this.length = payloadLength + this.payloadOffset - (this.packetOffset + 6);
                ByteArray.setShort(PESPack.this.pack, this.packetOffset + 4, this.length);
                return true;
            }
            return false;
        }
    }
}

