# SPDX-License-Identifier: Apache-2.0
# SPDX-FileCopyrightText: Zygmunt Krynicki
DEBIAN_RELEASES ?=
GARDEN_SYSTEMS += $(foreach r,$(DEBIAN_RELEASES),$(foreach a,x86_64 aarch64,debian-cloud-$r.$a))

$(foreach R,$(DEBIAN_RELEASES),debian-cloud-$R.x86_64.run): debian-cloud-%.x86_64.run: $(MAKEFILE_LIST) | debian-cloud-%.x86_64.qcow2 debian-cloud-%.x86_64.efi-code.img debian-cloud-%.x86_64.efi-vars.img
	echo "#!/bin/sh" >$@
	echo 'set -xeu' >>$@
	echo "# WARNING: The .qcow2 file refers to a file in $(GARDEN_DL_DIR)/debian" >>$@
	echo '$(strip exec $(call QEMU_SYSTEM_X86_64_EFI_CMDLINE,$(word 1,$|),$(word 2,$|),$(word 3,$|)) "$$@")' >>$@
	chmod +x $@

$(foreach R,$(DEBIAN_RELEASES),debian-cloud-$R.aarch64.run): debian-cloud-%.aarch64.run: $(MAKEFILE_LIST) | debian-cloud-%.aarch64.qcow2 debian-cloud-%.aarch64.efi-code.img debian-cloud-%.aarch64.efi-vars.img
	echo "#!/bin/sh" >$@
	echo 'set -xeu' >>$@
	echo "# WARNING: The .qcow2 file refers to a file in $(GARDEN_DL_DIR)/debian" >>$@
	echo '$(strip exec $(call QEMU_SYSTEM_AARCH64_EFI_CMDLINE,$(word 1,$|),$(word 2,$|),$(word 3,$|)) "$$@")' >>$@
	chmod +x $@

# Debian cloud images do not contain a standalone installer that you only need
# during the setup process. Instead each image can be used as a read-only base
# for a read-write template.
$(foreach R,$(DEBIAN_RELEASES),debian-cloud-$R.x86_64.qcow2): debian-cloud-%.x86_64.qcow2: $(GARDEN_DL_DIR)/debian/debian-cloud-%.x86_64.qcow2 debian-cloud-%.seed.iso debian-cloud-%.x86_64.efi-code.img debian-cloud-%.x86_64.efi-vars.img
	$(strip $(QEMU_IMG) create -f qcow2 -b $< -F qcow2 $@ $(QEMU_IMG_SIZE))
	$(strip $(call QEMU_SYSTEM_X86_64_EFI_CMDLINE,$@,$(word 3,$^),$(word 4,$^)) \
		-drive file=$(word 2,$^),format=raw,id=drive1,if=none,readonly=true,media=cdrom \
		-device virtio-blk,drive=drive1 \
		-no-reboot | tee $@.log)

# Replicated because we have more releases than architectures and architecture-specific quirks are easier to express.
$(foreach R,$(DEBIAN_RELEASES),debian-cloud-$R.aarch64.qcow2): debian-cloud-%.aarch64.qcow2: $(GARDEN_DL_DIR)/debian/debian-cloud-%.aarch64.qcow2 debian-cloud-%.seed.iso debian-cloud-%.aarch64.efi-code.img debian-cloud-%.aarch64.efi-vars.img
	$(strip $(QEMU_IMG) create -f qcow2 -b $< -F qcow2 $@ $(QEMU_IMG_SIZE))
	$(strip $(call QEMU_SYSTEM_AARCH64_EFI_CMDLINE,$@,$(word 3,$^),$(word 4,$^)) \
		-drive file=$(word 2,$^),format=raw,id=drive1,if=none,readonly=true,media=cdrom \
		-device virtio-blk,drive=drive1 \
		-no-reboot | tee $@.log)

# Debian specific downloads.
$(GARDEN_DL_DIR)/debian: | $(GARDEN_DL_DIR)
	mkdir -p $@

debian-cloud-%.meta-data: export META_DATA = $(call CLOUD_INIT_META_DATA_TEMPLATE,debian-$*)
debian-cloud-%.meta-data: $(MAKEFILE_LIST)
	echo "$${META_DATA}" | tee $@
	touch --reference=$(shell stat $^ -c '%Y %n' | sort -nr | cut -d ' ' -f 2 | head -n 1) $@

debian-cloud-%.user-data: export USER_DATA = $(call $(call PICK_CLOUD_INIT_USER_DATA_TEMPLATE_FOR,DEBIAN,$*),debian-$*,debian)
debian-cloud-%.user-data: $(MAKEFILE_LIST) $(wildcard .image-garden.mk)
	echo "$${USER_DATA}" | tee $@
	touch --reference=$(shell stat $^ -c '%Y %n' | sort -nr | cut -d ' ' -f 2 | head -n 1) $@

.PHONY: clean
clean::
	rm -f $(foreach R,$(DEBIAN_RELEASES),$(foreach A,x86_64 aarch64,debian-cloud-$R.$A.qcow2 debian-cloud-$R.$A.run))
