/*
 * @(#)IChannelLoggerFactoryUTestI.java
 *
 * Copyright (C) 2002-2003 Matt Albrecht
 * groboclown@users.sourceforge.net
 * http://groboutils.sourceforge.net
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package net.sourceforge.groboutils.codecoverage.v2;

import java.util.Properties;

import net.sourceforge.groboutils.autodoc.v1.AutoDoc;
import net.sourceforge.groboutils.junit.v1.AssertConstructor;
import net.sourceforge.groboutils.junit.v1.iftc.ImplFactory;
import net.sourceforge.groboutils.junit.v1.iftc.InterfaceTestCase;
import net.sourceforge.groboutils.junit.v1.iftc.InterfaceTestSuite;


/**
 * Tests the IChannelLoggerFactory interface.
 *
 * @author    Matt Albrecht <a href="mailto:groboclown@users.sourceforge.net">groboclown@users.sourceforge.net</a>
 * @version   $Date: 2004/04/15 05:48:27 $
 * @since     December 28, 2002
 */
public class IChannelLoggerFactoryUTestI extends InterfaceTestCase
{
    //-------------------------------------------------------------------------
    // Standard JUnit Class-specific declarations
    
    private static final Class THIS_CLASS = IChannelLoggerFactoryUTestI.class;
    private static final AutoDoc DOC = new AutoDoc( THIS_CLASS );
    
    public IChannelLoggerFactoryUTestI( String name, ImplFactory f )
    {
        super( name, IChannelLoggerFactory.class, f );
    }

    
    public IChannelLoggerFactory createIChannelLoggerFactory()
    {
        return (IChannelLoggerFactory)createImplObject();
    }


    //-------------------------------------------------------------------------
    // Tests
    
    
    // the factory MUST have a default constructor!
    public void testConstructor1()
    {
        IChannelLoggerFactory clf = createIChannelLoggerFactory();
        AssertConstructor.assertHasDefaultConstructor(
            "All instances of IChannelLoggerFactory must have a default "+
            "constructor.", clf );
    }
    
    
    public void testCreateChannelLogger1()
    {
        IChannelLoggerFactory clf = createIChannelLoggerFactory();
        IChannelLogger cl = clf.createChannelLogger(
            "", new Properties(), (short)0 );
        assertNotNull(
            "Returned null logger.",
            cl );
    }
    
    
    public void testCreateChannelLogger2()
    {
        IChannelLoggerFactory clf = createIChannelLoggerFactory();
        IChannelLogger cl = clf.createChannelLogger(
            "", new Properties(), Short.MIN_VALUE );
        assertNotNull(
            "Returned null logger.",
            cl );
    }
    
    
    public void testCreateChannelLogger3()
    {
        IChannelLoggerFactory clf = createIChannelLoggerFactory();
        IChannelLogger cl = clf.createChannelLogger(
            "", new Properties(), Short.MAX_VALUE );
        assertNotNull(
            "Returned null logger.",
            cl );
    }
    
    
    //-------------------------------------------------------------------------
    // Standard JUnit declarations
    
    
    public static InterfaceTestSuite suite()
    {
        InterfaceTestSuite suite = new InterfaceTestSuite( THIS_CLASS );
        
        return suite;
    }
    
    public static void main( String[] args )
    {
        String[] name = { THIS_CLASS.getName() };
        
        // junit.textui.TestRunner.main( name );
        // junit.swingui.TestRunner.main( name );
        
        junit.textui.TestRunner.main( name );
    }
    
    
    /**
     * 
     * @exception Exception thrown under any exceptional condition.
     */
    protected void setUp() throws Exception
    {
        super.setUp();
        
        // set ourself up
    }
    
    
    /**
     * 
     * @exception Exception thrown under any exceptional condition.
     */
    protected void tearDown() throws Exception
    {
        // tear ourself down
        
        
        super.tearDown();
    }
}

