/*
 * @(#)ClassUtilOnlineUTest.java      0.9.0 17-APR-2001 - 14:40
 *
 * Copyright (C) 2002-2003 Matt Albrecht
 * groboclown@users.sourceforge.net
 * http://groboutils.sourceforge.net
 *
 *  Permission is hereby granted, free of charge, to any person obtaining a
 *  copy of this software and associated documentation files (the "Software"),
 *  to deal in the Software without restriction, including without limitation
 *  the rights to use, copy, modify, merge, publish, distribute, sublicense,
 *  and/or sell copies of the Software, and to permit persons to whom the 
 *  Software is furnished to do so, subject to the following conditions:
 *
 *  The above copyright notice and this permission notice shall be included in 
 *  all copies or substantial portions of the Software. 
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL 
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.
 */

package net.sourceforge.groboutils.util.classes.v1;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;


/**
 * Tests only the ClassUtil tests that are online.
 *
 * @author  Matt Albrecht <a href="mailto:groboclown@users.sourceforge.net">groboclown@users.sourceforge.net</a>
 * @version $Date: 2003/02/10 22:52:38 $
 * @since   June 28, 2002
 */
public class ClassUtilOnlineUTest extends TestCase
{
    private static final Class THIS_CLASS = ClassUtilOnlineUTest.class;
    
    public ClassUtilOnlineUTest( String name )
    {
        super( name );
    }
    
    public static Test suite()
    {
        TestSuite suite = new TestSuite( THIS_CLASS );
        
        return suite;
    }
    
    public static void main( String[] args )
    {
        String[] name = { THIS_CLASS.getName() };
        
        // junit.textui.TestRunner.main( name );
        // junit.swingui.TestRunner.main( name );
        
        junit.textui.TestRunner.main( name );
    }
    
    protected void setUp() throws Exception
    {
        super.setUp();
        
        // set ourself up
    }
    
    
    protected void tearDown() throws Exception
    {
        // tear ourself down
        
        super.tearDown();
    }

    
    
    private static final String BELIEF_CLASS = "BeliefOfTheDay";
    private static final String BELIEF_JAR =
        "http://groboutils.sourceforge.net/Belief.jar";
    
    public static class InnerClass
    {
        public InnerClass()
        {
            // do nothing
        }
    }
    
    public void testGetClass1()
    {
        ClassUtil util = startTest();
        
        Class c = util.getClass( BELIEF_CLASS, BELIEF_JAR );
        assertNotNull( "getClass( "+BELIEF_CLASS+" ) returned null.", c );
        assertEquals( "getClass( "+BELIEF_CLASS+" ) returned the wrong class.",
            BELIEF_CLASS, c.getName() );
    }
    
    
    public void testCreateObject1()
    {
        ClassUtil util = startTest();
        
        Object o = util.createObject( BELIEF_CLASS, BELIEF_JAR );
        assertEquals(
            "createObject( "+BELIEF_CLASS+", "+BELIEF_JAR+
            " ) did not instantiate the remote class.",
            BELIEF_CLASS, o.getClass().getName() );
    }
    
    
    //---------------------------------
    
    
    // we must assert that the ClassUtil is fresh to avoid incorrect
    // behavior.
    protected ClassUtil startTest()
    {
        ClassUtil util = ClassUtil.getInstance();
        util.flush();
        return util;
    }
}
