/*
 * @(#)UrlClassLoaderOnlineUTest.java      0.9.0 23-May-2001 - 14:40
 *
 * Copyright (C) 2002-2003 Matt Albrecht
 * groboclown@users.sourceforge.net
 * http://groboutils.sourceforge.net
 *
 *  Permission is hereby granted, free of charge, to any person obtaining a
 *  copy of this software and associated documentation files (the "Software"),
 *  to deal in the Software without restriction, including without limitation
 *  the rights to use, copy, modify, merge, publish, distribute, sublicense,
 *  and/or sell copies of the Software, and to permit persons to whom the
 *  Software is furnished to do so, subject to the following conditions:
 *
 *  The above copyright notice and this permission notice shall be included in
 *  all copies or substantial portions of the Software.
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 *  DEALINGS IN THE SOFTWARE.
 */

package net.sourceforge.groboutils.util.classes.v1.jdk0;

import net.sourceforge.groboutils.util.classes.v1.*;
import net.sourceforge.groboutils.junit.v1.iftc.*;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;


/**
 * Just like util.http.tests, this uses the Sourceforge account to ensure
 * that the URLs work correctly.  It loads the sample applet "BeliefOfTheDay"
 * to make sure that this is able to load classes remotely.
 * As insurance, this also tests to make sure that the same applet is not
 * in the current classpath.
 *
 * @author    Matt Albrecht <a href="mailto:groboclown@users.sourceforge.net">groboclown@users.sourceforge.net</a>
 * @version   $Date: 2003/05/06 05:35:01 $
 * @since     June 28, 2002
 */
public class UrlClassLoaderOnlineUTest extends TestCase
{
    private static final Class THIS_CLASS = UrlClassLoaderOnlineUTest.class;
    
    public static final String BELIEF_CLASS =
        IUrlClassLoaderOnlineUTestI.BELIEF_CLASS;
    public static final String BELIEF_JAR =
        IUrlClassLoaderOnlineUTestI.BELIEF_JAR;
    
    public UrlClassLoaderOnlineUTest( String name )
    {
        super( name );
    }
    
    public static Test suite()
    {
        InterfaceTestSuite suite = IUrlClassLoaderOnlineUTestI.suite();
        suite.addTestSuite( THIS_CLASS );
        suite.addFactory( new CxFactory( "A" ) {
            public Object createImplObject() {
                return createLoader();
            }
        } );
        
        return suite;
    }
    
    public static void main( String[] args )
    {
        String[] name = { THIS_CLASS.getName() };
        
        // junit.textui.TestRunner.main( name );
        // junit.swingui.TestRunner.main( name );
        
        junit.textui.TestRunner.main( name );
    }
    
    protected void setUp() throws Exception
    {
        super.setUp();
        
        // set ourself up
    }
    
    
    protected void tearDown() throws Exception
    {
        // tear ourself down
        
        super.tearDown();
    }

    
    protected static UrlClassLoader createLoader()
    {
        return new UrlClassLoader();
    }
    
    
    public void testFlush1()
    {
        // override the original, because we can better test the flushing
        // mechanism.
        
        UrlClassLoader loader = createLoader();
        
        // load up bytecode from a separate location
        Class c = loader.loadClass( BELIEF_CLASS, BELIEF_JAR );
        assertNotNull( "loadClass( "+BELIEF_CLASS+
            " ) returned null.", c );
        assertEquals( "loadClass( "+BELIEF_CLASS+
            " ) returned the wrong class.",
            BELIEF_CLASS, c.getName() );
        
        // this needs to be run in the same test, to ensure we don't load the
        // same class if referenced from a different JAR.
        byte b[] = loader.getBytecode( BELIEF_CLASS );
        assertNotNull( "getBytecode( "+BELIEF_CLASS+" ) returned null.", b );
        assertTrue( "getBytecode( "+BELIEF_CLASS+" ) returned no data.",
            b.length > 0 );
        
        loader.flush();
        
        // make sure the bytecode was properly eliminated.
        b = loader.getBytecode( BELIEF_CLASS );
        assertEquals( "getBytecode( "+BELIEF_CLASS+" ) did not return null.",
            null, b );
    }
    
    public void testGetBytecode1()
    {
        UrlClassLoader loader = (UrlClassLoader)createLoader();
        
        // load up bytecode from a separate location
        Class c = null;
        // I've had time-out issues with sourceforge.  Try 3 times.
        for (int i = 0; i < 3 && c == null; ++i)
        {
            c = loader.loadClass( BELIEF_CLASS, BELIEF_JAR );
        }
        assertNotNull( "loadClass( "+BELIEF_CLASS+
            " ) returned null 3 times.", c );
        assertEquals( "loadClass( "+BELIEF_CLASS+
            " ) returned the wrong class.",
            BELIEF_CLASS, c.getName() );
        
        // this needs to be run in the same test, to ensure we don't load the
        // same class if referenced from a different JAR.
        byte b[] = loader.getBytecode( BELIEF_CLASS );
        assertNotNull( "getBytecode( "+BELIEF_CLASS+" ) returned null.", b );
        assertTrue( "getBytecode( "+BELIEF_CLASS+" ) returned no data.",
            b.length > 0 );
    }
}
