#include "osl/misc/mask.h"
#include <boost/static_assert.hpp>
#include <iostream>
#include <iomanip>

namespace osl
{
  // mask_t が必要なビットを表現できることの確認
#if OSL_WORDSIZE == 64
  BOOST_STATIC_ASSERT(sizeof(mask_t) == 8);
#elif OSL_WORDSIZE == 32
  BOOST_STATIC_ASSERT(sizeof(mask_t) == 4);
#endif
}

std::ostream& osl::misc::operator<<(std::ostream& os,const osl::mask_t& mask)
{
  return os << "mask(0x" << std::setbase(16) <<
    mask.value() << std::setbase(10) << ')';
}
// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:

