# @file    TestRDFAnnotation.rb
# @brief   fomula units data unit tests
#
# @author  Akiya Jouraku (Ruby conversion)
# @author  Ben Bornstein
 
# 
# ====== WARNING ===== WARNING ===== WARNING ===== WARNING ===== WARNING ======
#
# DO NOT EDIT THIS FILE.
#
# This file was generated automatically by converting the file located at
# src/sbml/test/TestRDFAnnotation.cpp
# using the conversion program dev/utilities/translateTests/translateTests.pl.
# Any changes made here will be lost the next time the file is regenerated.
#
# -----------------------------------------------------------------------------
# This file is part of libSBML.  Please visit http://sbml.org for more
# information about SBML, and the latest version of libSBML.
#
# Copyright 2005-2010 California Institute of Technology.
# Copyright 2002-2005 California Institute of Technology and
#                     Japan Science and Technology Corporation.
# 
# This library is free software; you can redistribute it and/or modify it
# under the terms of the GNU Lesser General Public License as published by
# the Free Software Foundation.  A copy of the license agreement is provided
# in the file named "LICENSE.txt" included with this software distribution
# and also available online as http://sbml.org/software/libsbml/license.html
# -----------------------------------------------------------------------------
require 'test/unit'
require 'libSBML'

class TestRDFAnnotation < Test::Unit::TestCase

  def util_NaN
    z = 0.0
    return 0.0/z
  end

  def util_PosInf
    z = 0.0
    return 1.0/z
  end

  def util_NegInf
    z = 0.0
    return -1.0/z
  end

  def equals(*x)
    case x.size
    when 2
      e, s = x
      return e == s
    when 1
      e, = x
      return e == @@oss.str()
    end
  end

  def setup
    filename = "../../sbml/annotation/test/test-data/annotation.xml"
    @@d = LibSBML::readSBML(filename)
    @@m = @@d.getModel()
  end

  def teardown
    @@d = nil
  end

  def test_RDFAnnotation_delete
    node = LibSBML::RDFAnnotationParser.parseCVTerms(@@m.getCompartment(0))
    n1 = LibSBML::RDFAnnotationParser.deleteRDFAnnotation(node)
    expected =  "<annotation/>";
    assert( n1.getNumChildren() == 0 )
    assert( n1.getName() ==  "annotation" )
    assert_equal true, equals(expected,n1.toXMLString())
    node = nil
  end

  def test_RDFAnnotation_deleteWithOther
    c = @@m.getCompartment(1)
    node = LibSBML::RDFAnnotationParser.deleteRDFAnnotation(c.getAnnotation())
    expected = "<annotation>\n" + "  <jd2:JDesignerLayout version=\"2.0\" MajorVersion=\"2\" MinorVersion=\"0\" BuildVersion=\"41\">\n" + 
    "    <jd2:header>\n" + 
    "      <jd2:VersionHeader JDesignerVersion=\"2.0\"/>\n" + 
    "      <jd2:ModelHeader Author=\"Mr Untitled\" ModelVersion=\"0.0\" ModelTitle=\"untitled\"/>\n" + 
    "      <jd2:TimeCourseDetails timeStart=\"0\" timeEnd=\"10\" numberOfPoints=\"1000\"/>\n" + 
    "    </jd2:header>\n" + 
    "  </jd2:JDesignerLayout>\n" + 
    "</annotation>"
    assert_equal true, equals(expected,node.toXMLString())
  end

  def test_RDFAnnotation_deleteWithOtherRDF
    c = @@m.getCompartment(5)
    node = c.getAnnotation()
    expected = "<annotation>\n" +
    "  <jd2:JDesignerLayout version=\"2.0\" MajorVersion=\"2\" MinorVersion=\"0\" BuildVersion=\"41\">\n" + 
    "    <jd2:header>\n"+ 
    "      <jd2:VersionHeader JDesignerVersion=\"2.0\"/>\n" + 
    "      <jd2:ModelHeader Author=\"Mr Untitled\" ModelVersion=\"0.0\" ModelTitle=\"untitled\"/>\n" + 
    "      <jd2:TimeCourseDetails timeStart=\"0\" timeEnd=\"10\" numberOfPoints=\"1000\"/>\n" + 
    "    </jd2:header>\n" + 
    "  </jd2:JDesignerLayout>\n" + 
    "  <rdf:RDF xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\" xmlns:dc=\"http://purl.org/dc/elements/1.1/\" xmlns:dcterms=\"http://purl.org/dc/terms/\" xmlns:vCard=\"http://www.w3.org/2001/vcard-rdf/3.0#\" xmlns:bqbiol=\"http://biomodels.net/biology-qualifiers/\" xmlns:bqmodel=\"http://biomodels.net/model-qualifiers/\">\n" + 
    "    <rdf:Description>\n" + 
    "      <rdf:other/>\n" + 
    "    </rdf:Description>\n" + 
    "  </rdf:RDF>\n" + 
    "</annotation>"
    assert_equal true, equals(expected,node.toXMLString())
  end

  def test_RDFAnnotation_deleteWithOutOther
    c = @@m.getCompartment(2)
    node = c.getAnnotation()
    expected = "<annotation>\n" + "  <jd2:JDesignerLayout version=\"2.0\" MajorVersion=\"2\" MinorVersion=\"0\" BuildVersion=\"41\">\n" + 
    "    <jd2:header>\n" + 
    "      <jd2:VersionHeader JDesignerVersion=\"2.0\"/>\n" + 
    "      <jd2:ModelHeader Author=\"Mr Untitled\" ModelVersion=\"0.0\" ModelTitle=\"untitled\"/>\n" + 
    "      <jd2:TimeCourseDetails timeStart=\"0\" timeEnd=\"10\" numberOfPoints=\"1000\"/>\n" + 
    "    </jd2:header>\n" + 
    "  </jd2:JDesignerLayout>\n" + 
    "</annotation>"
    assert_equal true, equals(expected,node.toXMLString())
  end

  def test_RDFAnnotation_getModelHistory
    assert( !( @@m == nil) )
    history = @@m.getModelHistory()
    assert( history != nil )
    mc = history.getCreator(0)
    assert ((  "Le Novere" == mc.getFamilyName() ))
    assert ((  "Nicolas" == mc.getGivenName() ))
    assert ((  "lenov@ebi.ac.uk" == mc.getEmail() ))
    assert ((  "EMBL-EBI" == mc.getOrganisation() ))
    date = history.getCreatedDate()
    assert( date.getYear() == 2005 )
    assert( date.getMonth() == 2 )
    assert( date.getDay() == 2 )
    assert( date.getHour() == 14 )
    assert( date.getMinute() == 56 )
    assert( date.getSecond() == 11 )
    assert( date.getSignOffset() == 0 )
    assert( date.getHoursOffset() == 0 )
    assert( date.getMinutesOffset() == 0 )
    assert ((  "2005-02-02T14:56:11Z" == date.getDateAsString() ))
    date = history.getModifiedDate()
    assert( date.getYear() == 2006 )
    assert( date.getMonth() == 5 )
    assert( date.getDay() == 30 )
    assert( date.getHour() == 10 )
    assert( date.getMinute() == 46 )
    assert( date.getSecond() == 2 )
    assert( date.getSignOffset() == 0 )
    assert( date.getHoursOffset() == 0 )
    assert( date.getMinutesOffset() == 0 )
    assert ((  "2006-05-30T10:46:02Z" == date.getDateAsString() ))
  end

  def test_RDFAnnotation_parseCVTerms
    node = LibSBML::RDFAnnotationParser.parseCVTerms(@@m.getCompartment(0))
    assert( node.getNumChildren() == 1 )
    rdf = node.getChild(0)
    assert ((  "RDF" == rdf.getName() ))
    assert ((  "rdf" == rdf.getPrefix() ))
    assert ((  "http://www.w3.org/1999/02/22-rdf-syntax-ns#" == rdf.getURI() ))
    assert( rdf.getNumChildren() == 1 )
    desc = rdf.getChild(0)
    assert ((  "Description" == desc.getName() ))
    assert ((  "rdf" == desc.getPrefix() ))
    assert ((  "http://www.w3.org/1999/02/22-rdf-syntax-ns#" == desc.getURI() ))
    assert( desc.getNumChildren() == 1 )
    is1 = desc.getChild(0)
    assert ((  "is" == is1.getName() ))
    assert ((  "bqbiol" == is1.getPrefix() ))
    assert( is1.getNumChildren() == 1 )
    bag = is1.getChild(0)
    assert ((  "Bag" == bag.getName() ))
    assert ((  "rdf" == bag.getPrefix() ))
    assert ((  "http://www.w3.org/1999/02/22-rdf-syntax-ns#" == bag.getURI() ))
    assert( bag.getNumChildren() == 4 )
    li = bag.getChild(0)
    assert ((  "li" == li.getName() ))
    assert ((  "rdf" == li.getPrefix() ))
    assert ((  "http://www.w3.org/1999/02/22-rdf-syntax-ns#" == li.getURI() ))
    assert( li.getNumChildren() == 0 )
    li1 = bag.getChild(1)
    assert ((  "li" == li1.getName() ))
    assert ((  "rdf" == li1.getPrefix() ))
    assert ((  "http://www.w3.org/1999/02/22-rdf-syntax-ns#" == li1.getURI() ))
    assert( li1.getNumChildren() == 0 )
    li2 = bag.getChild(2)
    assert ((  "li" == li2.getName() ))
    assert ((  "rdf" == li2.getPrefix() ))
    assert ((  "http://www.w3.org/1999/02/22-rdf-syntax-ns#" == li2.getURI() ))
    assert( li2.getNumChildren() == 0 )
    li3 = bag.getChild(3)
    assert ((  "li" == li3.getName() ))
    assert ((  "rdf" == li3.getPrefix() ))
    assert ((  "http://www.w3.org/1999/02/22-rdf-syntax-ns#" == li3.getURI() ))
    assert( li3.getNumChildren() == 0 )
    node = nil
    node1 = LibSBML::RDFAnnotationParser.parseCVTerms(nil)
    assert( node1 == nil )
    node1 = LibSBML::RDFAnnotationParser.createCVTerms(nil)
    assert( node1 == nil )
    node1 = LibSBML::RDFAnnotationParser.parseCVTerms(@@m.getCompartment(2))
    assert( node1 == nil )
    node1 = LibSBML::RDFAnnotationParser.createCVTerms(@@m.getCompartment(2))
    assert( node1 == nil )
    node1 = LibSBML::RDFAnnotationParser.parseCVTerms(@@m)
    assert( node1 == nil )
    node1 = LibSBML::RDFAnnotationParser.createCVTerms(@@m)
    assert( node1 == nil )
    c = LibSBML::Compartment.new(3,1)
    c.setMetaId("_002")
    node1 = LibSBML::RDFAnnotationParser.parseCVTerms(c)
    assert( node1 == nil )
    node1 = LibSBML::RDFAnnotationParser.createCVTerms(c)
    assert( node1 == nil )
    cv = LibSBML::CVTerm.new(LibSBML::BIOLOGICAL_QUALIFIER)
    cv.setBiologicalQualifierType(23)
    cv.addResource("http://myres")
    c.addCVTerm(cv)
    node1 = LibSBML::RDFAnnotationParser.createCVTerms(c)
    assert( node1 == nil )
    c = nil
    m1 = LibSBML::Model.new(3,1)
    m1.setMetaId("_002")
    cv = LibSBML::CVTerm.new(LibSBML::MODEL_QUALIFIER)
    cv.setModelQualifierType(23)
    cv.addResource("http://myres")
    m1.addCVTerm(cv)
    node1 = LibSBML::RDFAnnotationParser.createCVTerms(m1)
    assert( node1 == nil )
  end

  def test_RDFAnnotation_parseModelHistory
    node = LibSBML::RDFAnnotationParser.parseModelHistory(@@m)
    assert( node.getNumChildren() == 1 )
    rdf = node.getChild(0)
    assert ((  "RDF" == rdf.getName() ))
    assert ((  "rdf" == rdf.getPrefix() ))
    assert ((  "http://www.w3.org/1999/02/22-rdf-syntax-ns#" == rdf.getURI() ))
    assert( rdf.getNumChildren() == 1 )
    desc = rdf.getChild(0)
    assert ((  "Description" == desc.getName() ))
    assert ((  "rdf" == desc.getPrefix() ))
    assert ((  "http://www.w3.org/1999/02/22-rdf-syntax-ns#" == desc.getURI() ))
    assert( desc.getNumChildren() == 3 )
    creator = desc.getChild(0)
    assert ((  "creator" == creator.getName() ))
    assert ((  "dc" == creator.getPrefix() ))
    assert ((  "http://purl.org/dc/elements/1.1/" == creator.getURI() ))
    assert( creator.getNumChildren() == 1 )
    bag = creator.getChild(0)
    assert ((  "Bag" == bag.getName() ))
    assert ((  "rdf" == bag.getPrefix() ))
    assert ((  "http://www.w3.org/1999/02/22-rdf-syntax-ns#" == bag.getURI() ))
    assert( bag.getNumChildren() == 1 )
    li = bag.getChild(0)
    assert ((  "li" == li.getName() ))
    assert ((  "rdf" == li.getPrefix() ))
    assert ((  "http://www.w3.org/1999/02/22-rdf-syntax-ns#" == li.getURI() ))
    assert( li.getNumChildren() == 3 )
    n = li.getChild(0)
    assert ((  "N" == n.getName() ))
    assert ((  "vCard" == n.getPrefix() ))
    assert ((  "http://www.w3.org/2001/vcard-rdf/3.0#" == n.getURI() ))
    assert( n.getNumChildren() == 2 )
    family = n.getChild(0)
    assert ((  "Family" == family.getName() ))
    assert ((  "vCard" == family.getPrefix() ))
    assert ((  "http://www.w3.org/2001/vcard-rdf/3.0#" == family.getURI() ))
    assert( family.getNumChildren() == 1 )
    given = n.getChild(1)
    assert ((  "Given" == given.getName() ))
    assert ((  "vCard" == given.getPrefix() ))
    assert ((  "http://www.w3.org/2001/vcard-rdf/3.0#" == given.getURI() ))
    assert( given.getNumChildren() == 1 )
    email = li.getChild(1)
    assert ((  "EMAIL" == email.getName() ))
    assert ((  "vCard" == email.getPrefix() ))
    assert ((  "http://www.w3.org/2001/vcard-rdf/3.0#" == email.getURI() ))
    assert( email.getNumChildren() == 1 )
    org = li.getChild(2)
    assert ((  "ORG" == org.getName() ))
    assert ((  "vCard" == org.getPrefix() ))
    assert ((  "http://www.w3.org/2001/vcard-rdf/3.0#" == org.getURI() ))
    assert( org.getNumChildren() == 1 )
    orgname = org.getChild(0)
    assert ((  "Orgname" == orgname.getName() ))
    assert ((  "vCard" == orgname.getPrefix() ))
    assert ((  "http://www.w3.org/2001/vcard-rdf/3.0#" == orgname.getURI() ))
    assert( orgname.getNumChildren() == 1 )
    created = desc.getChild(1)
    assert ((  "created" == created.getName() ))
    assert ((  "dcterms" == created.getPrefix() ))
    assert ((  "http://purl.org/dc/terms/" == created.getURI() ))
    assert( created.getNumChildren() == 1 )
    cr_date = created.getChild(0)
    assert ((  "W3CDTF" == cr_date.getName() ))
    assert ((  "dcterms" == cr_date.getPrefix() ))
    assert ((  "http://purl.org/dc/terms/" == cr_date.getURI() ))
    assert( cr_date.getNumChildren() == 1 )
    modified = desc.getChild(2)
    assert ((  "modified" == modified.getName() ))
    assert ((  "dcterms" == modified.getPrefix() ))
    assert ((  "http://purl.org/dc/terms/" == modified.getURI() ))
    assert( modified.getNumChildren() == 1 )
    mo_date = created.getChild(0)
    assert ((  "W3CDTF" == mo_date.getName() ))
    assert ((  "dcterms" == mo_date.getPrefix() ))
    assert ((  "http://purl.org/dc/terms/" == mo_date.getURI() ))
    assert( mo_date.getNumChildren() == 1 )
    node = nil
  end

  def test_RDFAnnotation_removeAnnotation
    n1 = nil
    expected = "<annotation>\n" + 
    "  <rdf:RDF xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\" xmlns:dc=\"http://purl.org/dc/elements/1.1/\" xmlns:dcterms=\"http://purl.org/dc/terms/\" xmlns:vCard=\"http://www.w3.org/2001/vcard-rdf/3.0#\" xmlns:bqbiol=\"http://biomodels.net/biology-qualifiers/\" xmlns:bqmodel=\"http://biomodels.net/model-qualifiers/\">\n" + 
    "    <rdf:Description rdf:about=\"#_000005\">\n" + 
    "      <bqbiol:is>\n" + 
    "        <rdf:Bag>\n" + 
    "          <rdf:li rdf:resource=\"http://www.geneontology.org/#GO:0007274\"/>\n" + 
    "        </rdf:Bag>\n" + 
    "      </bqbiol:is>\n" + 
    "    </rdf:Description>\n" + 
    "    <rdf:Description>\n" + 
    "      <rdf:other/>\n" + 
    "    </rdf:Description>\n" + 
    "  </rdf:RDF>\n" + 
    "</annotation>"
    i = @@m.getCompartment(4).removeTopLevelAnnotationElement("JDesignerLayout")
    n1 = @@m.getCompartment(4).getAnnotation()
    assert( i == LibSBML::LIBSBML_OPERATION_SUCCESS )
    assert_equal true, equals(expected,n1.toXMLString())
    i = @@m.getListOfCompartments().removeTopLevelAnnotationElement("RDF")
    assert( i == LibSBML::LIBSBML_OPERATION_SUCCESS )
  end

  def test_RDFAnnotation_removeSingleAnnotation
    n1 = nil
    i = @@m.getCompartment(0).removeTopLevelAnnotationElement("RDF")
    n1 = @@m.getCompartment(0).getAnnotation()
    assert( i == LibSBML::LIBSBML_OPERATION_SUCCESS )
    assert( n1 == nil )
    i = @@m.getCompartment(2).removeTopLevelAnnotationElement("JDesignerLayout")
    n1 = @@m.getCompartment(2).getAnnotation()
    assert( i == LibSBML::LIBSBML_OPERATION_SUCCESS )
    assert( n1 == nil )
    i = @@m.getCompartment(3).removeTopLevelAnnotationElement("RDF", "http://www.w3.org/1999/02/22-rdf-syntax-ns#")
    n1 = @@m.getCompartment(3).getAnnotation()
    assert( i == LibSBML::LIBSBML_OPERATION_SUCCESS )
    assert( n1 == nil )
  end

  def test_RDFAnnotation_removeSingleAnnotation1
    n1 = nil
    i = @@m.getCompartment(0).removeTopLevelAnnotationElement("RDF1")
    n1 = @@m.getCompartment(0).getAnnotation()
    assert( i == LibSBML::LIBSBML_ANNOTATION_NAME_NOT_FOUND )
    assert( n1.getNumChildren() == 1 )
    i = @@m.getCompartment(2).removeTopLevelAnnotationElement("JDLayout")
    n1 = @@m.getCompartment(2).getAnnotation()
    assert( i == LibSBML::LIBSBML_ANNOTATION_NAME_NOT_FOUND )
    assert( n1.getNumChildren() == 1 )
    i = @@m.getCompartment(3).removeTopLevelAnnotationElement("RDF", "http://www.w3.org/1999/02/22-rdf-syntax-ns")
    n1 = @@m.getCompartment(3).getAnnotation()
    assert( i == LibSBML::LIBSBML_ANNOTATION_NS_NOT_FOUND )
    assert( n1.getNumChildren() == 1 )
  end

  def test_RDFAnnotation_replaceAnnotation
    node = @@m.getCompartment(3).getAnnotation()
    n1 = nil
    expected = "<annotation>\n" + 
    "  <rdf:RDF xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\" xmlns:dc=\"http://purl.org/dc/elements/1.1/\" xmlns:dcterms=\"http://purl.org/dc/terms/\" xmlns:vCard=\"http://www.w3.org/2001/vcard-rdf/3.0#\" xmlns:bqbiol=\"http://biomodels.net/biology-qualifiers/\" xmlns:bqmodel=\"http://biomodels.net/model-qualifiers/\">\n" + 
    "    <rdf:Description rdf:about=\"#_000002\">\n" + 
    "      <bqbiol:is>\n" + 
    "        <rdf:Bag>\n" + 
    "          <rdf:li rdf:resource=\"http://www.geneontology.org/#GO:0007274\"/>\n" + 
    "        </rdf:Bag>\n" + 
    "      </bqbiol:is>\n" + 
    "    </rdf:Description>\n" + 
    "  </rdf:RDF>\n" + 
    "</annotation>"
    i = @@m.getCompartment(0).replaceTopLevelAnnotationElement(node)
    n1 = @@m.getCompartment(0).getAnnotation()
    assert( i == LibSBML::LIBSBML_OPERATION_SUCCESS )
    assert_equal true, equals(expected,n1.toXMLString())
  end

  def test_RDFAnnotation_replaceAnnotation1
    n1 = nil
    noRDF = "<annotation>\n" +
    "  <jd2:JDesignerLayout version=\"2.0\" MajorVersion=\"2\" MinorVersion=\"3\" BuildVersion=\"41\">\n" + 
    "    <jd2:header>\n" + 
    "      <jd2:VersionHeader JDesignerVersion=\"2.0\"/>\n" + 
    "      <jd2:ModelHeader Author=\"Sarah\" ModelVersion=\"0.0\" ModelTitle=\"mine\"/>\n" + 
    "      <jd2:TimeCourseDetails timeStart=\"0\" timeEnd=\"12\" numberOfPoints=\"1000\"/>\n" + 
    "    </jd2:header>\n" + 
    "  </jd2:JDesignerLayout>\n" + 
    "</annotation>"
    expected = "<annotation>\n" + 
    "  <jd2:JDesignerLayout version=\"2.0\" MajorVersion=\"2\" MinorVersion=\"3\" BuildVersion=\"41\">\n" + 
    "    <jd2:header>\n" + 
    "      <jd2:VersionHeader JDesignerVersion=\"2.0\"/>\n" + 
    "      <jd2:ModelHeader Author=\"Sarah\" ModelVersion=\"0.0\" ModelTitle=\"mine\"/>\n" + 
    "      <jd2:TimeCourseDetails timeStart=\"0\" timeEnd=\"12\" numberOfPoints=\"1000\"/>\n" + 
    "    </jd2:header>\n" + 
    "  </jd2:JDesignerLayout>\n"+ 
    "  <rdf:RDF xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\" xmlns:dc=\"http://purl.org/dc/elements/1.1/\" xmlns:dcterms=\"http://purl.org/dc/terms/\" xmlns:vCard=\"http://www.w3.org/2001/vcard-rdf/3.0#\" xmlns:bqbiol=\"http://biomodels.net/biology-qualifiers/\" xmlns:bqmodel=\"http://biomodels.net/model-qualifiers/\">\n" + 
    "    <rdf:Description rdf:about=\"#_000005\">\n" + 
    "      <bqbiol:is>\n" + 
    "        <rdf:Bag>\n" + 
    "          <rdf:li rdf:resource=\"http://www.geneontology.org/#GO:0007274\"/>\n" + 
    "        </rdf:Bag>\n" + 
    "      </bqbiol:is>\n" + 
    "    </rdf:Description>\n" + 
    "    <rdf:Description>\n" + 
    "      <rdf:other/>\n" + 
    "    </rdf:Description>\n" + 
    "  </rdf:RDF>\n" + 
    "</annotation>"
    i = @@m.getCompartment(4).replaceTopLevelAnnotationElement(noRDF)
    n1 = @@m.getCompartment(4).getAnnotation()
    assert( i == LibSBML::LIBSBML_OPERATION_SUCCESS )
    assert_equal true, equals(expected,n1.toXMLString())
  end

  def test_RDFAnnotation_replaceAnnotation2
    n1 = nil
    jd = "  <jd2:JDesignerLayout version=\"2.0\" MajorVersion=\"2\" MinorVersion=\"3\" BuildVersion=\"41\">\n" +
    "    <jd2:header>\n" + 
    "      <jd2:VersionHeader JDesignerVersion=\"2.0\"/>\n" + 
    "      <jd2:ModelHeader Author=\"Sarah\" ModelVersion=\"0.0\" ModelTitle=\"mine\"/>\n" + 
    "      <jd2:TimeCourseDetails timeStart=\"0\" timeEnd=\"12\" numberOfPoints=\"1000\"/>\n" + 
    "    </jd2:header>\n" + 
    "  </jd2:JDesignerLayout>"
    twoAnn = "<annotation>\n" + 
    "  <jd2:JDesignerLayout version=\"2.0\" MajorVersion=\"2\" MinorVersion=\"3\" BuildVersion=\"41\">\n" + 
    "    <jd2:header>\n" + 
    "      <jd2:VersionHeader JDesignerVersion=\"2.0\"/>\n" + 
    "      <jd2:ModelHeader Author=\"Sarah\" ModelVersion=\"0.0\" ModelTitle=\"mine\"/>\n" + 
    "      <jd2:TimeCourseDetails timeStart=\"0\" timeEnd=\"12\" numberOfPoints=\"1000\"/>\n" + 
    "    </jd2:header>\n" + 
    "  </jd2:JDesignerLayout>\n" + 
    "  <rdf:RDF xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\" xmlns:dc=\"http://purl.org/dc/elements/1.1/\" xmlns:dcterms=\"http://purl.org/dc/terms/\" xmlns:vCard=\"http://www.w3.org/2001/vcard-rdf/3.0#\" xmlns:bqbiol=\"http://biomodels.net/biology-qualifiers/\" xmlns:bqmodel=\"http://biomodels.net/model-qualifiers/\">\n" + 
    "    <rdf:Description rdf:about=\"#_000005\">\n" + 
    "      <bqbiol:is>\n" + 
    "        <rdf:Bag>\n" + 
    "          <rdf:li rdf:resource=\"http://www.geneontology.org/#GO:0007274\"/>\n" + 
    "        </rdf:Bag>\n" + 
    "      </bqbiol:is>\n" + 
    "    </rdf:Description>\n" + 
    "    <rdf:Description>\n" + 
    "      <rdf:other/>\n" + 
    "    </rdf:Description>\n" + 
    "  </rdf:RDF>\n" + 
    "</annotation>"
    i = @@m.getCompartment(4).replaceTopLevelAnnotationElement(twoAnn)
    assert( i == LibSBML::LIBSBML_INVALID_OBJECT )
    i = @@m.getCompartment(4).replaceTopLevelAnnotationElement(jd)
    n1 = @@m.getCompartment(4).getAnnotation()
    assert( i == LibSBML::LIBSBML_OPERATION_SUCCESS )
    assert_equal true, equals(twoAnn,n1.toXMLString())
  end

  def test_RDFAnnotation_testAnnotationForMetaId
    doc = LibSBML::SBMLDocument.new( 3,1 )
    model = doc.createModel()
    assert( model != nil )
    model.setId("test1")
    term = LibSBML::CVTerm.new( LibSBML::MODEL_QUALIFIER )
    term.addResource("testResource")
    term.setModelQualifierType(LibSBML::BQM_IS)
    model.setMetaId("t1")
    model.addCVTerm(term)
    model.setMetaId("")
    test = model.toSBML()
    assert( test ==  "<model id=\"test1\"/>" )
  end

  def test_RDFAnnotation_testMissingAbout
    withAbout = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n" + 
    "  <annotation>\n" + 
    "    <rdf:RDF xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\" xmlns:dc=\"http://purl.org/dc/elements/1.1/\" xmlns:dcterms=\"http://purl.org/dc/terms/\" xmlns:vCard=\"http://www.w3.org/2001/vcard-rdf/3.0#\" xmlns:bqbiol=\"http://biomodels.net/biology-qualifiers/\" xmlns:bqmodel=\"http://biomodels.net/model-qualifiers/\">\n" + 
    "      <rdf:Description rdf:about=\"#_000004\">\n" + 
    "        <bqbiol:is>\n" + 
    "          <rdf:Bag>\n" +    
    "            <rdf:li rdf:resource=\"http://www.geneontology.org/#GO:0007274\"/>\n" + 
    "          </rdf:Bag>\n" + 
    "        </bqbiol:is>\n" + 
    "      </rdf:Description>\n" + 
    "    </rdf:RDF>\n" + 
    "  </annotation>"
    emptyAbout = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n" + 
    "  <annotation>\n" + 
    "    <rdf:RDF xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\" xmlns:dc=\"http://purl.org/dc/elements/1.1/\" xmlns:dcterms=\"http://purl.org/dc/terms/\" xmlns:vCard=\"http://www.w3.org/2001/vcard-rdf/3.0#\" xmlns:bqbiol=\"http://biomodels.net/biology-qualifiers/\" xmlns:bqmodel=\"http://biomodels.net/model-qualifiers/\">\n" + 
    "      <rdf:Description rdf:about=\"\">\n" + 
    "        <bqbiol:is>\n" + 
    "          <rdf:Bag>\n" + 
    "            <rdf:li rdf:resource=\"http://www.geneontology.org/#GO:0007274\"/>\n" + 
    "          </rdf:Bag>\n" + 
    "        </bqbiol:is>\n" + 
    "      </rdf:Description>\n" + 
    "    </rdf:RDF>\n" + 
    "  </annotation>"
    noAbout = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n" + 
    "  <annotation>\n" + 
    "    <rdf:RDF xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\" xmlns:dc=\"http://purl.org/dc/elements/1.1/\" xmlns:dcterms=\"http://purl.org/dc/terms/\" xmlns:vCard=\"http://www.w3.org/2001/vcard-rdf/3.0#\" xmlns:bqbiol=\"http://biomodels.net/biology-qualifiers/\" xmlns:bqmodel=\"http://biomodels.net/model-qualifiers/\">\n" + 
    "      <rdf:Description>\n" + 
    "        <bqbiol:is>\n" + 
    "          <rdf:Bag>\n" + 
    "            <rdf:li rdf:resource=\"http://www.geneontology.org/#GO:0007274\"/>\n" + 
    "          </rdf:Bag>\n" + 
    "        </bqbiol:is>\n" + 
    "      </rdf:Description>\n" + 
    "    </rdf:RDF>\n" + 
    "  </annotation>"
    cvTerms = LibSBML::CVTermList.new()
    stream = LibSBML::XMLInputStream.new( withAbout,false )
    node = LibSBML::XMLNode.new( stream )
    LibSBML::RDFAnnotationParser.parseRDFAnnotation(node,cvTerms)
    assert( cvTerms.getSize() == 1 )
    cvTerms = LibSBML::CVTermList.new()
    LibSBML::RDFAnnotationParser.parseRDFAnnotation(node,cvTerms )
    assert( cvTerms.getSize() == 1 )
    cvTerms = nil
    cvTerms = nil
    cvTerms = LibSBML::CVTermList.new()
    stream1 = LibSBML::XMLInputStream.new( emptyAbout,false )
    node1 = LibSBML::XMLNode.new( stream1 )
    LibSBML::RDFAnnotationParser.parseRDFAnnotation(node1,cvTerms)
    assert( cvTerms.getSize() == 0 )
    cvTerms = nil
    cvTerms = nil
    cvTerms = LibSBML::CVTermList.new()
    stream2 = LibSBML::XMLInputStream.new( noAbout,false )
    node2 = LibSBML::XMLNode.new( stream2 )
    LibSBML::RDFAnnotationParser.parseRDFAnnotation(node2,cvTerms)
    assert( cvTerms.getSize() == 0 )
    cvTerms = nil
    cvTerms = nil
  end

  def test_RDFAnnotation_testMissingMetaId
    doc = LibSBML::SBMLDocument.new( 3,1 )
    model = doc.createModel()
    assert( model != nil )
    model.setId("test1")
    term = LibSBML::CVTerm.new( LibSBML::MODEL_QUALIFIER )
    term.addResource("testResource")
    term.setModelQualifierType(LibSBML::BQM_IS)
    model.setMetaId("t1")
    model.addCVTerm(term)
    model.setMetaId("")
    test = model.toSBML()
    assert( test ==  "<model id=\"test1\"/>" )
  end

end
