/* ***************************************************************************
 *
 * Pico Technology USB Device Driver
 *
 *//**
 * \file      tctables.h
 * \brief     Converts readings between temperature and millivolts using lookup table
 **//*
 *
 * Copyright (c) 2007, Pico Technology.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *  * The name of Pico Technology may not be used to endorse or promote
 *    products derived from this software without specific prior written
 *    permission.
 *
 * THIS SOFTWARE IS PROVIDED BY PICO TECHNOLOGY "AS IS" AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL PICO TECHNOLOGY BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * Version $Id: tctables.h,v 1.2 2007/05/14 14:36:28 douglas Exp $
 *
 *************************************************************************** */

/* Avoid including this header more than once */
#ifndef TCTABLES_H
#define TCTABLES_H

#include <vector>


///////////////////////////////////////////////////////////////
// Structures

struct tTCDataTable
  {
  char    TCType;
  long *  pTCData;
  float   MinTemp;
  float   MaxTemp;
  float   TempInterval;
  };


///////////////////////////////////////////////////////////////
// Class

class ThermocoupleTables
  {
  public:
    ThermocoupleTables() {}; // default constructor
    ~ThermocoupleTables();

    // Add a lookup table from an array
    void  AddTable    ( char    tctype, 
                        long  * pTCData_uV, 
                        float   minimumtemp, 
                        float   maximumtemp,
                        float   tempinterval);

    // Voltage to temperature
    bool  ConvertTemp ( char    tctype, 
                        float   millivolts,
                        float * centigrade,
                        bool  * overflow);

    // Temperature to voltage (used in CJ compensation)
    bool ConvertMillivolts (  char    tctype, 
                              float   centigrade, 
                              float * millivolts,
                              bool  * overflow);

  private:
    void m_ClearTables  (void);

    std::vector<tTCDataTable *> m_vecTCTable;
  };

////////////////////////////////////////////////////////////////////////////
// Static Functions

// for function pointers
static bool GreaterThan (float test1, float test2);
static bool LessThan    (float test1, float test2);
static int  Increment   (int value);
static int  Decrement   (int value);

#endif /* not defined TCTABLES_H */
