/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.netbeans.modules.cordova.platforms.spi;

import java.util.Properties;
import org.netbeans.api.project.Project;
import org.netbeans.modules.web.clientproject.spi.platform.ProjectConfigurationCustomizer;
import org.netbeans.spi.project.ActionProvider;

/**
 *
 * @author Jan Becicka
 */
public interface Device {
    
    public static String EMULATOR = "emulator"; // NOI18N
    public static String DEVICE_PROP = "device"; // NOI18N
    public static String DEVICE = "device"; // NOI18N
    public static String VIRTUAL_DEVICE_PROP = "virtual.device"; // NOI18N
    public static String BROWSER_PROP = "browser"; // NOI18N

    public static final String TYPE_PROP = "type"; // NOI18N

    public boolean isEmulator();

    public MobilePlatform getPlatform();
    
    public void addProperties(Properties props);

    public ActionProvider getActionProvider(Project p);

    public ProjectConfigurationCustomizer getProjectConfigurationCustomizer(Project project, PropertyProvider aThis);

    void openUrl(String url);
    
    public MobileDebugTransport getDebugTransport();
    
    public boolean isWebViewDebugSupported();
    
}
