/**
* @license Apache-2.0
*
* Copyright (c) 2020 The Stdlib Authors.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*    http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

'use strict';

// MODULES //

var gcusumkbn = require( './../../../../ext/base/gcusumkbn' );


// MAIN //

/**
* Computes the cumulative sum of strided array elements.
*
* @param {PositiveInteger} N - number of indexed elements
* @param {number} sum - initial sum
* @param {NumericArray} x - input array
* @param {integer} strideX - `x` stride length
* @param {NumericArray} y - output array
* @param {integer} strideY - `y` stride length
* @returns {NumericArray} output array
*
* @example
* var x = [ 1.0, -2.0, 2.0 ];
* var y = [ 0.0, 0.0, 0.0 ];
*
* var v = gcusum( x.length, 0.0, x, 1, y, 1 );
* // returns [ 1.0, -1.0, 1.0 ]
*/
function gcusum( N, sum, x, strideX, y, strideY ) {
	return gcusumkbn( N, sum, x, strideX, y, strideY );
}


// EXPORTS //

module.exports = gcusum;
