# encoding: utf8

# How to draw a circle.
#
# We use the fact that the equation for a circle is:
#
#   (x - a)² + (y - b)² = d²
#
# The output may look like an ellipse since the out window's aspect
# ratio may not be preserved.

import numpy

radius = 100

def video_out(a):
    (w, h) = (a.shape[1], a.shape[0])
    (iy, ix) = numpy.mgrid[:h,:w]
    a[(h / 2 - iy) ** 2 + (w / 2 - ix) ** 2 < radius ** 2] = 255

def mouse_in(ev, px, py, button):
    global radius
    radius = ((320*(0.5 - px)) ** 2 + (240*(0.5 - py)) ** 2) ** 0.5
