// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _ShapeFix_Edge_HeaderFile
#define _ShapeFix_Edge_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_DefineHandle_HeaderFile
#include <Standard_DefineHandle.hxx>
#endif
#ifndef _Handle_ShapeFix_Edge_HeaderFile
#include <Handle_ShapeFix_Edge.hxx>
#endif

#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Handle_ShapeConstruct_ProjectCurveOnSurface_HeaderFile
#include <Handle_ShapeConstruct_ProjectCurveOnSurface.hxx>
#endif
#ifndef _MMgt_TShared_HeaderFile
#include <MMgt_TShared.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Handle_Geom_Surface_HeaderFile
#include <Handle_Geom_Surface.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Handle_ShapeAnalysis_Surface_HeaderFile
#include <Handle_ShapeAnalysis_Surface.hxx>
#endif
#ifndef _ShapeExtend_Status_HeaderFile
#include <ShapeExtend_Status.hxx>
#endif
class ShapeConstruct_ProjectCurveOnSurface;
class TopoDS_Edge;
class TopoDS_Face;
class Geom_Surface;
class TopLoc_Location;
class ShapeAnalysis_Surface;


//! Fixing invalid edge. <br>
//!          Geometrical and/or topological inconsistency: <br>
//!          - no 3d curve or pcurve, <br>
//!          - mismatching orientation of 3d curve and pcurve, <br>
//!          - incorrect SameParameter flag (curve deviation is greater than <br>
//!            edge tolerance), <br>
//!          - not adjacent curves (3d or pcurve) to the vertices. <br>
class ShapeFix_Edge : public MMgt_TShared {

public:

  //! Empty constructor <br>
  Standard_EXPORT   ShapeFix_Edge();
  //! Returns the projector used for recomputing missing pcurves <br>
//!          Can be used for adjusting parameters of projector <br>
  Standard_EXPORT     Handle_ShapeConstruct_ProjectCurveOnSurface Projector() ;
  
  Standard_EXPORT     Standard_Boolean FixRemovePCurve(const TopoDS_Edge& edge,const TopoDS_Face& face) ;
  //! Removes the pcurve(s) of the edge if it does not match the <br>
//!          vertices <br>
//!          Check is done <br>
//!  Use    : It is to be called when pcurve of an edge can be wrong <br>
//!          (e.g., after import from IGES) <br>
//!  Returns: True, if does not match, removed (status DONE) <br>
//!          False, (status OK) if matches or (status FAIL) if no pcurve, <br>
//!          nothing done <br>
  Standard_EXPORT     Standard_Boolean FixRemovePCurve(const TopoDS_Edge& edge,const Handle(Geom_Surface)& surface,const TopLoc_Location& location) ;
  //! Removes 3d curve of the edge if it does not match the vertices <br>
//!  Returns: True,  if does not match, removed (status DONE) <br>
//!          False, (status OK) if matches or (status FAIL) if no 3d curve, <br>
//!          nothing done <br>
  Standard_EXPORT     Standard_Boolean FixRemoveCurve3d(const TopoDS_Edge& edge) ;
  //! See method below for information <br>
  Standard_EXPORT     Standard_Boolean FixAddPCurve(const TopoDS_Edge& edge,const TopoDS_Face& face,const Standard_Boolean isSeam,const Standard_Real prec = 0.0) ;
  //! See method below for information <br>
  Standard_EXPORT     Standard_Boolean FixAddPCurve(const TopoDS_Edge& edge,const Handle(Geom_Surface)& surface,const TopLoc_Location& location,const Standard_Boolean isSeam,const Standard_Real prec = 0.0) ;
  //! See method below for information <br>
  Standard_EXPORT     Standard_Boolean FixAddPCurve(const TopoDS_Edge& edge,const TopoDS_Face& face,const Standard_Boolean isSeam,const Handle(ShapeAnalysis_Surface)& surfana,const Standard_Real prec = 0.0) ;
  //! Adds pcurve(s) of the edge if missing (by projecting 3d curve) <br>
//!          Parameter isSeam indicates if the edge is a seam. <br>
//!          The parameter <prec> defines the precision for calculations. <br>
//!          If it is 0 (default), the tolerance of the edge is taken. <br>
//!  Remark : This method is rather for internal use since it accepts parameter <br>
//!          <surfana> for optimization of computations <br>
//!  Use    : It is to be called after FixRemovePCurve (if removed) or in any <br>
//!          case when edge can have no pcurve <br>
//!  Returns: True if pcurve was added, else False <br>
//!  Status : <br>
//!          OK   : Pcurve exists <br>
//!          FAIL1: No 3d curve <br>
//!          FAIL2: fail during projecting <br>
//!          DONE1: Pcurve was added <br>
//!          DONE2: specific case of pcurve going through degenerated point on <br>
//!                 sphere encountered during projection (see class <br>
//!                 ShapeConstruct_ProjectCurveOnSurface for more info) <br>
  Standard_EXPORT     Standard_Boolean FixAddPCurve(const TopoDS_Edge& edge,const Handle(Geom_Surface)& surface,const TopLoc_Location& location,const Standard_Boolean isSeam,const Handle(ShapeAnalysis_Surface)& surfana,const Standard_Real prec = 0.0) ;
  //! Tries to build 3d curve of the edge if missing <br>
//!  Use    : It is to be called after FixRemoveCurve3d (if removed) or in any <br>
//!          case when edge can have no 3d curve <br>
//!  Returns: True if 3d curve was added, else False <br>
//!  Status : <br>
//!          OK   : 3d curve exists <br>
//!          FAIL1: BRepLib::BuildCurve3d() has failed <br>
//!          DONE1: 3d curve was added <br>
  Standard_EXPORT     Standard_Boolean FixAddCurve3d(const TopoDS_Edge& edge) ;
  
  Standard_EXPORT     Standard_Boolean FixVertexTolerance(const TopoDS_Edge& edge,const TopoDS_Face& face) ;
  //! Increases the tolerances of the edge vertices to comprise <br>
//!          the ends of 3d curve and pcurve on the given face <br>
//!          (first method) or all pcurves stored in an edge (second one) <br>
//!  Returns: True, if tolerances have been increased, otherwise False <br>
//!  Status: <br>
//!          OK   : the original tolerances have not been changed <br>
//!          DONE1: the tolerance of first vertex has been increased <br>
//!          DONE2: the tolerance of last  vertex has been increased <br>
  Standard_EXPORT     Standard_Boolean FixVertexTolerance(const TopoDS_Edge& edge) ;
  
  Standard_EXPORT     Standard_Boolean FixReversed2d(const TopoDS_Edge& edge,const TopoDS_Face& face) ;
  //! Fixes edge if pcurve is directed opposite to 3d curve <br>
//!          Check is done by call to the function <br>
//!          ShapeAnalysis_Edge::CheckCurve3dWithPCurve() <br>
//!  Warning: For seam edge this method will check and fix the pcurve in only <br>
//!          one direction. Hence, it should be called twice for seam edge: <br>
//!          once with edge orientation FORWARD and once with REVERSED. <br>
//!  Returns: False if nothing done, True if reversed (status DONE) <br>
//!  Status:  OK    - pcurve OK, nothing done <br>
//!          FAIL1 - no pcurve <br>
//!          FAIL2 - no 3d curve <br>
//!          DONE1 - pcurve was reversed <br>
  Standard_EXPORT     Standard_Boolean FixReversed2d(const TopoDS_Edge& edge,const Handle(Geom_Surface)& surface,const TopLoc_Location& location) ;
  //! Tries to make edge SameParameter and sets corresponding <br>
//!          tolerance and SameParameter flag. <br>
//!          First, it makes edge same range if SameRange flag is not set. <br>
//! <br>
//!          If flag SameParameter is set, this method calls the <br>
//!          function ShapeAnalysis_Edge::CheckSameParameter() that <br>
//!          calculates the maximal deviation of pcurves of the edge from <br>
//!          its 3d curve. If deviation > tolerance, the tolerance of edge <br>
//!          is increased to a value of deviation. If deviation < tolerance <br>
//!          nothing happens. <br>
//! <br>
//!          If flag SameParameter is not set, this method chooses the best <br>
//!          variant (one that has minimal tolerance), either <br>
//!          a. only after computing deviation (as above) or <br>
//!          b. after calling standard procedure BRepLib::SameParameter <br>
//!          and computing deviation (as above). If <tolerance> > 0, it is <br>
//!          used as parameter for BRepLib::SameParameter, otherwise, <br>
//!          tolerance of the edge is used. <br>
//! <br>
//!  Use    : Is to be called after all pcurves and 3d curve of the edge are <br>
//!          correctly computed <br>
//!  Remark : SameParameter flag is always set to True after this method <br>
//!  Returns: True, if something done, else False <br>
//!  Status : OK    - edge was initially SameParameter, nothing is done <br>
//!          FAIL1 - computation of deviation of pcurves from 3d curve has failed <br>
//!          FAIL2 - BRepLib::SameParameter() has failed <br>
//!          DONE1 - tolerance of the edge was increased <br>
//!          DONE2 - flag SameParameter was set to True (only if <br>
//!                  BRepLib::SameParameter() did not set it) <br>
//!          DONE3 - edge was modified by BRepLib::SameParameter() to SameParameter <br>
//!          DONE4 - not used anymore <br>
//!          DONE5 - if the edge resulting from BRepLib has been chosen, i.e. variant b. above <br>
//!                  (only for edges with not set SameParameter) <br>
  Standard_EXPORT     Standard_Boolean FixSameParameter(const TopoDS_Edge& edge,const Standard_Real tolerance = 0.0) ;
  //! Returns the status (in the form of True/False) of last Fix <br>
  Standard_EXPORT     Standard_Boolean Status(const ShapeExtend_Status status) const;




  DEFINE_STANDARD_RTTI(ShapeFix_Edge)

protected:


Standard_Integer myStatus;
Handle_ShapeConstruct_ProjectCurveOnSurface myProjector;


private: 




};





// other Inline functions and methods (like "C++: function call" methods)


#endif
