// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _Interface_TypedValue_HeaderFile
#define _Interface_TypedValue_HeaderFile

#include <Standard.hxx>
#include <Standard_DefineHandle.hxx>
#include <Handle_Interface_TypedValue.hxx>

#include <TCollection_AsciiString.hxx>
#include <Handle_Standard_Type.hxx>
#include <Handle_TColStd_HArray1OfAsciiString.hxx>
#include <Handle_Dico_DictionaryOfInteger.hxx>
#include <Handle_TCollection_HAsciiString.hxx>
#include <Handle_Standard_Transient.hxx>
#include <MoniTool_TypedValue.hxx>
#include <Standard_CString.hxx>
#include <Interface_ParamType.hxx>
#include <MoniTool_ValueType.hxx>
class Standard_Type;
class TColStd_HArray1OfAsciiString;
class Dico_DictionaryOfInteger;
class TCollection_HAsciiString;
class Standard_Transient;
class Interface_InterfaceError;


//! Now strictly equivalent to TypedValue from MoniTool,
//! except for ParamType which remains for compatibility reasons
//!
//! This class allows to dynamically manage .. typed values, i.e.
//! values which have an alphanumeric expression, but with
//! controls. Such as "must be an Integer" or "Enumerative Text"
//! etc
//!
//! Hence, a TypedValue brings a specification (type + constraints
//! if any) and a value. Its basic form is a string, it can be
//! specified as integer or real or enumerative string, then
//! queried as such.
//! Its string content, which is a Handle(HAsciiString) can be
//! shared by other data structures, hence gives a direct on line
//! access to its value.
class Interface_TypedValue : public MoniTool_TypedValue
{

public:

  
  //! Creates a TypedValue, with a name
  //!
  //! type gives the type of the parameter, default is free text
  //! Also available : Integer, Real, Enum, Entity (i.e. Object)
  //! More precise specifications, titles, can be given to the
  //! TypedValue once created
  //!
  //! init gives an initial value. If it is not given, the
  //! TypedValue begins as "not set", its value is empty
  Standard_EXPORT Interface_TypedValue(const Standard_CString name, const Interface_ParamType type = Interface_ParamText, const Standard_CString init = "");
  
  //! Returns the type
  //! I.E. calls ValueType then makes correspondance between
  //! ParamType from Interface (which remains for compatibility
  //! reasons) and ValueType from MoniTool
  Standard_EXPORT   Interface_ParamType Type()  const;
  
  //! Correspondance ParamType from Interface  to
  //! ValueType from MoniTool
  Standard_EXPORT static   MoniTool_ValueType ParamTypeToValueType (const Interface_ParamType typ) ;
  
  //! Correspondance ParamType from Interface  to
  //! ValueType from MoniTool
  Standard_EXPORT static   Interface_ParamType ValueTypeToParamType (const MoniTool_ValueType typ) ;




  DEFINE_STANDARD_RTTI(Interface_TypedValue)

protected:




private: 


  TCollection_AsciiString thename;
  TCollection_AsciiString thedef;
  TCollection_AsciiString thelabel;
  Handle(Standard_Type) theotyp;
  TCollection_AsciiString theunidef;
  Handle(TColStd_HArray1OfAsciiString) theenums;
  Handle(Dico_DictionaryOfInteger) theeadds;
  TCollection_AsciiString thesatisn;
  Handle(TCollection_HAsciiString) thehval;
  Handle(Standard_Transient) theoval;


};







#endif // _Interface_TypedValue_HeaderFile
