###############################################################################
# OpenVAS Vulnerability Test
# $Id: ePo_detect.nasl 7287 2010-04-13 15:13:26Z chandra $
#
# ePo Agent Detection
#
# Authors:
# Michael Meyer
#
# Copyright:
# Copyright (c) 2009 Greenbone Networks GmbH
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

# need desc here to modify it later in script.
desc = "Overview:
This host is running an ePolicy Orchestrator (ePo) Agent.

Risk factor : None";

if (description)
{
 script_id(100329);
 script_version ("1.0-$Revision: 7287 $");
 script_tag(name:"risk_factor", value:"None");
 script_name("ePo Agent Detection");
 script_description(desc);
 script_summary("Checks for the presence of ePo Agent");
 script_category(ACT_GATHER_INFO);
 script_family("Service detection");
 script_copyright("This script is Copyright (C) 2009 Greenbone Networks GmbH");
 script_dependencies("find_service.nes","http_version.nasl");
 script_require_ports("Services/www", 8081);
 exit(0);
}

include("http_func.inc");
include("http_keepalive.inc");
include("global_settings.inc");
include("misc_func.inc");

port = get_http_port(default:8081);

if(!get_port_state(port))exit(0);

 url = string("/");
 req = http_get(item:url, port:port);
 buf = http_keepalive_send_recv(port:port, data:req, bodyonly:FALSE);
 if( buf == NULL )exit(0);

 if(egrep(pattern:"Agent-ListenServer", string: buf, icase: TRUE) ||
   (egrep(pattern:"naLog>", string: buf, icase: FALSE) &&
    egrep(pattern:"ComputerName>", string: buf, icase: FALSE) &&
    egrep(pattern:"FrameworkLog", string: buf, icase: FALSE))) {

    info = string("None\n\nInformation that was gathered:\n\n");

    if("403 Forbidden" >< buf) {
    
      info += string("Could not read remote log. Error: 403 Forbidden\n");

    } else {  

      if(lines = split(buf, sep:'><', keep: TRUE)) {
  
        foreach line (lines) { 
 
         if(computer_name = eregmatch(string: line, pattern:'ComputerName>([^<]+)</ComputerName>',icase:TRUE)) {
          if(!isnull(computer_name[1]))cn=computer_name[1];
         }	 
       
         if(version = eregmatch(string: line, pattern: "version>([^<]+)</version>",icase:TRUE)) {
           if(!isnull(version[1]))vers=version[1];
         }

         if(connected = eregmatch(string: line, pattern: 'Log component="[0-9]+" time="([^"]+)" type="3">(Agent is connecting to ePO server|Agent stellt Verbindung zu ePO-Server her)</Log>',icase:TRUE)) {
           if(!isnull(connected[1]))co=connected[1];
         }	

         if(repServer = eregmatch(string: line, pattern: 'Log component=[^>]+>Checking update packages from repository ([a-zA-Z-_0-9]+).</Log',icase:FALSE)) {
	   if(!isnull(repServer[1]))rserver = repServer[1];
         }	
	
         if(isnull(rserver)) {
          if(repServer = eregmatch(string:line, pattern: "ePOServerName>([^<]+)</ePOServerName>")) {
           if(!isnull(repServer[1]))rserver = repServer[1];  
          }   
         } 
      
       }  
     }
   
   }

    set_kb_item(name: string("www/", port, "/ePoAgent"), value: TRUE);
    register_service(port:port,  ipproto:"tcp", proto:"ePoAgent");

    if(!isnull(cn)) {
      info += string("ComputerName: ", cn, "\n");
    }  

    if(!isnull(vers)) {
      info += string("ClientVersion: ", vers, "\n");
      set_kb_item(name: string("www/", port, "/ePoAgent/Version"), value: vers);
      set_kb_item(name: string("cpe:/a:mcafee:agent:",vers), value: TRUE);
    } else {
      set_kb_item(name: string("www/", port, "/ePoAgent/Version"), value: string("unknown"));
      set_kb_item(name: string("cpe:/a:mcafee:agent"), value: TRUE);
    }  
 
    if(!isnull(rserver)) {
      info += string("Repository-Server: ", rserver, "\n");
    }  

    if(!isnull(co)) {
      info += string("Last connect to ePo-Server: ", co,"\n");
    }

    if(strlen(info)>40) {
      desc = ereg_replace(
          string:desc,
          pattern:"None$",
          replace:info
      );
     }

     if(report_verbosity > 0) {
       security_note(port:port,data:desc);
     }
     exit(0);
 }

exit(0);

