/* image.h - Image handling functions
 * 
 * Copyright (C) 2004, 2005 Anderson Lizardo
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc., 59
 * Temple Place, Suite 330, Boston, MA  02111-1307 USA
*/

/* Disabled by now, until code gets fixed */
#if 0
#ifndef _IMAGE_H
#define _IMAGE_H

typedef struct
{
    double brightness;
    double contrast;
    double gamma;
} color_setting;

typedef struct
{
    int width;                  /* image width (pixels) */
    int height;                 /* image height (pixels) */
    float from_top;             /* distance from top (inch) */
    float from_left;            /* distance from left side (inch) */
    int resolution;
    int num_colors;             /* number of colors */
    color_setting color[3];     /* b/c/g of all colors */
    unsigned char *color_table[3];
    char *filename;
} scan_image;

extern const int color_table_size;

extern int redmax, greenmax, bluemax, redmin, greenmin, bluemin;

extern void calc_color_table (scan_image * image);
extern void calibrate (scan_image * image);
extern void init_image (scan_image ** image);

#endif /* _IMAGE_H */
#endif
