/**
 * Boost Software License - Version 1.0 - August 17th, 2003
 *
 * Permission is hereby granted, free of charge, to any person or organization
 * obtaining a copy of the software and accompanying documentation covered by
 * this license (the "Software") to use, reproduce, display, distribute,
 * execute, and transmit the Software, and to prepare derivative works of the
 * Software, and to permit third-parties to whom the Software is furnished to
 * do so, all subject to the following:
 *
 * The copyright notices in the Software and this entire statement, including
 * the above license grant, this restriction and the following disclaimer,
 * must be included in all copies of the Software, in whole or in part, and
 * all derivative works of the Software, unless such copies or derivative
 * works are solely in the form of machine-executable object code generated by
 * a source language processor.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
 * SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
 * FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
 * ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */

#ifndef COMMON_SAFE_BOOL_H
#define COMMON_SAFE_BOOL_H

namespace Common {
	namespace impl {
		template <typename T>
		struct no_base {};

		template <typename T>
		struct safe_bool_impl {
			typedef T *TP; // workaround to make parsing easier
			TP stub;
			typedef TP safe_bool_impl::*type;
		};
	}

	/**
	 * Prevents `operator bool` from implicitly converting to other types.
	 */
	template <typename DerivedT, typename BaseT = impl::no_base<DerivedT> >
	struct SafeBool : BaseT {
	private:
		typedef impl::safe_bool_impl<DerivedT> impl_t;
		typedef typename impl_t::type bool_type;

	public:
		operator bool_type() const {
			return static_cast<const DerivedT *>(this)->operator_bool() ?
			&impl_t::stub : 0;
		}

		operator bool_type() {
			return static_cast<DerivedT *>(this)->operator_bool() ?
			&impl_t::stub : 0;
		}
	};
} // End of namespace Common

#endif
