#define XERR
#include "loop.ih"

extern size_t g_caseIdx;
extern size_t g_err;

void Loop::postScreen()
{
    if (d_status != PRESENT)            // the woman has died: no further
        return;                         // actions

    g_log << "\nLoop::postScreen\n";

                                    // there may be a tumor, detected before
                                    // the woman's natural death
    if (
        d_tumor.selfDetectable()
        and d_tumor.selfDetectAge() < d_naturalDeathAge
    )
    {
        g_log << "  *** case died because of a tumor detected at age " <<
                 d_tumor.selfDetectAge() << '\n';

        treatmentDeath();           // this results in a tumor caused death.
                                    // (the condition check in the original
    }                               //  sources is superfluous)
    else                        // or a naturally caused death
    {
        //if (g_caseIdx >= g_err)xerr(g_caseIdx << " setStatus");
        setStatus(LEFT_POST, d_naturalDeathAge);
        g_log << "  *** case died at natural death age " <<
                                                d_naturalDeathAge << '\n';

                                    // although the woman has died, still
                                    // determine the tumor's characteristics
        if (d_tumor.selfDetectable())
            d_tumor.characteristics(d_deathAge);
    }
}


//if (g_caseIdx >= g_err) 
//xerr(g_caseIdx << " treatment cost entry: " << d_caseCost);

//if (g_caseIdx >= g_err) xerr(g_caseIdx << " treatmentDeath");
